/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.goat;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.InstrumentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.goat.GoatAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class Goat
extends EntityAnimal {
    public static final EntitySize bZ = EntitySize.b(0.9f, 1.3f).a(0.7f);
    private static final int cg = 2;
    private static final int ch = 1;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Goat>>> ca = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.o, SensorType.f, SensorType.r);
    protected static final ImmutableList<MemoryModuleType<?>> cb = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.h, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.av, MemoryModuleType.r, MemoryModuleType.S, MemoryModuleType.T, MemoryModuleType.O, MemoryModuleType.K, MemoryModuleType.P, (Object[])new MemoryModuleType[]{MemoryModuleType.R, MemoryModuleType.V, MemoryModuleType.W, MemoryModuleType.Z});
    public static final int cd = 10;
    public static final double ce = 0.02;
    public static final double cf = (double)0.1f;
    private static final DataWatcherObject<Boolean> ci = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> cj = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> ck = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    private boolean cl;
    private int cm;

    public Goat(EntityTypes<? extends Goat> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.L().a(true);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    public ItemStack p() {
        RandomSource randomsource = RandomSource.a(this.cG().hashCode());
        TagKey<Instrument> tagkey = this.gA() ? InstrumentTags.b : InstrumentTags.a;
        return this.dW().K_().e(Registries.I).a(tagkey, randomsource).map(holder -> InstrumentItem.a(Items.wY, holder)).orElseGet(() -> new ItemStack(Items.wY));
    }

    protected BehaviorController.b<Goat> ed() {
        return BehaviorController.a(cb, ca);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return GoatAi.a(this.ed().a(dynamic));
    }

    public static AttributeProvider.Builder t() {
        return EntityAnimal.gt().a(GenericAttributes.s, 10.0).a(GenericAttributes.v, 0.2f).a(GenericAttributes.c, 2.0);
    }

    @Override
    protected void i() {
        if (this.e_()) {
            this.g(GenericAttributes.c).a(1.0);
            this.gs();
        } else {
            this.g(GenericAttributes.c).a(2.0);
            this.gr();
        }
    }

    @Override
    protected int f(float fallDistance, float damageMultiplier) {
        return super.f(fallDistance, damageMultiplier) - 10;
    }

    @Override
    protected SoundEffect u() {
        return this.gA() ? SoundEffects.ln : SoundEffects.le;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return this.gA() ? SoundEffects.lq : SoundEffects.lh;
    }

    @Override
    public SoundEffect o_() {
        return this.gA() ? SoundEffects.lo : SoundEffects.lf;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.lv, 0.15f, 1.0f);
    }

    protected SoundEffect x() {
        return this.gA() ? SoundEffects.ls : SoundEffects.lj;
    }

    @Nullable
    public Goat b(WorldServer world, EntityAgeable entity) {
        Goat goat = EntityTypes.ai.a(world, EntitySpawnReason.e);
        if (goat != null) {
            EntityAgeable goat1;
            GoatAi.a(goat, world.H_());
            EntityAgeable object = world.H_().h() ? this : entity;
            boolean flag = object instanceof Goat && ((Goat)(goat1 = object)).gA() || !(world.H_().j() >= 0.02);
            boolean flag1 = flag;
            goat.x(flag1);
        }
        return goat;
    }

    public BehaviorController<Goat> ec() {
        return super.ec();
    }

    @Override
    protected void a(WorldServer world) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("goatBrain");
        this.ec().a(world, this);
        gameprofilerfiller.c();
        gameprofilerfiller.a("goatActivityUpdate");
        GoatAi.a(this);
        gameprofilerfiller.c();
        super.a(world);
    }

    @Override
    public int aa() {
        return 15;
    }

    @Override
    public void q(float headYaw) {
        int i2 = this.aa();
        float f1 = MathHelper.c(this.aX, headYaw);
        float f2 = MathHelper.a(f1, (float)(-i2), (float)i2);
        super.q(this.aX + f2);
    }

    @Override
    protected void gu() {
        this.dW().a((EntityHuman)null, this, this.gA() ? SoundEffects.lp : SoundEffects.lg, SoundCategory.g, 1.0f, MathHelper.b(this.dW().A, 0.8f, 1.2f));
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.ag);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.qW) && !this.e_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((WorldServer)player.dW(), player, this.dw(), this.dw(), null, itemstack, Items.rc, hand);
            if (event.isCancelled()) {
                player.cd.b();
                return EnumInteractionResult.e;
            }
            player.a(this.x(), 1.0f, 1.0f);
            ItemStack itemstack1 = ItemLiquidUtil.a(itemstack, player, CraftItemStack.asNMSCopy(event.getItemStack()));
            player.a(hand, itemstack1);
            return EnumInteractionResult.a;
        }
        boolean isFood = this.j(itemstack);
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (enuminteractionresult.a() && isFood) {
            this.gu();
        }
        return enuminteractionresult;
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        RandomSource randomsource = world.H_();
        GoatAi.a(this, randomsource);
        this.x(randomsource.j() < 0.02);
        this.i();
        if (!this.e_() && (double)randomsource.i() < (double)0.1f) {
            DataWatcherObject<Boolean> datawatcherobject = randomsource.h() ? cj : ck;
            this.al.a(datawatcherobject, false);
        }
        return super.a(world, difficulty, spawnReason, entityData);
    }

    @Override
    protected void Y() {
        super.Y();
        PacketDebug.a(this);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return pose == EntityPose.g ? bZ.a(this.ej()) : super.e(pose);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("IsScreamingGoat", this.gA());
        nbt.a("HasLeftHorn", this.go());
        nbt.a("HasRightHorn", this.gp());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.x(nbt.q("IsScreamingGoat"));
        this.al.a(cj, nbt.q("HasLeftHorn"));
        this.al.a(ck, nbt.q("HasRightHorn"));
    }

    @Override
    public void b(byte status) {
        if (status == 58) {
            this.cl = true;
        } else if (status == 59) {
            this.cl = false;
        } else {
            super.b(status);
        }
    }

    @Override
    public void d_() {
        this.cm = this.cl ? ++this.cm : (this.cm -= 2);
        this.cm = MathHelper.a(this.cm, 0, 20);
        super.d_();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ci, false);
        builder.a(cj, true);
        builder.a(ck, true);
    }

    public boolean go() {
        return this.al.a(cj);
    }

    public boolean gp() {
        return this.al.a(ck);
    }

    public boolean gq() {
        boolean flag = this.go();
        boolean flag1 = this.gp();
        if (!flag && !flag1) {
            return false;
        }
        DataWatcherObject<Boolean> datawatcherobject = !flag ? ck : (!flag1 ? cj : (this.ae.h() ? cj : ck));
        this.al.a(datawatcherobject, false);
        Vec3D vec3d = this.du();
        ItemStack itemstack = this.p();
        double d0 = MathHelper.b(this.ae, -0.2f, 0.2f);
        double d1 = MathHelper.b(this.ae, 0.3f, 0.7f);
        double d2 = MathHelper.b(this.ae, -0.2f, 0.2f);
        EntityItem entityitem = new EntityItem(this.dW(), vec3d.a(), vec3d.b(), vec3d.c(), itemstack, d0, d1, d2);
        return this.spawnAtLocation((WorldServer)this.dW(), entityitem) != null;
    }

    public void gr() {
        this.al.a(cj, true);
        this.al.a(ck, true);
    }

    public void gs() {
        this.al.a(cj, false);
        this.al.a(ck, false);
    }

    public boolean gA() {
        return this.al.a(ci);
    }

    public void x(boolean screaming) {
        this.al.a(ci, screaming);
    }

    public float gB() {
        return (float)this.cm / 20.0f * 30.0f * ((float)Math.PI / 180);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess world, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.e()).a(TagsBlock.cb) && Goat.a(world, pos);
    }

    public void ram(EntityLiving entity) {
        BehaviorController<Goat> brain = this.ec();
        brain.a(MemoryModuleType.W, entity.du());
        brain.b(MemoryModuleType.V);
        brain.b(MemoryModuleType.r);
        brain.b(MemoryModuleType.O);
        brain.a(Activity.r);
    }
}

