/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.DoubleSupplier;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryListener;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.ContainerSingleItem;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.inventory.InventoryHolder;

public abstract class EntityHorseAbstract
extends EntityAnimal
implements IInventoryListener,
HasCustomInventoryScreen,
OwnableEntity,
IJumpable,
ISaddleable {
    public static final int ck = 400;
    public static final int cl = 499;
    public static final int cm = 500;
    public static final double cn = 0.15;
    private static final float bZ = (float)EntityHorseAbstract.b(() -> 0.0);
    private static final float ca = (float)EntityHorseAbstract.b(() -> 1.0);
    private static final float cb = (float)EntityHorseAbstract.a(() -> 0.0);
    private static final float cd = (float)EntityHorseAbstract.a(() -> 1.0);
    private static final float ce = EntityHorseAbstract.a((int i2) -> 0);
    private static final float cf = EntityHorseAbstract.a((int i2) -> i2 - 1);
    private static final float cg = 0.25f;
    private static final float ch = 0.5f;
    private static final PathfinderTargetCondition.a ci = (entityliving, worldserver) -> {
        EntityHorseAbstract entityhorseabstract;
        if (entityliving instanceof EntityHorseAbstract && (entityhorseabstract = (EntityHorseAbstract)entityliving).gK()) {
            boolean flag = true;
            return flag;
        }
        boolean flag = false;
        return flag;
    };
    private static final PathfinderTargetCondition cj = PathfinderTargetCondition.b().a(16.0).d().a(ci);
    private static final DataWatcherObject<Byte> cC = DataWatcher.a(EntityHorseAbstract.class, DataWatcherRegistry.a);
    private static final int cD = 2;
    private static final int cE = 4;
    private static final int cF = 8;
    private static final int cG = 16;
    private static final int cH = 32;
    private static final int cI = 64;
    public static final int co = 0;
    public static final int cp = 1;
    public static final int cq = 3;
    private int cJ;
    private int cK;
    private int cL;
    public int cr;
    public int cs;
    protected boolean ct;
    public InventorySubcontainer cu;
    protected int cv;
    protected float cw;
    protected boolean cx;
    private float cM;
    private float cN;
    private float cO;
    private float cP;
    private float cQ;
    private float cR;
    protected boolean cy = true;
    protected int cz;
    @Nullable
    private UUID cS;
    private final IInventory cT = new ContainerSingleItem(){
        public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
        private int maxStack = 99;

        @Override
        public ItemStack f() {
            return EntityHorseAbstract.this.af();
        }

        @Override
        public void b(ItemStack stack) {
            EntityHorseAbstract.this.h(stack);
        }

        @Override
        public void e() {
        }

        @Override
        public boolean a(EntityHuman player) {
            return player.dl() == EntityHorseAbstract.this || player.b(EntityHorseAbstract.this, 4.0);
        }

        @Override
        public List<ItemStack> getContents() {
            return Arrays.asList(this.f());
        }

        @Override
        public void onOpen(CraftHumanEntity who) {
            this.transaction.add(who);
        }

        @Override
        public void onClose(CraftHumanEntity who) {
            this.transaction.remove(who);
        }

        @Override
        public List<HumanEntity> getViewers() {
            return this.transaction;
        }

        @Override
        public int ao_() {
            return this.maxStack;
        }

        @Override
        public void setMaxStackSize(int size) {
            this.maxStack = size;
        }

        @Override
        public InventoryHolder getOwner() {
            return (AbstractHorse)EntityHorseAbstract.this.getBukkitEntity();
        }

        @Override
        public Location getLocation() {
            return EntityHorseAbstract.this.getBukkitEntity().getLocation();
        }
    };
    public int maxDomestication = 100;

    protected EntityHorseAbstract(EntityTypes<? extends EntityHorseAbstract> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.gN();
    }

    @Override
    protected void B() {
        this.bT.a(1, new PathfinderGoalPanic(this, 1.2));
        this.bT.a(1, new PathfinderGoalTame(this, 1.2));
        this.bT.a(2, new PathfinderGoalBreed(this, 1.0, EntityHorseAbstract.class));
        this.bT.a(4, new PathfinderGoalFollowParent(this, 1.0));
        this.bT.a(6, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.bT.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bT.a(8, new PathfinderGoalRandomLookaround(this));
        if (this.gp()) {
            this.bT.a(9, new RandomStandGoal(this));
        }
        this.gG();
    }

    protected void gG() {
        this.bT.a(0, new PathfinderGoalFloat(this));
        this.bT.a(3, new PathfinderGoalTempt(this, 1.25, itemstack -> itemstack.a(TagsItem.al), false));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cC, (byte)0);
    }

    protected boolean s(int bitmask) {
        return (this.al.a(cC) & bitmask) != 0;
    }

    protected void d(int bitmask, boolean flag) {
        byte b0 = this.al.a(cC);
        if (flag) {
            this.al.a(cC, (byte)(b0 | bitmask));
        } else {
            this.al.a(cC, (byte)(b0 & ~bitmask));
        }
    }

    public boolean gF() {
        return this.s(2);
    }

    @Override
    @Nullable
    public UUID ab_() {
        return this.cS;
    }

    public void b(@Nullable UUID ownerUuid) {
        this.cS = ownerUuid;
    }

    public boolean gH() {
        return this.ct;
    }

    public void y(boolean tame) {
        this.d(2, tame);
    }

    public void z(boolean inAir) {
        this.ct = inAir;
    }

    @Override
    public boolean a(Entity leashHolder, float distance) {
        if (distance > 6.0f && this.gI()) {
            this.B(false);
        }
        return true;
    }

    public boolean gI() {
        return this.s(16);
    }

    public boolean gJ() {
        return this.s(32);
    }

    public boolean gK() {
        return this.s(8);
    }

    public void A(boolean bred) {
        this.d(8, bred);
    }

    @Override
    public boolean f() {
        return this.bL() && !this.e_() && this.gF();
    }

    @Override
    public void a(ItemStack stack, @Nullable SoundCategory soundCategory) {
        this.cu.a(0, stack);
    }

    public void b(EntityHuman player, ItemStack stack) {
        if (this.a(stack, EnumItemSlot.g)) {
            this.h(stack.b(1, (EntityLiving)player));
        }
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return slot == EnumItemSlot.g && this.gF() || super.f(slot);
    }

    @Override
    public boolean j() {
        return this.s(4);
    }

    public int gL() {
        return this.cv;
    }

    public void t(int temper) {
        this.cv = temper;
    }

    public int u(int difference) {
        int j2 = MathHelper.a(this.gL() + difference, 0, this.gR());
        this.t(j2);
        return j2;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return !this.ca();
    }

    private void p() {
        SoundEffect soundeffect;
        this.x();
        if (!this.bb() && (soundeffect = this.gq()) != null) {
            this.dW().a((EntityHuman)null, this.dB(), this.dD(), this.dH(), soundeffect, this.dn(), 1.0f, 1.0f + (this.ae.i() - this.ae.i()) * 0.2f);
        }
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        int i2;
        if (fallDistance > 1.0f) {
            this.a(SoundEffects.nh, 0.4f, 1.0f);
        }
        if ((i2 = this.f(fallDistance, damageMultiplier)) <= 0) {
            return false;
        }
        this.a(damageSource, (float)i2);
        if (this.ca()) {
            for (Entity entity : this.dd()) {
                entity.a(damageSource, (float)i2);
            }
        }
        this.eO();
        return true;
    }

    public final int gM() {
        return EntityHorseAbstract.v(this.ag_());
    }

    public static int v(int columns) {
        return columns * 3 + 1;
    }

    public void gN() {
        InventorySubcontainer inventorysubcontainer = this.cu;
        this.cu = new InventorySubcontainer(this.gM(), (InventoryHolder)((AbstractHorse)this.getBukkitEntity()));
        if (inventorysubcontainer != null) {
            inventorysubcontainer.b(this);
            int i2 = Math.min(inventorysubcontainer.b(), this.cu.b());
            for (int j2 = 0; j2 < i2; ++j2) {
                ItemStack itemstack = inventorysubcontainer.a(j2);
                if (itemstack.f()) continue;
                this.cu.a(j2, itemstack.v());
            }
        }
        this.cu.a(this);
        this.gO();
    }

    protected void gO() {
        if (!this.dW().C) {
            this.d(4, !this.cu.a(0).f());
        }
    }

    @Override
    public void a(IInventory sender) {
        boolean flag = this.j();
        this.gO();
        if (this.af > 20 && !flag && this.j()) {
            this.a(this.ac_(), 0.5f, 1.0f);
        }
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        boolean flag = super.a(world, source, amount);
        if (flag && this.ae.a(3) == 0) {
            this.gU();
        }
        return flag;
    }

    protected boolean gp() {
        return true;
    }

    @Nullable
    protected SoundEffect gq() {
        return null;
    }

    @Nullable
    protected SoundEffect gP() {
        return null;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        if (!state.n()) {
            IBlockData iblockdata1 = this.dW().a_(pos.d());
            SoundEffectType soundeffecttype = state.A();
            if (iblockdata1.a(Blocks.ea)) {
                soundeffecttype = iblockdata1.A();
            }
            if (this.ca() && this.cy) {
                ++this.cz;
                if (this.cz > 5 && this.cz % 3 == 0) {
                    this.a(soundeffecttype);
                } else if (this.cz <= 5) {
                    this.a(SoundEffects.nk, soundeffecttype.a() * 0.15f, soundeffecttype.b());
                }
            } else if (this.b(soundeffecttype)) {
                this.a(SoundEffects.nk, soundeffecttype.a() * 0.15f, soundeffecttype.b());
            } else {
                this.a(SoundEffects.nj, soundeffecttype.a() * 0.15f, soundeffecttype.b());
            }
        }
    }

    private boolean b(SoundEffectType soundGroup) {
        return soundGroup == SoundEffectType.b || soundGroup == SoundEffectType.aT || soundGroup == SoundEffectType.B || soundGroup == SoundEffectType.aU || soundGroup == SoundEffectType.aS;
    }

    protected void a(SoundEffectType group) {
        this.a(SoundEffects.ne, group.a() * 0.15f, group.b());
    }

    public static AttributeProvider.Builder gQ() {
        return EntityAnimal.gt().a(GenericAttributes.o, 0.7).a(GenericAttributes.s, 53.0).a(GenericAttributes.v, 0.225f).a(GenericAttributes.B, 1.0).a(GenericAttributes.x, 6.0).a(GenericAttributes.k, 0.5);
    }

    @Override
    public int ad() {
        return 6;
    }

    public int gR() {
        return this.maxDomestication;
    }

    @Override
    public float fg() {
        return 0.8f;
    }

    @Override
    public int Q() {
        return 400;
    }

    @Override
    public void b(EntityHuman player) {
        if (!this.dW().C && (!this.ca() || this.y(player)) && this.gF()) {
            player.a(this, this.cu);
        }
    }

    public EnumInteractionResult c(EntityHuman player, ItemStack stack) {
        boolean flag = this.a(player, stack);
        if (flag) {
            stack.a(1, (EntityLiving)player);
        }
        return (EnumInteractionResult)((Object)(!flag && !this.dW().C ? EnumInteractionResult.e : EnumInteractionResult.b));
    }

    protected boolean a(EntityHuman player, ItemStack item) {
        boolean flag = false;
        float f2 = 0.0f;
        int short0 = 0;
        int b0 = 0;
        if (item.a(Items.pS)) {
            f2 = 2.0f;
            short0 = 20;
            b0 = 3;
        } else if (item.a(Items.so)) {
            f2 = 1.0f;
            short0 = 30;
            b0 = 3;
        } else if (item.a(Blocks.iA.j())) {
            f2 = 20.0f;
            short0 = 180;
        } else if (item.a(Items.oQ)) {
            f2 = 3.0f;
            short0 = 60;
            b0 = 3;
        } else if (item.a(Items.va)) {
            f2 = 4.0f;
            short0 = 60;
            b0 = 5;
            if (!this.dW().C && this.gF() && this.Z_() == 0 && !this.gy()) {
                flag = true;
                this.setInLove(player, item.v());
            }
        } else if (item.a(Items.qw) || item.a(Items.qx)) {
            f2 = 10.0f;
            short0 = 240;
            b0 = 10;
            if (!this.dW().C && this.gF() && this.Z_() == 0 && !this.gy()) {
                flag = true;
                this.setInLove(player, item.v());
            }
        }
        if (this.eE() < this.eS() && f2 > 0.0f) {
            this.heal(f2, EntityRegainHealthEvent.RegainReason.EATING);
            flag = true;
        }
        if (this.e_() && short0 > 0) {
            this.dW().a(Particles.O, this.d(1.0), this.dE() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
            if (!this.dW().C) {
                this.b_(short0);
                flag = true;
            }
        }
        if (!(b0 <= 0 || !flag && this.gF() || this.gL() >= this.gR() || this.dW().C)) {
            this.u(b0);
            flag = true;
        }
        if (flag) {
            this.p();
            ((Entity)this).a(GameEvent.m);
        }
        return flag;
    }

    protected void a(EntityHuman player) {
        this.B(false);
        this.C(false);
        if (!this.dW().C) {
            player.v(this.dM());
            player.w(this.dO());
            player.n(this);
        }
    }

    @Override
    public boolean fi() {
        return super.fi() && this.ca() && this.j() || this.gI() || this.gJ();
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.ak);
    }

    private void t() {
        this.cr = 1;
    }

    @Override
    protected void f(WorldServer world) {
        super.f(world);
        if (this.cu != null) {
            for (int i2 = 0; i2 < this.cu.b(); ++i2) {
                ItemStack itemstack = this.cu.a(i2);
                if (itemstack.f() || EnchantmentManager.a(itemstack, EnchantmentEffectComponents.D)) continue;
                this.a(world, itemstack);
            }
        }
    }

    @Override
    public void d_() {
        if (this.ae.a(200) == 0) {
            this.t();
        }
        super.d_();
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.bL()) {
                if (this.ae.a(900) == 0 && this.aP == 0) {
                    this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
                }
                if (this.gS()) {
                    if (!this.gI() && !this.ca() && this.ae.a(300) == 0 && worldserver.a_(this.dw().e()).a(Blocks.i)) {
                        this.B(true);
                    }
                    if (this.gI() && ++this.cJ > 50) {
                        this.cJ = 0;
                        this.B(false);
                    }
                }
                this.g(worldserver);
                return;
            }
        }
    }

    protected void g(WorldServer world) {
        EntityHorseAbstract entityliving;
        if (this.gK() && this.e_() && !this.gI() && (entityliving = world.a(EntityHorseAbstract.class, cj, this, this.dB(), this.dD(), this.dH(), this.cR().g(16.0))) != null && this.g((Entity)entityliving) > 4.0) {
            this.bS.a((Entity)entityliving, 0);
        }
    }

    public boolean gS() {
        return true;
    }

    @Override
    public void h() {
        super.h();
        if (this.cK > 0 && ++this.cK > 30) {
            this.cK = 0;
            this.d(64, false);
        }
        if (this.dk() && this.cL > 0 && ++this.cL > 20) {
            this.cL = 0;
            this.C(false);
        }
        if (this.cr > 0 && ++this.cr > 8) {
            this.cr = 0;
        }
        if (this.cs > 0) {
            ++this.cs;
            if (this.cs > 300) {
                this.cs = 0;
            }
        }
        this.cN = this.cM;
        if (this.gI()) {
            this.cM += (1.0f - this.cM) * 0.4f + 0.05f;
            if (this.cM > 1.0f) {
                this.cM = 1.0f;
            }
        } else {
            this.cM += (0.0f - this.cM) * 0.4f - 0.05f;
            if (this.cM < 0.0f) {
                this.cM = 0.0f;
            }
        }
        this.cP = this.cO;
        if (this.gJ()) {
            this.cN = this.cM = 0.0f;
            this.cO += (1.0f - this.cO) * 0.4f + 0.05f;
            if (this.cO > 1.0f) {
                this.cO = 1.0f;
            }
        } else {
            this.cx = false;
            this.cO += (0.8f * this.cO * this.cO * this.cO - this.cO) * 0.6f - 0.05f;
            if (this.cO < 0.0f) {
                this.cO = 0.0f;
            }
        }
        this.cR = this.cQ;
        if (this.s(64)) {
            this.cQ += (1.0f - this.cQ) * 0.7f + 0.05f;
            if (this.cQ > 1.0f) {
                this.cQ = 1.0f;
            }
        } else {
            this.cQ += (0.0f - this.cQ) * 0.7f - 0.05f;
            if (this.cQ < 0.0f) {
                this.cQ = 0.0f;
            }
        }
    }

    public void setMouthOpen(boolean open) {
        this.d(64, open);
    }

    public boolean isMouthOpen() {
        return this.s(64);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        if (!this.ca() && !this.e_()) {
            if (this.gF() && player.fY()) {
                this.b(player);
                return EnumInteractionResult.a;
            }
            ItemStack itemstack = player.b(hand);
            if (!itemstack.f()) {
                EnumInteractionResult enuminteractionresult = itemstack.a(player, (EntityLiving)this, hand);
                if (enuminteractionresult.a()) {
                    return enuminteractionresult;
                }
                if (this.a(itemstack, EnumItemSlot.g) && !this.ag()) {
                    this.b(player, itemstack);
                    return EnumInteractionResult.a;
                }
            }
            this.a(player);
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    private void x() {
        if (!this.dW().C) {
            this.cK = 1;
            this.d(64, true);
        }
    }

    public void B(boolean eatingGrass) {
        this.d(16, eatingGrass);
    }

    public void setForceStanding(boolean standing) {
        this.d(32, standing);
    }

    public void C(boolean angry) {
        if (angry) {
            this.B(false);
        }
        this.d(32, angry);
    }

    @Nullable
    public SoundEffect gT() {
        return this.u();
    }

    public void gU() {
        if (this.gp() && this.dk()) {
            this.cL = 1;
            this.C(true);
        }
    }

    public void gV() {
        if (!this.gJ()) {
            this.gU();
            this.b(this.gP());
        }
    }

    public boolean g(EntityHuman player) {
        this.b(player.cG());
        this.y(true);
        if (player instanceof EntityPlayer) {
            CriterionTriggers.y.a((EntityPlayer)player, this);
        }
        this.dW().a((Entity)this, (byte)7);
        return true;
    }

    @Override
    protected void a(EntityHuman controllingPlayer, Vec3D movementInput) {
        super.a(controllingPlayer, movementInput);
        Vec2F vec2f = this.j(controllingPlayer);
        this.b(vec2f.j, vec2f.i);
        this.aX = this.aZ = this.dM();
        this.N = this.aZ;
        if (this.di()) {
            if (movementInput.f <= 0.0) {
                this.cz = 0;
            }
            if (this.aJ()) {
                this.z(false);
                if (this.cw > 0.0f && !this.gH()) {
                    this.b(this.cw, movementInput);
                }
                this.cw = 0.0f;
            }
        }
    }

    protected Vec2F j(EntityLiving controllingPassenger) {
        return new Vec2F(controllingPassenger.dO() * 0.5f, controllingPassenger.dM());
    }

    @Override
    protected Vec3D b(EntityHuman controllingPlayer, Vec3D movementInput) {
        if (this.aJ() && this.cw == 0.0f && this.gJ() && !this.cx) {
            return Vec3D.c;
        }
        float f2 = controllingPlayer.bo * 0.5f;
        float f1 = controllingPlayer.bq;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3D(f2, 0.0, f1);
    }

    @Override
    protected float e(EntityHuman controllingPlayer) {
        return (float)this.h(GenericAttributes.v);
    }

    protected void b(float strength, Vec3D movementInput) {
        double d0 = this.A(strength);
        Vec3D vec3d1 = this.dz();
        this.n(vec3d1.d, d0, vec3d1.f);
        this.z(true);
        this.ar = true;
        if (movementInput.f > 0.0) {
            float f1 = MathHelper.a(this.dM() * ((float)Math.PI / 180));
            float f2 = MathHelper.b(this.dM() * ((float)Math.PI / 180));
            this.h(this.dz().b(-0.4f * f1 * strength, 0.0, 0.4f * f2 * strength));
        }
    }

    protected void gW() {
        this.a(SoundEffects.ng, 0.4f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("EatingHaystack", this.gI());
        nbt.a("Bred", this.gK());
        nbt.a("Temper", this.gL());
        nbt.a("Tame", this.gF());
        if (this.ab_() != null) {
            nbt.a("Owner", this.ab_());
        }
        nbt.a("Bukkit.MaxDomestication", this.maxDomestication);
        if (!this.cu.a(0).f()) {
            nbt.a("SaddleItem", this.cu.a(0).a(this.dY()));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        ItemStack itemstack;
        UUID uuid;
        super.a(nbt);
        this.B(nbt.q("EatingHaystack"));
        this.A(nbt.q("Bred"));
        this.t(nbt.h("Temper"));
        this.y(nbt.q("Tame"));
        if (nbt.b("Owner")) {
            uuid = nbt.a("Owner");
        } else {
            String s2 = nbt.l("Owner");
            uuid = NameReferencingFileConverter.a(this.cV(), s2);
        }
        if (uuid != null) {
            this.b(uuid);
        }
        if (nbt.e("Bukkit.MaxDomestication")) {
            this.maxDomestication = nbt.h("Bukkit.MaxDomestication");
        }
        if (nbt.b("SaddleItem", 10) && (itemstack = ItemStack.a((HolderLookup.a)this.dY(), (NBTBase)nbt.p("SaddleItem")).orElse(ItemStack.j)).a(Items.oe)) {
            this.cu.a(0, itemstack);
        }
        this.gO();
    }

    @Override
    public boolean a(EntityAnimal other) {
        return false;
    }

    protected boolean gX() {
        return !this.ca() && !this.bZ() && this.gF() && !this.e_() && this.eE() >= this.eS() && this.gy();
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return null;
    }

    protected void a(EntityAgeable other, EntityHorseAbstract child) {
        this.a(other, child, GenericAttributes.s, (double)ce, (double)cf);
        this.a(other, child, GenericAttributes.o, (double)cb, (double)cd);
        this.a(other, child, GenericAttributes.v, (double)bZ, (double)ca);
    }

    private void a(EntityAgeable other, EntityHorseAbstract child, Holder<AttributeBase> attribute, double min, double max) {
        double d2 = EntityHorseAbstract.a(this.i(attribute), other.i(attribute), min, max, this.ae);
        child.g(attribute).a(d2);
    }

    static double a(double parentBase, double otherParentBase, double min, double max, RandomSource random) {
        double d7;
        if (max <= min) {
            throw new IllegalArgumentException("Incorrect range for an attribute");
        }
        parentBase = MathHelper.a(parentBase, min, max);
        otherParentBase = MathHelper.a(otherParentBase, min, max);
        double d4 = 0.15 * (max - min);
        double d6 = (parentBase + otherParentBase) / 2.0;
        double d5 = Math.abs(parentBase - otherParentBase) + d4 * 2.0;
        double d8 = d6 + d5 * (d7 = (random.j() + random.j() + random.j()) / 3.0 - 0.5);
        if (d8 > max) {
            double d9 = d8 - max;
            return max - d9;
        }
        if (d8 < min) {
            double d9 = min - d8;
            return min + d9;
        }
        return d8;
    }

    public float J(float tickDelta) {
        return MathHelper.h(tickDelta, this.cN, this.cM);
    }

    public float K(float tickDelta) {
        return MathHelper.h(tickDelta, this.cP, this.cO);
    }

    public float L(float tickDelta) {
        return MathHelper.h(tickDelta, this.cR, this.cQ);
    }

    @Override
    public void b(int strength) {
        if (this.j()) {
            if (strength < 0) {
                strength = 0;
            } else {
                this.cx = true;
                this.gU();
            }
            this.cw = strength >= 90 ? 1.0f : 0.4f + 0.4f * (float)strength / 90.0f;
        }
    }

    @Override
    public boolean a() {
        return this.j();
    }

    @Override
    public void c(int height) {
        float power = height >= 90 ? 1.0f : 0.4f + 0.4f * (float)height / 90.0f;
        if (!CraftEventFactory.callHorseJumpEvent(this, power)) {
            return;
        }
        this.cx = true;
        this.gU();
        this.gW();
    }

    @Override
    public void b() {
    }

    protected void D(boolean positive) {
        ParticleType particletype = positive ? Particles.Q : Particles.af;
        for (int i2 = 0; i2 < 7; ++i2) {
            double d0 = this.ae.k() * 0.02;
            double d1 = this.ae.k() * 0.02;
            double d2 = this.ae.k() * 0.02;
            this.dW().a(particletype, this.d(1.0), this.dE() + 0.5, this.g(1.0), d0, d1, d2);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 7) {
            this.D(true);
        } else if (status == 6) {
            this.D(false);
        } else {
            super.b(status);
        }
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction positionUpdater) {
        super.a(passenger, positionUpdater);
        if (passenger instanceof EntityLiving) {
            ((EntityLiving)passenger).aX = this.aX;
        }
    }

    protected static float a(IntUnaryOperator randomIntGetter) {
        return 15.0f + (float)randomIntGetter.applyAsInt(8) + (float)randomIntGetter.applyAsInt(9);
    }

    protected static double a(DoubleSupplier randomDoubleGetter) {
        return (double)0.4f + randomDoubleGetter.getAsDouble() * 0.2 + randomDoubleGetter.getAsDouble() * 0.2 + randomDoubleGetter.getAsDouble() * 0.2;
    }

    protected static double b(DoubleSupplier randomDoubleGetter) {
        return ((double)0.45f + randomDoubleGetter.getAsDouble() * 0.3 + randomDoubleGetter.getAsDouble() * 0.3 + randomDoubleGetter.getAsDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean q_() {
        return false;
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        int j2 = mappedIndex - 400;
        if (j2 == 0) {
            return new SlotAccess(){

                @Override
                public ItemStack a() {
                    return EntityHorseAbstract.this.cu.a(0);
                }

                @Override
                public boolean a(ItemStack stack) {
                    if (!stack.f() && !stack.a(Items.oe)) {
                        return false;
                    }
                    EntityHorseAbstract.this.cu.a(0, stack);
                    EntityHorseAbstract.this.gO();
                    return true;
                }
            };
        }
        int k2 = mappedIndex - 500 + 1;
        return k2 >= 1 && k2 < this.cu.b() ? SlotAccess.a(this.cu, k2) : super.a_(mappedIndex);
    }

    @Override
    @Nullable
    public EntityLiving cX() {
        Entity entity;
        if (this.j() && (entity = this.da()) instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity;
            return entityhuman;
        }
        return super.cX();
    }

    @Nullable
    private Vec3D a(Vec3D offset, EntityLiving passenger) {
        double d0 = this.dB() + offset.d;
        double d1 = this.cR().b;
        double d2 = this.dH() + offset.f;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        block0: for (EntityPose entitypose : passenger.fO()) {
            blockposition_mutableblockposition.b(d0, d1, d2);
            double d3 = this.cR().e + 0.75;
            do {
                double d4 = this.dW().j(blockposition_mutableblockposition);
                if ((double)blockposition_mutableblockposition.v() + d4 > d3) continue block0;
                if (DismountUtil.a(d4)) {
                    AxisAlignedBB axisalignedbb = passenger.f(entitypose);
                    Vec3D vec3d1 = new Vec3D(d0, (double)blockposition_mutableblockposition.v() + d4, d2);
                    if (DismountUtil.a(this.dW(), passenger, axisalignedbb.c(vec3d1))) {
                        passenger.b(entitypose);
                        return vec3d1;
                    }
                }
                blockposition_mutableblockposition.c(EnumDirection.b);
            } while (!((double)blockposition_mutableblockposition.v() >= d3));
        }
        return null;
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        Vec3D vec3d = EntityHorseAbstract.a(this.dr(), (double)passenger.dr(), this.dM() + (passenger.fy() == EnumMainHand.b ? 90.0f : -90.0f));
        Vec3D vec3d1 = this.a(vec3d, passenger);
        if (vec3d1 != null) {
            return vec3d1;
        }
        Vec3D vec3d2 = EntityHorseAbstract.a(this.dr(), (double)passenger.dr(), this.dM() + (passenger.fy() == EnumMainHand.a ? 90.0f : -90.0f));
        Vec3D vec3d3 = this.a(vec3d2, passenger);
        return vec3d3 != null ? vec3d3 : this.du();
    }

    protected void a(RandomSource random) {
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        if (entityData == null) {
            entityData = new EntityAgeable.a(0.2f);
        }
        this.a(world.H_());
        return super.a(world, difficulty, spawnReason, entityData);
    }

    public boolean b(IInventory inventory) {
        return this.cu != inventory;
    }

    public int gY() {
        return this.Q();
    }

    @Override
    protected Vec3D a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return super.a(passenger, dimensions, scaleFactor).e(new Vec3D(0.0, 0.15 * (double)this.cP * (double)scaleFactor, -0.7 * (double)this.cP * (double)scaleFactor).b(-this.dM() * ((float)Math.PI / 180)));
    }

    public final IInventory gZ() {
        return this.cT;
    }

    public int ag_() {
        return 0;
    }
}

