/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.event.entity.EntityDeathEvent;

public abstract class EntityHorseChestedAbstract
extends EntityHorseAbstract {
    private static final DataWatcherObject<Boolean> bZ = DataWatcher.a(EntityHorseChestedAbstract.class, DataWatcherRegistry.k);
    private final EntitySize ca;

    protected EntityHorseChestedAbstract(EntityTypes<? extends EntityHorseChestedAbstract> type, World world) {
        super((EntityTypes<? extends EntityHorseAbstract>)type, world);
        this.cy = false;
        this.ca = type.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, type.m() - 0.15625f, 0.0f)).a(0.5f);
    }

    @Override
    protected void a(RandomSource random) {
        this.g(GenericAttributes.s).a(EntityHorseChestedAbstract.a(random::a));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bZ, false);
    }

    public static AttributeProvider.Builder p() {
        return EntityHorseChestedAbstract.gQ().a(GenericAttributes.v, 0.175f).a(GenericAttributes.o, 0.5);
    }

    public boolean t() {
        return this.al.a(bZ);
    }

    public void x(boolean hasChest) {
        this.al.a(bZ, hasChest);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? this.ca : super.e(pose);
    }

    @Override
    protected void f(WorldServer world) {
        super.f(world);
        if (this.t()) {
            this.a(world, Blocks.cD);
        }
    }

    @Override
    protected void postDeathDropItems(EntityDeathEvent event) {
        if (this.t() && (event == null || !event.isCancelled())) {
            this.x(false);
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("ChestedHorse", this.t());
        if (this.t()) {
            NBTTagList listTag = new NBTTagList();
            for (int i2 = 1; i2 < this.cu.b(); ++i2) {
                ItemStack itemStack = this.cu.a(i2);
                if (itemStack.f()) continue;
                NBTTagCompound compoundTag = new NBTTagCompound();
                compoundTag.a("Slot", (byte)(i2 - 1));
                listTag.add(itemStack.b(this.dY(), compoundTag));
            }
            nbt.a("Items", listTag);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.x(nbt.q("ChestedHorse"));
        this.gN();
        if (this.t()) {
            NBTTagList listTag = nbt.c("Items", 10);
            for (int i2 = 0; i2 < listTag.size(); ++i2) {
                NBTTagCompound compoundTag = listTag.a(i2);
                int j2 = compoundTag.f("Slot") & 0xFF;
                if (j2 >= this.cu.b() - 1) continue;
                this.cu.a(j2 + 1, ItemStack.a((HolderLookup.a)this.dY(), (NBTBase)compoundTag).orElse(ItemStack.j));
            }
        }
        this.gO();
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        return mappedIndex == 499 ? new SlotAccess(){

            @Override
            public ItemStack a() {
                return EntityHorseChestedAbstract.this.t() ? new ItemStack(Items.eZ) : ItemStack.j;
            }

            @Override
            public boolean a(ItemStack stack) {
                if (stack.f()) {
                    if (EntityHorseChestedAbstract.this.t()) {
                        EntityHorseChestedAbstract.this.x(false);
                        EntityHorseChestedAbstract.this.gN();
                    }
                    return true;
                }
                if (stack.a(Items.eZ)) {
                    if (!EntityHorseChestedAbstract.this.t()) {
                        EntityHorseChestedAbstract.this.x(true);
                        EntityHorseChestedAbstract.this.gN();
                    }
                    return true;
                }
                return false;
            }
        } : super.a_(mappedIndex);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean bl;
        boolean bl2 = bl = !this.e_() && this.gF() && player.fY();
        if (!this.ca() && !bl) {
            ItemStack itemStack = player.b(hand);
            if (!itemStack.f()) {
                if (this.j(itemStack)) {
                    return this.c(player, itemStack);
                }
                if (!this.gF()) {
                    this.gV();
                    return EnumInteractionResult.a;
                }
                if (!this.t() && itemStack.a(Items.eZ)) {
                    this.d(player, itemStack);
                    return EnumInteractionResult.a;
                }
            }
            return super.b(player, hand);
        }
        return super.b(player, hand);
    }

    private void d(EntityHuman player, ItemStack chest) {
        this.x(true);
        this.x();
        chest.a(1, (EntityLiving)player);
        this.gN();
    }

    protected void x() {
        this.a(SoundEffects.hB, 1.0f, (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
    }

    @Override
    public int ag_() {
        return this.t() ? 5 : 0;
    }
}

