/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.PathfinderGoalHorseTrap;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityHorseSkeleton
extends EntityHorseAbstract {
    private final PathfinderGoalHorseTrap bZ = new PathfinderGoalHorseTrap(this);
    private static final int ca = 18000;
    private static final EntitySize cb = EntityTypes.bg.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.bg.m() - 0.03125f, 0.0f)).a(0.5f);
    private boolean cd;
    public int ce;

    public EntityHorseSkeleton(EntityTypes<? extends EntityHorseSkeleton> type, World world) {
        super((EntityTypes<? extends EntityHorseAbstract>)type, world);
    }

    public static AttributeProvider.Builder p() {
        return EntityHorseSkeleton.gQ().a(GenericAttributes.s, 15.0).a(GenericAttributes.v, 0.2f);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> type, GeneratorAccess world, EntitySpawnReason reason, BlockPosition pos, RandomSource random) {
        return !EntitySpawnReason.a(reason) ? EntityAnimal.b(type, world, reason, pos, random) : EntitySpawnReason.b(reason) || EntityHorseSkeleton.a(world, pos);
    }

    @Override
    protected void a(RandomSource random) {
        AttributeModifiable attributemodifiable = this.g(GenericAttributes.o);
        Objects.requireNonNull(random);
        attributemodifiable.a(EntityHorseSkeleton.a(random::j));
    }

    @Override
    protected void gG() {
    }

    @Override
    protected SoundEffect u() {
        return ((Entity)this).a(TagsFluid.a) ? SoundEffects.xC : SoundEffects.xy;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.xz;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.xA;
    }

    @Override
    protected SoundEffect aV() {
        if (this.aJ()) {
            if (!this.ca()) {
                return SoundEffects.xF;
            }
            ++this.cz;
            if (this.cz > 5 && this.cz % 3 == 0) {
                return SoundEffects.xD;
            }
            if (this.cz <= 5) {
                return SoundEffects.xF;
            }
        }
        return SoundEffects.xB;
    }

    @Override
    protected void f(float volume) {
        if (this.aJ()) {
            super.f(0.3f);
        } else {
            super.f(Math.min(0.1f, volume * 25.0f));
        }
    }

    @Override
    protected void gW() {
        if (this.bj()) {
            this.a(SoundEffects.xE, 0.4f, 1.0f);
        } else {
            super.gW();
        }
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? cb : super.e(pose);
    }

    @Override
    public void d_() {
        super.d_();
        if (this.t() && this.ce++ >= 18000) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("SkeletonTrap", this.t());
        nbt.a("SkeletonTrapTime", this.ce);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.x(nbt.q("SkeletonTrap"));
        this.ce = nbt.h("SkeletonTrapTime");
    }

    @Override
    protected float fm() {
        return 0.96f;
    }

    public boolean t() {
        return this.cd;
    }

    public void x(boolean trapped) {
        if (trapped != this.cd) {
            this.cd = trapped;
            if (trapped) {
                this.bT.a(1, this.bZ);
            } else {
                this.bT.a(this.bZ);
            }
        }
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return EntityTypes.bg.a(world, EntitySpawnReason.e);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return !this.gF() ? EnumInteractionResult.e : super.b(player, hand);
    }
}

