/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLlamaFollow;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class EntityLlama
extends EntityHorseChestedAbstract
implements VariantHolder<Variant>,
IRangedEntity {
    private static final int bZ = 5;
    private static final DataWatcherObject<Integer> ca = DataWatcher.a(EntityLlama.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> cb = DataWatcher.a(EntityLlama.class, DataWatcherRegistry.b);
    private static final EntitySize cd = EntityTypes.ay.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.ay.m() - 0.8125f, -0.3f)).a(0.5f);
    boolean ce;
    @Nullable
    private EntityLlama cf;
    @Nullable
    public EntityLlama cg;

    public EntityLlama(EntityTypes<? extends EntityLlama> type, World world) {
        super((EntityTypes<? extends EntityHorseChestedAbstract>)type, world);
        this.L().a(40.0f);
        this.maxDomestication = 30;
    }

    public boolean gr() {
        return false;
    }

    public void setStrengthPublic(int i2) {
        this.w(i2);
    }

    private void w(int strength) {
        this.al.a(ca, Math.max(1, Math.min(5, strength)));
    }

    private void b(RandomSource random) {
        int i2 = random.i() < 0.04f ? 5 : 3;
        this.w(1 + random.a(i2));
    }

    public int gs() {
        return this.al.a(ca);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Variant", this.gB().g);
        nbt.a("Strength", this.gs());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.w(nbt.h("Strength"));
        super.a(nbt);
        this.a(Variant.a(nbt.h("Variant")));
    }

    @Override
    protected void B() {
        this.bT.a(0, new PathfinderGoalFloat(this));
        this.bT.a(1, new PathfinderGoalTame(this, 1.2));
        this.bT.a(2, new PathfinderGoalLlamaFollow(this, 2.1f));
        this.bT.a(3, new PathfinderGoalArrowAttack(this, 1.25, 40, 20.0f));
        this.bT.a(3, new PathfinderGoalPanic(this, 1.2));
        this.bT.a(4, new PathfinderGoalBreed(this, 1.0));
        this.bT.a(5, new PathfinderGoalTempt(this, 1.25, itemstack -> itemstack.a(TagsItem.at), false));
        this.bT.a(6, new PathfinderGoalFollowParent(this, 1.0));
        this.bT.a(7, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.bT.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bT.a(9, new PathfinderGoalRandomLookaround(this));
        this.bU.a(1, new c(this));
        this.bU.a(2, new a(this));
    }

    public static AttributeProvider.Builder gA() {
        return EntityLlama.p();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ca, 0);
        builder.a(cb, 0);
    }

    public Variant gB() {
        return Variant.a(this.al.a(cb));
    }

    @Override
    public void a(Variant variant) {
        this.al.a(cb, variant.g);
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.as);
    }

    @Override
    protected boolean a(EntityHuman player, ItemStack item) {
        SoundEffect soundeffect;
        int b0 = 0;
        int b1 = 0;
        float f2 = 0.0f;
        boolean flag = false;
        if (item.a(Items.pS)) {
            b0 = 10;
            b1 = 3;
            f2 = 2.0f;
        } else if (item.a(Blocks.iA.j())) {
            b0 = 90;
            b1 = 6;
            f2 = 10.0f;
            if (this.gF() && this.Z_() == 0 && this.gv()) {
                flag = true;
                this.setInLove(player, item.v());
            }
        }
        if (this.eE() < this.eS() && f2 > 0.0f) {
            this.heal(f2, EntityRegainHealthEvent.RegainReason.EATING);
            flag = true;
        }
        if (this.e_() && b0 > 0) {
            this.dW().a(Particles.O, this.d(1.0), this.dE() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
            if (!this.dW().C) {
                this.b_(b0);
            }
            flag = true;
        }
        if (b1 > 0 && (flag || !this.gF()) && this.gL() < this.gR()) {
            flag = true;
            if (!this.dW().C) {
                this.u(b1);
            }
        }
        if (flag && !this.bb() && (soundeffect = this.gq()) != null) {
            this.dW().a((EntityHuman)null, this.dB(), this.dD(), this.dH(), this.gq(), this.dn(), 1.0f, 1.0f + (this.ae.i() - this.ae.i()) * 0.2f);
        }
        return flag;
    }

    @Override
    public boolean fi() {
        return this.eF() || this.gI();
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        Variant entityllama_variant;
        RandomSource randomsource = world.H_();
        this.b(randomsource);
        if (entityData instanceof b) {
            entityllama_variant = ((b)entityData).a;
        } else {
            entityllama_variant = (Variant)SystemUtils.a((Object[])Variant.values(), randomsource);
            entityData = new b(entityllama_variant);
        }
        this.a(entityllama_variant);
        return super.a(world, difficulty, spawnReason, entityData);
    }

    @Override
    protected boolean gp() {
        return false;
    }

    @Override
    protected SoundEffect gP() {
        return SoundEffects.or;
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.oq;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.ov;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.ot;
    }

    @Override
    @Nullable
    protected SoundEffect gq() {
        return SoundEffects.ou;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.ox, 0.15f, 1.0f);
    }

    @Override
    protected void x() {
        this.a(SoundEffects.os, 1.0f, (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
    }

    @Override
    public int ag_() {
        return this.t() ? this.gs() : 0;
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return true;
    }

    @Override
    public boolean f() {
        return false;
    }

    @Override
    public int gR() {
        return super.gR();
    }

    @Override
    public boolean a(EntityAnimal other) {
        return other != this && other instanceof EntityLlama && this.gX() && ((EntityLlama)other).gX();
    }

    @Nullable
    public EntityLlama b(WorldServer world, EntityAgeable entity) {
        EntityLlama entityllama = this.gC();
        if (entityllama != null) {
            this.a(entity, entityllama);
            EntityLlama entityllama1 = (EntityLlama)entity;
            int i2 = this.ae.a(Math.max(this.gs(), entityllama1.gs())) + 1;
            if (this.ae.i() < 0.03f) {
                ++i2;
            }
            entityllama.w(i2);
            entityllama.a(this.ae.h() ? this.gB() : entityllama1.gB());
        }
        return entityllama;
    }

    @Nullable
    protected EntityLlama gC() {
        return EntityTypes.ay.a(this.dW(), EntitySpawnReason.e);
    }

    private void k(EntityLiving target) {
        EntityLlamaSpit entityllamaspit = new EntityLlamaSpit(this.dW(), this);
        double d0 = target.dB() - this.dB();
        double d1 = target.e(0.3333333333333333) - entityllamaspit.dD();
        double d2 = target.dH() - this.dH();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.2f;
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            IProjectile.a(entityllamaspit, worldserver, ItemStack.j, d0, d1 + d3, d2, 1.5f, 10.0f);
        }
        if (!this.bb()) {
            this.dW().a((EntityHuman)null, this.dB(), this.dD(), this.dH(), SoundEffects.ow, this.dn(), 1.0f, 1.0f + (this.ae.i() - this.ae.i()) * 0.2f);
        }
        this.ce = true;
    }

    void E(boolean spit) {
        this.ce = spit;
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        int i2 = this.f(fallDistance, damageMultiplier);
        if (i2 <= 0) {
            return false;
        }
        if (fallDistance >= 6.0f) {
            this.a(damageSource, (float)i2);
            if (this.ca()) {
                for (Entity entity : this.dd()) {
                    entity.a(damageSource, (float)i2);
                }
            }
        }
        this.eO();
        return true;
    }

    public void gD() {
        if (this.cf != null) {
            this.cf.cg = null;
        }
        this.cf = null;
    }

    @Override
    public void a(EntityLlama llama) {
        this.cf = llama;
        this.cf.cg = this;
    }

    public boolean gE() {
        return this.cg != null;
    }

    public boolean ha() {
        return this.cf != null;
    }

    @Nullable
    public EntityLlama hb() {
        return this.cf;
    }

    @Override
    protected double gn() {
        return 2.0;
    }

    @Override
    protected void g(WorldServer world) {
        if (!this.ha() && this.e_()) {
            super.g(world);
        }
    }

    @Override
    public boolean gS() {
        return false;
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        this.k(target);
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.75 * (double)this.cS(), (double)this.dr() * 0.5);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? cd : super.e(pose);
    }

    @Override
    protected Vec3D a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return EntityLlama.a(this, passenger, dimensions.d());
    }

    public static enum Variant implements INamable
    {
        a(0, "creamy"),
        b(1, "white"),
        c(2, "brown"),
        d(3, "gray");

        public static final Codec<Variant> e;
        private static final IntFunction<Variant> f;
        final int g;
        private final String h;

        private Variant(int i2, String s2) {
            this.g = i2;
            this.h = s2;
        }

        public int a() {
            return this.g;
        }

        public static Variant a(int id) {
            return f.apply(id);
        }

        @Override
        public String c() {
            return this.h;
        }

        static {
            e = INamable.a(Variant::values);
            f = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.c);
        }
    }

    private static class c
    extends PathfinderGoalHurtByTarget {
        public c(EntityLlama llama) {
            super(llama, new Class[0]);
        }

        @Override
        public boolean c() {
            EntityInsentient entityinsentient = this.e;
            if (entityinsentient instanceof EntityLlama) {
                EntityLlama entityllama = (EntityLlama)entityinsentient;
                if (entityllama.ce) {
                    entityllama.E(false);
                    return false;
                }
            }
            return super.c();
        }
    }

    private static class a
    extends PathfinderGoalNearestAttackableTarget<EntityWolf> {
        public a(EntityLlama llama) {
            super(llama, EntityWolf.class, 16, false, true, (entityliving, worldserver) -> !((EntityWolf)entityliving).p());
        }

        @Override
        protected double l() {
            return super.l() * 0.25;
        }
    }

    private static class b
    extends EntityAgeable.a {
        public final Variant a;

        b(Variant variant) {
            super(true);
            this.a = variant;
        }
    }
}

