/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sniffer;

import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.sniffer.SnifferAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;

public class Sniffer
extends EntityAnimal {
    private static final int cf = 1700;
    private static final int cg = 6000;
    private static final int ch = 30;
    private static final int ci = 120;
    private static final int cj = 48000;
    private static final float ck = 0.4f;
    private static final EntitySize cl = EntitySize.b(EntityTypes.bj.l(), EntityTypes.bj.m() - 0.4f).b(0.81f);
    private static final DataWatcherObject<State> cm = DataWatcher.a(Sniffer.class, DataWatcherRegistry.C);
    private static final DataWatcherObject<Integer> cn = DataWatcher.a(Sniffer.class, DataWatcherRegistry.b);
    public final AnimationState bZ = new AnimationState();
    public final AnimationState ca = new AnimationState();
    public final AnimationState cb = new AnimationState();
    public final AnimationState cd = new AnimationState();
    public final AnimationState ce = new AnimationState();

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gt().a(GenericAttributes.v, 0.1f).a(GenericAttributes.s, 14.0);
    }

    public Sniffer(EntityTypes<? extends EntityAnimal> type, World world) {
        super(type, world);
        this.L().a(true);
        this.a(PathType.j, -1.0f);
        this.a(PathType.g, -1.0f);
        this.a(PathType.y, -1.0f);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cm, State.a);
        builder.a(cn, 0);
    }

    @Override
    public void E() {
        super.E();
        if (this.bY() || this.bj()) {
            this.a(PathType.j, 0.0f);
        }
    }

    @Override
    public void F() {
        this.a(PathType.j, -1.0f);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.gB() == State.f ? cl.a(this.ej()) : super.e(pose);
    }

    public boolean t() {
        return this.gB() == State.e;
    }

    public boolean x() {
        return this.bF.c(MemoryModuleType.R).orElse(false);
    }

    public boolean go() {
        return !this.x() && !this.gl() && !this.bj() && !this.gy() && this.aJ() && !this.bZ() && !this.P_();
    }

    public boolean gp() {
        return this.gB() == State.f || this.gB() == State.e;
    }

    private BlockPosition gs() {
        Vec3D vec3d = this.gA();
        return BlockPosition.a(vec3d.a(), this.dD() + (double)0.2f, vec3d.c());
    }

    private Vec3D gA() {
        return this.du().e(this.bV().c(2.25));
    }

    public State gB() {
        return this.al.a(cm);
    }

    private Sniffer b(State state) {
        this.al.a(cm, state);
        return this;
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (cm.equals(data)) {
            State sniffer_state = this.gB();
            this.gC();
            switch (sniffer_state.ordinal()) {
                case 1: {
                    this.bZ.b(this.af);
                    break;
                }
                case 2: {
                    this.ca.b(this.af);
                    break;
                }
                case 3: {
                    this.cb.b(this.af);
                }
                default: {
                    break;
                }
                case 5: {
                    this.cd.b(this.af);
                    break;
                }
                case 6: {
                    this.ce.b(this.af);
                }
            }
            this.m_();
        }
        super.a(data);
    }

    private void gC() {
        this.cd.a();
        this.cb.a();
        this.ce.a();
        this.bZ.a();
        this.ca.a();
    }

    public Sniffer a(State state) {
        switch (state.ordinal()) {
            case 0: {
                this.b(State.a);
                break;
            }
            case 1: {
                this.a(SoundEffects.yV, 1.0f, 1.0f);
                this.b(State.b);
                break;
            }
            case 2: {
                this.b(State.c).gD();
                break;
            }
            case 3: {
                this.a(SoundEffects.yR, 1.0f, 1.0f);
                this.b(State.d);
                break;
            }
            case 4: {
                this.b(State.e);
                break;
            }
            case 5: {
                this.b(State.f).gE();
                break;
            }
            case 6: {
                this.a(SoundEffects.yU, 1.0f, 1.0f);
                this.b(State.g);
            }
        }
        return this;
    }

    private Sniffer gD() {
        this.a(SoundEffects.yQ, 1.0f, this.e_() ? 1.3f : 1.0f);
        return this;
    }

    private Sniffer gE() {
        this.al.a(cn, this.af + 120);
        this.dW().a((Entity)this, (byte)63);
        return this;
    }

    public Sniffer x(boolean explored) {
        if (explored) {
            this.i(this.aR());
        }
        return this;
    }

    public Optional<BlockPosition> gq() {
        return IntStream.range(0, 5).mapToObj(i2 -> LandRandomPos.a(this, 10 + 2 * i2, 3)).filter(Objects::nonNull).map(BlockPosition::a).filter(blockposition -> this.dW().F_().a((BlockPosition)blockposition)).map(BlockPosition::e).filter(this::h).findFirst();
    }

    public boolean gr() {
        return !this.gl() && !this.x() && !this.e_() && !this.bj() && this.aJ() && !this.bZ() && this.h(this.gs().e());
    }

    private boolean h(BlockPosition pos) {
        return this.dW().a_(pos).a(TagsBlock.cu) && this.gG().noneMatch(globalpos -> GlobalPos.a(this.dW().ah(), pos).equals(globalpos)) && Optional.ofNullable(this.L().a(pos, 1)).map(PathEntity::j).orElse(false) != false;
    }

    private void gF() {
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.al.a(cn) == this.af) {
                BlockPosition blockposition = this.gs();
                this.a(worldserver, LootTables.aG, (WorldServer worldserver1, ItemStack itemstack) -> {
                    EntityItem entityitem = new EntityItem(this.dW(), blockposition.u(), blockposition.v(), blockposition.w(), (ItemStack)itemstack);
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                    entityitem.s();
                    worldserver1.b(entityitem);
                });
                this.a(SoundEffects.yP, 1.0f, 1.0f);
                return;
            }
        }
    }

    private Sniffer a(AnimationState diggingAnimationState) {
        boolean flag;
        boolean bl = flag = diggingAnimationState.a((float)this.af) > 1700L && diggingAnimationState.a((float)this.af) < 6000L;
        if (flag) {
            BlockPosition blockposition = this.gs();
            IBlockData iblockdata = this.dW().a_(blockposition.e());
            if (iblockdata.o() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    Vec3D vec3d = Vec3D.b(blockposition).b(0.0, -0.65f, 0.0);
                    this.dW().a(new ParticleParamBlock(Particles.b, iblockdata), vec3d.d, vec3d.e, vec3d.f, 0.0, 0.0, 0.0);
                }
                if (this.af % 10 == 0) {
                    this.dW().a(this.dB(), this.dD(), this.dH(), iblockdata.A().f(), this.dn(), 0.5f, 0.5f, false);
                }
            }
        }
        if (this.af % 10 == 0) {
            this.dW().a(GameEvent.u, this.gs(), GameEvent.a.a(this));
        }
        return this;
    }

    public Sniffer i(BlockPosition pos) {
        List list = this.gG().limit(20L).collect(Collectors.toList());
        list.add(0, GlobalPos.a(this.dW().ah(), pos));
        this.ec().a(MemoryModuleType.aQ, list);
        return this;
    }

    public Stream<GlobalPos> gG() {
        return this.ec().c(MemoryModuleType.aQ).stream().flatMap(Collection::stream);
    }

    @Override
    public void s() {
        double d1;
        super.s();
        double d0 = this.bQ.c();
        if (d0 > 0.0 && (d1 = this.dz().j()) < 0.01) {
            this.a(0.1f, new Vec3D(0.0, 0.0, 1.0));
        }
    }

    @Override
    public void a(WorldServer world, EntityAnimal other) {
        EntityFertilizeEggEvent result = CraftEventFactory.callEntityFertilizeEggEvent(this, other);
        if (result.isCancelled()) {
            return;
        }
        ItemStack itemstack = new ItemStack(Items.kE);
        EntityItem entityitem = new EntityItem(world, this.du().a(), this.du().b(), this.du().c(), itemstack);
        entityitem.s();
        this.finalizeSpawnChildFromBreeding(world, other, null, result.getExperience());
        if (this.spawnAtLocation(world, entityitem) != null) {
            this.a(SoundEffects.yW, 1.0f, (this.ae.i() - this.ae.i()) * 0.2f + 0.5f);
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        this.a(State.a);
        super.a(damageSource);
    }

    @Override
    public void h() {
        switch (this.gB().ordinal()) {
            case 4: {
                this.gH();
                break;
            }
            case 5: {
                this.a(this.cd).gF();
            }
        }
        super.h();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        boolean flag = this.j(itemstack);
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (enuminteractionresult.a() && flag) {
            this.gu();
        }
        return enuminteractionresult;
    }

    @Override
    protected void gu() {
        this.dW().a((EntityHuman)null, this, SoundEffects.yL, SoundCategory.g, 1.0f, MathHelper.b(this.dW().A, 0.8f, 1.2f));
    }

    private void gH() {
        if (this.dW().B_() && this.af % 20 == 0) {
            this.dW().a(this.dB(), this.dD(), this.dH(), SoundEffects.yS, this.dn(), 1.0f, 1.0f, false);
        }
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.yK, 0.15f, 1.0f);
    }

    @Override
    protected SoundEffect u() {
        return Set.of(State.f, State.e).contains((Object)this.gB()) ? null : SoundEffects.yM;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.yN;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.yO;
    }

    @Override
    public int aa() {
        return 50;
    }

    @Override
    public void a(boolean baby) {
        this.c_(baby ? -48000 : 0);
    }

    @Override
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return EntityTypes.bj.a(world, EntitySpawnReason.e);
    }

    @Override
    public boolean a(EntityAnimal other) {
        if (!(other instanceof Sniffer)) {
            return false;
        }
        Sniffer sniffer = (Sniffer)other;
        Set<State> set = Set.of(State.a, State.c, State.b);
        return set.contains((Object)this.gB()) && set.contains((Object)sniffer.gB()) && super.a(other);
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.ac);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return SnifferAi.a(this.ed().a(dynamic));
    }

    public BehaviorController<Sniffer> ec() {
        return super.ec();
    }

    protected BehaviorController.b<Sniffer> ed() {
        return BehaviorController.a(SnifferAi.b, SnifferAi.a);
    }

    @Override
    protected void a(WorldServer world) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("snifferBrain");
        this.ec().a(world, this);
        gameprofilerfiller.b("snifferActivityUpdate");
        SnifferAi.a(this);
        gameprofilerfiller.c();
        super.a(world);
    }

    @Override
    protected void Y() {
        super.Y();
        PacketDebug.a(this);
    }

    public static enum State {
        a(0),
        b(1),
        c(2),
        d(3),
        e(4),
        f(5),
        g(6);

        public static final IntFunction<State> h;
        public static final StreamCodec<ByteBuf, State> i;
        private final int j;

        private State(int i2) {
            this.j = i2;
        }

        public int a() {
            return this.j;
        }

        static {
            h = ByIdMap.a(State::a, State.values(), ByIdMap.a.a);
            i = ByteBufCodecs.a(h, State::a);
        }
    }
}

