/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.dimension.end.EnumDragonRespawn;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityEnderCrystal
extends Entity {
    private static final DataWatcherObject<Optional<BlockPosition>> b = DataWatcher.a(EntityEnderCrystal.class, DataWatcherRegistry.p);
    private static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityEnderCrystal.class, DataWatcherRegistry.k);
    public int a;
    public boolean generatedByDragonFight = false;

    public EntityEnderCrystal(EntityTypes<? extends EntityEnderCrystal> type, World world) {
        super(type, world);
        this.I = true;
        this.a = this.ae.a(100000);
    }

    public EntityEnderCrystal(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityEnderCrystal>)EntityTypes.S, world);
        this.a_(x2, y2, z2);
    }

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(b, Optional.empty());
        builder.a(c, true);
    }

    @Override
    public void h() {
        ++this.a;
        this.aK();
        this.bW();
        if (this.dW() instanceof WorldServer) {
            BlockPosition blockposition = this.dw();
            if (((WorldServer)this.dW()).E() != null && this.dW().a_(blockposition).l() && !CraftEventFactory.callBlockIgniteEvent(this.dW(), blockposition, this).isCancelled()) {
                this.dW().b(blockposition, BlockFireAbstract.a(this.dW(), blockposition));
            }
            if (this.dW().paperConfig().unsupportedSettings.fixInvulnerableEndCrystalExploit && this.generatedByDragonFight && this.cC() && (!Objects.equals(((WorldServer)this.dW()).uuid, this.getOriginWorld()) || ((WorldServer)this.dW()).E() == null || ((WorldServer)this.dW()).E().z == null || ((WorldServer)this.dW()).E().z.ordinal() > EnumDragonRespawn.d.ordinal())) {
                this.n(false);
                this.a((BlockPosition)null);
            }
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        if (this.l() != null) {
            nbt.a("beam_target", GameProfileSerializer.a(this.l()));
        }
        nbt.a("ShowBottom", this.m());
        if (this.generatedByDragonFight) {
            nbt.a("Paper.GeneratedByDragonFight", this.generatedByDragonFight);
        }
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        GameProfileSerializer.a(nbt, "beam_target").ifPresent(this::a);
        if (nbt.b("ShowBottom", 1)) {
            this.a(nbt.q("ShowBottom"));
        }
        if (nbt.b("Paper.GeneratedByDragonFight", 1)) {
            this.generatedByDragonFight = nbt.q("Paper.GeneratedByDragonFight");
        }
    }

    @Override
    public boolean bH() {
        return true;
    }

    @Override
    public final boolean b(DamageSource source) {
        return this.d(source) ? false : !(source.d() instanceof EntityEnderDragon);
    }

    @Override
    public final boolean a(WorldServer world, DamageSource source, float amount) {
        if (this.d(source)) {
            return false;
        }
        if (source.d() instanceof EntityEnderDragon) {
            return false;
        }
        if (!this.dR()) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, false)) {
                return false;
            }
            if (!source.a(DamageTypeTags.l)) {
                DamageSource damagesource1 = source.d() != null ? this.dX().d(this, source.d()) : null;
                ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, 6.0f, false);
                if (event.isCancelled()) {
                    return false;
                }
                this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.EXPLODE);
                world.a(this, damagesource1, null, this.dB(), this.dD(), this.dH(), event.getRadius(), event.getFire(), World.a.b);
            } else {
                this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
            }
            this.a(world, source);
        }
        return true;
    }

    @Override
    public void c(WorldServer world) {
        this.a(world, this.dX().p());
        super.c(world);
    }

    private void a(WorldServer world, DamageSource source) {
        EnderDragonBattle enderdragonbattle = world.E();
        if (enderdragonbattle != null) {
            enderdragonbattle.a(this, source);
        }
    }

    public void a(@Nullable BlockPosition beamTarget) {
        this.au().a(b, Optional.ofNullable(beamTarget));
    }

    @Nullable
    public BlockPosition l() {
        return this.au().a(b).orElse(null);
    }

    public void a(boolean showBottom) {
        this.au().a(c, showBottom);
    }

    public boolean m() {
        return this.au().a(c);
    }

    @Override
    public boolean a(double distance) {
        return super.a(distance) || this.l() != null;
    }

    @Override
    public ItemStack dJ() {
        return new ItemStack(Items.vV);
    }
}

