/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.destroystokyo.paper.event.block.TNTPrimeEvent;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.DragonFlightHistory;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerManager;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EntityEnderDragon
extends EntityInsentient
implements IMonster {
    private static final Logger cd = LogUtils.getLogger();
    public static final DataWatcherObject<Integer> a = DataWatcher.a(EntityEnderDragon.class, DataWatcherRegistry.b);
    private static final PathfinderTargetCondition ce = PathfinderTargetCondition.a().a(64.0);
    private static final int cf = 200;
    private static final int cg = 400;
    private static final float ch = 0.25f;
    private static final String ci = "DragonDeathTime";
    private static final String cj = "DragonPhase";
    public final DragonFlightHistory b = new DragonFlightHistory();
    public final EntityComplexPart[] ck;
    public final EntityComplexPart c;
    private final EntityComplexPart cl;
    private final EntityComplexPart cm;
    private final EntityComplexPart cn;
    private final EntityComplexPart co;
    private final EntityComplexPart cp;
    private final EntityComplexPart cq;
    private final EntityComplexPart cr;
    public float d;
    public float bY;
    public boolean bZ;
    public int ca;
    public float cb;
    @Nullable
    public EntityEnderCrystal cc;
    @Nullable
    private EnderDragonBattle cs;
    private BlockPosition ct = BlockPosition.c;
    private final DragonControllerManager cu;
    private int cv = 100;
    private float cw;
    private final PathPoint[] cx = new PathPoint[24];
    private final int[] cy = new int[24];
    private final Path cz = new Path();
    private final Explosion explosionSource;
    @Nullable
    private BlockPosition podium;

    public EntityEnderDragon(EntityTypes<? extends EntityEnderDragon> entitytypes, World world) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.Q, world);
        this.c = new EntityComplexPart(this, "head", 1.0f, 1.0f);
        this.cl = new EntityComplexPart(this, "neck", 3.0f, 3.0f);
        this.cm = new EntityComplexPart(this, "body", 5.0f, 3.0f);
        this.cn = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.co = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cp = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cq = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.cr = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.ck = new EntityComplexPart[]{this.c, this.cl, this.cm, this.cn, this.co, this.cp, this.cq, this.cr};
        this.x(this.eS());
        this.ad = true;
        this.cu = new DragonControllerManager(this);
        this.explosionSource = new ServerExplosion(world.getMinecraftWorld(), this, null, null, new Vec3D(Double.NaN, Double.NaN, Double.NaN), Float.NaN, true, Explosion.Effect.b);
    }

    public void a(EnderDragonBattle fight) {
        this.cs = fight;
    }

    public void c(BlockPosition fightOrigin) {
        this.ct = fightOrigin;
    }

    public BlockPosition m() {
        return this.ct;
    }

    public static AttributeProvider.Builder p() {
        return EntityInsentient.C().a(GenericAttributes.s, 200.0);
    }

    public BlockPosition getPodium() {
        if (this.podium == null) {
            return WorldGenEndTrophy.a(this.m());
        }
        return this.podium;
    }

    public void setPodium(@Nullable BlockPosition blockPos) {
        this.podium = blockPos;
    }

    @Override
    public boolean ba() {
        float f2 = MathHelper.b(this.bY * ((float)Math.PI * 2));
        float f1 = MathHelper.b(this.d * ((float)Math.PI * 2));
        return f1 <= -0.3f && f2 >= -0.3f;
    }

    @Override
    public void aZ() {
        if (this.dW().C && !this.bb()) {
            this.dW().a(this.dB(), this.dD(), this.dH(), SoundEffects.ix, this.dn(), 5.0f, 0.8f + this.ae.i() * 0.3f, false);
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, DragonControllerPhase.k.b());
    }

    @Override
    public void d_() {
        WorldServer worldserver;
        EnderDragonBattle enderdragonbattle;
        World world;
        this.aO();
        if (this.dW().C) {
            this.x(this.eE());
            if (!this.bb() && !this.cu.a().a() && --this.cv < 0) {
                this.dW().a(this.dB(), this.dD(), this.dH(), SoundEffects.iy, this.dn(), 2.5f, 0.8f + this.ae.i() * 0.3f, false);
                this.cv = 200 + this.ae.a(200);
            }
        }
        if (this.cs == null && (world = this.dW()) instanceof WorldServer && (enderdragonbattle = (worldserver = (WorldServer)world).E()) != null && this.cG().equals(enderdragonbattle.i())) {
            this.cs = enderdragonbattle;
        }
        this.d = this.bY;
        if (this.eF()) {
            float f1 = (this.ae.i() - 0.5f) * 8.0f;
            float f2 = (this.ae.i() - 0.5f) * 4.0f;
            float f22 = (this.ae.i() - 0.5f) * 8.0f;
            this.dW().a(Particles.w, this.dB() + (double)f1, this.dD() + 2.0 + (double)f2, this.dH() + (double)f22, 0.0, 0.0, 0.0);
        } else {
            this.gn();
            Vec3D vec3d = this.dz();
            float f3 = 0.2f / ((float)vec3d.i() * 10.0f + 1.0f);
            this.bY = this.cu.a().a() ? (this.bY += 0.1f) : (this.bZ ? (this.bY += f3 * 0.5f) : (this.bY += (f3 *= (float)Math.pow(2.0, vec3d.e))));
            this.v(MathHelper.h(this.dM()));
            if (this.gb()) {
                this.bY = 0.5f;
            } else {
                int j2;
                float f5;
                float f4;
                float f32;
                this.b.a(this.dD(), this.dM());
                World world1 = this.dW();
                if (world1 instanceof WorldServer) {
                    Vec3D vec3d1;
                    WorldServer worldserver1 = (WorldServer)world1;
                    IDragonController idragoncontroller = this.cu.a();
                    idragoncontroller.a(worldserver1);
                    if (this.cu.a() != idragoncontroller) {
                        idragoncontroller = this.cu.a();
                        idragoncontroller.a(worldserver1);
                    }
                    if ((vec3d1 = idragoncontroller.f()) != null && idragoncontroller.h() != DragonControllerPhase.k) {
                        double d0 = vec3d1.d - this.dB();
                        double d1 = vec3d1.e - this.dD();
                        double d2 = vec3d1.f - this.dH();
                        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                        float f6 = idragoncontroller.e();
                        double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                        if (d4 > 0.0) {
                            d1 = MathHelper.a(d1 / d4, (double)(-f6), (double)f6);
                        }
                        this.h(this.dz().b(0.0, d1 * 0.01, 0.0));
                        this.v(MathHelper.h(this.dM()));
                        Vec3D vec3d2 = vec3d1.a(this.dB(), this.dD(), this.dH()).d();
                        Vec3D vec3d3 = new Vec3D(MathHelper.a(this.dM() * ((float)Math.PI / 180)), this.dz().e, -MathHelper.b(this.dM() * ((float)Math.PI / 180))).d();
                        f32 = Math.max(((float)vec3d3.b(vec3d2) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d0) > (double)1.0E-5f || Math.abs(d2) > (double)1.0E-5f) {
                            f4 = MathHelper.a(MathHelper.h(180.0f - (float)MathHelper.d(d0, d2) * 57.295776f - this.dM()), -50.0f, 50.0f);
                            this.cb *= 0.8f;
                            this.cb += f4 * idragoncontroller.g();
                            this.v(this.dM() + this.cb * 0.1f);
                        }
                        f4 = (float)(2.0 / (d3 + 1.0));
                        f5 = 0.06f;
                        this.a(0.06f * (f32 * f4 + (1.0f - f4)), new Vec3D(0.0, 0.0, -1.0));
                        if (this.bZ) {
                            this.a(EnumMoveType.a, this.dz().c((double)0.8f));
                        } else {
                            this.a(EnumMoveType.a, this.dz());
                        }
                        Vec3D vec3d4 = this.dz().d();
                        double d5 = 0.8 + 0.15 * (vec3d4.b(vec3d3) + 1.0) / 2.0;
                        this.h(this.dz().d(d5, 0.91f, d5));
                    }
                } else {
                    if (this.br > 0) {
                        this.a(this.br, this.bs, this.bt, this.bu, this.bv, this.bw);
                        --this.br;
                    }
                    this.cu.a().b();
                }
                if (!this.dW().B_()) {
                    this.aK();
                }
                this.aX = this.dM();
                Vec3D[] avec3d = new Vec3D[this.ck.length];
                for (int i2 = 0; i2 < this.ck.length; ++i2) {
                    avec3d[i2] = new Vec3D(this.ck[i2].dB(), this.ck[i2].dD(), this.ck[i2].dH());
                }
                float f7 = (float)(this.b.a(5).a() - this.b.a(10).a()) * 10.0f * ((float)Math.PI / 180);
                float f8 = MathHelper.b(f7);
                float f9 = MathHelper.a(f7);
                float f10 = this.dM() * ((float)Math.PI / 180);
                float f11 = MathHelper.a(f10);
                float f12 = MathHelper.b(f10);
                this.a(this.cm, (double)(f11 * 0.5f), 0.0, (double)(-f12 * 0.5f));
                this.a(this.cq, (double)(f12 * 4.5f), 2.0, (double)(f11 * 4.5f));
                this.a(this.cr, (double)(f12 * -4.5f), 2.0, (double)(f11 * -4.5f));
                World world2 = this.dW();
                if (world2 instanceof WorldServer) {
                    WorldServer worldserver2 = (WorldServer)world2;
                    if (this.aN == 0) {
                        this.a(worldserver2, worldserver2.a((Entity)this, this.cq.cR().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        this.a(worldserver2, worldserver2.a((Entity)this, this.cr.cR().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        this.b(worldserver2, worldserver2.a((Entity)this, this.c.cR().g(1.0), IEntitySelector.e));
                        this.b(worldserver2, worldserver2.a((Entity)this, this.cl.cR().g(1.0), IEntitySelector.e));
                    }
                }
                float f13 = MathHelper.a(this.dM() * ((float)Math.PI / 180) - this.cb * 0.01f);
                float f14 = MathHelper.b(this.dM() * ((float)Math.PI / 180) - this.cb * 0.01f);
                float f15 = this.gm();
                this.a(this.c, (double)(f13 * 6.5f * f8), (double)(f15 + f9 * 6.5f), (double)(-f14 * 6.5f * f8));
                this.a(this.cl, (double)(f13 * 5.5f * f8), (double)(f15 + f9 * 5.5f), (double)(-f14 * 5.5f * f8));
                DragonFlightHistory.a dragonflighthistory_a = this.b.a(5);
                for (j2 = 0; j2 < 3; ++j2) {
                    EntityComplexPart entitycomplexpart = null;
                    if (j2 == 0) {
                        entitycomplexpart = this.cn;
                    }
                    if (j2 == 1) {
                        entitycomplexpart = this.co;
                    }
                    if (j2 == 2) {
                        entitycomplexpart = this.cp;
                    }
                    DragonFlightHistory.a dragonflighthistory_a1 = this.b.a(12 + j2 * 2);
                    float f16 = this.dM() * ((float)Math.PI / 180) + this.i((double)(dragonflighthistory_a1.b() - dragonflighthistory_a.b())) * ((float)Math.PI / 180);
                    float f17 = MathHelper.a(f16);
                    f32 = MathHelper.b(f16);
                    f4 = 1.5f;
                    f5 = (float)(j2 + 1) * 2.0f;
                    this.a(entitycomplexpart, (double)(-(f11 * 1.5f + f17 * f5) * f8), dragonflighthistory_a1.a() - dragonflighthistory_a.a() - (double)((f5 + 1.5f) * f9) + 1.5, (double)((f12 * 1.5f + f32 * f5) * f8));
                }
                World world3 = this.dW();
                if (world3 instanceof WorldServer) {
                    WorldServer worldserver3 = (WorldServer)world3;
                    this.bZ = this.a(worldserver3, this.c.cR()) | this.a(worldserver3, this.cl.cR()) | this.a(worldserver3, this.cm.cR());
                    if (this.cs != null) {
                        this.cs.b(this);
                    }
                }
                for (j2 = 0; j2 < this.ck.length; ++j2) {
                    this.ck[j2].K = avec3d[j2].d;
                    this.ck[j2].L = avec3d[j2].e;
                    this.ck[j2].M = avec3d[j2].f;
                    this.ck[j2].aa = avec3d[j2].d;
                    this.ck[j2].ab = avec3d[j2].e;
                    this.ck[j2].ac = avec3d[j2].f;
                }
            }
        }
    }

    private void a(EntityComplexPart enderDragonPart, double dx, double dy, double dz) {
        enderDragonPart.a_(this.dB() + dx, this.dD() + dy, this.dH() + dz);
    }

    private float gm() {
        if (this.cu.a().a()) {
            return -1.0f;
        }
        DragonFlightHistory.a dragonflighthistory_a = this.b.a(5);
        DragonFlightHistory.a dragonflighthistory_a1 = this.b.a(0);
        return (float)(dragonflighthistory_a.a() - dragonflighthistory_a1.a());
    }

    private void gn() {
        if (this.cc != null) {
            if (this.cc.dR()) {
                this.cc = null;
            } else if (this.af % 10 == 0 && this.eE() < this.eS()) {
                EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0, EntityRegainHealthEvent.RegainReason.ENDER_CRYSTAL);
                this.dW().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.x((float)((double)this.eE() + event.getAmount()));
                }
            }
        }
        if (this.ae.a(10) == 0) {
            List<EntityEnderCrystal> list = this.dW().a(EntityEnderCrystal.class, this.cR().g(32.0));
            EntityEnderCrystal entityendercrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EntityEnderCrystal entityendercrystal1 : list) {
                double d1 = entityendercrystal1.g(this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entityendercrystal = entityendercrystal1;
            }
            this.cc = entityendercrystal;
        }
    }

    private void a(WorldServer world, List<Entity> entities) {
        double d0 = (this.cm.cR().a + this.cm.cR().d) / 2.0;
        double d1 = (this.cm.cR().c + this.cm.cR().f) / 2.0;
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLiving)) continue;
            EntityLiving entityliving = (EntityLiving)entity;
            double d2 = entity.dB() - d0;
            double d3 = entity.dH() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.push(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0, this);
            if (this.cu.a().a() || entityliving.er() >= entity.af - 2) continue;
            DamageSource damagesource = this.dX().b(this);
            entity.a(world, damagesource, 5.0f);
            EnchantmentManager.a(world, entity, damagesource);
        }
    }

    private void b(WorldServer world, List<Entity> entities) {
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLiving)) continue;
            DamageSource damagesource = this.dX().b(this);
            entity.a(world, damagesource, 10.0f);
            EnchantmentManager.a(world, entity, damagesource);
        }
    }

    private float i(double yawDegrees) {
        return (float)MathHelper.d(yawDegrees);
    }

    private boolean a(WorldServer world, AxisAlignedBB box) {
        int i2 = MathHelper.a(box.a);
        int j2 = MathHelper.a(box.b);
        int k2 = MathHelper.a(box.c);
        int l2 = MathHelper.a(box.d);
        int i1 = MathHelper.a(box.e);
        int j1 = MathHelper.a(box.f);
        boolean flag = false;
        boolean flag1 = false;
        ArrayList<org.bukkit.block.Block> destroyedBlocks = new ArrayList<org.bukkit.block.Block>();
        for (int k1 = i2; k1 <= l2; ++k1) {
            for (int l1 = j2; l1 <= i1; ++l1) {
                for (int i22 = k2; i22 <= j1; ++i22) {
                    BlockPosition blockposition = new BlockPosition(k1, l1, i22);
                    IBlockData iblockdata = world.a_(blockposition);
                    if (iblockdata.l() || iblockdata.a(TagsBlock.aG)) continue;
                    if (world.N().b(GameRules.c) && !iblockdata.a(TagsBlock.aF)) {
                        flag1 = true;
                        destroyedBlocks.add(CraftBlock.at(world, blockposition));
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (!flag1) {
            return flag;
        }
        EntityExplodeEvent event = CraftEventFactory.callEntityExplodeEvent(this, destroyedBlocks, 0.0f, this.explosionSource.b());
        if (event.isCancelled()) {
            return flag;
        }
        if (event.getYield() == 0.0f) {
            for (org.bukkit.block.Block block : event.blockList()) {
                this.dW().a(new BlockPosition(block.getX(), block.getY(), block.getZ()), false);
            }
        } else {
            for (org.bukkit.block.Block block : event.blockList()) {
                CraftBlock tntBlock;
                Material blockId = block.getType();
                if (blockId.isAir()) continue;
                CraftBlock craftBlock = (CraftBlock)block;
                BlockPosition blockposition = craftBlock.getPosition();
                Block nmsBlock = craftBlock.getNMS().b();
                if (nmsBlock.a(this.explosionSource)) {
                    TileEntity tileentity = craftBlock.getNMS().x() ? this.dW().c_(blockposition) : null;
                    LootParams.a loottableinfo_builder = new LootParams.a((WorldServer)this.dW()).a(LootContextParameters.f, Vec3D.b(blockposition)).a(LootContextParameters.i, ItemStack.j).a(LootContextParameters.j, Float.valueOf(1.0f / event.getYield())).b(LootContextParameters.h, tileentity);
                    craftBlock.getNMS().a(loottableinfo_builder).forEach(itemstack -> Block.a(this.dW(), blockposition, itemstack));
                    craftBlock.getNMS().a((WorldServer)this.dW(), blockposition, ItemStack.j, false);
                }
                if (!new TNTPrimeEvent((org.bukkit.block.Block)(tntBlock = CraftBlock.at(this.dW(), blockposition)), TNTPrimeEvent.PrimeReason.EXPLOSION, (org.bukkit.entity.Entity)this.explosionSource.c().getBukkitEntity()).callEvent()) continue;
                nmsBlock.a((WorldServer)this.dW(), blockposition, this.explosionSource);
                this.dW().a(blockposition, false);
            }
        }
        if (flag1) {
            BlockPosition blockposition1 = new BlockPosition(i2 + this.ae.a(l2 - i2 + 1), j2 + this.ae.a(i1 - j2 + 1), k2 + this.ae.a(j1 - k2 + 1));
            world.c(2008, blockposition1, 0);
        }
        return flag;
    }

    public boolean a(WorldServer world, EntityComplexPart part, DamageSource source, float amount) {
        if (this.cu.a().h() == DragonControllerPhase.j) {
            return false;
        }
        amount = this.cu.a().a(source, amount);
        if (part != this.c) {
            amount = amount / 4.0f + Math.min(amount, 1.0f);
        }
        if (amount < 0.01f) {
            return false;
        }
        if (source.d() instanceof EntityHuman || source.a(DamageTypeTags.y)) {
            float f1 = this.eE();
            this.c(world, source, amount);
            if (this.eF() && !this.cu.a().a()) {
                this.x(1.0f);
                this.cu.a(DragonControllerPhase.j);
            }
            if (this.cu.a().a()) {
                this.cw = this.cw + f1 - this.eE();
                if (this.cw > 0.25f * this.eS()) {
                    this.cw = 0.0f;
                    this.cu.a(DragonControllerPhase.e);
                }
            }
        }
        return true;
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        return this.a(world, this.cm, source, amount);
    }

    protected void c(WorldServer world, DamageSource source, float amount) {
        super.a(world, source, amount);
    }

    @Override
    public void c(WorldServer world) {
        this.silentDeath = true;
        EntityDeathEvent deathEvent = CraftEventFactory.callEntityDeathEvent(this, this.dX().y());
        if (deathEvent.isCancelled()) {
            this.silentDeath = false;
            return;
        }
        this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        ((Entity)this).a(GameEvent.p);
        if (this.cs != null) {
            this.cs.b(this);
            this.cs.a(this);
        }
    }

    @Override
    public int getExpReward(WorldServer worldserver, Entity entity) {
        boolean flag = worldserver.N().b(GameRules.f);
        int short0 = 500;
        if (this.cs != null && !this.cs.f()) {
            short0 = 12000;
        }
        return flag ? short0 : 0;
    }

    @Override
    protected void em() {
        if (this.cs != null) {
            this.cs.b(this);
        }
        ++this.ca;
        if (this.ca >= 180 && this.ca <= 200) {
            float f2 = (this.ae.i() - 0.5f) * 8.0f;
            float f1 = (this.ae.i() - 0.5f) * 4.0f;
            float f22 = (this.ae.i() - 0.5f) * 8.0f;
            this.dW().a(Particles.v, this.dB() + (double)f2, this.dD() + 2.0 + (double)f1, this.dH() + (double)f22, 0.0, 0.0, 0.0);
        }
        int short0 = this.expToDrop;
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.ca > 150 && this.ca % 5 == 0) {
                EntityExperienceOrb.award(worldserver, this.du(), MathHelper.d((float)short0 * 0.08f), ExperienceOrb.SpawnReason.ENTITY_DEATH, this.bc, this);
            }
            if (this.ca == 1 && !this.bb()) {
                int viewDistance = worldserver.getCraftServer().getViewDistance() * 16;
                for (EntityPlayer player : worldserver.getPlayersForGlobalSoundGamerule()) {
                    double deltaX = this.dB() - player.dB();
                    double deltaZ = this.dH() - player.dH();
                    double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                    double soundRadiusSquared = worldserver.getGlobalSoundRangeSquared(config -> config.dragonDeathSoundRadius);
                    if (!worldserver.N().b(GameRules.X) && distanceSquared > soundRadiusSquared) continue;
                    if (distanceSquared > (double)(viewDistance * viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.dB() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.dH() + deltaZ / deltaLength * (double)viewDistance;
                        player.f.b(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)relativeX, (int)this.dD(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.f.b(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)this.dB(), (int)this.dD(), (int)this.dH()), 0, true));
                }
            }
        }
        this.a(EnumMoveType.a, new Vec3D(0.0, 0.1f, 0.0));
        if (this.ca == 200 && (world = this.dW()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            EntityExperienceOrb.award(worldserver, this.du(), MathHelper.d((float)short0 * 0.2f), ExperienceOrb.SpawnReason.ENTITY_DEATH, this.bc, this);
            if (this.cs != null) {
                this.cs.a(this);
            }
            this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
            ((Entity)this).a(GameEvent.p);
        }
    }

    public int t() {
        if (this.cx[0] == null) {
            for (int i2 = 0; i2 < 24; ++i2) {
                int l2;
                int k2;
                int j2 = 5;
                if (i2 < 12) {
                    k2 = MathHelper.d(60.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                    l2 = MathHelper.d(60.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                } else if (i2 < 20) {
                    i1 = i2 - 12;
                    k2 = MathHelper.d(40.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    l2 = MathHelper.d(40.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    j2 += 10;
                } else {
                    i1 = i2 - 20;
                    k2 = MathHelper.d(20.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)i1)));
                    l2 = MathHelper.d(20.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)i1)));
                }
                int j1 = Math.max(73, this.dW().a(HeightMap.Type.f, new BlockPosition(k2, 0, l2)).v() + j2);
                this.cx[i2] = new PathPoint(k2, j1, l2);
            }
            this.cy[0] = 6146;
            this.cy[1] = 8197;
            this.cy[2] = 8202;
            this.cy[3] = 16404;
            this.cy[4] = 32808;
            this.cy[5] = 32848;
            this.cy[6] = 65696;
            this.cy[7] = 131392;
            this.cy[8] = 131712;
            this.cy[9] = 263424;
            this.cy[10] = 526848;
            this.cy[11] = 525313;
            this.cy[12] = 1581057;
            this.cy[13] = 3166214;
            this.cy[14] = 2138120;
            this.cy[15] = 6373424;
            this.cy[16] = 4358208;
            this.cy[17] = 12910976;
            this.cy[18] = 9044480;
            this.cy[19] = 9706496;
            this.cy[20] = 15216640;
            this.cy[21] = 0xD0E000;
            this.cy[22] = 11763712;
            this.cy[23] = 0x7E0000;
        }
        return this.q(this.dB(), this.dD(), this.dH());
    }

    public int q(double x2, double y2, double z2) {
        float f2 = 10000.0f;
        int i2 = 0;
        PathPoint pathpoint = new PathPoint(MathHelper.a(x2), MathHelper.a(y2), MathHelper.a(z2));
        int b0 = 0;
        if (this.cs == null || this.cs.e() == 0) {
            b0 = 12;
        }
        for (int j2 = b0; j2 < 24; ++j2) {
            float f1;
            if (this.cx[j2] == null || !((f1 = this.cx[j2].c(pathpoint)) < f2)) continue;
            f2 = f1;
            i2 = j2;
        }
        return i2;
    }

    @Nullable
    public PathEntity a(int from, int to, @Nullable PathPoint pathNode) {
        PathPoint pathpoint1;
        for (int k2 = 0; k2 < 24; ++k2) {
            pathpoint1 = this.cx[k2];
            pathpoint1.i = false;
            pathpoint1.f = 0.0f;
            pathpoint1.g = 0.0f;
            pathpoint1.f = 0.0f;
            pathpoint1.h = null;
            pathpoint1.d = -1;
        }
        PathPoint pathpoint2 = this.cx[from];
        pathpoint1 = this.cx[to];
        pathpoint2.g = 0.0f;
        pathpoint2.f = pathpoint2.f = pathpoint2.a(pathpoint1);
        this.cz.a();
        this.cz.a(pathpoint2);
        PathPoint pathpoint3 = pathpoint2;
        int b0 = 0;
        if (this.cs == null || this.cs.e() == 0) {
            b0 = 12;
        }
        while (!this.cz.e()) {
            int i1;
            PathPoint pathpoint4 = this.cz.c();
            if (pathpoint4.equals(pathpoint1)) {
                if (pathNode != null) {
                    pathNode.h = pathpoint1;
                    pathpoint1 = pathNode;
                }
                return this.a(pathpoint2, pathpoint1);
            }
            if (pathpoint4.a(pathpoint1) < pathpoint3.a(pathpoint1)) {
                pathpoint3 = pathpoint4;
            }
            pathpoint4.i = true;
            int l2 = 0;
            for (i1 = 0; i1 < 24; ++i1) {
                if (this.cx[i1] != pathpoint4) {
                    continue;
                }
                l2 = i1;
                break;
            }
            for (i1 = b0; i1 < 24; ++i1) {
                if ((this.cy[l2] & 1 << i1) <= 0) continue;
                PathPoint pathpoint5 = this.cx[i1];
                if (pathpoint5.i) continue;
                float f2 = pathpoint4.g + pathpoint4.a(pathpoint5);
                if (pathpoint5.c() && !(f2 < pathpoint5.g)) continue;
                pathpoint5.h = pathpoint4;
                pathpoint5.g = f2;
                pathpoint5.f = pathpoint5.a(pathpoint1);
                if (pathpoint5.c()) {
                    this.cz.a(pathpoint5, pathpoint5.g + pathpoint5.f);
                    continue;
                }
                pathpoint5.f = pathpoint5.g + pathpoint5.f;
                this.cz.a(pathpoint5);
            }
        }
        if (pathpoint3 == pathpoint2) {
            return null;
        }
        cd.debug("Failed to find path from {} to {}", (Object)from, (Object)to);
        if (pathNode != null) {
            pathNode.h = pathpoint3;
            pathpoint3 = pathNode;
        }
        return this.a(pathpoint2, pathpoint3);
    }

    private PathEntity a(PathPoint unused, PathPoint node) {
        ArrayList list = Lists.newArrayList();
        PathPoint pathpoint2 = node;
        list.add(0, node);
        while (pathpoint2.h != null) {
            pathpoint2 = pathpoint2.h;
            list.add(0, pathpoint2);
        }
        return new PathEntity(list, new BlockPosition(node.a, node.b, node.c), true);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a(cj, this.cu.a().h().b());
        nbt.a(ci, this.ca);
        nbt.a("Bukkit.expToDrop", this.expToDrop);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.e(cj)) {
            this.cu.a(DragonControllerPhase.a(nbt.h(cj)));
        }
        if (nbt.e(ci)) {
            this.ca = nbt.h(ci);
        }
        if (nbt.e("Bukkit.expToDrop")) {
            this.expToDrop = nbt.h("Bukkit.expToDrop");
        }
    }

    @Override
    public void dI() {
    }

    public EntityComplexPart[] x() {
        return this.ck;
    }

    @Override
    public boolean bH() {
        return false;
    }

    @Override
    public SoundCategory dn() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.iu;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.iz;
    }

    @Override
    public float fg() {
        return 5.0f;
    }

    public Vec3D J(float tickDelta) {
        Vec3D vec3d;
        IDragonController idragoncontroller = this.cu.a();
        DragonControllerPhase<? extends IDragonController> dragoncontrollerphase = idragoncontroller.h();
        if (dragoncontrollerphase != DragonControllerPhase.d && dragoncontrollerphase != DragonControllerPhase.e) {
            if (idragoncontroller.a()) {
                float f2 = this.dO();
                float f1 = 1.5f;
                this.w(-45.0f);
                vec3d = this.g(tickDelta);
                this.w(f2);
            } else {
                vec3d = this.g(tickDelta);
            }
        } else {
            BlockPosition blockposition = this.dW().a(HeightMap.Type.f, this.getPodium());
            float f1 = Math.max((float)Math.sqrt(blockposition.b(this.du())) / 4.0f, 1.0f);
            float f3 = 6.0f / f1;
            float f4 = this.dO();
            float f5 = 1.5f;
            this.w(-f3 * 1.5f * 5.0f);
            vec3d = this.g(tickDelta);
            this.w(f4);
        }
        return vec3d;
    }

    public void a(WorldServer world, EntityEnderCrystal crystal, BlockPosition pos, DamageSource source) {
        EntityHuman entityhuman = source.d() instanceof EntityHuman ? (EntityHuman)source.d() : world.a(ce, (double)pos.u(), (double)pos.v(), (double)pos.w());
        if (crystal == this.cc) {
            this.a(world, this.c, this.dX().d(crystal, entityhuman), 10.0f);
        }
        this.cu.a().a(crystal, pos, source, entityhuman);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (a.equals(data) && this.dW().C) {
            this.cu.a(DragonControllerPhase.a(this.au().a(a)));
        }
        super.a(data);
    }

    public DragonControllerManager gk() {
        return this.cu;
    }

    @Nullable
    public EnderDragonBattle gl() {
        return this.cs;
    }

    @Override
    public boolean b(MobEffect effect, @Nullable Entity source) {
        return false;
    }

    @Override
    protected boolean o(Entity entity) {
        return false;
    }

    @Override
    public boolean o(boolean allowVehicles) {
        return false;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        EntityComplexPart[] aentitycomplexpart = this.x();
        for (int i2 = 0; i2 < aentitycomplexpart.length; ++i2) {
            aentitycomplexpart[i2].e(i2 + packet.b());
        }
    }

    @Override
    public boolean c(EntityLiving target) {
        return target.ex();
    }

    @Override
    protected float b(float scale) {
        return 1.0f;
    }
}

