/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.wither;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.BossBattle;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityWither
extends EntityMonster
implements IRangedEntity {
    private static final DataWatcherObject<Integer> a = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> b = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final List<DataWatcherObject<Integer>> d = ImmutableList.of(a, b, c);
    private static final DataWatcherObject<Integer> bZ = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final int ca = 220;
    private final float[] cb = new float[2];
    private final float[] cc = new float[2];
    private final float[] cd = new float[2];
    private final float[] ce = new float[2];
    private final int[] cf = new int[2];
    private final int[] cg = new int[2];
    private int ch;
    public final BossBattleServer ci = (BossBattleServer)new BossBattleServer(this.p_(), BossBattle.BarColor.f, BossBattle.BarStyle.a).a(true);
    private static final PathfinderTargetCondition.a cj = (entityliving, worldserver) -> !entityliving.aq().a(TagsEntity.y) && entityliving.fM();
    private static final PathfinderTargetCondition ck = PathfinderTargetCondition.a().a(20.0).a(cj);
    private boolean canPortal = false;

    public void setCanTravelThroughPortals(boolean canPortal) {
        this.canPortal = canPortal;
    }

    public EntityWither(EntityTypes<? extends EntityWither> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
        this.bQ = new ControllerMoveFlying(this, 10, false);
        this.x(this.eS());
        this.bO = 50;
    }

    @Override
    protected NavigationAbstract b(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world);
        navigationflying.b(false);
        navigationflying.a(true);
        navigationflying.c(true);
        return navigationflying;
    }

    @Override
    protected void B() {
        this.bT.a(0, new a());
        this.bT.a(2, new PathfinderGoalArrowAttack(this, 1.0, 40, 20.0f));
        this.bT.a(5, new PathfinderGoalRandomFly(this, 1.0));
        this.bT.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bT.a(7, new PathfinderGoalRandomLookaround(this));
        this.bU.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bU.a(2, new PathfinderGoalNearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 0, false, false, cj));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, 0);
        builder.a(b, 0);
        builder.a(c, 0);
        builder.a(bZ, 0);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Invul", this.go());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.b(nbt.h("Invul"));
        if (this.l_()) {
            this.ci.a(this.p_());
        }
    }

    @Override
    public void b(@Nullable IChatBaseComponent name) {
        super.b(name);
        this.ci.a(this.p_());
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.CX;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.Da;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.CZ;
    }

    @Override
    public void d_() {
        int i2;
        Entity entity;
        Vec3D vec3d = this.dz().d(1.0, 0.6, 1.0);
        if (!this.dW().C && this.c(0) > 0 && (entity = this.dW().a(this.c(0))) != null) {
            double d0 = vec3d.e;
            if (this.dD() < entity.dD() || !this.gp() && this.dD() < entity.dD() + 5.0) {
                d0 = Math.max(0.0, d0);
                d0 += 0.3 - d0 * (double)0.6f;
            }
            vec3d = new Vec3D(vec3d.d, d0, vec3d.f);
            Vec3D vec3d1 = new Vec3D(entity.dB() - this.dB(), 0.0, entity.dH() - this.dH());
            if (vec3d1.j() > 9.0) {
                Vec3D vec3d2 = vec3d1.d();
                vec3d = vec3d.b(vec3d2.d * 0.3 - vec3d.d * 0.6, 0.0, vec3d2.f * 0.3 - vec3d.f * 0.6);
            }
        }
        this.h(vec3d);
        if (vec3d.j() > 0.05) {
            this.v((float)MathHelper.d(vec3d.f, vec3d.d) * 57.295776f - 90.0f);
        }
        super.d_();
        for (i2 = 0; i2 < 2; ++i2) {
            this.ce[i2] = this.cc[i2];
            this.cd[i2] = this.cb[i2];
        }
        for (i2 = 0; i2 < 2; ++i2) {
            int j2 = this.c(i2 + 1);
            Entity entity1 = null;
            if (j2 > 0) {
                entity1 = this.dW().a(j2);
            }
            if (entity1 != null) {
                double d1 = this.r(i2 + 1);
                double d2 = this.s(i2 + 1);
                double d3 = this.t(i2 + 1);
                double d4 = entity1.dB() - d1;
                double d5 = entity1.dF() - d2;
                double d6 = entity1.dH() - d3;
                double d7 = Math.sqrt(d4 * d4 + d6 * d6);
                float f2 = (float)(MathHelper.d(d6, d4) * 57.2957763671875) - 90.0f;
                float f1 = (float)(-(MathHelper.d(d5, d7) * 57.2957763671875));
                this.cb[i2] = this.a(this.cb[i2], f1, 40.0f);
                this.cc[i2] = this.a(this.cc[i2], f2, 10.0f);
                continue;
            }
            this.cc[i2] = this.a(this.cc[i2], this.aX, 10.0f);
        }
        boolean flag = this.gp();
        for (int j3 = 0; j3 < 3; ++j3) {
            double d8 = this.r(j3);
            double d9 = this.s(j3);
            double d10 = this.t(j3);
            float f2 = 0.3f * this.ek();
            this.dW().a(Particles.af, d8 + this.ae.k() * (double)f2, d9 + this.ae.k() * (double)f2, d10 + this.ae.k() * (double)f2, 0.0, 0.0, 0.0);
            if (!flag || this.dW().A.a(4) != 0) continue;
            this.dW().a(ColorParticleOption.a(Particles.u, 0.7f, 0.7f, 0.5f), d8 + this.ae.k() * (double)f2, d9 + this.ae.k() * (double)f2, d10 + this.ae.k() * (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.go() > 0) {
            float f3 = 3.3f * this.ek();
            for (int k2 = 0; k2 < 3; ++k2) {
                this.dW().a(ColorParticleOption.a(Particles.u, 0.7f, 0.7f, 0.9f), this.dB() + this.ae.k(), this.dD() + (double)(this.ae.i() * f3), this.dH() + this.ae.k(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void a(WorldServer world) {
        if (this.go() > 0) {
            int i2 = this.go() - 1;
            this.ci.a(1.0f - (float)i2 / 220.0f);
            if (i2 <= 0) {
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 7.0f, false);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    world.a((Entity)this, this.dB(), this.dF(), this.dH(), event.getRadius(), event.getFire(), World.a.c);
                }
                if (!this.bb()) {
                    int viewDistance = world.getCraftServer().getViewDistance() * 16;
                    for (EntityPlayer player : world.getPlayersForGlobalSoundGamerule()) {
                        double deltaX = this.dB() - player.dB();
                        double deltaZ = this.dH() - player.dH();
                        double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                        double soundRadiusSquared = world.getGlobalSoundRangeSquared(config -> config.witherSpawnSoundRadius);
                        if (!world.N().b(GameRules.X) && distanceSquared > soundRadiusSquared) continue;
                        if (distanceSquared > (double)(viewDistance * viewDistance)) {
                            double deltaLength = Math.sqrt(distanceSquared);
                            double relativeX = player.dB() + deltaX / deltaLength * (double)viewDistance;
                            double relativeZ = player.dH() + deltaZ / deltaLength * (double)viewDistance;
                            player.f.b(new PacketPlayOutWorldEvent(1023, new BlockPosition((int)relativeX, (int)this.dD(), (int)relativeZ), 0, true));
                            continue;
                        }
                        player.f.b(new PacketPlayOutWorldEvent(1023, this.dw(), 0, true));
                    }
                }
            }
            this.b(i2);
            if (this.af % 10 == 0) {
                this.heal(10.0f, EntityRegainHealthEvent.RegainReason.WITHER_SPAWN);
            }
        } else {
            int j2;
            super.a(world);
            for (int i3 = 1; i3 < 3; ++i3) {
                EntityLiving entityliving1;
                if (this.af < this.cf[i3 - 1]) continue;
                this.cf[i3 - 1] = this.af + 10 + this.ae.a(10);
                if (world.al() == EnumDifficulty.c || world.al() == EnumDifficulty.d) {
                    int k2 = i3 - 1;
                    int l2 = this.cg[i3 - 1];
                    this.cg[k2] = this.cg[i3 - 1] + 1;
                    if (l2 > 15) {
                        float f2 = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.a(this.ae, this.dB() - 10.0, this.dB() + 10.0);
                        double d1 = MathHelper.a(this.ae, this.dD() - 5.0, this.dD() + 5.0);
                        double d2 = MathHelper.a(this.ae, this.dH() - 10.0, this.dH() + 10.0);
                        this.a(i3 + 1, d0, d1, d2, true);
                        this.cg[i3 - 1] = 0;
                    }
                }
                if ((j2 = this.c(i3)) > 0) {
                    EntityLiving entityliving = (EntityLiving)world.a(j2);
                    if (entityliving != null && this.c(entityliving) && this.g((Entity)entityliving) <= 900.0 && this.E(entityliving)) {
                        this.a(i3 + 1, entityliving);
                        this.cf[i3 - 1] = this.af + 40 + this.ae.a(20);
                        this.cg[i3 - 1] = 0;
                        continue;
                    }
                    this.a(i3, 0);
                    continue;
                }
                List<EntityLiving> list = world.a(EntityLiving.class, ck, this, this.cR().c(20.0, 8.0, 20.0));
                if (list.isEmpty() || CraftEventFactory.callEntityTargetLivingEvent(this, entityliving1 = list.get(this.ae.a(list.size())), EntityTargetEvent.TargetReason.CLOSEST_ENTITY).isCancelled()) continue;
                this.a(i3, entityliving1.ar());
            }
            if (this.O_() != null) {
                this.a(0, this.O_().ar());
            } else {
                this.a(0, 0);
            }
            if (this.ch > 0) {
                --this.ch;
                if (this.ch == 0 && world.N().b(GameRules.c)) {
                    boolean flag = false;
                    j2 = MathHelper.d(this.dr() / 2.0f + 1.0f);
                    int i1 = MathHelper.d(this.ds());
                    for (BlockPosition blockposition : BlockPosition.b(this.dA() - j2, this.dC(), this.dG() - j2, this.dA() + j2, this.dC() + i1, this.dG() + j2)) {
                        IBlockData iblockdata = world.a_(blockposition);
                        if (!EntityWither.c(iblockdata) || !CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, iblockdata.y().g())) continue;
                        flag = world.a(blockposition, true, this) || flag;
                    }
                    if (flag) {
                        world.a((EntityHuman)null, 1022, this.dw(), 0);
                    }
                }
            }
            if (this.af % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            this.ci.a(this.eE() / this.eS());
        }
    }

    public static boolean c(IBlockData block) {
        return !block.l() && !block.a(TagsBlock.aH);
    }

    public void m() {
        this.b(220);
        this.ci.a(0.0f);
        this.x(this.eS() / 3.0f);
    }

    @Override
    public void a(IBlockData state, Vec3D multiplier) {
    }

    @Override
    public void d(EntityPlayer player) {
        super.d(player);
        this.ci.a(player);
    }

    @Override
    public void e(EntityPlayer player) {
        super.e(player);
        this.ci.b(player);
    }

    private double r(int headIndex) {
        if (headIndex <= 0) {
            return this.dB();
        }
        float f2 = (this.aX + (float)(180 * (headIndex - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.b(f2);
        return this.dB() + (double)f1 * 1.3 * (double)this.ek();
    }

    private double s(int headIndex) {
        float f2 = headIndex <= 0 ? 3.0f : 2.2f;
        return this.dD() + (double)(f2 * this.ek());
    }

    private double t(int headIndex) {
        if (headIndex <= 0) {
            return this.dH();
        }
        float f2 = (this.aX + (float)(180 * (headIndex - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.a(f2);
        return this.dH() + (double)f1 * 1.3 * (double)this.ek();
    }

    private float a(float prevAngle, float desiredAngle, float maxDifference) {
        float f3 = MathHelper.h(desiredAngle - prevAngle);
        if (f3 > maxDifference) {
            f3 = maxDifference;
        }
        if (f3 < -maxDifference) {
            f3 = -maxDifference;
        }
        return prevAngle + f3;
    }

    private void a(int headIndex, EntityLiving target) {
        this.a(headIndex, target.dB(), target.dD() + (double)target.cS() * 0.5, target.dH(), headIndex == 0 && this.ae.i() < 0.001f);
    }

    private void a(int headIndex, double targetX, double targetY, double targetZ, boolean charged) {
        if (!this.bb()) {
            this.dW().a((EntityHuman)null, 1024, this.dw(), 0);
        }
        double d3 = this.r(headIndex);
        double d4 = this.s(headIndex);
        double d5 = this.t(headIndex);
        double d6 = targetX - d3;
        double d7 = targetY - d4;
        double d8 = targetZ - d5;
        Vec3D vec3d = new Vec3D(d6, d7, d8);
        EntityWitherSkull entitywitherskull = new EntityWitherSkull(this.dW(), this, vec3d.d());
        entitywitherskull.c(this);
        if (charged) {
            entitywitherskull.a(true);
        }
        entitywitherskull.a_(d3, d4, d5);
        this.dW().b(entitywitherskull);
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        this.a(0, target);
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        if (this.a(world, source)) {
            return false;
        }
        if (!source.a(DamageTypeTags.t) && !(source.d() instanceof EntityWither)) {
            Entity entity;
            if (this.go() > 0 && !source.a(DamageTypeTags.d)) {
                return false;
            }
            if (this.gp() && ((entity = source.c()) instanceof EntityArrow || entity instanceof WindCharge)) {
                return false;
            }
            entity = source.d();
            if (entity != null && entity.aq().a(TagsEntity.y)) {
                return false;
            }
            if (this.ch <= 0) {
                this.ch = 20;
            }
            int i2 = 0;
            while (i2 < this.cg.length) {
                int n2 = i2++;
                this.cg[n2] = this.cg[n2] + 3;
            }
            return super.a(world, source, amount);
        }
        return false;
    }

    @Override
    protected void a(WorldServer world, DamageSource source, boolean causedByPlayer) {
        super.a(world, source, causedByPlayer);
        EntityItem entityitem = this.spawnAtLocation(world, new ItemStack(Items.vi), 0.0f, EntityItem::x);
        if (entityitem != null) {
            entityitem.x();
        }
    }

    @Override
    public void dI() {
        if (this.dW().al() == EnumDifficulty.a && this.X()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            this.bf = 0;
        }
    }

    @Override
    public boolean b(MobEffect effect, @Nullable Entity source) {
        return false;
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gt().a(GenericAttributes.s, 300.0).a(GenericAttributes.v, 0.6f).a(GenericAttributes.l, 0.6f).a(GenericAttributes.m, 40.0).a(GenericAttributes.a, 4.0);
    }

    public float[] t() {
        return this.cc;
    }

    public float[] x() {
        return this.cb;
    }

    public int go() {
        return this.al.a(bZ);
    }

    public void b(int ticks) {
        this.al.a(bZ, ticks);
    }

    public int c(int headIndex) {
        return this.al.a(d.get(headIndex));
    }

    public void a(int headIndex, int id) {
        this.al.a(d.get(headIndex), id);
    }

    public boolean gp() {
        return this.eE() <= this.eS() / 2.0f;
    }

    @Override
    protected boolean o(Entity entity) {
        return false;
    }

    @Override
    public boolean o(boolean allowVehicles) {
        return this.canPortal;
    }

    @Override
    public boolean b(MobEffect effect) {
        return effect.a(MobEffects.t) && this.dW().paperConfig().entities.mobEffects.immuneToWitherEffect.wither ? false : super.b(effect);
    }

    private class a
    extends PathfinderGoal {
        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.c, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return EntityWither.this.go() > 0;
        }
    }
}

