/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.slf4j.Logger;

public abstract class BlockAttachedEntity
extends Entity {
    private static final Logger b = LogUtils.getLogger();
    private int c;
    protected BlockPosition a;

    protected BlockAttachedEntity(EntityTypes<? extends BlockAttachedEntity> type, World world) {
        super(type, world);
        this.c = this.ar() % this.dW().spigotConfig.hangingTickFrequency;
    }

    protected BlockAttachedEntity(EntityTypes<? extends BlockAttachedEntity> type, World world, BlockPosition attachedBlockPos) {
        this(type, world);
        this.a = attachedBlockPos;
    }

    protected abstract void l();

    @Override
    public void h() {
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.aA();
            if (this.c++ == this.dW().spigotConfig.hangingTickFrequency) {
                this.c = 0;
                if (!this.dR() && !this.m()) {
                    IBlockData material = this.dW().a_(this.dw());
                    HangingBreakEvent.RemoveCause cause = !material.l() ? HangingBreakEvent.RemoveCause.OBSTRUCTION : HangingBreakEvent.RemoveCause.PHYSICS;
                    HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), cause);
                    this.dW().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (this.dR() || event.isCancelled()) {
                        return;
                    }
                    this.discard(EntityRemoveEvent.Cause.DROP);
                    this.a(worldserver, (Entity)null);
                }
            }
        }
    }

    public abstract boolean m();

    @Override
    public boolean bH() {
        return true;
    }

    @Override
    public boolean v(Entity attacker) {
        if (attacker instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)attacker;
            return !this.dW().a(entityhuman, this.a) ? true : this.b(this.dX().a(entityhuman), 0.0f);
        }
        return false;
    }

    @Override
    public boolean b(DamageSource source) {
        return !this.d(source);
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        if (this.d(source)) {
            return false;
        }
        if (!world.N().b(GameRules.c) && source.d() instanceof EntityInsentient) {
            return false;
        }
        if (!this.dR()) {
            Entity damager;
            Entity entity = damager = !source.b() && source.d() != null ? source.d() : source.c();
            Object event = damager != null ? new HangingBreakByEntityEvent((Hanging)this.getBukkitEntity(), (org.bukkit.entity.Entity)damager.getBukkitEntity(), source.a(DamageTypeTags.l) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.ENTITY) : new HangingBreakEvent((Hanging)this.getBukkitEntity(), source.a(DamageTypeTags.l) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.DEFAULT);
            this.dW().getCraftServer().getPluginManager().callEvent((Event)event);
            if (this.dR() || event.isCancelled()) {
                return true;
            }
            this.c(world);
            this.bD();
            this.a(world, source.d());
        }
        return true;
    }

    @Override
    public boolean a(Explosion explosion) {
        return explosion.h() ? super.a(explosion) : true;
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!this.dR() && movement.h() > 0.0) {
                HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), HangingBreakEvent.RemoveCause.PHYSICS);
                this.dW().getCraftServer().getPluginManager().callEvent((Event)event);
                if (this.dR() || event.isCancelled()) {
                    return;
                }
                this.c(worldserver);
                this.a(worldserver, (Entity)null);
            }
        }
    }

    @Override
    public void push(double deltaX, double deltaY, double deltaZ, @Nullable Entity pushingEntity) {
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)world;
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound, boolean includeAll) {
        if (includeAll) {
            this.b(nbttagcompound);
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        BlockPosition blockposition = this.p();
        nbt.a("TileX", blockposition.u());
        nbt.a("TileY", blockposition.v());
        nbt.a("TileZ", blockposition.w());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        BlockPosition blockposition = new BlockPosition(nbt.h("TileX"), nbt.h("TileY"), nbt.h("TileZ"));
        if (!blockposition.a(this.dw(), 16.0)) {
            b.error("Block-attached entity at invalid position: {}", (Object)blockposition);
        } else {
            this.a = blockposition;
        }
    }

    public abstract void a(WorldServer var1, @Nullable Entity var2);

    @Override
    protected boolean bJ() {
        return false;
    }

    @Override
    public void a_(double x2, double y2, double z2) {
        this.a = BlockPosition.a(x2, y2, z2);
        this.l();
        this.ar = true;
    }

    public BlockPosition p() {
        return this.a;
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
    }

    @Override
    public void m_() {
    }
}

