/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vector3f;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class EntityArmorStand
extends EntityLiving {
    public static final int a = 5;
    private static final boolean bR = true;
    public static final Vector3f b = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f c = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f d = new Vector3f(-10.0f, 0.0f, -10.0f);
    public static final Vector3f e = new Vector3f(-15.0f, 0.0f, 10.0f);
    public static final Vector3f f = new Vector3f(-1.0f, 0.0f, -1.0f);
    public static final Vector3f g = new Vector3f(1.0f, 0.0f, 1.0f);
    private static final EntitySize bS = EntitySize.c(0.0f, 0.0f);
    private static final EntitySize bT = EntityTypes.f.n().a(0.5f).b(0.9875f);
    private static final double bU = 0.1;
    private static final double bV = 0.9;
    private static final double bW = 0.4;
    private static final double bX = 1.6;
    public static final int h = 8;
    public static final int i = 16;
    public static final int j = 1;
    public static final int k = 4;
    public static final int bH = 8;
    public static final int bI = 16;
    public static final DataWatcherObject<Byte> bJ = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Vector3f> bK = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> bL = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> bM = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> bN = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> bO = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    public static final DataWatcherObject<Vector3f> bP = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.n);
    private static final Predicate<Entity> bY = entity -> {
        EntityMinecartAbstract entityminecartabstract;
        if (entity instanceof EntityMinecartAbstract && (entityminecartabstract = (EntityMinecartAbstract)entity).D()) {
            boolean flag = true;
            return flag;
        }
        boolean flag = false;
        return flag;
    };
    private final NonNullList<net.minecraft.world.item.ItemStack> bZ;
    private final NonNullList<net.minecraft.world.item.ItemStack> ca;
    private boolean cb;
    public long bQ;
    public int cc;
    public Vector3f cd;
    public Vector3f ce;
    public Vector3f cf;
    public Vector3f cg;
    public Vector3f ch;
    public Vector3f ci;
    public boolean canMove = true;
    public boolean canTick = true;
    public boolean canTickSetByAPI = false;
    private boolean noTickPoseDirty = false;
    private boolean noTickEquipmentDirty = false;

    public EntityArmorStand(EntityTypes<? extends EntityArmorStand> type, World world) {
        super((EntityTypes<? extends EntityLiving>)type, world);
        if (world != null) {
            this.canTick = world.paperConfig().entities.armorStands.tick;
        }
        this.bZ = NonNullList.a(2, net.minecraft.world.item.ItemStack.j);
        this.ca = NonNullList.a(4, net.minecraft.world.item.ItemStack.j);
        this.cd = b;
        this.ce = c;
        this.cf = d;
        this.cg = e;
        this.ch = f;
        this.ci = g;
    }

    public EntityArmorStand(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityArmorStand>)EntityTypes.f, world);
        this.a_(x2, y2, z2);
    }

    public static AttributeProvider.Builder m() {
        return EntityArmorStand.ee().a(GenericAttributes.B, 0.0);
    }

    @Override
    public float getBukkitYaw() {
        return this.dM();
    }

    @Override
    public void m_() {
        double d0 = this.dB();
        double d1 = this.dD();
        double d2 = this.dH();
        super.m_();
        this.a_(d0, d1, d2);
    }

    private boolean E() {
        return !this.x() && !this.bc();
    }

    @Override
    public boolean dk() {
        return super.dk() && this.E();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bJ, (byte)0);
        builder.a(bK, b);
        builder.a(bL, c);
        builder.a(bM, d);
        builder.a(bN, e);
        builder.a(bO, f);
        builder.a(bP, g);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> fc() {
        return this.bZ;
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> fb() {
        return this.ca;
    }

    @Override
    public net.minecraft.world.item.ItemStack a(EnumItemSlot slot) {
        switch (slot.a()) {
            case a: {
                return this.bZ.get(slot.b());
            }
            case b: {
                return this.ca.get(slot.b());
            }
        }
        return net.minecraft.world.item.ItemStack.j;
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.g && !this.g(slot);
    }

    @Override
    public void a(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        this.c(itemstack);
        switch (enumitemslot.a()) {
            case a: {
                this.onEquipItem(enumitemslot, this.bZ.set(enumitemslot.b(), itemstack), itemstack, silent);
                break;
            }
            case b: {
                this.onEquipItem(enumitemslot, this.ca.set(enumitemslot.b(), itemstack), itemstack, silent);
            }
        }
        this.noTickEquipmentDirty = true;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        for (net.minecraft.world.item.ItemStack itemstack : this.ca) {
            nbttaglist.add(itemstack.b(this.dY()));
        }
        nbt.a("ArmorItems", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (net.minecraft.world.item.ItemStack itemstack1 : this.bZ) {
            nbttaglist1.add(itemstack1.b(this.dY()));
        }
        nbt.a("HandItems", nbttaglist1);
        nbt.a("Invisible", this.cp());
        nbt.a("Small", this.p());
        nbt.a("ShowArms", this.t());
        nbt.a("DisabledSlots", this.cc);
        nbt.a("NoBasePlate", !this.u());
        if (this.x()) {
            nbt.a("Marker", this.x());
        }
        nbt.a("Pose", this.F());
        if (this.canTickSetByAPI) {
            nbt.a("Paper.CanTickOverride", this.canTick);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        NBTTagCompound nbttagcompound1;
        int i2;
        NBTTagList nbttaglist;
        super.a(nbt);
        if (nbt.b("ArmorItems", 9)) {
            nbttaglist = nbt.c("ArmorItems", 10);
            for (i2 = 0; i2 < this.ca.size(); ++i2) {
                nbttagcompound1 = nbttaglist.a(i2);
                this.ca.set(i2, net.minecraft.world.item.ItemStack.a((HolderLookup.a)this.dY(), nbttagcompound1));
            }
        }
        if (nbt.b("HandItems", 9)) {
            nbttaglist = nbt.c("HandItems", 10);
            for (i2 = 0; i2 < this.bZ.size(); ++i2) {
                nbttagcompound1 = nbttaglist.a(i2);
                this.bZ.set(i2, net.minecraft.world.item.ItemStack.a((HolderLookup.a)this.dY(), nbttagcompound1));
            }
        }
        this.k(nbt.q("Invisible"));
        this.u(nbt.q("Small"));
        this.a(nbt.q("ShowArms"));
        this.cc = nbt.h("DisabledSlots");
        this.b(nbt.q("NoBasePlate"));
        this.v(nbt.q("Marker"));
        boolean bl = this.ad = !this.E();
        if (nbt.e("Paper.CanTickOverride")) {
            this.canTick = nbt.q("Paper.CanTickOverride");
            this.canTickSetByAPI = true;
        }
        NBTTagCompound nbttagcompound2 = nbt.p("Pose");
        this.c(nbttagcompound2);
    }

    private void c(NBTTagCompound nbt) {
        NBTTagList nbttaglist = nbt.c("Head", 5);
        this.a(nbttaglist.isEmpty() ? b : new Vector3f(nbttaglist));
        NBTTagList nbttaglist1 = nbt.c("Body", 5);
        this.b(nbttaglist1.isEmpty() ? c : new Vector3f(nbttaglist1));
        NBTTagList nbttaglist2 = nbt.c("LeftArm", 5);
        this.c(nbttaglist2.isEmpty() ? d : new Vector3f(nbttaglist2));
        NBTTagList nbttaglist3 = nbt.c("RightArm", 5);
        this.d(nbttaglist3.isEmpty() ? e : new Vector3f(nbttaglist3));
        NBTTagList nbttaglist4 = nbt.c("LeftLeg", 5);
        this.e(nbttaglist4.isEmpty() ? f : new Vector3f(nbttaglist4));
        NBTTagList nbttaglist5 = nbt.c("RightLeg", 5);
        this.f(nbttaglist5.isEmpty() ? g : new Vector3f(nbttaglist5));
    }

    private NBTTagCompound F() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (!b.equals(this.cd)) {
            nbttagcompound.a("Head", this.cd.a());
        }
        if (!c.equals(this.ce)) {
            nbttagcompound.a("Body", this.ce.a());
        }
        if (!d.equals(this.cf)) {
            nbttagcompound.a("LeftArm", this.cf.a());
        }
        if (!e.equals(this.cg)) {
            nbttagcompound.a("RightArm", this.cg.a());
        }
        if (!f.equals(this.ch)) {
            nbttagcompound.a("LeftLeg", this.ch.a());
        }
        if (!g.equals(this.ci)) {
            nbttagcompound.a("RightLeg", this.ci.a());
        }
        return nbttagcompound;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    @Override
    protected void D(Entity entity) {
    }

    @Override
    protected void o() {
        if (!this.dW().paperConfig().entities.armorStands.doCollisionEntityLookups) {
            return;
        }
        List<Entity> list = this.dW().a(EntityMinecartAbstract.class, this.cR(), bY);
        for (Entity entity : list) {
            if (!(this.g(entity) <= 0.2)) continue;
            entity.h(this);
        }
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, Vec3D hitPos, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemstack = player.b(hand);
        if (!this.x() && !itemstack.a(Items.vB)) {
            if (player.aa_()) {
                return EnumInteractionResult.a;
            }
            if (player.dW().C) {
                return EnumInteractionResult.b;
            }
            EnumItemSlot enumitemslot = this.f(itemstack);
            if (itemstack.f()) {
                EnumItemSlot enumitemslot2;
                EnumItemSlot enumitemslot1 = this.k(hitPos);
                EnumItemSlot enumItemSlot = enumitemslot2 = this.g(enumitemslot1) ? enumitemslot : enumitemslot1;
                if (this.d(enumitemslot2) && this.a(player, enumitemslot2, itemstack, hand)) {
                    return EnumInteractionResult.b;
                }
            } else {
                if (this.g(enumitemslot)) {
                    return EnumInteractionResult.d;
                }
                if (enumitemslot.a() == EnumItemSlot.Function.a && !this.t()) {
                    return EnumInteractionResult.d;
                }
                if (this.a(player, enumitemslot, itemstack, hand)) {
                    return EnumInteractionResult.b;
                }
            }
            return EnumInteractionResult.e;
        }
        return EnumInteractionResult.e;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EnumItemSlot k(Vec3D hitPos) {
        EnumItemSlot enumitemslot = EnumItemSlot.a;
        boolean flag = this.p();
        double d0 = hitPos.e / (double)(this.ek() * this.ej());
        EnumItemSlot enumitemslot1 = EnumItemSlot.c;
        if (d0 >= 0.1) {
            double d2 = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d2 && this.d(enumitemslot1)) {
                return EnumItemSlot.c;
            }
        }
        double d3 = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d3) {
            double d4 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d4 && this.d(EnumItemSlot.e)) {
                return EnumItemSlot.e;
            }
        }
        if (d0 >= 0.4) {
            double d5 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d5 && this.d(EnumItemSlot.d)) {
                return EnumItemSlot.d;
            }
        }
        if (d0 >= 1.6 && this.d(EnumItemSlot.f)) {
            return EnumItemSlot.f;
        }
        if (this.d(EnumItemSlot.a)) return enumitemslot;
        if (!this.d(EnumItemSlot.b)) return enumitemslot;
        return EnumItemSlot.b;
    }

    public boolean g(EnumItemSlot slot) {
        return (this.cc & 1 << slot.b(0)) != 0 || slot.a() == EnumItemSlot.Function.a && !this.t();
    }

    private boolean a(EntityHuman player, EnumItemSlot slot, net.minecraft.world.item.ItemStack stack, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemstack1 = this.a(slot);
        if (!itemstack1.f() && (this.cc & 1 << slot.b(8)) != 0) {
            return false;
        }
        if (itemstack1.f() && (this.cc & 1 << slot.b(16)) != 0) {
            return false;
        }
        CraftItemStack armorStandItem = CraftItemStack.asCraftMirror(itemstack1);
        CraftItemStack playerHeldItem = CraftItemStack.asCraftMirror(stack);
        Player player1 = (Player)player.getBukkitEntity();
        ArmorStand self = (ArmorStand)this.getBukkitEntity();
        EquipmentSlot slot1 = CraftEquipmentSlot.getSlot(slot);
        EquipmentSlot hand1 = CraftEquipmentSlot.getHand(hand);
        PlayerArmorStandManipulateEvent armorStandManipulateEvent = new PlayerArmorStandManipulateEvent(player1, self, (ItemStack)playerHeldItem, (ItemStack)armorStandItem, slot1, hand1);
        this.dW().getCraftServer().getPluginManager().callEvent((Event)armorStandManipulateEvent);
        if (armorStandManipulateEvent.isCancelled()) {
            return true;
        }
        if (player.fV() && itemstack1.f() && !stack.f()) {
            this.a(slot, stack.c(1));
            return true;
        }
        if (!stack.f() && stack.L() > 1) {
            if (!itemstack1.f()) {
                return false;
            }
            this.a(slot, stack.a(1));
            return true;
        }
        this.a(slot, stack);
        player.a(hand, itemstack1);
        return true;
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        if (this.dR()) {
            return false;
        }
        if (!world.N().b(GameRules.c) && source.d() instanceof EntityInsentient) {
            return false;
        }
        if (source.a(DamageTypeTags.d)) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount)) {
                return false;
            }
            this.kill(world, source);
            return false;
        }
        if (!this.a(world, source) && !this.x()) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, true, this.cb)) {
                return false;
            }
            if (source.a(DamageTypeTags.l)) {
                EntityDeathEvent event = this.brokenByAnything(world, source);
                if (!event.isCancelled()) {
                    this.kill(source, false);
                }
                return false;
            }
            if (source.a(DamageTypeTags.u)) {
                if (this.bY()) {
                    this.c(world, source, 0.15f);
                } else {
                    this.d(5.0f);
                }
                return false;
            }
            if (source.a(DamageTypeTags.v) && this.eE() > 0.5f) {
                this.c(world, source, 4.0f);
                return false;
            }
            boolean flag = source.a(DamageTypeTags.B);
            boolean flag1 = source.a(DamageTypeTags.A);
            if (!flag && !flag1) {
                return false;
            }
            Entity entity = source.d();
            if (entity instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)entity;
                if (!entityhuman.gj().e) {
                    return false;
                }
            }
            if (source.h()) {
                this.H();
                this.G();
                this.kill(world, source);
                return true;
            }
            long i2 = world.ac();
            if (i2 - this.bQ > 5L && !flag1) {
                world.a((Entity)this, (byte)32);
                this.a(GameEvent.o, source.d());
                this.bQ = i2;
            } else {
                EntityDeathEvent event = this.brokenByPlayer(world, source);
                this.G();
                if (!event.isCancelled()) {
                    this.kill(source, false);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void b(byte status) {
        if (status == 32) {
            if (this.dW().C) {
                this.dW().a(this.dB(), this.dD(), this.dH(), SoundEffects.aC, this.dn(), 0.3f, 1.0f, false);
                this.bQ = this.dW().ac();
            }
        } else {
            super.b(status);
        }
    }

    @Override
    public boolean a(double distance) {
        double d1 = this.cR().a() * 4.0;
        if (Double.isNaN(d1) || d1 == 0.0) {
            d1 = 4.0;
        }
        return distance < (d1 *= 64.0) * d1;
    }

    private void G() {
        if (this.dW() instanceof WorldServer) {
            ((WorldServer)this.dW()).a(new ParticleParamBlock(Particles.b, Blocks.n.m()), this.dB(), this.e(0.6666666666666666), this.dH(), 10, (double)(this.dr() / 4.0f), (double)(this.ds() / 4.0f), (double)(this.dr() / 4.0f), 0.05);
        }
    }

    private void c(WorldServer world, DamageSource damageSource, float amount) {
        float f1 = this.eE();
        if ((f1 -= amount) <= 0.5f) {
            this.brokenByAnything(world, damageSource);
            EntityDeathEvent event = this.brokenByAnything(world, damageSource);
            if (!event.isCancelled()) {
                this.kill(damageSource, false);
            }
        } else {
            this.x(f1);
            this.a(GameEvent.o, damageSource.d());
        }
    }

    private EntityDeathEvent brokenByPlayer(WorldServer world, DamageSource damageSource) {
        net.minecraft.world.item.ItemStack itemstack = new net.minecraft.world.item.ItemStack(Items.vv);
        itemstack.b(DataComponents.g, this.an());
        this.drops.add(new Entity.DefaultDrop(itemstack, stack -> Block.a(this.dW(), this.dw(), stack)));
        return this.brokenByAnything(world, damageSource);
    }

    private EntityDeathEvent brokenByAnything(WorldServer world, DamageSource damageSource) {
        net.minecraft.world.item.ItemStack itemstack;
        int i2;
        this.H();
        for (i2 = 0; i2 < this.bZ.size(); ++i2) {
            itemstack = this.bZ.get(i2);
            if (itemstack.f()) continue;
            this.drops.add(new Entity.DefaultDrop(itemstack, stack -> Block.a(this.dW(), this.dw().d(), stack)));
            this.bZ.set(i2, net.minecraft.world.item.ItemStack.j);
        }
        for (i2 = 0; i2 < this.ca.size(); ++i2) {
            itemstack = this.ca.get(i2);
            if (itemstack.f()) continue;
            this.drops.add(new Entity.DefaultDrop(itemstack, stack -> Block.a(this.dW(), this.dw().d(), stack)));
            this.ca.set(i2, net.minecraft.world.item.ItemStack.j);
        }
        return this.dropAllDeathLoot(world, damageSource);
    }

    private void H() {
        this.dW().a((EntityHuman)null, this.dB(), this.dD(), this.dH(), SoundEffects.aA, this.dn(), 1.0f, 1.0f);
    }

    @Override
    protected float g(float bodyRotation, float headRotation) {
        this.aY = this.N;
        this.aX = this.dM();
        return 0.0f;
    }

    @Override
    public void a_(Vec3D movementInput) {
        if (this.E()) {
            super.a_(movementInput);
        }
    }

    @Override
    public void r(float bodyYaw) {
        this.aY = this.N = bodyYaw;
        this.ba = this.aZ = bodyYaw;
    }

    @Override
    public void q(float headYaw) {
        this.aY = this.N = headYaw;
        this.ba = this.aZ = headYaw;
    }

    @Override
    public void h() {
        if (!this.canTick) {
            if (this.noTickPoseDirty) {
                this.noTickPoseDirty = false;
                this.updatePose();
            }
            if (this.noTickEquipmentDirty) {
                this.noTickEquipmentDirty = false;
                this.detectEquipmentUpdatesPublic();
            }
            return;
        }
        super.h();
        this.updatePose();
    }

    public void updatePose() {
        Vector3f vector3f5;
        Vector3f vector3f4;
        Vector3f vector3f3;
        Vector3f vector3f2;
        Vector3f vector3f1;
        Vector3f vector3f = this.al.a(bK);
        if (!this.cd.equals(vector3f)) {
            this.a(vector3f);
        }
        if (!this.ce.equals(vector3f1 = this.al.a(bL))) {
            this.b(vector3f1);
        }
        if (!this.cf.equals(vector3f2 = this.al.a(bM))) {
            this.c(vector3f2);
        }
        if (!this.cg.equals(vector3f3 = this.al.a(bN))) {
            this.d(vector3f3);
        }
        if (!this.ch.equals(vector3f4 = this.al.a(bO))) {
            this.e(vector3f4);
        }
        if (!this.ci.equals(vector3f5 = this.al.a(bP))) {
            this.f(vector3f5);
        }
    }

    @Override
    protected void K() {
        this.k(this.cb);
    }

    @Override
    public void k(boolean invisible) {
        this.cb = invisible;
        super.k(invisible);
    }

    @Override
    public boolean e_() {
        return this.p();
    }

    @Override
    public boolean en() {
        return true;
    }

    @Override
    public void c(WorldServer world) {
        this.kill(world, null);
    }

    public void kill(WorldServer worldserver, DamageSource damageSource) {
        this.kill(damageSource, true);
    }

    public void kill(DamageSource damageSource, boolean callEvent) {
        EntityDeathEvent event;
        if (callEvent && (event = CraftEventFactory.callEntityDeathEvent(this, damageSource == null ? this.dX().y() : damageSource, this.drops)).isCancelled()) {
            return;
        }
        this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        ((Entity)this).a(GameEvent.p);
    }

    @Override
    public boolean a(Explosion explosion) {
        return explosion.h() ? this.cp() : true;
    }

    @Override
    public EnumPistonReaction n_() {
        return this.x() ? EnumPistonReaction.d : super.n_();
    }

    @Override
    public boolean s_() {
        return this.x();
    }

    public void u(boolean small) {
        this.al.a(bJ, this.a(this.al.a(bJ), 1, small));
    }

    public boolean p() {
        return (this.al.a(bJ) & 1) != 0;
    }

    public void a(boolean showArms) {
        this.al.a(bJ, this.a(this.al.a(bJ), 4, showArms));
    }

    public boolean t() {
        return (this.al.a(bJ) & 4) != 0;
    }

    public void b(boolean hideBasePlate) {
        this.al.a(bJ, this.a(this.al.a(bJ), 8, hideBasePlate));
    }

    @Override
    public boolean u() {
        return (this.al.a(bJ) & 8) == 0;
    }

    public void v(boolean marker) {
        this.al.a(bJ, this.a(this.al.a(bJ), 16, marker));
    }

    public boolean x() {
        return (this.al.a(bJ) & 0x10) != 0;
    }

    private byte a(byte value, int bitField, boolean set) {
        value = set ? (byte)(value | bitField) : (byte)(value & ~bitField);
        return value;
    }

    public void a(Vector3f angle) {
        this.cd = angle;
        this.al.a(bK, angle);
        this.noTickPoseDirty = true;
    }

    public void b(Vector3f angle) {
        this.ce = angle;
        this.al.a(bL, angle);
        this.noTickPoseDirty = true;
    }

    public void c(Vector3f angle) {
        this.cf = angle;
        this.al.a(bM, angle);
        this.noTickPoseDirty = true;
    }

    public void d(Vector3f angle) {
        this.cg = angle;
        this.al.a(bN, angle);
        this.noTickPoseDirty = true;
    }

    public void e(Vector3f angle) {
        this.ch = angle;
        this.al.a(bO, angle);
        this.noTickPoseDirty = true;
    }

    public void f(Vector3f angle) {
        this.ci = angle;
        this.al.a(bP, angle);
        this.noTickPoseDirty = true;
    }

    public Vector3f y() {
        return this.cd;
    }

    public Vector3f z() {
        return this.ce;
    }

    public Vector3f A() {
        return this.cf;
    }

    public Vector3f B() {
        return this.cg;
    }

    public Vector3f C() {
        return this.ch;
    }

    public Vector3f D() {
        return this.ci;
    }

    @Override
    public boolean bH() {
        return super.bH() && !this.x();
    }

    @Override
    public boolean v(Entity attacker) {
        return attacker instanceof EntityHuman && !this.dW().a((EntityHuman)attacker, this.dw());
    }

    @Override
    public EnumMainHand fy() {
        return EnumMainHand.b;
    }

    @Override
    public EntityLiving.a eM() {
        return new EntityLiving.a(SoundEffects.aB, SoundEffects.aB);
    }

    @Override
    @Nullable
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.aC;
    }

    @Override
    @Nullable
    public SoundEffect o_() {
        return SoundEffects.aA;
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
    }

    @Override
    public boolean fL() {
        return false;
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (bJ.equals(data)) {
            this.m_();
            this.I = !this.x();
        }
        super.a(data);
    }

    @Override
    public boolean fM() {
        return false;
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.w(this.x());
    }

    private EntitySize w(boolean marker) {
        return marker ? bS : (this.e_() ? bT : this.aq().n());
    }

    @Override
    public Vec3D n(float tickDelta) {
        if (this.x()) {
            AxisAlignedBB axisalignedbb = this.w(false).a(this.du());
            BlockPosition blockposition = this.dw();
            int i2 = Integer.MIN_VALUE;
            for (BlockPosition blockposition1 : BlockPosition.c(BlockPosition.a(axisalignedbb.a, axisalignedbb.b, axisalignedbb.c), BlockPosition.a(axisalignedbb.d, axisalignedbb.e, axisalignedbb.f))) {
                int j2 = Math.max(this.dW().a(EnumSkyBlock.b, blockposition1), this.dW().a(EnumSkyBlock.a, blockposition1));
                if (j2 == 15) {
                    return Vec3D.b(blockposition1);
                }
                if (j2 <= i2) continue;
                i2 = j2;
                blockposition = blockposition1.j();
            }
            return Vec3D.b(blockposition);
        }
        return super.n(tickDelta);
    }

    @Override
    public net.minecraft.world.item.ItemStack dJ() {
        return new net.minecraft.world.item.ItemStack(Items.vv);
    }

    @Override
    public boolean ey() {
        return !this.cp() && !this.x();
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        if (this.canMove) {
            super.a(type, movement);
        }
    }
}

