/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import io.papermc.paper.event.player.PlayerItemFrameChangeEvent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class EntityItemFrame
extends EntityHanging {
    public static final DataWatcherObject<ItemStack> e = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.h);
    public static final DataWatcherObject<Integer> f = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.b);
    public static final int d = 8;
    private static final float g = 0.0625f;
    private static final float h = 0.75f;
    private static final float i = 0.75f;
    public float j = 1.0f;
    public boolean k;
    @javax.annotation.Nullable
    public MapId cachedMapId;

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> type, World world) {
        super((EntityTypes<? extends EntityHanging>)type, world);
    }

    public EntityItemFrame(World world, BlockPosition pos, EnumDirection facing) {
        this(EntityTypes.at, world, pos, facing);
    }

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> type, World world, BlockPosition pos, EnumDirection facing) {
        super((EntityTypes<? extends EntityHanging>)type, world, pos);
        this.a(facing);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(e, ItemStack.j);
        builder.a(f, 0);
    }

    @Override
    public void a(EnumDirection facing) {
        Validate.notNull((Object)facing);
        this.c = facing;
        if (facing.o().d()) {
            this.w(0.0f);
            this.v(this.c.e() * 90);
        } else {
            this.w(-90 * facing.f().a());
            this.v(0.0f);
        }
        this.O = this.dO();
        this.N = this.dM();
        this.l();
    }

    @Override
    protected AxisAlignedBB a(BlockPosition pos, EnumDirection side) {
        return EntityItemFrame.calculateBoundingBoxStatic(pos, side);
    }

    public static AxisAlignedBB calculateBoundingBoxStatic(BlockPosition blockposition, EnumDirection enumdirection) {
        float f2 = 0.46875f;
        Vec3D vec3d = Vec3D.b(blockposition).a(enumdirection, -0.46875);
        EnumDirection.EnumAxis enumdirection_enumaxis = enumdirection.o();
        double d0 = enumdirection_enumaxis == EnumDirection.EnumAxis.a ? 0.0625 : 0.75;
        double d1 = enumdirection_enumaxis == EnumDirection.EnumAxis.b ? 0.0625 : 0.75;
        double d2 = enumdirection_enumaxis == EnumDirection.EnumAxis.c ? 0.0625 : 0.75;
        return AxisAlignedBB.a(vec3d, d0, d1, d2);
    }

    @Override
    public boolean m() {
        if (this.k) {
            return true;
        }
        if (!this.dW().g(this)) {
            return false;
        }
        IBlockData iblockdata = this.dW().a_(this.a.a(this.c.g()));
        return !iblockdata.e() && (!this.c.o().d() || !BlockDiodeAbstract.n(iblockdata)) ? false : this.dW().a((Entity)this, this.cR(), EntityHanging.b).isEmpty();
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        if (!this.k) {
            super.a(type, movement);
        }
    }

    @Override
    public void push(double deltaX, double deltaY, double deltaZ, @Nullable Entity pushingEntity) {
        if (!this.k) {
            super.push(deltaX, deltaY, deltaZ, pushingEntity);
        }
    }

    @Override
    public void c(WorldServer world) {
        this.c(this.A());
        super.c(world);
    }

    private boolean a(DamageSource damageSource) {
        return !damageSource.a(DamageTypeTags.l) && !this.A().f();
    }

    private static boolean e(DamageSource damageSource) {
        return damageSource.a(DamageTypeTags.d) || damageSource.h();
    }

    @Override
    public boolean b(DamageSource source) {
        return this.k && !EntityItemFrame.e(source) ? false : !this.d(source);
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        if (!this.k) {
            if (this.d(source)) {
                return false;
            }
            if (this.a(source)) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, false) || this.dR()) {
                    return true;
                }
                Entity entity = source.d();
                if (entity instanceof EntityHuman) {
                    EntityHuman player = (EntityHuman)entity;
                    PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), this.A().asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.REMOVE);
                    if (!event.callEvent()) {
                        return true;
                    }
                    this.a(ItemStack.fromBukkitCopy(event.getItemStack()), false);
                }
                this.a(world, source.d(), false);
                this.a(GameEvent.c, source.d());
                this.a(this.s(), 1.0f, 1.0f);
                return true;
            }
            return super.a(world, source, amount);
        }
        return EntityItemFrame.e(source) && super.a(world, source, amount);
    }

    public SoundEffect s() {
        return SoundEffects.nR;
    }

    @Override
    public boolean a(double distance) {
        double d1 = 16.0;
        return distance < (d1 *= 64.0 * EntityItemFrame.cK()) * d1;
    }

    @Override
    public void a(WorldServer world, @javax.annotation.Nullable Entity breaker) {
        this.a(this.t(), 1.0f, 1.0f);
        this.a(world, breaker, true);
        this.a(GameEvent.c, breaker);
    }

    public SoundEffect t() {
        return SoundEffects.nP;
    }

    @Override
    public void z() {
        this.a(this.u(), 1.0f, 1.0f);
    }

    public SoundEffect u() {
        return SoundEffects.nQ;
    }

    private void a(WorldServer world, @javax.annotation.Nullable Entity entity, boolean dropSelf) {
        if (!this.k) {
            ItemStack itemstack = this.A();
            this.b(ItemStack.j);
            if (!world.N().b(GameRules.i)) {
                if (entity == null) {
                    this.c(itemstack);
                }
            } else {
                EntityHuman entityhuman;
                if (entity instanceof EntityHuman && (entityhuman = (EntityHuman)entity).fV()) {
                    this.c(itemstack);
                    return;
                }
                if (dropSelf) {
                    this.a(world, this.x());
                }
                if (!itemstack.f()) {
                    itemstack = itemstack.v();
                    this.c(itemstack);
                    if (this.ae.i() < this.j) {
                        this.a(world, itemstack);
                    }
                }
            }
        }
    }

    private void c(ItemStack stack) {
        WorldMap worldmap;
        MapId mapid = this.a(stack);
        if (mapid != null && (worldmap = ItemWorldMap.a(mapid, this.dW())) != null) {
            worldmap.a(this.a, this.ar());
        }
        stack.a((Entity)null);
    }

    public ItemStack A() {
        return this.au().a(e);
    }

    @Override
    @javax.annotation.Nullable
    public EntityItem a(WorldServer serverLevel, ItemStack stack) {
        return this.a(serverLevel, stack, this.cO() == EnumDirection.a ? -0.6f : 0.0f);
    }

    @javax.annotation.Nullable
    public MapId a(ItemStack stack) {
        return stack.a(DataComponents.L);
    }

    public boolean B() {
        return this.A().b(DataComponents.L);
    }

    public void b(ItemStack stack) {
        this.a(stack, true);
    }

    public void a(ItemStack value, boolean update) {
        this.setItem(value, update, true);
    }

    public void setItem(ItemStack itemstack, boolean flag, boolean playSound) {
        if (!itemstack.f()) {
            itemstack = itemstack.c(1);
        }
        this.d(itemstack);
        this.au().a(e, itemstack);
        if (!itemstack.f() && flag && playSound) {
            this.a(this.v(), 1.0f, 1.0f);
        }
        if (flag && this.a != null) {
            this.dW().c(this.a, Blocks.a);
        }
    }

    public SoundEffect v() {
        return SoundEffects.nO;
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        return mappedIndex == 0 ? SlotAccess.a(this::A, this::b) : super.a_(mappedIndex);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (data.equals(e)) {
            this.d(this.A());
        }
    }

    private void d(ItemStack stack) {
        this.cachedMapId = stack.a().a(DataComponents.L);
        if (!stack.f() && stack.H() != this) {
            stack.a(this);
        }
        this.l();
    }

    public int C() {
        return this.au().a(f);
    }

    public void b(int value) {
        this.a(value, true);
    }

    private void a(int value, boolean updateComparators) {
        this.au().a(f, value % 8);
        if (updateComparators && this.a != null) {
            this.dW().c(this.a, Blocks.a);
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (!this.A().f()) {
            nbt.a("Item", this.A().a(this.dY()));
            nbt.a("ItemRotation", (byte)this.C());
            nbt.a("ItemDropChance", this.j);
        }
        nbt.a("Facing", (byte)this.c.d());
        nbt.a("Invisible", this.cp());
        nbt.a("Fixed", this.k);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        ItemStack itemstack;
        super.a(nbt);
        if (nbt.b("Item", 10)) {
            NBTTagCompound nbttagcompound1 = nbt.p("Item");
            itemstack = ItemStack.a((HolderLookup.a)this.dY(), (NBTBase)nbttagcompound1).orElse(ItemStack.j);
        } else {
            itemstack = ItemStack.j;
        }
        ItemStack itemstack1 = this.A();
        if (!itemstack1.f() && !ItemStack.a(itemstack, itemstack1)) {
            this.c(itemstack1);
        }
        this.a(itemstack, false);
        if (!itemstack.f()) {
            this.a(nbt.f("ItemRotation"), false);
            if (nbt.b("ItemDropChance", 99)) {
                this.j = nbt.j("ItemDropChance");
            }
        }
        this.a(EnumDirection.a(nbt.f("Facing")));
        this.k(nbt.q("Invisible"));
        this.k = nbt.q("Fixed");
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        boolean flag1;
        ItemStack itemstack = player.b(hand);
        boolean flag = !this.A().f();
        boolean bl = flag1 = !itemstack.f();
        if (this.k) {
            return EnumInteractionResult.e;
        }
        if (!player.dW().C) {
            if (!flag) {
                if (flag1 && !this.dR()) {
                    WorldMap worldmap = ItemWorldMap.b(itemstack, this.dW());
                    if (worldmap != null && worldmap.a(256)) {
                        return EnumInteractionResult.d;
                    }
                    PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), itemstack.asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.PLACE);
                    if (!event.callEvent()) {
                        return EnumInteractionResult.d;
                    }
                    this.b(ItemStack.fromBukkitCopy(event.getItemStack()));
                    this.a(GameEvent.c, (Entity)player);
                    itemstack.a(1, (EntityLiving)player);
                    return EnumInteractionResult.a;
                }
                return EnumInteractionResult.e;
            }
            PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), this.A().asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.ROTATE);
            if (!event.callEvent()) {
                return EnumInteractionResult.d;
            }
            this.setItem(ItemStack.fromBukkitCopy(event.getItemStack()), false, false);
            this.a(this.w(), 1.0f, 1.0f);
            this.b(this.C() + 1);
            this.a(GameEvent.c, (Entity)player);
            return EnumInteractionResult.a;
        }
        return (EnumInteractionResult)((Object)(!flag && !flag1 ? EnumInteractionResult.e : EnumInteractionResult.a));
    }

    public SoundEffect w() {
        return SoundEffects.nS;
    }

    public int D() {
        return this.A().f() ? 0 : this.C() % 8 + 1;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entityTrackerEntry) {
        return new PacketPlayOutSpawnEntity((Entity)this, this.c.d(), this.p());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.a(EnumDirection.a(packet.p()));
    }

    @Override
    public ItemStack dJ() {
        ItemStack itemstack = this.A();
        return itemstack.f() ? this.x() : itemstack.v();
    }

    protected ItemStack x() {
        return new ItemStack(Items.uS);
    }

    @Override
    public float dN() {
        EnumDirection enumdirection = this.cO();
        int i2 = enumdirection.o().b() ? 90 * enumdirection.f().a() : 0;
        return MathHelper.b(180 + enumdirection.e() * 90 + this.C() * 45 + i2);
    }
}

