/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.decoration.BlockAttachedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLeash;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;

public class EntityLeash
extends BlockAttachedEntity {
    public static final double b = 0.375;

    public EntityLeash(EntityTypes<? extends EntityLeash> type, World world) {
        super((EntityTypes<? extends BlockAttachedEntity>)type, world);
    }

    public EntityLeash(World world, BlockPosition pos) {
        super(EntityTypes.aw, world, pos);
        this.a_(pos.u(), pos.v(), pos.w());
    }

    @Override
    protected void a(DataWatcher.a builder) {
    }

    @Override
    protected void l() {
        this.o((double)this.a.u() + 0.5, (double)this.a.v() + 0.375, (double)this.a.w() + 0.5);
        double d0 = (double)this.aq().l() / 2.0;
        double d1 = this.aq().m();
        this.a(new AxisAlignedBB(this.dB() - d0, this.dD(), this.dH() - d0, this.dB() + d0, this.dD() + d1, this.dH() + d0));
    }

    @Override
    public boolean a(double distance) {
        return distance < 1024.0;
    }

    @Override
    public void a(WorldServer world, @Nullable Entity breaker) {
        this.a(SoundEffects.ok, 1.0f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound nbt) {
    }

    @Override
    public void a(NBTTagCompound nbt) {
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        if (this.dW().C) {
            return EnumInteractionResult.a;
        }
        boolean flag = false;
        List<Leashable> list = ItemLeash.a(this.dW(), this.p(), (Leashable leashable) -> {
            Entity entity = leashable.A();
            return entity == player || entity == this;
        });
        for (Leashable leashable2 : list) {
            Entity leashed;
            if (leashable2.A() != player) continue;
            if (leashable2 instanceof Entity && CraftEventFactory.callPlayerLeashEntityEvent(leashed = (Entity)((Object)leashable2), this, player, hand).isCancelled()) {
                ((EntityPlayer)player).f.b(new PacketPlayOutAttachEntity(leashed, leashable2.A()));
                flag = true;
                continue;
            }
            leashable2.b((Entity)this, true);
            flag = true;
        }
        boolean flag1 = false;
        if (!flag) {
            boolean die = true;
            for (Leashable leashable1 : list) {
                boolean dropLeash;
                if (!leashable1.P_() || leashable1.A() != this) continue;
                boolean bl = dropLeash = !player.fV();
                if (leashable1 instanceof Entity) {
                    Entity leashed = (Entity)((Object)leashable1);
                    PlayerUnleashEntityEvent event = CraftEventFactory.callPlayerUnleashEntityEvent(leashed, player, hand, dropLeash);
                    dropLeash = event.isDropLeash();
                    if (event.isCancelled()) {
                        die = false;
                        continue;
                    }
                }
                leashable1.a(true, dropLeash);
                flag1 = true;
            }
            if (die) {
                this.discard(EntityRemoveEvent.Cause.DROP);
            }
        }
        if (flag || flag1) {
            this.a(GameEvent.b, (Entity)player);
        }
        return EnumInteractionResult.a;
    }

    @Override
    public boolean m() {
        return this.dW().a_(this.a).a(TagsBlock.U);
    }

    public static EntityLeash a(World world, BlockPosition pos) {
        EntityLeash entityleash;
        int i2 = pos.u();
        int j2 = pos.v();
        int k2 = pos.w();
        List<EntityLeash> list = world.a(EntityLeash.class, new AxisAlignedBB((double)i2 - 1.0, (double)j2 - 1.0, (double)k2 - 1.0, (double)i2 + 1.0, (double)j2 + 1.0, (double)k2 + 1.0));
        Iterator<EntityLeash> iterator = list.iterator();
        do {
            if (iterator.hasNext()) continue;
            EntityLeash entityleash1 = new EntityLeash(world, pos);
            world.b(entityleash1);
            return entityleash1;
        } while (!(entityleash = iterator.next()).p().equals(pos));
        return entityleash;
    }

    public void s() {
        this.a(SoundEffects.ol, 1.0f, 1.0f);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entityTrackerEntry) {
        return new PacketPlayOutSpawnEntity((Entity)this, 0, this.p());
    }

    @Override
    public Vec3D u(float delta) {
        return this.o(delta).b(0.0, 0.2, 0.0);
    }

    @Override
    public ItemStack dJ() {
        return new ItemStack(Items.vA);
    }
}

