/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContextDirectional;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.BlockConcretePowder;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EntityFallingBlock
extends Entity {
    private static final Logger f = LogUtils.getLogger();
    public IBlockData g = Blocks.L.m();
    public int a;
    public boolean b = true;
    public boolean h;
    public boolean i;
    public int j = 40;
    public float k;
    @Nullable
    public NBTTagCompound c;
    public boolean d;
    protected static final DataWatcherObject<BlockPosition> e = DataWatcher.a(EntityFallingBlock.class, DataWatcherRegistry.o);
    public boolean autoExpire = true;

    public EntityFallingBlock(EntityTypes<? extends EntityFallingBlock> type, World world) {
        super(type, world);
    }

    public EntityFallingBlock(World world, double x2, double y2, double z2, IBlockData block) {
        this((EntityTypes<? extends EntityFallingBlock>)EntityTypes.Y, world);
        this.g = block;
        this.I = true;
        this.a_(x2, y2, z2);
        this.h(Vec3D.c);
        this.K = x2;
        this.L = y2;
        this.M = z2;
        this.a(this.dw());
    }

    public static EntityFallingBlock a(World world, BlockPosition pos, IBlockData state) {
        return EntityFallingBlock.fall(world, pos, state, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public static EntityFallingBlock fall(World world, BlockPosition blockposition, IBlockData iblockdata, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityFallingBlock entityfallingblock = new EntityFallingBlock(world, (double)blockposition.u() + 0.5, blockposition.v(), (double)blockposition.w() + 0.5, iblockdata.b(BlockProperties.D) ? (IBlockData)iblockdata.b(BlockProperties.D, false) : iblockdata);
        if (!CraftEventFactory.callEntityChangeBlockEvent(entityfallingblock, blockposition, iblockdata.y().g())) {
            return entityfallingblock;
        }
        world.a(blockposition, iblockdata.y().g(), 3);
        world.addFreshEntity(entityfallingblock, spawnReason);
        return entityfallingblock;
    }

    @Override
    public boolean cB() {
        return false;
    }

    @Override
    public final boolean a(WorldServer world, DamageSource source, float amount) {
        if (!this.d(source)) {
            this.bD();
        }
        return false;
    }

    public void a(BlockPosition pos) {
        this.al.a(e, pos);
    }

    public BlockPosition l() {
        return this.al.a(e);
    }

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(e, BlockPosition.c);
    }

    @Override
    public boolean bH() {
        return !this.dR();
    }

    @Override
    protected double bd() {
        return 0.04;
    }

    @Override
    public void h() {
        if (this.g.l()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            Block block = this.g.b();
            ++this.a;
            this.bf();
            this.a(EnumMoveType.a, this.dz());
            this.aK();
            if (this.dW().paperConfig().fixes.fallingBlockHeightNerf.test(v2 -> this.dD() > (double)v2)) {
                WorldServer serverLevel;
                World world;
                if (this.b && (world = this.dW()) instanceof WorldServer && (serverLevel = (WorldServer)world).N().b(GameRules.i)) {
                    this.a(serverLevel, block);
                }
                this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
                return;
            }
            this.bW();
            World world = this.dW();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (this.bL() || this.d) {
                    MovingObjectPositionBlock movingobjectpositionblock;
                    BlockPosition blockposition = this.dw();
                    boolean flag = this.g.b() instanceof BlockConcretePowder;
                    boolean flag1 = flag && this.dW().b_(blockposition).a(TagsFluid.a);
                    double d0 = this.dz().h();
                    if (flag && d0 > 1.0 && (movingobjectpositionblock = this.dW().a(new RayTrace(new Vec3D(this.K, this.L, this.M), this.du(), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.b, this))).d() != MovingObjectPosition.EnumMovingObjectType.a && this.dW().b_(movingobjectpositionblock.b()).a(TagsFluid.a)) {
                        blockposition = movingobjectpositionblock.b();
                        flag1 = true;
                    }
                    if (!this.aJ() && !flag1) {
                        if (this.a > 100 && this.autoExpire && (blockposition.v() <= this.dW().L_() || blockposition.v() > this.dW().am()) || this.a > 600 && this.autoExpire) {
                            if (this.b && worldserver.N().b(GameRules.i)) {
                                this.a(worldserver, block);
                            }
                            this.discard(EntityRemoveEvent.Cause.DROP);
                        }
                    } else {
                        IBlockData iblockdata = this.dW().a_(blockposition);
                        this.h(this.dz().d(0.7, -0.5, 0.7));
                        if (!iblockdata.a(Blocks.bX)) {
                            if (!this.h) {
                                boolean flag4;
                                boolean flag2 = iblockdata.a(new BlockActionContextDirectional(this.dW(), blockposition, EnumDirection.a, ItemStack.j, EnumDirection.b));
                                boolean flag3 = BlockFalling.n(this.dW().a_(blockposition.e())) && (!flag || !flag1);
                                boolean bl = flag4 = this.g.a((IWorldReader)this.dW(), blockposition) && !flag3;
                                if (flag2 && flag4) {
                                    if (this.g.b(BlockProperties.D) && this.dW().b_(blockposition).a() == FluidTypes.c) {
                                        this.g = (IBlockData)this.g.b(BlockProperties.D, true);
                                    }
                                    if (!CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, this.g)) {
                                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                        return;
                                    }
                                    if (this.dW().a(blockposition, this.g, 3)) {
                                        TileEntity tileentity;
                                        ((WorldServer)this.dW()).m().a.a(this, new PacketPlayOutBlockChange(blockposition, this.dW().a_(blockposition)));
                                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                        if (block instanceof Fallable) {
                                            ((Fallable)((Object)block)).a(this.dW(), blockposition, this.g, iblockdata, this);
                                        }
                                        if (this.c != null && this.g.x() && (tileentity = this.dW().c_(blockposition)) != null) {
                                            NBTTagCompound nbttagcompound = tileentity.d(this.dW().K_());
                                            for (String s2 : this.c.e()) {
                                                nbttagcompound.a(s2, this.c.c(s2).d());
                                            }
                                            try {
                                                tileentity.c(nbttagcompound, this.dW().K_());
                                            }
                                            catch (Exception exception) {
                                                f.error("Failed to load block entity from falling block", (Throwable)exception);
                                            }
                                            tileentity.e();
                                        }
                                    } else if (this.b && worldserver.N().b(GameRules.i)) {
                                        this.discard(EntityRemoveEvent.Cause.DROP);
                                        this.a(block, blockposition);
                                        this.a(worldserver, block);
                                    }
                                } else {
                                    this.discard(EntityRemoveEvent.Cause.DROP);
                                    if (this.b && worldserver.N().b(GameRules.i)) {
                                        this.a(block, blockposition);
                                        this.a(worldserver, block);
                                    }
                                }
                            } else {
                                this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                this.a(block, blockposition);
                            }
                        }
                    }
                }
            }
            this.h(this.dz().c(0.98));
        }
    }

    public void a(Block block, BlockPosition pos) {
        if (block instanceof Fallable) {
            ((Fallable)((Object)block)).a(this.dW(), pos, this);
        }
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        DamageSource damagesource1;
        if (!this.i) {
            return false;
        }
        int i2 = MathHelper.f(fallDistance - 1.0f);
        if (i2 < 0) {
            return false;
        }
        Predicate<Entity> predicate = IEntitySelector.e.and(IEntitySelector.b);
        Block block = this.g.b();
        if (block instanceof Fallable) {
            Fallable fallable = (Fallable)((Object)block);
            damagesource1 = fallable.a(this);
        } else {
            damagesource1 = this.dX().a(this);
        }
        DamageSource damagesource2 = damagesource1;
        float f2 = Math.min(MathHelper.d((float)i2 * this.k), this.j);
        this.dW().a((Entity)this, this.cR(), predicate).forEach(entity -> entity.a(damagesource2, f2));
        boolean flag = this.g.a(TagsBlock.O);
        if (flag && f2 > 0.0f && this.ae.i() < 0.05f + (float)i2 * 0.05f) {
            IBlockData iblockdata = BlockAnvil.e(this.g);
            if (iblockdata == null) {
                this.h = true;
            } else {
                this.g = iblockdata;
            }
        }
        return false;
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        nbt.a("BlockState", GameProfileSerializer.a(this.g));
        nbt.a("Time", this.a);
        nbt.a("DropItem", this.b);
        nbt.a("HurtEntities", this.i);
        nbt.a("FallHurtAmount", this.k);
        nbt.a("FallHurtMax", this.j);
        if (this.c != null) {
            nbt.a("TileEntityData", this.c);
        }
        nbt.a("CancelDrop", this.h);
        if (!this.autoExpire) {
            nbt.a("Paper.AutoExpire", false);
        }
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        this.g = GameProfileSerializer.a(this.dW().a(Registries.f), nbt.p("BlockState"));
        this.a = nbt.h("Time");
        if (nbt.b("HurtEntities", 99)) {
            this.i = nbt.q("HurtEntities");
            this.k = nbt.j("FallHurtAmount");
            this.j = nbt.h("FallHurtMax");
        } else if (this.g.a(TagsBlock.O)) {
            this.i = true;
        }
        if (nbt.b("DropItem", 99)) {
            this.b = nbt.q("DropItem");
        }
        if (!(!nbt.b("TileEntityData", 10) || this.dW().paperConfig().entities.spawning.filterBadTileEntityNbtFromFallingBlocks && this.g.b() instanceof GameMasterBlock)) {
            this.c = nbt.p("TileEntityData").i();
        }
        this.h = nbt.q("CancelDrop");
        if (this.g.l()) {
            this.g = Blocks.L.m();
        }
        if (nbt.e("Paper.AutoExpire")) {
            this.autoExpire = nbt.q("Paper.AutoExpire");
        }
    }

    public void b(float fallHurtAmount, int fallHurtMax) {
        this.i = true;
        this.k = fallHurtAmount;
        this.j = fallHurtMax;
    }

    public void m() {
        this.h = true;
    }

    @Override
    public boolean cF() {
        return false;
    }

    @Override
    public void a(CrashReportSystemDetails section) {
        super.a(section);
        section.a("Immitating BlockState", this.g.toString());
    }

    public IBlockData p() {
        return this.g;
    }

    @Override
    protected IChatBaseComponent cz() {
        return IChatBaseComponent.a("entity.minecraft.falling_block_type", this.g.b().f());
    }

    @Override
    public boolean cW() {
        return true;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entityTrackerEntry) {
        return new PacketPlayOutSpawnEntity((Entity)this, entityTrackerEntry, Block.j(this.p()));
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.g = Block.a(packet.p());
        this.I = true;
        double d0 = packet.g();
        double d1 = packet.h();
        double d2 = packet.i();
        this.a_(d0, d1, d2);
        this.a(this.dw());
    }

    @Override
    @Nullable
    public Entity b(TeleportTransition teleportTarget) {
        ResourceKey<World> resourcekey = teleportTarget.b().ah();
        ResourceKey<World> resourcekey1 = this.dW().ah();
        boolean flag = (resourcekey1 == World.k || resourcekey == World.k) && resourcekey1 != resourcekey;
        Entity entity = super.b(teleportTarget);
        this.d = entity != null && flag && GlobalConfiguration.get().unsupportedSettings.allowUnsafeEndPortalTeleportation;
        return entity;
    }
}

