/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;

public class EntityItem
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<ItemStack> c = DataWatcher.a(EntityItem.class, DataWatcherRegistry.h);
    private static final float d = 0.1f;
    public static final float a = 0.2125f;
    private static final int e = 6000;
    private static final int f = Short.MAX_VALUE;
    private static final int g = Short.MIN_VALUE;
    public int h;
    public int i;
    public int j = 5;
    @Nullable
    public UUID k;
    @Nullable
    private Entity l;
    @Nullable
    public UUID m;
    public final float b;
    public boolean canMobPickup = true;
    private int despawnRate = -1;
    public TriState frictionState = TriState.NOT_SET;

    public EntityItem(EntityTypes<? extends EntityItem> type, World world) {
        super(type, world);
        this.b = this.ae.i() * (float)Math.PI * 2.0f;
        this.v(this.ae.i() * 360.0f);
    }

    public EntityItem(World world, double x2, double y2, double z2, ItemStack stack) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ar, world);
        this.a_(x2, y2, z2);
        this.n(this.ae.j() * 0.2 - 0.1, 0.2, this.ae.j() * 0.2 - 0.1);
        this.a(stack);
    }

    public EntityItem(World world, double x2, double y2, double z2, ItemStack stack, double velocityX, double velocityY, double velocityZ) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ar, world);
        this.a_(x2, y2, z2);
        this.n(velocityX, velocityY, velocityZ);
        this.a(stack);
    }

    private EntityItem(EntityItem entity) {
        super(entity.aq(), entity.dW());
        this.a(entity.l().v());
        this.w(entity);
        this.h = entity.h;
        this.b = entity.b;
    }

    @Override
    public boolean bh() {
        return this.l().a(TagsItem.bt);
    }

    @Override
    @Nullable
    public Entity p() {
        World world;
        if (this.l != null && !this.l.dR()) {
            return this.l;
        }
        if (this.k != null && (world = this.dW()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.l = worldserver.a(this.k);
            return this.l;
        }
        return null;
    }

    @Override
    public void x(Entity original) {
        super.x(original);
        if (original instanceof EntityItem) {
            EntityItem entityitem = (EntityItem)original;
            this.l = entityitem.l;
        }
    }

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(c, ItemStack.j);
    }

    @Override
    protected double bd() {
        return 0.04;
    }

    @Override
    public void h() {
        if (this.l().f()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            double d0;
            int i2;
            super.h();
            if (this.i > 0 && this.i != Short.MAX_VALUE) {
                --this.i;
            }
            this.K = this.dB();
            this.L = this.dD();
            this.M = this.dH();
            Vec3D vec3d = this.dz();
            if (this.bj() && this.b(TagsFluid.a) > (double)0.1f) {
                this.A();
            } else if (this.bx() && this.b(TagsFluid.b) > (double)0.1f) {
                this.B();
            } else {
                this.bf();
            }
            if (this.dW().C) {
                this.ad = false;
            } else {
                boolean bl = this.ad = !this.dW().a((Entity)this, this.cR().h(1.0E-7));
                if (this.ad) {
                    this.m(this.dB(), (this.cR().b + this.cR().e) / 2.0, this.dH());
                }
            }
            if (!this.aJ() || this.dz().j() > (double)1.0E-5f || (this.af + this.ar()) % 4 == 0) {
                this.a(EnumMoveType.a, this.dz());
                this.aK();
                float f2 = 0.98f;
                if (this.frictionState == TriState.FALSE) {
                    f2 = 1.0f;
                } else if (this.aJ()) {
                    f2 = this.dW().a_(this.aQ()).b().g() * 0.98f;
                }
                this.h(this.dz().d(f2, 0.98, f2));
                if (this.aJ()) {
                    Vec3D vec3d1 = this.dz();
                    if (vec3d1.e < 0.0) {
                        this.h(vec3d1.d(1.0, -0.5, 1.0));
                    }
                }
            }
            boolean flag = MathHelper.a(this.K) != MathHelper.a(this.dB()) || MathHelper.a(this.L) != MathHelper.a(this.dD()) || MathHelper.a(this.M) != MathHelper.a(this.dH());
            int n2 = i2 = flag ? 2 : 40;
            if (this.af % i2 == 0 && !this.dW().C && this.D()) {
                this.C();
            }
            if (this.h != Short.MIN_VALUE) {
                ++this.h;
            }
            this.ar |= this.bq();
            if (!this.dW().C && (d0 = this.dz().d(vec3d).h()) > 0.01) {
                this.ar = true;
            }
            if (!this.dW().C && this.h >= this.despawnRate) {
                if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                    this.h = 0;
                    return;
                }
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            }
        }
    }

    @Override
    public void inactiveTick() {
        if (this.i > 0 && this.i != Short.MAX_VALUE) {
            --this.i;
        }
        if (this.h != Short.MIN_VALUE) {
            ++this.h;
        }
        if (!this.dW().C && this.h >= this.despawnRate) {
            if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                this.h = 0;
                return;
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public BlockPosition aQ() {
        return this.e(0.999999f);
    }

    private void A() {
        this.h((double)0.99f);
    }

    private void B() {
        this.h((double)0.95f);
    }

    private void h(double horizontalMultiplier) {
        Vec3D vec3d = this.dz();
        this.n(vec3d.d * horizontalMultiplier, vec3d.e + (double)(vec3d.e < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.f * horizontalMultiplier);
    }

    private void C() {
        if (this.D()) {
            double radius = this.dW().spigotConfig.itemMerge;
            List<EntityItem> list = this.dW().a(EntityItem.class, this.cR().c(radius, this.dW().paperConfig().entities.behavior.onlyMergeItemsHorizontally ? 0.0 : radius - 0.5, radius), (? super T entityitem) -> entityitem != this && entityitem.D());
            for (EntityItem entityitem2 : list) {
                if (!entityitem2.D() || this.dW().paperConfig().fixes.fixItemsMergingThroughWalls && this.dW().clipDirect(this.du(), entityitem2.du(), VoxelShapeCollision.a(this)) == MovingObjectPosition.EnumMovingObjectType.b) continue;
                this.a(entityitem2);
                if (!this.dR()) continue;
                break;
            }
        }
    }

    private boolean D() {
        ItemStack itemstack = this.l();
        return this.bL() && this.i != Short.MAX_VALUE && this.h != Short.MIN_VALUE && this.h < this.despawnRate && itemstack.L() < itemstack.k();
    }

    private void a(EntityItem other) {
        ItemStack itemstack = this.l();
        ItemStack itemstack1 = other.l();
        if (Objects.equals(this.m, other.m) && EntityItem.a(itemstack, itemstack1)) {
            EntityItem.a(this, itemstack, other, itemstack1);
        }
    }

    public static boolean a(ItemStack stack1, ItemStack stack2) {
        return stack2.L() + stack1.L() > stack2.k() ? false : ItemStack.c(stack1, stack2);
    }

    public static ItemStack a(ItemStack stack1, ItemStack stack2, int maxCount) {
        int j2 = Math.min(Math.min(stack1.k(), maxCount) - stack1.L(), stack2.L());
        ItemStack itemstack2 = stack1.c(stack1.L() + j2);
        stack2.h(j2);
        return itemstack2;
    }

    private static void a(EntityItem targetEntity, ItemStack stack1, ItemStack stack2) {
        ItemStack itemstack2 = EntityItem.a(stack1, stack2, 64);
        targetEntity.a(itemstack2);
    }

    private static void a(EntityItem targetEntity, ItemStack targetStack, EntityItem sourceEntity, ItemStack sourceStack) {
        if (!CraftEventFactory.callItemMergeEvent(sourceEntity, targetEntity)) {
            return;
        }
        EntityItem.a(targetEntity, targetStack, sourceStack);
        targetEntity.i = Math.max(targetEntity.i, sourceEntity.i);
        targetEntity.h = Math.min(targetEntity.h, sourceEntity.h);
        if (sourceStack.f()) {
            sourceEntity.discard(EntityRemoveEvent.Cause.MERGE);
        }
    }

    @Override
    public boolean bi() {
        return !this.l().a(this.dX().a()) || super.bi();
    }

    @Override
    protected boolean aF() {
        return this.j <= 0 ? true : this.af % 10 == 0;
    }

    @Override
    public final boolean b(DamageSource source) {
        return this.d(source) ? false : this.l().a(source);
    }

    @Override
    public final boolean a(WorldServer world, DamageSource source, float amount) {
        if (this.d(source)) {
            return false;
        }
        if (!world.N().b(GameRules.c) && source.d() instanceof EntityInsentient) {
            return false;
        }
        if (!this.l().a(source)) {
            return false;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount)) {
            return false;
        }
        this.bD();
        this.j = (int)((float)this.j - amount);
        this.a(GameEvent.o, source.d());
        if (this.j <= 0) {
            this.l().a(this);
            this.discard(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    public boolean a(Explosion explosion) {
        return explosion.h() ? super.a(explosion) : true;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        if (this.frictionState != TriState.NOT_SET) {
            nbt.a("Paper.FrictionState", this.frictionState.toString());
        }
        nbt.a("Health", (short)this.j);
        nbt.a("Age", (short)this.h);
        nbt.a("PickupDelay", (short)this.i);
        if (this.k != null) {
            nbt.a("Thrower", this.k);
        }
        if (this.m != null) {
            nbt.a("Owner", this.m);
        }
        if (!this.l().f()) {
            nbt.a("Item", this.l().a(this.dY()));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.j = nbt.g("Health");
        this.h = nbt.g("Age");
        if (nbt.e("PickupDelay")) {
            this.i = nbt.g("PickupDelay");
        }
        if (nbt.b("Owner")) {
            this.m = nbt.a("Owner");
        }
        if (nbt.b("Thrower")) {
            this.k = nbt.a("Thrower");
            this.l = null;
        }
        if (nbt.b("Item", 10)) {
            NBTTagCompound nbttagcompound1 = nbt.p("Item");
            this.a(ItemStack.a((HolderLookup.a)this.dY(), (NBTBase)nbttagcompound1).orElse(ItemStack.j));
        } else {
            this.a(ItemStack.j);
        }
        if (nbt.e("Paper.FrictionState")) {
            String fs = nbt.l("Paper.FrictionState");
            try {
                this.frictionState = TriState.valueOf((String)fs);
            }
            catch (Exception ignored) {
                LogUtils.getLogger().error("Unknown friction state " + fs + " for " + String.valueOf(this));
            }
        }
        if (this.l().f()) {
            this.discard(null);
        }
    }

    @Override
    public void a_(EntityHuman player) {
        if (!this.dW().C) {
            ItemStack itemstack = this.l();
            Item item = itemstack.h();
            int i2 = itemstack.L();
            int canHold = player.gi().canHold(itemstack);
            int remaining = i2 - canHold;
            boolean flyAtPlayer = false;
            if (this.i <= 0) {
                PlayerAttemptPickupItemEvent attemptEvent = new PlayerAttemptPickupItemEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                this.dW().getCraftServer().getPluginManager().callEvent((Event)attemptEvent);
                flyAtPlayer = attemptEvent.getFlyAtPlayer();
                if (attemptEvent.isCancelled()) {
                    if (flyAtPlayer) {
                        player.a((Entity)this, i2);
                    }
                    return;
                }
            }
            if (this.i <= 0 && canHold > 0) {
                EntityPickupItemEvent entityEvent;
                itemstack.e(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                playerEvent.setCancelled(!playerEvent.getPlayer().getCanPickupItems());
                this.dW().getCraftServer().getPluginManager().callEvent((Event)playerEvent);
                flyAtPlayer = playerEvent.getFlyAtPlayer();
                if (playerEvent.isCancelled()) {
                    itemstack.e(i2);
                    if (flyAtPlayer) {
                        player.a((Entity)this, i2);
                    }
                    return;
                }
                entityEvent.setCancelled(!(entityEvent = new EntityPickupItemEvent((LivingEntity)((Player)player.getBukkitEntity()), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining)).getEntity().getCanPickupItems());
                this.dW().getCraftServer().getPluginManager().callEvent((Event)entityEvent);
                if (entityEvent.isCancelled()) {
                    itemstack.e(i2);
                    return;
                }
                ItemStack current = this.l();
                if (!itemstack.equals(current)) {
                    itemstack = current;
                } else {
                    itemstack.e(canHold + remaining);
                }
                this.i = 0;
            } else if (this.i == 0) {
                this.i = -1;
            }
            if (this.i == 0 && (this.m == null || this.m.equals(player.cG())) && player.gi().f(itemstack)) {
                if (flyAtPlayer) {
                    player.a((Entity)this, i2);
                }
                if (itemstack.f()) {
                    this.discard(EntityRemoveEvent.Cause.PICKUP);
                    itemstack.e(i2);
                }
                player.a(StatisticList.e.b(item), i2);
                player.a(this);
            }
        }
    }

    @Override
    public IChatBaseComponent al() {
        IChatBaseComponent ichatbasecomponent = this.an();
        return ichatbasecomponent != null ? ichatbasecomponent : this.l().z();
    }

    @Override
    public boolean cB() {
        return false;
    }

    @Override
    @Nullable
    public Entity b(TeleportTransition teleportTarget) {
        Entity entity = super.b(teleportTarget);
        if (!this.dW().C && entity instanceof EntityItem) {
            EntityItem entityitem = (EntityItem)entity;
            entityitem.C();
        }
        return entity;
    }

    public ItemStack l() {
        return this.au().a(c);
    }

    public void a(ItemStack stack) {
        this.au().a(c, stack);
        this.despawnRate = this.dW().paperConfig().entities.spawning.altItemDespawnRate.enabled ? this.dW().paperConfig().entities.spawning.altItemDespawnRate.items.getOrDefault((Object)stack.h(), this.dW().spigotConfig.itemDespawnRate) : this.dW().spigotConfig.itemDespawnRate;
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (c.equals(data)) {
            this.l().a((Entity)this);
        }
    }

    public void b(@Nullable UUID owner) {
        this.m = owner;
    }

    public void b(Entity thrower) {
        this.k = thrower.cG();
        this.l = thrower;
    }

    public int m() {
        return this.h;
    }

    public void s() {
        this.i = 10;
    }

    public void t() {
        this.i = 0;
    }

    public void u() {
        this.i = Short.MAX_VALUE;
    }

    public void b(int pickupDelay) {
        this.i = pickupDelay;
    }

    public boolean v() {
        return this.i > 0;
    }

    public void w() {
        this.h = Short.MIN_VALUE;
    }

    public void x() {
        this.h = -6000;
    }

    public void y() {
        this.u();
        this.h = this.despawnRate - 1;
    }

    public static float f(float f2, float f1) {
        return f2 / 20.0f + f1;
    }

    public EntityItem z() {
        return new EntityItem(this);
    }

    @Override
    public SoundCategory dn() {
        return SoundCategory.i;
    }

    @Override
    public float dN() {
        return 180.0f - EntityItem.f((float)this.m() + 0.5f, this.b) / ((float)Math.PI * 2) * 360.0f;
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        return mappedIndex == 0 ? SlotAccess.a(this::l, this::a) : super.a_(mappedIndex);
    }
}

