/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.portal.TeleportTransition;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.Explosive;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityTNTPrimed
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<Integer> a = DataWatcher.a(EntityTNTPrimed.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<IBlockData> b = DataWatcher.a(EntityTNTPrimed.class, DataWatcherRegistry.i);
    private static final int c = 80;
    private static final float d = 4.0f;
    private static final String e = "block_state";
    private static final String f = "fuse";
    private static final String g = "explosion_power";
    private static final ExplosionDamageCalculator h = new ExplosionDamageCalculator(){

        @Override
        public boolean a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData state, float power) {
            return state.a(Blocks.eq) ? false : super.a(explosion, world, pos, state, power);
        }

        @Override
        public Optional<Float> a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData blockState, Fluid fluidState) {
            return blockState.a(Blocks.eq) ? Optional.empty() : super.a(explosion, world, pos, blockState, fluidState);
        }
    };
    @Nullable
    public EntityLiving i;
    private boolean j;
    public float k = 4.0f;
    public boolean isIncendiary = false;

    public EntityTNTPrimed(EntityTypes<? extends EntityTNTPrimed> type, World world) {
        super(type, world);
        this.I = true;
    }

    public EntityTNTPrimed(World world, double x2, double y2, double z2, @Nullable EntityLiving igniter) {
        this((EntityTypes<? extends EntityTNTPrimed>)EntityTypes.bw, world);
        this.a_(x2, y2, z2);
        double d3 = this.ae.j() * 6.2831854820251465;
        this.n(-Math.sin(d3) * 0.02, 0.2f, -Math.cos(d3) * 0.02);
        this.b(80);
        this.K = x2;
        this.L = y2;
        this.M = z2;
        this.i = igniter;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(a, 80);
        builder.a(b, Blocks.cr.m());
    }

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.a;
    }

    @Override
    public boolean bH() {
        return !this.dR();
    }

    @Override
    protected double bd() {
        return 0.04;
    }

    @Override
    public void h() {
        PlayerChunkMap.EntityTracker ete;
        if (this.dW().spigotConfig.maxTntTicksPerTick > 0 && ++this.dW().spigotConfig.currentPrimedTnt > this.dW().spigotConfig.maxTntTicksPerTick) {
            return;
        }
        this.bW();
        this.bf();
        this.a(EnumMoveType.a, this.dz());
        this.aK();
        if (this.dW().paperConfig().fixes.tntEntityHeightNerf.test(v2 -> this.dD() > (double)v2)) {
            this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
            return;
        }
        this.h(this.dz().c(0.98));
        if (this.aJ()) {
            this.h(this.dz().d(0.7, -0.5, 0.7));
        }
        int i2 = this.m() - 1;
        this.b(i2);
        if (i2 <= 0) {
            if (!this.dW().C) {
                this.t();
            }
            this.discard(EntityRemoveEvent.Cause.EXPLODE);
        } else {
            this.bq();
            if (this.dW().C) {
                this.dW().a(Particles.af, this.dB(), this.dD() + 0.5, this.dH(), 0.0, 0.0, 0.0);
            }
        }
        if (!this.dR() && this.ag && this.dW().paperConfig().fixes.preventTntFromMovingInWater && (ete = (PlayerChunkMap.EntityTracker)((WorldServer)this.dW()).m().a.K.get(this.ar())) != null) {
            PacketPlayOutEntityVelocity velocityPacket = new PacketPlayOutEntityVelocity(this);
            PacketPlayOutEntityTeleport positionPacket = PacketPlayOutEntityTeleport.a(this.ar(), PositionMoveRotation.a(this), Set.of(), this.aD);
            ete.f.stream().filter(viewer -> (viewer.o().dB() - this.dB()) * (viewer.o().dD() - this.dD()) * (viewer.o().dH() - this.dH()) < 256.0).forEach(viewer -> {
                viewer.b(velocityPacket);
                viewer.b(positionPacket);
            });
        }
    }

    private void t() {
        ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent((Explosive)this.getBukkitEntity());
        if (event.isCancelled()) {
            return;
        }
        this.dW().a(this, Explosion.a(this.dW(), this), this.j ? h : null, this.dB(), this.e(0.0625), this.dH(), event.getRadius(), event.getFire(), World.a.d);
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        nbt.a(f, (short)this.m());
        nbt.a(e, GameProfileSerializer.a(this.s()));
        if (this.k != 4.0f) {
            nbt.a(g, this.k);
        }
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        this.b(nbt.g(f));
        if (nbt.b(e, 10)) {
            this.c(GameProfileSerializer.a(this.dW().a(Registries.f), nbt.p(e)));
        }
        if (nbt.b(g, 99)) {
            this.k = MathHelper.a(nbt.j(g), 0.0f, 128.0f);
        }
    }

    @Nullable
    public EntityLiving l() {
        return this.i;
    }

    @Override
    public void x(Entity original) {
        super.x(original);
        if (original instanceof EntityTNTPrimed) {
            EntityTNTPrimed entitytntprimed = (EntityTNTPrimed)original;
            this.i = entitytntprimed.i;
        }
    }

    public void b(int fuse) {
        this.al.a(a, fuse);
    }

    public int m() {
        return this.al.a(a);
    }

    public void c(IBlockData state) {
        this.al.a(b, state);
    }

    public IBlockData s() {
        return this.al.a(b);
    }

    private void a(boolean teleported) {
        this.j = teleported;
    }

    @Override
    @Nullable
    public Entity b(TeleportTransition teleportTarget) {
        Entity entity = super.b(teleportTarget);
        if (entity instanceof EntityTNTPrimed) {
            EntityTNTPrimed entitytntprimed = (EntityTNTPrimed)entity;
            entitytntprimed.a(true);
        }
        return entity;
    }

    @Override
    public final boolean a(WorldServer world, DamageSource source, float amount) {
        return false;
    }

    @Override
    public boolean cJ() {
        return !this.dW().paperConfig().fixes.preventTntFromMovingInWater && super.cJ();
    }
}

