/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.CreeperIgniteEvent;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSwell;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.Creeper;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityCreeper
extends EntityMonster {
    private static final DataWatcherObject<Integer> a = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> b = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private int d;
    public int bZ;
    public int ca = 30;
    public int cb = 3;
    private int cc;
    public Entity entityIgniter;

    public EntityCreeper(EntityTypes<? extends EntityCreeper> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
    }

    @Override
    protected void B() {
        this.bT.a(1, new PathfinderGoalFloat(this));
        this.bT.a(2, new PathfinderGoalSwell(this));
        this.bT.a(3, new PathfinderGoalAvoidTarget<EntityOcelot>(this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.bT.a(3, new PathfinderGoalAvoidTarget<EntityCat>(this, EntityCat.class, 6.0f, 1.0, 1.2));
        this.bT.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bT.a(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.bT.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bT.a(6, new PathfinderGoalRandomLookaround(this));
        this.bU.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bU.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gt().a(GenericAttributes.v, 0.25);
    }

    @Override
    public int cE() {
        return this.O_() == null ? this.y(0.0f) : this.y(this.eE() - 1.0f);
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag = super.a(fallDistance, damageMultiplier, damageSource);
        this.bZ += (int)(fallDistance * 1.5f);
        if (this.bZ > this.ca - 5) {
            this.bZ = this.ca - 5;
        }
        return flag;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, -1);
        builder.a(b, false);
        builder.a(c, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.al.a(b).booleanValue()) {
            nbt.a("powered", true);
        }
        nbt.a("Fuse", (short)this.ca);
        nbt.a("ExplosionRadius", (byte)this.cb);
        nbt.a("ignited", this.x());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.al.a(b, nbt.q("powered"));
        if (nbt.b("Fuse", 99)) {
            this.ca = nbt.g("Fuse");
        }
        if (nbt.b("ExplosionRadius", 99)) {
            this.cb = nbt.f("ExplosionRadius");
        }
        if (nbt.q("ignited")) {
            this.al.a(c, true);
        }
    }

    @Override
    public void h() {
        if (this.bL()) {
            int i2;
            this.d = this.bZ;
            if (this.x()) {
                this.b(1);
            }
            if ((i2 = this.t()) > 0 && this.bZ == 0) {
                this.a(SoundEffects.gE, 1.0f, 0.5f);
                ((Entity)this).a(GameEvent.I);
            }
            this.bZ += i2;
            if (this.bZ < 0) {
                this.bZ = 0;
            }
            if (this.bZ >= this.ca) {
                this.bZ = this.ca;
                this.gr();
            }
        }
        super.h();
    }

    @Override
    public void h(@Nullable EntityLiving target) {
        if (!(target instanceof Goat)) {
            super.h(target);
        }
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.gD;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.gC;
    }

    @Override
    protected void a(WorldServer world, DamageSource source, boolean causedByPlayer) {
        EntityCreeper entitycreeper;
        super.a(world, source, causedByPlayer);
        Entity entity = source.d();
        if (entity != this && entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).gp()) {
            entitycreeper.gq();
            this.a(world, Items.vf);
        }
    }

    @Override
    public boolean c(WorldServer world, Entity target) {
        return true;
    }

    public boolean p() {
        return this.al.a(b);
    }

    public float J(float timeDelta) {
        return MathHelper.h(timeDelta, this.d, this.bZ) / (float)(this.ca - 2);
    }

    public int t() {
        return this.al.a(a);
    }

    public void b(int fuseSpeed) {
        this.al.a(a, fuseSpeed);
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        super.a(world, lightning);
        if (CraftEventFactory.callCreeperPowerEvent(this, lightning, CreeperPowerEvent.PowerCause.LIGHTNING).isCancelled()) {
            return;
        }
        this.al.a(b, true);
    }

    public void setPowered(boolean powered) {
        this.al.a(b, powered);
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(TagsItem.bx)) {
            SoundEffect soundeffect = itemstack.a(Items.uM) ? SoundEffects.je : SoundEffects.jt;
            this.dW().a(player, this.dB(), this.dD(), this.dH(), soundeffect, this.dn(), 1.0f, this.ae.i() * 0.4f + 0.8f);
            if (!this.dW().C) {
                this.entityIgniter = player;
                this.go();
                if (itemstack.p() == 0) {
                    itemstack.h(1);
                } else {
                    itemstack.a(1, (EntityLiving)player, EntityCreeper.d(hand));
                }
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    public void gr() {
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            float f2 = this.p() ? 2.0f : 1.0f;
            ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, (float)this.cb * f2, false);
            if (!event.isCancelled()) {
                this.be = true;
                worldserver.a((Entity)this, this.dB(), this.dD(), this.dH(), event.getRadius(), event.getFire(), World.a.c);
                this.gu();
                this.a(worldserver, Entity.RemovalReason.a);
                this.discard(EntityRemoveEvent.Cause.EXPLODE);
            } else {
                this.bZ = 0;
                this.al.a(c, false);
            }
        }
    }

    private void gu() {
        Collection<MobEffect> collection = this.eB();
        if (!collection.isEmpty() && !this.dW().paperConfig().entities.behavior.disableCreeperLingeringEffect) {
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.dW(), this.dB(), this.dD(), this.dH());
            entityareaeffectcloud.a(this);
            entityareaeffectcloud.a(2.5f);
            entityareaeffectcloud.b(-0.5f);
            entityareaeffectcloud.c(10);
            entityareaeffectcloud.a(entityareaeffectcloud.g() / 2);
            entityareaeffectcloud.c(-entityareaeffectcloud.c() / (float)entityareaeffectcloud.g());
            for (MobEffect mobeffect : collection) {
                entityareaeffectcloud.a(new MobEffect(mobeffect));
            }
            this.dW().addFreshEntity(entityareaeffectcloud, CreatureSpawnEvent.SpawnReason.EXPLOSION);
        }
    }

    public boolean x() {
        return this.al.a(c);
    }

    public void go() {
        this.setIgnited(true);
    }

    public void setIgnited(boolean ignited) {
        CreeperIgniteEvent event;
        if (this.x() != ignited && (event = new CreeperIgniteEvent((Creeper)this.getBukkitEntity(), ignited)).callEvent()) {
            this.al.a(c, event.isIgnited());
        }
    }

    public boolean gp() {
        return this.p() && this.cc < 1;
    }

    public void gq() {
        ++this.cc;
    }
}

