/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.EndermanAttackPlayerEvent;
import com.destroystokyo.paper.event.entity.EndermanEscapeEvent;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityEnderman
extends EntityMonster
implements IEntityAngerable {
    private static final MinecraftKey c = MinecraftKey.b("attacking");
    private static final AttributeModifier d = new AttributeModifier(c, 0.15f, AttributeModifier.Operation.a);
    private static final int bZ = 400;
    private static final int ca = 600;
    private static final DataWatcherObject<Optional<IBlockData>> cb = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.j);
    private static final DataWatcherObject<Boolean> cc = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cd = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private int ce = Integer.MIN_VALUE;
    private int cf;
    private static final UniformInt cg = TimeRange.a(20, 39);
    private int ch;
    @Nullable
    private UUID ci;

    public EntityEnderman(EntityTypes<? extends EntityEnderman> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
        this.a(PathType.j, -1.0f);
    }

    @Override
    protected void B() {
        this.bT.a(0, new PathfinderGoalFloat(this));
        this.bT.a(1, new a(this));
        this.bT.a(2, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bT.a(7, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 0.0f));
        this.bT.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bT.a(8, new PathfinderGoalRandomLookaround(this));
        this.bT.a(10, new PathfinderGoalEndermanPlaceBlock(this));
        this.bT.a(11, new PathfinderGoalEndermanPickupBlock(this));
        this.bU.a(1, new PathfinderGoalPlayerWhoLookedAtTarget(this, this::a));
        this.bU.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bU.a(3, new PathfinderGoalNearestAttackableTarget<EntityEndermite>((EntityInsentient)this, EntityEndermite.class, true, false));
        this.bU.a(4, new PathfinderGoalUniversalAngerReset<EntityEnderman>(this, false));
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gt().a(GenericAttributes.s, 40.0).a(GenericAttributes.v, 0.3f).a(GenericAttributes.c, 7.0).a(GenericAttributes.m, 64.0).a(GenericAttributes.B, 1.0);
    }

    @Override
    public void h(@Nullable EntityLiving target) {
        this.setTarget(target, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    private boolean tryEscape(EndermanEscapeEvent.Reason reason) {
        return new EndermanEscapeEvent((Enderman)((CraftEnderman)this.getBukkitEntity()), reason).callEvent();
    }

    @Override
    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (!super.setTarget(entityliving, reason, fireEvent)) {
            return false;
        }
        entityliving = this.O_();
        AttributeModifiable attributemodifiable = this.g(GenericAttributes.v);
        if (entityliving == null) {
            this.cf = 0;
            this.al.a(cc, false);
            this.al.a(cd, false);
            attributemodifiable.c(c);
        } else {
            this.cf = this.af;
            this.al.a(cc, true);
            if (!attributemodifiable.b(c)) {
                attributemodifiable.b(d);
            }
        }
        return true;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cb, Optional.empty());
        builder.a(cc, false);
        builder.a(cd, false);
    }

    @Override
    public void c() {
        this.a(cg.a(this.ae));
    }

    @Override
    public void a(int angerTime) {
        this.ch = angerTime;
    }

    @Override
    public int a() {
        return this.ch;
    }

    @Override
    public void a(@Nullable UUID angryAt) {
        this.ci = angryAt;
    }

    @Override
    @Nullable
    public UUID b() {
        return this.ci;
    }

    public void p() {
        if (this.af >= this.ce + 400) {
            this.ce = this.af;
            if (!this.bb()) {
                this.dW().a(this.dB(), this.dF(), this.dH(), SoundEffects.iH, this.dn(), 2.5f, 1.0f, false);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (cc.equals(data) && this.gp() && this.dW().C) {
            this.p();
        }
        super.a(data);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        IBlockData iblockdata = this.x();
        if (iblockdata != null) {
            nbt.a("carriedBlockState", GameProfileSerializer.a(iblockdata));
        }
        this.a_(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        IBlockData iblockdata = null;
        if (nbt.b("carriedBlockState", 10) && (iblockdata = GameProfileSerializer.a(this.dW().a(Registries.f), nbt.p("carriedBlockState"))).l()) {
            iblockdata = null;
        }
        this.c(iblockdata);
        this.a(this.dW(), nbt);
    }

    boolean a(EntityHuman player) {
        boolean shouldAttack = this.isBeingStaredBy0(player);
        EndermanAttackPlayerEvent event = new EndermanAttackPlayerEvent((Enderman)this.getBukkitEntity(), (Player)player.getBukkitEntity());
        event.setCancelled(!shouldAttack);
        return event.callEvent();
    }

    private boolean isBeingStaredBy0(EntityHuman player) {
        return this.a(player, 0.025, true, false, EntityLiving.aH, this::dF);
    }

    @Override
    public void d_() {
        if (this.dW().C) {
            for (int i2 = 0; i2 < 2; ++i2) {
                this.dW().a(Particles.ad, this.d(0.5), this.dE() - 0.25, this.g(0.5), (this.ae.j() - 0.5) * 2.0, -this.ae.j(), (this.ae.j() - 0.5) * 2.0);
            }
        }
        this.bn = false;
        if (!this.dW().C) {
            this.a((WorldServer)this.dW(), true);
        }
        super.d_();
    }

    @Override
    public boolean fr() {
        return true;
    }

    @Override
    protected void a(WorldServer world) {
        float f2;
        if (world.U() && this.af >= this.cf + 600 && (f2 = this.by()) > 0.5f && world.h(this.dw()) && this.ae.i() * 30.0f < (f2 - 0.4f) * 2.0f && this.tryEscape(EndermanEscapeEvent.Reason.RUNAWAY)) {
            this.h((EntityLiving)null);
            this.t();
        }
        super.a(world);
    }

    public boolean t() {
        if (!this.dW().B_() && this.bL()) {
            double d0 = this.dB() + (this.ae.j() - 0.5) * 64.0;
            double d1 = this.dD() + (double)(this.ae.a(64) - 32);
            double d2 = this.dH() + (this.ae.j() - 0.5) * 64.0;
            return this.q(d0, d1, d2);
        }
        return false;
    }

    public boolean b(Entity entity) {
        Vec3D vec3d = new Vec3D(this.dB() - entity.dB(), this.e(0.5) - entity.dF(), this.dH() - entity.dH());
        vec3d = vec3d.d();
        double d0 = 16.0;
        double d1 = this.dB() + (this.ae.j() - 0.5) * 8.0 - vec3d.d * 16.0;
        double d2 = this.dD() + (double)(this.ae.a(16) - 8) - vec3d.e * 16.0;
        double d3 = this.dH() + (this.ae.j() - 0.5) * 8.0 - vec3d.f * 16.0;
        return this.q(d1, d2, d3);
    }

    private boolean q(double x2, double y2, double z2) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(x2, y2, z2);
        while (blockposition_mutableblockposition.v() > this.dW().L_() && !this.dW().a_(blockposition_mutableblockposition).d()) {
            blockposition_mutableblockposition.c(EnumDirection.a);
        }
        IBlockData iblockdata = this.dW().a_(blockposition_mutableblockposition);
        boolean flag = iblockdata.d();
        boolean flag1 = iblockdata.y().a(TagsFluid.a);
        if (flag && !flag1) {
            Vec3D vec3d = this.du();
            boolean flag2 = this.b(x2, y2, z2, true);
            if (flag2) {
                this.dW().a(GameEvent.R, vec3d, GameEvent.a.a(this));
                if (!this.bb()) {
                    this.dW().a((EntityHuman)null, this.K, this.L, this.M, SoundEffects.iI, this.dn(), 1.0f, 1.0f);
                    this.a(SoundEffects.iI, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    @Override
    protected SoundEffect u() {
        return this.go() ? SoundEffects.iG : SoundEffects.iD;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.iF;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.iE;
    }

    @Override
    protected void a(WorldServer world, DamageSource source, boolean causedByPlayer) {
        super.a(world, source, causedByPlayer);
        IBlockData iblockdata = this.x();
        if (iblockdata != null) {
            ItemStack itemstack = new ItemStack(Items.pF);
            EnchantmentManager.a(itemstack, world.K_(), VanillaEnchantmentProviders.g, world.d_(this.dw()), this.dZ());
            LootParams.a lootparams_a = new LootParams.a((WorldServer)this.dW()).a(LootContextParameters.f, this.du()).a(LootContextParameters.i, itemstack).b(LootContextParameters.a, this);
            List<ItemStack> list = iblockdata.a(lootparams_a);
            for (ItemStack itemstack1 : list) {
                this.a(world, itemstack1);
            }
        }
    }

    public void c(@Nullable IBlockData state) {
        this.al.a(cb, Optional.ofNullable(state));
    }

    @Nullable
    public IBlockData x() {
        return this.al.a(cb).orElse(null);
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        boolean flag1;
        if (this.a(world, source)) {
            return false;
        }
        boolean flag = source.c() instanceof EntityPotion;
        if (!source.a(DamageTypeTags.j) && !flag) {
            boolean flag12 = super.a(world, source, amount);
            if (!(source.d() instanceof EntityLiving) && this.ae.a(10) != 0) {
                this.t();
            }
            return flag12;
        }
        boolean bl = flag1 = flag && this.a(world, source, (EntityPotion)source.c(), amount);
        if (this.tryEscape(EndermanEscapeEvent.Reason.INDIRECT)) {
            for (int i2 = 0; i2 < 64; ++i2) {
                if (!this.t()) continue;
                return true;
            }
        }
        return flag1;
    }

    private boolean a(WorldServer world, DamageSource source, EntityPotion potion, float amount) {
        ItemStack itemstack = potion.l();
        PotionContents potioncontents = itemstack.a(DataComponents.Q, PotionContents.a);
        return potioncontents.a(Potions.a) ? super.a(world, source, amount) : false;
    }

    public boolean go() {
        return this.al.a(cc);
    }

    public boolean gp() {
        return this.al.a(cd);
    }

    public void gq() {
        this.al.a(cd, true);
    }

    public void setCreepy(boolean creepy) {
        this.al.a(cc, creepy);
    }

    public void setHasBeenStaredAt(boolean hasBeenStaredAt) {
        this.al.a(cd, hasBeenStaredAt);
    }

    @Override
    public boolean W() {
        return super.W() || this.x() != null;
    }

    private static class a
    extends PathfinderGoal {
        private final EntityEnderman a;
        @Nullable
        private EntityLiving b;

        public a(EntityEnderman enderman) {
            this.a = enderman;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            this.b = this.a.O_();
            if (!(this.b instanceof EntityHuman)) {
                return false;
            }
            double d0 = this.b.g((Entity)this.a);
            return d0 > 256.0 ? false : this.a.a((EntityHuman)this.b);
        }

        @Override
        public void d() {
            this.a.L().o();
        }

        @Override
        public void a() {
            this.a.H().a(this.b.dB(), this.b.dF(), this.b.dH());
        }
    }

    private static class PathfinderGoalEndermanPlaceBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPlaceBlock(EntityEnderman enderman) {
            this.a = enderman;
        }

        @Override
        public boolean b() {
            return this.a.x() == null ? false : (!PathfinderGoalEndermanPlaceBlock.a(this.a).N().b(GameRules.c) ? false : this.a.dZ().a(PathfinderGoalEndermanPlaceBlock.b(2000)) == 0);
        }

        @Override
        public void a() {
            int k2;
            int j2;
            int i2;
            BlockPosition blockposition;
            RandomSource randomsource = this.a.dZ();
            World world = this.a.dW();
            IBlockData iblockdata = world.getBlockStateIfLoaded(blockposition = new BlockPosition(i2 = MathHelper.a(this.a.dB() - 1.0 + randomsource.j() * 2.0), j2 = MathHelper.a(this.a.dD() + randomsource.j() * 2.0), k2 = MathHelper.a(this.a.dH() - 1.0 + randomsource.j() * 2.0)));
            if (iblockdata == null) {
                return;
            }
            BlockPosition blockposition1 = blockposition.e();
            IBlockData iblockdata1 = world.a_(blockposition1);
            IBlockData iblockdata2 = this.a.x();
            if (iblockdata2 != null && this.a(world, blockposition, iblockdata2 = Block.b(iblockdata2, this.a.dW(), blockposition), iblockdata, iblockdata1, blockposition1) && CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition, iblockdata2)) {
                world.a(blockposition, iblockdata2, 3);
                world.a(GameEvent.i, blockposition, GameEvent.a.a(this.a, iblockdata2));
                this.a.c((IBlockData)null);
            }
        }

        private boolean a(World world, BlockPosition posAbove, IBlockData carriedState, IBlockData stateAbove, IBlockData state, BlockPosition pos) {
            return stateAbove.l() && !state.l() && !state.a(Blocks.I) && state.m(world, pos) && carriedState.a((IWorldReader)world, posAbove) && world.a_(this.a, AxisAlignedBB.a(Vec3D.a(posAbove))).isEmpty();
        }
    }

    private static class PathfinderGoalEndermanPickupBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPickupBlock(EntityEnderman enderman) {
            this.a = enderman;
        }

        @Override
        public boolean b() {
            return this.a.x() != null ? false : (!PathfinderGoalEndermanPickupBlock.a(this.a).N().b(GameRules.c) ? false : this.a.dZ().a(PathfinderGoalEndermanPickupBlock.b(20)) == 0);
        }

        @Override
        public void a() {
            int k2;
            int j2;
            int i2;
            BlockPosition blockposition;
            RandomSource randomsource = this.a.dZ();
            World world = this.a.dW();
            IBlockData iblockdata = world.getBlockStateIfLoaded(blockposition = new BlockPosition(i2 = MathHelper.a(this.a.dB() - 2.0 + randomsource.j() * 4.0), j2 = MathHelper.a(this.a.dD() + randomsource.j() * 3.0), k2 = MathHelper.a(this.a.dH() - 2.0 + randomsource.j() * 4.0)));
            if (iblockdata == null) {
                return;
            }
            Vec3D vec3d = new Vec3D((double)this.a.dA() + 0.5, (double)j2 + 0.5, (double)this.a.dG() + 0.5);
            Vec3D vec3d1 = new Vec3D((double)i2 + 0.5, (double)j2 + 0.5, (double)k2 + 0.5);
            MovingObjectPositionBlock movingobjectpositionblock = world.a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.a));
            boolean flag = movingobjectpositionblock.b().equals(blockposition);
            if (iblockdata.a(TagsBlock.ao) && flag && CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition, iblockdata.y().g())) {
                world.a(blockposition, false);
                world.a(GameEvent.f, blockposition, GameEvent.a.a(this.a, iblockdata));
                this.a.c(iblockdata.b().m());
            }
        }
    }

    private static class PathfinderGoalPlayerWhoLookedAtTarget
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        private final EntityEnderman i;
        @Nullable
        private EntityHuman j;
        private int k;
        private int l;
        private final PathfinderTargetCondition m;
        private final PathfinderTargetCondition n = PathfinderTargetCondition.a().d();
        private final PathfinderTargetCondition.a o;

        public PathfinderGoalPlayerWhoLookedAtTarget(EntityEnderman enderman, @Nullable PathfinderTargetCondition.a targetPredicate) {
            super(enderman, EntityHuman.class, 10, false, false, targetPredicate);
            this.i = enderman;
            this.o = (entityliving, worldserver) -> (enderman.a((EntityHuman)entityliving) || enderman.a(entityliving, worldserver)) && !enderman.A(entityliving);
            this.m = PathfinderTargetCondition.a().a(this.l()).a(this.o);
        }

        @Override
        public boolean b() {
            this.j = PathfinderGoalPlayerWhoLookedAtTarget.a(this.i).a(this.m.a(this.l()), this.i);
            return this.j != null;
        }

        @Override
        public void d() {
            this.k = this.a(5);
            this.l = 0;
            this.i.gq();
        }

        @Override
        public void e() {
            this.j = null;
            super.e();
        }

        @Override
        public boolean c() {
            if (this.j != null) {
                if (!this.o.test(this.j, PathfinderGoalPlayerWhoLookedAtTarget.a(this.i))) {
                    return false;
                }
                this.i.a((Entity)this.j, 10.0f, 10.0f);
                return true;
            }
            if (this.c != null) {
                if (this.i.A(this.c)) {
                    return false;
                }
                if (this.n.a(PathfinderGoalPlayerWhoLookedAtTarget.a(this.i), this.i, this.c)) {
                    return true;
                }
            }
            return super.c();
        }

        @Override
        public void a() {
            if (this.i.O_() == null) {
                super.a((EntityLiving)null);
            }
            if (this.j != null) {
                if (--this.k <= 0) {
                    this.c = this.j;
                    this.j = null;
                    super.d();
                }
            } else {
                if (this.c != null && !this.i.bZ()) {
                    if (this.i.a((EntityHuman)this.c)) {
                        if (this.c.g((Entity)this.i) < 16.0 && this.i.tryEscape(EndermanEscapeEvent.Reason.STARE)) {
                            this.i.t();
                        }
                        this.l = 0;
                    } else if (this.c.g((Entity)this.i) > 256.0 && this.l++ >= this.a(30) && this.i.b((Entity)this.c)) {
                        this.l = 0;
                    }
                }
                super.a();
            }
        }
    }
}

