/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.monster.EntityIllagerWizard;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class EntityEvoker
extends EntityIllagerWizard {
    @Nullable
    private EntitySheep a;

    public EntityEvoker(EntityTypes<? extends EntityEvoker> type, World world) {
        super((EntityTypes<? extends EntityIllagerWizard>)type, world);
        this.bO = 10;
    }

    @Override
    protected void B() {
        super.B();
        this.bT.a(0, new PathfinderGoalFloat(this));
        this.bT.a(1, new b());
        this.bT.a(2, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 8.0f, 0.6, 1.0));
        this.bT.a(3, new PathfinderGoalAvoidTarget<Creaking>(this, Creaking.class, 8.0f, 1.0, 1.2));
        this.bT.a(4, new c());
        this.bT.a(5, new a());
        this.bT.a(6, new d());
        this.bT.a(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.bT.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.bT.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.bU.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bU.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true).c(300));
        this.bU.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false).c(300));
        this.bU.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, false));
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gt().a(GenericAttributes.v, 0.5).a(GenericAttributes.m, 12.0).a(GenericAttributes.s, 24.0);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
    }

    @Override
    public SoundEffect ak_() {
        return SoundEffects.iT;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
    }

    @Override
    protected boolean t(Entity other) {
        EntityVex entityvex;
        if (other == this) {
            return true;
        }
        if (super.t(other)) {
            return true;
        }
        if (other instanceof EntityVex && (entityvex = (EntityVex)other).t() != null) {
            return this.t(entityvex.t());
        }
        return false;
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.iR;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.iU;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.iW;
    }

    public void a(@Nullable EntitySheep wololoTarget) {
        this.a = wololoTarget;
    }

    @Nullable
    public EntitySheep gI() {
        return this.a;
    }

    @Override
    protected SoundEffect x() {
        return SoundEffects.iS;
    }

    @Override
    public void a(WorldServer world, int wave, boolean unused) {
    }

    private class b
    extends EntityIllagerWizard.b {
        b() {
            super(EntityEvoker.this);
        }

        @Override
        public void a() {
            if (EntityEvoker.this.O_() != null) {
                EntityEvoker.this.H().a(EntityEvoker.this.O_(), (float)EntityEvoker.this.aa(), (float)EntityEvoker.this.Z());
            } else if (EntityEvoker.this.gI() != null) {
                EntityEvoker.this.H().a(EntityEvoker.this.gI(), (float)EntityEvoker.this.aa(), (float)EntityEvoker.this.Z());
            }
        }
    }

    private class c
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition e;

        c() {
            super(EntityEvoker.this);
            this.e = PathfinderTargetCondition.b().a(16.0).d().e();
        }

        @Override
        public boolean b() {
            if (!super.b()) {
                return false;
            }
            int i2 = net.minecraft.world.entity.monster.EntityEvoker$c.a(EntityEvoker.this.dW()).a(EntityVex.class, this.e, EntityEvoker.this, EntityEvoker.this.cR().g(16.0)).size();
            return EntityEvoker.this.ae.a(8) + 1 > i2;
        }

        @Override
        protected int h() {
            return 100;
        }

        @Override
        protected int i() {
            return 340;
        }

        @Override
        protected void k() {
            WorldServer worldserver = (WorldServer)EntityEvoker.this.dW();
            ScoreboardTeam scoreboardteam = EntityEvoker.this.cr();
            for (int i2 = 0; i2 < 3; ++i2) {
                BlockPosition blockposition = EntityEvoker.this.dw().b(-2 + EntityEvoker.this.ae.a(5), 1, -2 + EntityEvoker.this.ae.a(5));
                EntityVex entityvex = EntityTypes.bC.a(EntityEvoker.this.dW(), EntitySpawnReason.f);
                if (entityvex == null) continue;
                entityvex.a(blockposition, 0.0f, 0.0f);
                entityvex.a((WorldAccess)worldserver, EntityEvoker.this.dW().d_(blockposition), EntitySpawnReason.f, (GroupDataEntity)null);
                entityvex.a(EntityEvoker.this);
                entityvex.h(blockposition);
                entityvex.b(20 * (30 + EntityEvoker.this.ae.a(90)));
                if (scoreboardteam != null) {
                    worldserver.g().a(entityvex.cI(), scoreboardteam);
                }
                worldserver.addFreshEntityWithPassengers(entityvex, CreatureSpawnEvent.SpawnReason.SPELL);
                worldserver.a(GameEvent.t, blockposition, GameEvent.a.a(EntityEvoker.this));
            }
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.iY;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.b;
        }
    }

    private class a
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        a() {
            super(EntityEvoker.this);
        }

        @Override
        protected int h() {
            return 40;
        }

        @Override
        protected int i() {
            return 100;
        }

        @Override
        protected void k() {
            EntityLiving entityliving = EntityEvoker.this.O_();
            double d0 = Math.min(entityliving.dD(), EntityEvoker.this.dD());
            double d1 = Math.max(entityliving.dD(), EntityEvoker.this.dD()) + 1.0;
            float f2 = (float)MathHelper.d(entityliving.dH() - EntityEvoker.this.dH(), entityliving.dB() - EntityEvoker.this.dB());
            if (EntityEvoker.this.g((Entity)entityliving) < 9.0) {
                float f1;
                int i2;
                for (i2 = 0; i2 < 5; ++i2) {
                    f1 = f2 + (float)i2 * (float)Math.PI * 0.4f;
                    this.a(EntityEvoker.this.dB() + (double)MathHelper.b(f1) * 1.5, EntityEvoker.this.dH() + (double)MathHelper.a(f1) * 1.5, d0, d1, f1, 0);
                }
                for (i2 = 0; i2 < 8; ++i2) {
                    f1 = f2 + (float)i2 * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.a(EntityEvoker.this.dB() + (double)MathHelper.b(f1) * 2.5, EntityEvoker.this.dH() + (double)MathHelper.a(f1) * 2.5, d0, d1, f1, 3);
                }
            } else {
                for (int i3 = 0; i3 < 16; ++i3) {
                    double d2 = 1.25 * (double)(i3 + 1);
                    int j2 = 1 * i3;
                    this.a(EntityEvoker.this.dB() + (double)MathHelper.b(f2) * d2, EntityEvoker.this.dH() + (double)MathHelper.a(f2) * d2, d0, d1, f2, j2);
                }
            }
        }

        private void a(double x2, double z2, double maxY, double y2, float yaw, int warmup) {
            BlockPosition blockposition = BlockPosition.a(x2, y2, z2);
            boolean flag = false;
            double d4 = 0.0;
            do {
                IBlockData iblockdata1;
                VoxelShape voxelshape;
                BlockPosition blockposition1 = blockposition.e();
                IBlockData iblockdata = EntityEvoker.this.dW().a_(blockposition1);
                if (!iblockdata.c((IBlockAccess)EntityEvoker.this.dW(), blockposition1, EnumDirection.b)) continue;
                if (!EntityEvoker.this.dW().u(blockposition) && !(voxelshape = (iblockdata1 = EntityEvoker.this.dW().a_(blockposition)).g(EntityEvoker.this.dW(), blockposition)).c()) {
                    d4 = voxelshape.c(EnumDirection.EnumAxis.b);
                }
                flag = true;
                break;
            } while ((blockposition = blockposition.e()).v() >= MathHelper.a(maxY) - 1);
            if (flag) {
                EntityEvoker.this.dW().b(new EntityEvokerFangs(EntityEvoker.this.dW(), x2, (double)blockposition.v() + d4, z2, yaw, warmup, EntityEvoker.this));
                EntityEvoker.this.dW().a(GameEvent.t, new Vec3D(x2, (double)blockposition.v() + d4, z2), GameEvent.a.a(EntityEvoker.this));
            }
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.iX;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.c;
        }
    }

    public class d
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition e;

        public d() {
            super(EntityEvoker.this);
            this.e = PathfinderTargetCondition.b().a(16.0).a((EntityLiving entityliving, WorldServer worldserver) -> ((EntitySheep)entityliving).t() == EnumColor.l);
        }

        @Override
        public boolean b() {
            if (EntityEvoker.this.O_() != null) {
                return false;
            }
            if (EntityEvoker.this.gx()) {
                return false;
            }
            if (EntityEvoker.this.af < this.c) {
                return false;
            }
            WorldServer worldserver = net.minecraft.world.entity.monster.EntityEvoker$d.a(EntityEvoker.this.dW());
            if (!worldserver.N().b(GameRules.c)) {
                return false;
            }
            List<EntitySheep> list = worldserver.a(EntitySheep.class, this.e, EntityEvoker.this, EntityEvoker.this.cR().c(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            EntityEvoker.this.a(list.get(EntityEvoker.this.ae.a(list.size())));
            return true;
        }

        @Override
        public boolean c() {
            return EntityEvoker.this.gI() != null && this.b > 0;
        }

        @Override
        public void e() {
            super.e();
            EntityEvoker.this.a((EntitySheep)null);
        }

        @Override
        protected void k() {
            EntitySheep entitysheep = EntityEvoker.this.gI();
            if (entitysheep != null && entitysheep.bL()) {
                entitysheep.b(EnumColor.o);
            }
        }

        @Override
        protected int n() {
            return 40;
        }

        @Override
        protected int h() {
            return 60;
        }

        @Override
        protected int i() {
            return 140;
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.iZ;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.d;
        }
    }
}

