/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityFlying;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntityGhast
extends EntityFlying
implements IMonster {
    private static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityGhast.class, DataWatcherRegistry.k);
    private int b = 1;

    public EntityGhast(EntityTypes<? extends EntityGhast> type, World world) {
        super((EntityTypes<? extends EntityFlying>)type, world);
        this.bO = 5;
        this.bQ = new ControllerGhast(this);
    }

    @Override
    protected void B() {
        this.bT.a(5, new PathfinderGoalGhastIdleMove(this));
        this.bT.a(7, new PathfinderGoalGhastMoveTowardsTarget(this));
        this.bT.a(7, new PathfinderGoalGhastAttackTarget(this));
        this.bU.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, (entityliving, worldserver) -> Math.abs(entityliving.dD() - this.dD()) <= 4.0));
    }

    public boolean m() {
        return this.al.a(a);
    }

    public void x(boolean shooting) {
        this.al.a(a, shooting);
    }

    public int p() {
        return this.b;
    }

    public void setExplosionPower(int explosionPower) {
        this.b = explosionPower;
    }

    @Override
    protected boolean X() {
        return true;
    }

    private static boolean h(DamageSource damageSource) {
        return damageSource.c() instanceof EntityLargeFireball && damageSource.d() instanceof EntityHuman;
    }

    @Override
    public boolean a(WorldServer world, DamageSource source) {
        return this.cC() && !source.a(DamageTypeTags.d) || !EntityGhast.h(source) && super.a(world, source);
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        if (EntityGhast.h(source)) {
            super.a(world, source, 1000.0f);
            return true;
        }
        return this.a(world, source) ? false : super.a(world, source, amount);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, false);
    }

    public static AttributeProvider.Builder t() {
        return EntityInsentient.C().a(GenericAttributes.s, 10.0).a(GenericAttributes.m, 100.0);
    }

    @Override
    public SoundCategory dn() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.kE;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.kG;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.kF;
    }

    @Override
    public float fg() {
        return 5.0f;
    }

    public static boolean b(EntityTypes<EntityGhast> type, GeneratorAccess world, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return world.al() != EnumDifficulty.a && random.a(20) == 0 && EntityGhast.a(type, world, spawnReason, pos, random);
    }

    @Override
    public int ad() {
        return 1;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("ExplosionPower", (byte)this.b);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("ExplosionPower", 99)) {
            this.b = nbt.f("ExplosionPower");
        }
    }

    private static class ControllerGhast
    extends ControllerMove {
        private final EntityGhast l;
        private int m;

        public ControllerGhast(EntityGhast ghast) {
            super(ghast);
            this.l = ghast;
        }

        @Override
        public void a() {
            if (this.k == ControllerMove.Operation.b && this.m-- <= 0) {
                this.m += this.l.dZ().a(5) + 2;
                Vec3D vec3d = new Vec3D(this.e - this.l.dB(), this.f - this.l.dD(), this.g - this.l.dH());
                double d0 = vec3d.g();
                if (this.a(vec3d = vec3d.d(), MathHelper.c(d0))) {
                    this.l.h(this.l.dz().e(vec3d.c(0.1)));
                } else {
                    this.k = ControllerMove.Operation.a;
                }
            }
        }

        private boolean a(Vec3D direction, int steps) {
            AxisAlignedBB axisalignedbb = this.l.cR();
            for (int j2 = 1; j2 < steps; ++j2) {
                axisalignedbb = axisalignedbb.c(direction);
                if (this.l.dW().a((Entity)this.l, axisalignedbb)) continue;
                return false;
            }
            return true;
        }
    }

    private static class PathfinderGoalGhastIdleMove
    extends PathfinderGoal {
        private final EntityGhast a;

        public PathfinderGoalGhastIdleMove(EntityGhast ghast) {
            this.a = ghast;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            double d2;
            double d1;
            ControllerMove controllermove = this.a.I();
            if (!controllermove.b()) {
                return true;
            }
            double d0 = controllermove.d() - this.a.dB();
            double d3 = d0 * d0 + (d1 = controllermove.e() - this.a.dD()) * d1 + (d2 = controllermove.f() - this.a.dH()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public void d() {
            RandomSource randomsource = this.a.dZ();
            double d0 = this.a.dB() + (double)((randomsource.i() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.a.dD() + (double)((randomsource.i() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.a.dH() + (double)((randomsource.i() * 2.0f - 1.0f) * 16.0f);
            this.a.I().a(d0, d1, d2, 1.0);
        }
    }

    private static class PathfinderGoalGhastMoveTowardsTarget
    extends PathfinderGoal {
        private final EntityGhast a;

        public PathfinderGoalGhastMoveTowardsTarget(EntityGhast ghast) {
            this.a = ghast;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return true;
        }

        @Override
        public boolean V_() {
            return true;
        }

        @Override
        public void a() {
            if (this.a.O_() == null) {
                Vec3D vec3d = this.a.dz();
                this.a.v(-((float)MathHelper.d(vec3d.d, vec3d.f)) * 57.295776f);
                this.a.aX = this.a.dM();
            } else {
                EntityLiving entityliving = this.a.O_();
                double d0 = 64.0;
                if (entityliving.g((Entity)this.a) < 4096.0) {
                    double d1 = entityliving.dB() - this.a.dB();
                    double d2 = entityliving.dH() - this.a.dH();
                    this.a.v(-((float)MathHelper.d(d1, d2)) * 57.295776f);
                    this.a.aX = this.a.dM();
                }
            }
        }
    }

    private static class PathfinderGoalGhastAttackTarget
    extends PathfinderGoal {
        private final EntityGhast b;
        public int a;

        public PathfinderGoalGhastAttackTarget(EntityGhast ghast) {
            this.b = ghast;
        }

        @Override
        public boolean b() {
            return this.b.O_() != null;
        }

        @Override
        public void d() {
            this.a = 0;
        }

        @Override
        public void e() {
            this.b.x(false);
        }

        @Override
        public boolean V_() {
            return true;
        }

        @Override
        public void a() {
            EntityLiving entityliving = this.b.O_();
            if (entityliving != null) {
                double d0 = 64.0;
                if (entityliving.g((Entity)this.b) < 4096.0 && this.b.E(entityliving)) {
                    World world = this.b.dW();
                    ++this.a;
                    if (this.a == 10 && !this.b.bb()) {
                        world.a((EntityHuman)null, 1015, this.b.dw(), 0);
                    }
                    if (this.a == 20) {
                        double d1 = 4.0;
                        Vec3D vec3d = this.b.g(1.0f);
                        double d2 = entityliving.dB() - (this.b.dB() + vec3d.d * 4.0);
                        double d3 = entityliving.e(0.5) - (0.5 + this.b.e(0.5));
                        double d4 = entityliving.dH() - (this.b.dH() + vec3d.f * 4.0);
                        Vec3D vec3d1 = new Vec3D(d2, d3, d4);
                        if (!this.b.bb()) {
                            world.a((EntityHuman)null, 1016, this.b.dw(), 0);
                        }
                        EntityLargeFireball entitylargefireball = new EntityLargeFireball(world, (EntityLiving)this.b, vec3d1.d(), this.b.p());
                        entitylargefireball.d = this.b.p();
                        entitylargefireball.bukkitYield = entitylargefireball.d;
                        entitylargefireball.a_(this.b.dB() + vec3d.d * 4.0, this.b.e(0.5) + 0.5, entitylargefireball.dH() + vec3d.f * 4.0);
                        world.b(entitylargefireball);
                        this.a = -40;
                    }
                } else if (this.a > 0) {
                    --this.a;
                }
                this.b.x(this.a > 10);
            }
        }
    }
}

