/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.dimension.DimensionManager;

public abstract class EntityMonster
extends EntityCreature
implements IMonster {
    protected EntityMonster(EntityTypes<? extends EntityMonster> type, World world) {
        super((EntityTypes<? extends EntityCreature>)type, world);
        this.bO = 5;
    }

    @Override
    public SoundCategory dn() {
        return SoundCategory.f;
    }

    @Override
    public void d_() {
        this.eX();
        this.gs();
        super.d_();
    }

    protected void gs() {
        float f2 = this.by();
        if (f2 > 0.5f) {
            this.bf += 2;
        }
    }

    @Override
    protected boolean X() {
        return true;
    }

    @Override
    protected SoundEffect aV() {
        return SoundEffects.nq;
    }

    @Override
    protected SoundEffect aW() {
        return SoundEffects.np;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.nn;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.nm;
    }

    @Override
    public EntityLiving.a eM() {
        return new EntityLiving.a(SoundEffects.no, SoundEffects.nl);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return -world.w(pos);
    }

    public static boolean a(WorldAccess world, BlockPosition pos, RandomSource random) {
        if (world.a(EnumSkyBlock.a, pos) > random.a(32)) {
            return false;
        }
        DimensionManager dimensionType = world.G_();
        int i2 = world.a().paperConfig().entities.spawning.monsterSpawnMaxLightLevel.or(dimensionType.e());
        if (i2 < 15 && world.a(EnumSkyBlock.b, pos) > i2) {
            return false;
        }
        int j2 = world.a().ae() ? world.c(pos, 10) : world.A(pos);
        return j2 <= dimensionType.d().a(random);
    }

    public static boolean b(EntityTypes<? extends EntityMonster> type, WorldAccess world, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return world.al() != EnumDifficulty.a && (EntitySpawnReason.b(spawnReason) || EntityMonster.a(world, pos, random)) && EntityMonster.a(type, world, spawnReason, pos, random);
    }

    public static boolean c(EntityTypes<? extends EntityMonster> type, GeneratorAccess world, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return world.al() != EnumDifficulty.a && EntityMonster.a(type, world, spawnReason, pos, random);
    }

    public static AttributeProvider.Builder gt() {
        return EntityInsentient.C().a(GenericAttributes.c);
    }

    @Override
    public boolean en() {
        return true;
    }

    @Override
    protected boolean eo() {
        return true;
    }

    public boolean a(WorldServer world, EntityHuman player) {
        return true;
    }

    @Override
    public ItemStack d(ItemStack stack) {
        if (stack.h() instanceof ItemProjectileWeapon) {
            Predicate<ItemStack> predicate = ((ItemProjectileWeapon)stack.h()).d();
            ItemStack itemStack = ItemProjectileWeapon.a(this, predicate);
            return itemStack.f() ? new ItemStack(Items.oS) : itemStack;
        }
        return ItemStack.j;
    }
}

