/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityFlying;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityPhantom
extends EntityFlying
implements IMonster {
    public static final float a = 7.448451f;
    public static final int b = MathHelper.f(24.166098f);
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityPhantom.class, DataWatcherRegistry.b);
    Vec3D d = Vec3D.c;
    public BlockPosition bY = BlockPosition.c;
    AttackPhase bZ = AttackPhase.a;
    @Nullable
    UUID spawningEntity;
    private boolean shouldBurnInDay = true;

    public EntityPhantom(EntityTypes<? extends EntityPhantom> type, World world) {
        super((EntityTypes<? extends EntityFlying>)type, world);
        this.bO = 5;
        this.bQ = new g(this);
        this.bP = new f(this, this, this);
    }

    @Override
    public boolean ba() {
        return (this.p() + this.af) % b == 0;
    }

    @Override
    protected EntityAIBodyControl G() {
        return new d(this);
    }

    @Override
    protected void B() {
        this.bT.a(1, new c());
        this.bT.a(2, new i());
        this.bT.a(3, new e());
        this.bU.a(1, new b());
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, 0);
    }

    public void b(int size) {
        this.al.a(c, MathHelper.a(size, 0, 64));
    }

    private void t() {
        this.m_();
        this.g(GenericAttributes.c).a(6 + this.m());
    }

    public int m() {
        return this.al.a(c);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (c.equals(data)) {
            this.t();
        }
        super.a(data);
    }

    public int p() {
        return this.ar() * 3;
    }

    @Override
    protected boolean X() {
        return true;
    }

    @Override
    public void h() {
        super.h();
        if (this.dW().C) {
            float f2 = MathHelper.b((float)(this.p() + this.af) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI);
            float f1 = MathHelper.b((float)(this.p() + this.af + 1) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI);
            if (f2 > 0.0f && f1 <= 0.0f) {
                this.dW().a(this.dB(), this.dD(), this.dH(), SoundEffects.tR, this.dn(), 0.95f + this.ae.i() * 0.05f, 0.95f + this.ae.i() * 0.05f, false);
            }
            float f22 = this.dr() * 1.48f;
            float f3 = MathHelper.b(this.dM() * ((float)Math.PI / 180)) * f22;
            float f4 = MathHelper.a(this.dM() * ((float)Math.PI / 180)) * f22;
            float f5 = (0.3f + f2 * 0.45f) * this.ds() * 2.5f;
            this.dW().a(Particles.aa, this.dB() + (double)f3, this.dD() + (double)f5, this.dH() + (double)f4, 0.0, 0.0, 0.0);
            this.dW().a(Particles.aa, this.dB() - (double)f3, this.dD() + (double)f5, this.dH() - (double)f4, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void d_() {
        if (this.bL() && this.shouldBurnInDay && this.gg()) {
            this.d(8.0f);
        }
        super.d_();
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        this.bY = this.dw().b(5);
        this.b(0);
        return super.a(world, difficulty, spawnReason, entityData);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.e("AX")) {
            this.bY = new BlockPosition(nbt.h("AX"), nbt.h("AY"), nbt.h("AZ"));
        }
        this.b(nbt.h("Size"));
        if (nbt.b("Paper.SpawningEntity")) {
            this.spawningEntity = nbt.a("Paper.SpawningEntity");
        }
        if (nbt.e("Paper.ShouldBurnInDay")) {
            this.shouldBurnInDay = nbt.q("Paper.ShouldBurnInDay");
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("AX", this.bY.u());
        nbt.a("AY", this.bY.v());
        nbt.a("AZ", this.bY.w());
        nbt.a("Size", this.m());
        if (this.spawningEntity != null) {
            nbt.a("Paper.SpawningEntity", this.spawningEntity);
        }
        nbt.a("Paper.ShouldBurnInDay", this.shouldBurnInDay);
    }

    @Override
    public boolean a(double distance) {
        return true;
    }

    @Override
    public SoundCategory dn() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.tO;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.tS;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.tQ;
    }

    @Override
    public float fg() {
        return 1.0f;
    }

    @Override
    public boolean a(EntityTypes<?> type) {
        return true;
    }

    @Override
    public EntitySize e(EntityPose pose) {
        int i2 = this.m();
        EntitySize entitysize = super.e(pose);
        return entitysize.a(1.0f + 0.15f * (float)i2);
    }

    boolean a(WorldServer world, EntityLiving target, PathfinderTargetCondition predicate) {
        return predicate.a(world, this, target);
    }

    @Nullable
    public UUID getSpawningEntity() {
        return this.spawningEntity;
    }

    public void setSpawningEntity(UUID entity) {
        this.spawningEntity = entity;
    }

    public boolean shouldBurnInDay() {
        return this.shouldBurnInDay;
    }

    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.shouldBurnInDay = shouldBurnInDay;
    }

    private static enum AttackPhase {
        a,
        b;

    }

    private class g
    extends ControllerMove {
        private float m;

        public g(EntityInsentient entity) {
            super(entity);
            this.m = 0.1f;
        }

        @Override
        public void a() {
            if (EntityPhantom.this.P) {
                EntityPhantom.this.v(EntityPhantom.this.dM() + 180.0f);
                this.m = 0.1f;
            }
            double d0 = EntityPhantom.this.d.d - EntityPhantom.this.dB();
            double d1 = EntityPhantom.this.d.e - EntityPhantom.this.dD();
            double d2 = EntityPhantom.this.d.f - EntityPhantom.this.dH();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            if (Math.abs(d3) > (double)1.0E-5f) {
                double d4 = 1.0 - Math.abs(d1 * (double)0.7f) / d3;
                d3 = Math.sqrt((d0 *= d4) * d0 + (d2 *= d4) * d2);
                double d5 = Math.sqrt(d0 * d0 + d2 * d2 + d1 * d1);
                float f2 = EntityPhantom.this.dM();
                float f1 = (float)MathHelper.d(d2, d0);
                float f22 = MathHelper.h(EntityPhantom.this.dM() + 90.0f);
                float f3 = MathHelper.h(f1 * 57.295776f);
                EntityPhantom.this.v(MathHelper.e(f22, f3, 4.0f) - 90.0f);
                EntityPhantom.this.aX = EntityPhantom.this.dM();
                this.m = MathHelper.d(f2, EntityPhantom.this.dM()) < 3.0f ? MathHelper.d(this.m, 1.8f, 0.005f * (1.8f / this.m)) : MathHelper.d(this.m, 0.2f, 0.025f);
                float f4 = (float)(-(MathHelper.d(-d1, d3) * 57.2957763671875));
                EntityPhantom.this.w(f4);
                float f5 = EntityPhantom.this.dM() + 90.0f;
                double d6 = (double)(this.m * MathHelper.b(f5 * ((float)Math.PI / 180))) * Math.abs(d0 / d5);
                double d7 = (double)(this.m * MathHelper.a(f5 * ((float)Math.PI / 180))) * Math.abs(d2 / d5);
                double d8 = (double)(this.m * MathHelper.a(f4 * ((float)Math.PI / 180))) * Math.abs(d1 / d5);
                Vec3D vec3d = EntityPhantom.this.dz();
                EntityPhantom.this.h(vec3d.e(new Vec3D(d6, d8, d7).d(vec3d).c(0.2)));
            }
        }
    }

    private class f
    extends ControllerLook {
        public f(EntityPhantom entityPhantom, EntityPhantom entity, EntityInsentient phantom) {
            super(phantom);
        }

        @Override
        public void a() {
        }
    }

    private class d
    extends EntityAIBodyControl {
        public d(EntityInsentient entity) {
            super(entity);
        }

        @Override
        public void a() {
            EntityPhantom.this.aZ = EntityPhantom.this.aX;
            EntityPhantom.this.aX = EntityPhantom.this.dM();
        }
    }

    private class c
    extends PathfinderGoal {
        private int b;

        c() {
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = EntityPhantom.this.O_();
            return entityliving != null ? EntityPhantom.this.a(net.minecraft.world.entity.monster.EntityPhantom$c.a(EntityPhantom.this.dW()), entityliving, PathfinderTargetCondition.a) : false;
        }

        @Override
        public void d() {
            this.b = this.a(10);
            EntityPhantom.this.bZ = AttackPhase.a;
            this.h();
        }

        @Override
        public void e() {
            EntityPhantom.this.bY = EntityPhantom.this.dW().a(HeightMap.Type.e, EntityPhantom.this.bY).b(10 + EntityPhantom.this.ae.a(20));
        }

        @Override
        public void a() {
            if (EntityPhantom.this.bZ == AttackPhase.a) {
                --this.b;
                if (this.b <= 0) {
                    EntityPhantom.this.bZ = AttackPhase.b;
                    this.h();
                    this.b = this.a((8 + EntityPhantom.this.ae.a(4)) * 20);
                    EntityPhantom.this.a(SoundEffects.tT, 10.0f, 0.95f + EntityPhantom.this.ae.i() * 0.1f);
                }
            }
        }

        private void h() {
            EntityPhantom.this.bY = EntityPhantom.this.O_().dw().b(20 + EntityPhantom.this.ae.a(20));
            if (EntityPhantom.this.bY.v() < EntityPhantom.this.dW().O()) {
                EntityPhantom.this.bY = new BlockPosition(EntityPhantom.this.bY.u(), EntityPhantom.this.dW().O() + 1, EntityPhantom.this.bY.w());
            }
        }
    }

    private class i
    extends h {
        private static final int c = 20;
        private boolean d;
        private int e;

        i() {
        }

        @Override
        public boolean b() {
            return EntityPhantom.this.O_() != null && EntityPhantom.this.bZ == AttackPhase.b;
        }

        @Override
        public boolean c() {
            EntityLiving entityliving = EntityPhantom.this.O_();
            if (entityliving == null) {
                return false;
            }
            if (!entityliving.bL()) {
                return false;
            }
            if (entityliving instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)entityliving;
                if (entityliving.aa_() || entityhuman.b()) {
                    return false;
                }
            }
            if (!this.b()) {
                return false;
            }
            if (EntityPhantom.this.af > this.e) {
                this.e = EntityPhantom.this.af + 20;
                List<Entity> list = EntityPhantom.this.dW().a(EntityCat.class, EntityPhantom.this.cR().g(16.0), IEntitySelector.a);
                for (EntityCat entityCat : list) {
                    entityCat.gD();
                }
                this.d = !list.isEmpty();
            }
            return !this.d;
        }

        @Override
        public void d() {
        }

        @Override
        public void e() {
            EntityPhantom.this.h((EntityLiving)null);
            EntityPhantom.this.bZ = AttackPhase.a;
        }

        @Override
        public void a() {
            EntityLiving entityliving = EntityPhantom.this.O_();
            if (entityliving != null) {
                EntityPhantom.this.d = new Vec3D(entityliving.dB(), entityliving.e(0.5), entityliving.dH());
                if (EntityPhantom.this.cR().g(0.2f).c(entityliving.cR())) {
                    EntityPhantom.this.c(net.minecraft.world.entity.monster.EntityPhantom$i.a(EntityPhantom.this.dW()), (Entity)entityliving);
                    EntityPhantom.this.bZ = AttackPhase.a;
                    if (!EntityPhantom.this.bb()) {
                        EntityPhantom.this.dW().c(1039, EntityPhantom.this.dw(), 0);
                    }
                } else if (EntityPhantom.this.P || EntityPhantom.this.aN > 0) {
                    EntityPhantom.this.bZ = AttackPhase.a;
                }
            }
        }
    }

    private class e
    extends h {
        private float c;
        private float d;
        private float e;
        private float f;

        e() {
        }

        @Override
        public boolean b() {
            return EntityPhantom.this.O_() == null || EntityPhantom.this.bZ == AttackPhase.a;
        }

        @Override
        public void d() {
            this.d = 5.0f + EntityPhantom.this.ae.i() * 10.0f;
            this.e = -4.0f + EntityPhantom.this.ae.i() * 9.0f;
            this.f = EntityPhantom.this.ae.h() ? 1.0f : -1.0f;
            this.i();
        }

        @Override
        public void a() {
            if (EntityPhantom.this.ae.a(this.a(350)) == 0) {
                this.e = -4.0f + EntityPhantom.this.ae.i() * 9.0f;
            }
            if (EntityPhantom.this.ae.a(this.a(250)) == 0) {
                this.d += 1.0f;
                if (this.d > 15.0f) {
                    this.d = 5.0f;
                    this.f = -this.f;
                }
            }
            if (EntityPhantom.this.ae.a(this.a(450)) == 0) {
                this.c = EntityPhantom.this.ae.i() * 2.0f * (float)Math.PI;
                this.i();
            }
            if (this.h()) {
                this.i();
            }
            if (EntityPhantom.this.d.e < EntityPhantom.this.dD() && !EntityPhantom.this.dW().u(EntityPhantom.this.dw().c(1))) {
                this.e = Math.max(1.0f, this.e);
                this.i();
            }
            if (EntityPhantom.this.d.e > EntityPhantom.this.dD() && !EntityPhantom.this.dW().u(EntityPhantom.this.dw().b(1))) {
                this.e = Math.min(-1.0f, this.e);
                this.i();
            }
        }

        private void i() {
            if (BlockPosition.c.equals(EntityPhantom.this.bY)) {
                EntityPhantom.this.bY = EntityPhantom.this.dw();
            }
            this.c += this.f * 15.0f * ((float)Math.PI / 180);
            EntityPhantom.this.d = Vec3D.a(EntityPhantom.this.bY).b(this.d * MathHelper.b(this.c), -4.0f + this.e, this.d * MathHelper.a(this.c));
        }
    }

    private class b
    extends PathfinderGoal {
        private final PathfinderTargetCondition b = PathfinderTargetCondition.a().a(64.0);
        private int c = net.minecraft.world.entity.monster.EntityPhantom$b.b(20);

        b() {
        }

        @Override
        public boolean b() {
            if (this.c > 0) {
                --this.c;
                return false;
            }
            this.c = net.minecraft.world.entity.monster.EntityPhantom$b.b(60);
            WorldServer worldserver = net.minecraft.world.entity.monster.EntityPhantom$b.a(EntityPhantom.this.dW());
            List<EntityHuman> list = worldserver.a(this.b, EntityPhantom.this, EntityPhantom.this.cR().c(16.0, 64.0, 16.0));
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(e2 -> e2.dD()).reversed());
                for (EntityHuman entityhuman : list) {
                    if (!EntityPhantom.this.a(worldserver, entityhuman, PathfinderTargetCondition.a)) continue;
                    if (!EntityPhantom.this.dW().paperConfig().entities.behavior.phantomsOnlyAttackInsomniacs || IEntitySelector.IS_INSOMNIAC.test(entityhuman)) {
                        EntityPhantom.this.setTarget(entityhuman, EntityTargetEvent.TargetReason.CLOSEST_PLAYER, true);
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean c() {
            EntityLiving entityliving = EntityPhantom.this.O_();
            return entityliving != null ? EntityPhantom.this.a(net.minecraft.world.entity.monster.EntityPhantom$b.a(EntityPhantom.this.dW()), entityliving, PathfinderTargetCondition.a) : false;
        }
    }

    private abstract class h
    extends PathfinderGoal {
        public h() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        protected boolean h() {
            return EntityPhantom.this.d.c(EntityPhantom.this.dB(), EntityPhantom.this.dD(), EntityPhantom.this.dH()) < 4.0;
        }
    }
}

