/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalCrossbowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemBanner;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityPillager
extends EntityIllagerAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityPillager.class, DataWatcherRegistry.k);
    private static final int b = 5;
    private static final int bZ = 300;
    public final InventorySubcontainer ca = new InventorySubcontainer(5);

    public EntityPillager(EntityTypes<? extends EntityPillager> type, World world) {
        super((EntityTypes<? extends EntityIllagerAbstract>)type, world);
    }

    @Override
    protected void B() {
        super.B();
        this.bT.a(0, new PathfinderGoalFloat(this));
        this.bT.a(1, new PathfinderGoalAvoidTarget<Creaking>(this, Creaking.class, 8.0f, 1.0, 1.2));
        this.bT.a(2, new EntityRaider.a(this, this, 10.0f));
        this.bT.a(3, new PathfinderGoalCrossbowAttack<EntityPillager>(this, 1.0, 8.0f));
        this.bT.a(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.bT.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 15.0f, 1.0f));
        this.bT.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 15.0f));
        this.bU.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bU.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bU.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        this.bU.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gt().a(GenericAttributes.v, 0.35f).a(GenericAttributes.s, 24.0).a(GenericAttributes.c, 5.0).a(GenericAttributes.m, 32.0);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, false);
    }

    @Override
    public boolean a(ItemProjectileWeapon weapon) {
        return weapon == Items.wL;
    }

    public boolean x() {
        return this.al.a(a);
    }

    @Override
    public void b(boolean charging) {
        this.al.a(a, charging);
    }

    @Override
    public void a() {
        this.bf = 0;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.b(nbt, this.dY());
    }

    @Override
    public EntityIllagerAbstract.a m() {
        return this.x() ? EntityIllagerAbstract.a.f : (this.b(Items.wL) ? EntityIllagerAbstract.a.e : (this.gd() ? EntityIllagerAbstract.a.b : EntityIllagerAbstract.a.h));
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(nbt, this.dY());
        this.a_(true);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return 0.0f;
    }

    @Override
    public int ad() {
        return 1;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        RandomSource randomsource = world.H_();
        this.a(randomsource, difficulty);
        this.a(world, randomsource, difficulty);
        return super.a(world, difficulty, spawnReason, entityData);
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        this.a(EnumItemSlot.a, new ItemStack(Items.wL));
    }

    @Override
    protected void b(WorldAccess world, RandomSource random, DifficultyDamageScaler localDifficulty) {
        ItemStack itemstack;
        super.b(world, random, localDifficulty);
        if (random.a(300) == 0 && (itemstack = this.eZ()).a(Items.wL)) {
            EnchantmentManager.a(itemstack, world.K_(), VanillaEnchantmentProviders.b, localDifficulty, random);
        }
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.up;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.ur;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.us;
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        this.b(this, 1.6f);
    }

    @Override
    public InventorySubcontainer t() {
        return this.ca;
    }

    @Override
    protected void a(WorldServer world, EntityItem itemEntity) {
        ItemStack itemstack = itemEntity.l();
        if (itemstack.h() instanceof ItemBanner) {
            super.a(world, itemEntity);
        } else if (this.i(itemstack)) {
            this.a(itemEntity);
            ItemStack itemstack1 = this.ca.b(itemstack);
            if (itemstack1.f()) {
                itemEntity.discard(EntityRemoveEvent.Cause.PICKUP);
            } else {
                itemstack.e(itemstack1.L());
            }
        }
    }

    private boolean i(ItemStack stack) {
        return this.gE() && stack.a(Items.vF);
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        int j2 = mappedIndex - 300;
        return j2 >= 0 && j2 < this.ca.b() ? SlotAccess.a(this.ca, j2) : super.a_(mappedIndex);
    }

    @Override
    public void a(WorldServer world, int wave, boolean unused) {
        boolean flag1;
        Raid raid = this.gB();
        boolean bl = flag1 = this.ae.i() <= raid.v();
        if (flag1) {
            ItemStack itemstack = new ItemStack(Items.wL);
            ResourceKey<EnchantmentProvider> resourcekey = wave > raid.a(EnumDifficulty.c) ? VanillaEnchantmentProviders.d : (wave > raid.a(EnumDifficulty.b) ? VanillaEnchantmentProviders.c : null);
            if (resourcekey != null) {
                EnchantmentManager.a(itemstack, world.K_(), resourcekey, world.d_(this.dw()), this.dZ());
                this.a(EnumItemSlot.a, itemstack);
            }
        }
    }

    @Override
    public SoundEffect ak_() {
        return SoundEffects.uq;
    }
}

