/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;

public class EntityRavager
extends EntityRaider {
    private static final Predicate<Entity> bZ = entity -> !(entity instanceof EntityRavager) && entity.bL();
    private static final Predicate<Entity> ca = entity -> bZ.test((Entity)entity) && !entity.aq().equals(EntityTypes.f);
    private static final Predicate<EntityLiving> cb = entityliving -> !(entityliving instanceof EntityRavager) && entityliving.bL() && entityliving.di();
    private static final double cc = 0.3;
    private static final double cd = 0.35;
    private static final int ce = 8356754;
    private static final float cf = 0.57254905f;
    private static final float cg = 0.5137255f;
    private static final float ch = 0.49803922f;
    public static final int a = 10;
    public static final int b = 40;
    public int ci;
    public int cj;
    public int ck;

    public EntityRavager(EntityTypes<? extends EntityRavager> type, World world) {
        super((EntityTypes<? extends EntityRaider>)type, world);
        this.bO = 20;
        this.a(PathType.v, 0.0f);
    }

    @Override
    protected void B() {
        super.B();
        this.bT.a(0, new PathfinderGoalFloat(this));
        this.bT.a(3, new PathfinderGoalAvoidTarget<Creaking>(this, Creaking.class, 8.0f, 1.0, 1.2));
        this.bT.a(4, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.bT.a(5, new PathfinderGoalRandomStrollLand(this, 0.4));
        this.bT.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bT.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.bU.a(2, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bU.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bU.a(4, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, true, (entityliving, worldserver) -> !entityliving.e_()));
        this.bU.a(4, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    protected void T() {
        boolean flag = !(this.cX() instanceof EntityInsentient) || this.cX().aq().a(TagsEntity.c);
        boolean flag1 = !(this.dl() instanceof AbstractBoat);
        this.bT.a(PathfinderGoal.Type.a, flag);
        this.bT.a(PathfinderGoal.Type.c, flag && flag1);
        this.bT.a(PathfinderGoal.Type.b, flag);
        this.bT.a(PathfinderGoal.Type.d, flag);
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gt().a(GenericAttributes.s, 100.0).a(GenericAttributes.v, 0.3).a(GenericAttributes.p, 0.75).a(GenericAttributes.c, 12.0).a(GenericAttributes.d, 1.5).a(GenericAttributes.m, 32.0).a(GenericAttributes.B, 1.0);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("AttackTick", this.ci);
        nbt.a("StunTick", this.cj);
        nbt.a("RoarTick", this.ck);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.ci = nbt.h("AttackTick");
        this.cj = nbt.h("StunTick");
        this.ck = nbt.h("RoarTick");
    }

    @Override
    public SoundEffect ak_() {
        return SoundEffects.vz;
    }

    @Override
    public int aa() {
        return 45;
    }

    @Override
    public void d_() {
        super.d_();
        if (this.bL()) {
            if (this.fi()) {
                this.g(GenericAttributes.v).a(0.0);
            } else {
                double d0 = this.O_() != null ? 0.35 : 0.3;
                double d1 = this.g(GenericAttributes.v).b();
                this.g(GenericAttributes.v).a(MathHelper.d(0.1, d1, d0));
            }
            World world = this.dW();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (this.P && worldserver.N().b(GameRules.c)) {
                    boolean flag = false;
                    AxisAlignedBB axisalignedbb = this.cR().g(0.2);
                    for (BlockPosition blockposition : BlockPosition.b(MathHelper.a(axisalignedbb.a), MathHelper.a(axisalignedbb.b), MathHelper.a(axisalignedbb.c), MathHelper.a(axisalignedbb.d), MathHelper.a(axisalignedbb.e), MathHelper.a(axisalignedbb.f))) {
                        IBlockData iblockdata = worldserver.a_(blockposition);
                        Block block = iblockdata.b();
                        if (!(block instanceof BlockLeaves) || !CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, iblockdata.y().g())) continue;
                        flag = worldserver.a(blockposition, true, this) || flag;
                    }
                    if (!flag && this.aJ()) {
                        if (new EntityJumpEvent((LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                            this.s();
                        } else {
                            this.t(false);
                        }
                    }
                }
            }
            if (this.ck > 0) {
                --this.ck;
                if (this.ck == 10) {
                    this.gz();
                }
            }
            if (this.ci > 0) {
                --this.ci;
            }
            if (this.cj > 0) {
                --this.cj;
                this.gy();
                if (this.cj == 0) {
                    this.a(SoundEffects.vE, 1.0f, 1.0f);
                    this.ck = 20;
                }
            }
        }
    }

    private void gy() {
        if (this.ae.a(6) == 0) {
            double d0 = this.dB() - (double)this.dr() * Math.sin(this.aX * ((float)Math.PI / 180)) + (this.ae.j() * 0.6 - 0.3);
            double d1 = this.dD() + (double)this.ds() - 0.3;
            double d2 = this.dH() + (double)this.dr() * Math.cos(this.aX * ((float)Math.PI / 180)) + (this.ae.j() * 0.6 - 0.3);
            this.dW().a(ColorParticleOption.a(Particles.u, 0.49803922f, 0.5137255f, 0.57254905f), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected boolean fi() {
        return super.fi() || this.ci > 0 || this.cj > 0 || this.ck > 0;
    }

    @Override
    public boolean E(Entity entity) {
        return this.cj <= 0 && this.ck <= 0 ? super.E(entity) : false;
    }

    @Override
    protected void e(EntityLiving target) {
        if (this.ck == 0) {
            if (this.ae.j() < 0.5) {
                this.cj = 40;
                this.a(SoundEffects.vD, 1.0f, 1.0f);
                this.dW().a((Entity)this, (byte)39);
                target.h(this);
            } else {
                this.b((Entity)target);
            }
            target.T = true;
        }
    }

    private void gz() {
        if (this.bL()) {
            World world = this.dW();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                Predicate<Entity> predicate = worldserver.N().b(GameRules.c) ? bZ : ca;
                List<Entity> list = this.dW().a(EntityLiving.class, this.cR().g(4.0), predicate);
                for (EntityLiving entityLiving : list) {
                    if (!(entityLiving instanceof EntityIllagerAbstract)) {
                        entityLiving.a(worldserver, this.dX().b(this), 6.0f);
                    }
                    if (entityLiving instanceof EntityHuman) continue;
                    this.b((Entity)entityLiving);
                }
                ((Entity)this).a(GameEvent.u);
            } else {
                List<EntityLiving> list1 = this.dW().a(EntityLiving.class, this.cR().g(4.0), cb);
                for (EntityLiving entityliving1 : list1) {
                    this.b((Entity)entityliving1);
                }
                Vec3D vec3d = this.cR().f();
                for (int i2 = 0; i2 < 40; ++i2) {
                    double d2 = this.ae.k() * 0.2;
                    double d1 = this.ae.k() * 0.2;
                    double d22 = this.ae.k() * 0.2;
                    this.dW().a(Particles.ac, vec3d.d, vec3d.e, vec3d.f, d2, d1, d22);
                }
            }
        }
    }

    private void b(Entity entity) {
        double d0 = entity.dB() - this.dB();
        double d1 = entity.dH() - this.dH();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        entity.push(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0, this);
    }

    @Override
    public void b(byte status) {
        if (status == 4) {
            this.ci = 10;
            this.a(SoundEffects.vy, 1.0f, 1.0f);
        } else if (status == 39) {
            this.cj = 40;
        }
        super.b(status);
    }

    public int p() {
        return this.ci;
    }

    public int x() {
        return this.cj;
    }

    public int gx() {
        return this.ck;
    }

    @Override
    public boolean c(WorldServer world, Entity target) {
        this.ci = 10;
        world.a((Entity)this, (byte)4);
        this.a(SoundEffects.vy, 1.0f, 1.0f);
        return super.c(world, target);
    }

    @Override
    @Nullable
    protected SoundEffect u() {
        return SoundEffects.vx;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.vB;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.vA;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.vC, 0.15f, 1.0f);
    }

    @Override
    public boolean a(IWorldReader world) {
        return !world.d(this.cR());
    }

    @Override
    public void a(WorldServer world, int wave, boolean unused) {
    }

    @Override
    public boolean go() {
        return false;
    }

    @Override
    protected AxisAlignedBB ge() {
        AxisAlignedBB axisalignedbb = super.ge();
        return axisalignedbb.f(0.05, 0.0, 0.05);
    }
}

