/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import io.papermc.paper.event.entity.ShulkerDuplicateEvent;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftLocation;
import org.bukkit.entity.Shulker;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class EntityShulker
extends EntityGolem
implements VariantHolder<Optional<EnumColor>>,
IMonster {
    private static final MinecraftKey d = MinecraftKey.b("covered");
    private static final AttributeModifier bZ = new AttributeModifier(d, 20.0, AttributeModifier.Operation.a);
    protected static final DataWatcherObject<EnumDirection> a = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.q);
    protected static final DataWatcherObject<Byte> b = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Byte> c = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.a);
    private static final int ca = 6;
    private static final byte cb = 16;
    private static final byte cc = 16;
    private static final int cd = 8;
    private static final int ce = 8;
    private static final int cf = 5;
    private static final float cg = 0.05f;
    static final Vector3f ch = SystemUtils.a(() -> {
        BaseBlockPosition baseblockposition = EnumDirection.d.q();
        return new Vector3f((float)baseblockposition.u(), (float)baseblockposition.v(), (float)baseblockposition.w());
    });
    private static final float ci = 3.0f;
    private float cj;
    private float ck;
    @Nullable
    private BlockPosition cl;
    private int cm;
    private static final float cn = 1.0f;

    public EntityShulker(EntityTypes<? extends EntityShulker> type, World world) {
        super((EntityTypes<? extends EntityGolem>)type, world);
        this.bO = 5;
        this.bP = new d(this);
    }

    @Override
    protected void B() {
        this.bT.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f, 0.02f, true));
        this.bT.a(4, new a());
        this.bT.a(7, new f());
        this.bT.a(8, new PathfinderGoalRandomLookaround(this));
        this.bU.a(1, new PathfinderGoalHurtByTarget(this, this.getClass()).a(new Class[0]));
        this.bU.a(2, new e(this));
        this.bU.a(3, new c(this));
    }

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.a;
    }

    @Override
    public SoundCategory dn() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.xf;
    }

    @Override
    public void R() {
        if (!this.gs()) {
            super.R();
        }
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.xl;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return this.gs() ? SoundEffects.xn : SoundEffects.xm;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, EnumDirection.a);
        builder.a(b, (byte)0);
        builder.a(c, (byte)16);
    }

    public static AttributeProvider.Builder m() {
        return EntityInsentient.C().a(GenericAttributes.s, 30.0);
    }

    @Override
    protected EntityAIBodyControl G() {
        return new b(this);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(EnumDirection.a(nbt.f("AttachFace")));
        this.al.a(b, nbt.f("Peek"));
        if (nbt.b("Color", 99)) {
            this.al.a(c, nbt.f("Color"));
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("AttachFace", (byte)this.t().d());
        nbt.a("Peek", this.al.a(b));
        nbt.a("Color", this.al.a(c));
    }

    @Override
    public void h() {
        super.h();
        if (!(this.dW().C || this.bZ() || this.a(this.dw(), this.t()))) {
            this.gp();
        }
        if (this.gq()) {
            this.gr();
        }
        if (this.dW().C) {
            if (this.cm > 0) {
                --this.cm;
            } else {
                this.cl = null;
            }
        }
    }

    private void gp() {
        EnumDirection enumdirection = this.h(this.dw());
        if (enumdirection != null) {
            this.a(enumdirection);
        } else {
            this.p();
        }
    }

    @Override
    protected AxisAlignedBB ax() {
        float f2 = EntityShulker.L(this.ck);
        EnumDirection enumdirection = this.t().g();
        float f1 = this.dr() / 2.0f;
        return EntityShulker.a(this.ek(), enumdirection, f2).d(this.dB() - (double)f1, this.dD(), this.dH() - (double)f1);
    }

    private static float L(float openProgress) {
        return 0.5f - MathHelper.a((0.5f + openProgress) * (float)Math.PI) * 0.5f;
    }

    private boolean gq() {
        this.cj = this.ck;
        float f2 = (float)this.gu() * 0.01f;
        if (this.ck == f2) {
            return false;
        }
        this.ck = this.ck > f2 ? MathHelper.a(this.ck - 0.05f, f2, 1.0f) : MathHelper.a(this.ck + 0.05f, 0.0f, f2);
        return true;
    }

    private void gr() {
        this.ay();
        float f2 = EntityShulker.L(this.ck);
        float f1 = EntityShulker.L(this.cj);
        EnumDirection enumdirection = this.t().g();
        float f22 = (f2 - f1) * this.ek();
        if (f22 > 0.0f) {
            List<Entity> list = this.dW().a((Entity)this, EntityShulker.a(this.ek(), enumdirection, f1, f2).d(this.dB() - 0.5, this.dD(), this.dH() - 0.5), IEntitySelector.f.and(entity -> !entity.z(this)));
            for (Entity entity2 : list) {
                if (entity2 instanceof EntityShulker || entity2.ad) continue;
                entity2.a(EnumMoveType.e, new Vec3D(f22 * (float)enumdirection.j(), f22 * (float)enumdirection.k(), f22 * (float)enumdirection.l()));
            }
        }
    }

    public static AxisAlignedBB a(float scale, EnumDirection facing, float extraLength) {
        return EntityShulker.a(scale, facing, -1.0f, extraLength);
    }

    public static AxisAlignedBB a(float scale, EnumDirection facing, float prevExtraLength, float extraLength) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(0.0, 0.0, 0.0, scale, scale, scale);
        double d0 = Math.max(prevExtraLength, extraLength);
        double d1 = Math.min(prevExtraLength, extraLength);
        return axisalignedbb.b((double)facing.j() * d0 * (double)scale, (double)facing.k() * d0 * (double)scale, (double)facing.l() * d0 * (double)scale).a((double)(-facing.j()) * (1.0 + d1) * (double)scale, (double)(-facing.k()) * (1.0 + d1) * (double)scale, (double)(-facing.l()) * (1.0 + d1) * (double)scale);
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        if (this.dW().B_()) {
            this.cl = null;
            this.cm = 0;
        }
        this.a(EnumDirection.a);
        return super.a(entity, force);
    }

    @Override
    public void ae() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        super.stopRiding(suppressCancellation);
        if (this.dW().C) {
            this.cl = this.dw();
        }
        this.aY = 0.0f;
        this.aX = 0.0f;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        this.v(0.0f);
        this.aZ = this.dM();
        this.bz();
        return super.a(world, difficulty, spawnReason, entityData);
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        if (type == EnumMoveType.d) {
            this.p();
        } else {
            super.a(type, movement);
        }
    }

    @Override
    public Vec3D dz() {
        return Vec3D.c;
    }

    @Override
    public void h(Vec3D velocity) {
    }

    @Override
    public void a_(double x2, double y2, double z2) {
        BlockPosition blockposition1;
        BlockPosition blockposition = this.dw();
        if (this.bZ()) {
            super.a_(x2, y2, z2);
        } else {
            super.a_((double)MathHelper.a(x2) + 0.5, MathHelper.a(y2 + 0.5), (double)MathHelper.a(z2) + 0.5);
        }
        if (this.af != 0 && !(blockposition1 = this.dw()).equals(blockposition)) {
            this.al.a(b, (byte)0);
            this.ar = true;
            if (this.dW().C && !this.bZ() && !blockposition1.equals(this.cl)) {
                this.cl = blockposition;
                this.cm = 6;
                this.aa = this.dB();
                this.ab = this.dD();
                this.ac = this.dH();
            }
        }
    }

    @Nullable
    protected EnumDirection h(BlockPosition pos) {
        for (EnumDirection enumdirection : EnumDirection.values()) {
            if (!this.a(pos, enumdirection)) continue;
            return enumdirection;
        }
        return null;
    }

    boolean a(BlockPosition pos, EnumDirection direction) {
        if (this.i(pos)) {
            return false;
        }
        EnumDirection enumdirection1 = direction.g();
        if (!this.dW().a(pos.a(direction), this, enumdirection1)) {
            return false;
        }
        AxisAlignedBB axisalignedbb = EntityShulker.a(this.ek(), enumdirection1, 1.0f).a(pos).h(1.0E-6);
        return this.dW().a((Entity)this, axisalignedbb);
    }

    private boolean i(BlockPosition pos) {
        IBlockData iblockdata = this.dW().a_(pos);
        if (iblockdata.l()) {
            return false;
        }
        boolean flag = iblockdata.a(Blocks.bX) && pos.equals(this.dw());
        return !flag;
    }

    protected boolean p() {
        if (!this.gb() && this.bL()) {
            BlockPosition blockposition = this.dw();
            for (int i2 = 0; i2 < 5; ++i2) {
                EnumDirection enumdirection;
                BlockPosition blockposition1 = blockposition.b(MathHelper.b(this.ae, -8, 8), MathHelper.b(this.ae, -8, 8), MathHelper.b(this.ae, -8, 8));
                if (blockposition1.v() <= this.dW().L_() || !this.dW().u(blockposition1) || !this.dW().F_().a(blockposition1) || !this.dW().a((Entity)this, new AxisAlignedBB(blockposition1).h(1.0E-6)) || (enumdirection = this.h(blockposition1)) == null) continue;
                EntityTeleportEvent teleportEvent = CraftEventFactory.callEntityTeleportEvent(this, blockposition1.u(), blockposition1.v(), blockposition1.w());
                if (teleportEvent.isCancelled() || teleportEvent.getTo() == null) {
                    return false;
                }
                blockposition1 = CraftLocation.toBlockPosition(teleportEvent.getTo());
                this.ao();
                this.a(enumdirection);
                this.a(SoundEffects.xq, 1.0f, 1.0f);
                this.a_((double)blockposition1.u() + 0.5, blockposition1.v(), (double)blockposition1.w() + 0.5);
                this.dW().a(GameEvent.R, blockposition, GameEvent.a.a(this));
                this.al.a(b, (byte)0);
                this.h((EntityLiving)null);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps) {
        this.br = 0;
        this.a_(x2, y2, z2);
        this.b(yaw, pitch);
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        Entity entity;
        if (this.gs() && (entity = source.c()) instanceof EntityArrow) {
            return false;
        }
        if (!super.a(world, source, amount)) {
            return false;
        }
        if ((double)this.eE() < (double)this.eS() * 0.5 && this.ae.a(4) == 0) {
            this.p();
        } else if (source.a(DamageTypeTags.j) && (entity = source.c()) != null && entity.aq() == EntityTypes.bd) {
            this.gt();
        }
        return true;
    }

    private boolean gs() {
        return this.gu() == 0;
    }

    private void gt() {
        Vec3D vec3d = this.du();
        AxisAlignedBB axisalignedbb = this.cR();
        if (!this.gs() && this.p()) {
            EntityShulker entityshulker;
            int i2 = this.dW().a(EntityTypes.bc, axisalignedbb.g(8.0), Entity::bL).size();
            float f2 = (float)(i2 - 1) / 5.0f;
            if (this.dW().A.i() >= f2 && (entityshulker = EntityTypes.bc.a(this.dW(), EntitySpawnReason.e)) != null) {
                entityshulker.a(this.x());
                entityshulker.e(vec3d);
                if (!new ShulkerDuplicateEvent((Shulker)entityshulker.getBukkitEntity(), (Shulker)this.getBukkitEntity()).callEvent()) {
                    return;
                }
                this.dW().addFreshEntity(entityshulker, CreatureSpawnEvent.SpawnReason.BREEDING);
            }
        }
    }

    @Override
    public boolean bN() {
        return this.bL();
    }

    public EnumDirection t() {
        return this.al.a(a);
    }

    @Override
    public void a(EnumDirection face) {
        this.al.a(a, face);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (a.equals(data)) {
            this.a(this.ax());
        }
        super.a(data);
    }

    public int gu() {
        return this.al.a(b).byteValue();
    }

    public void b(int peekAmount) {
        if (!this.dW().C) {
            this.g(GenericAttributes.a).c(d);
            if (peekAmount == 0) {
                this.g(GenericAttributes.a).d(bZ);
                this.a(SoundEffects.xk, 1.0f, 1.0f);
                ((Entity)this).a((Holder<GameEvent>)GameEvent.j);
            } else {
                this.a(SoundEffects.xo, 1.0f, 1.0f);
                ((Entity)this).a((Holder<GameEvent>)GameEvent.k);
            }
        }
        this.al.a(b, (byte)peekAmount);
    }

    public float J(float delta) {
        return MathHelper.h(delta, this.cj, this.ck);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.aX = 0.0f;
        this.aY = 0.0f;
    }

    @Override
    public int Z() {
        return 180;
    }

    @Override
    public int aa() {
        return 180;
    }

    @Override
    public void h(Entity entity) {
    }

    @Nullable
    public Vec3D K(float tickDelta) {
        if (this.cl != null && this.cm > 0) {
            double d0 = (double)((float)this.cm - tickDelta) / 6.0;
            d0 *= d0;
            BlockPosition blockposition = this.dw();
            double d1 = (double)(blockposition.u() - this.cl.u()) * (d0 *= (double)this.ek());
            double d2 = (double)(blockposition.v() - this.cl.v()) * d0;
            double d3 = (double)(blockposition.w() - this.cl.w()) * d0;
            return new Vec3D(-d1, -d2, -d3);
        }
        return null;
    }

    @Override
    protected float b(float scale) {
        return Math.min(scale, 3.0f);
    }

    @Override
    public void a(Optional<EnumColor> variant) {
        this.al.a(c, variant.map(enumcolor -> (byte)enumcolor.a()).orElse((byte)16));
    }

    public Optional<EnumColor> x() {
        return Optional.ofNullable(this.go());
    }

    @Nullable
    public EnumColor go() {
        byte b0 = this.al.a(c);
        return b0 != 16 && b0 <= 15 ? EnumColor.a(b0) : null;
    }

    private class d
    extends ControllerLook {
        public d(EntityInsentient entity) {
            super(entity);
        }

        @Override
        protected void b() {
        }

        @Override
        protected Optional<Float> i() {
            EnumDirection enumdirection = EntityShulker.this.t().g();
            Vector3f vector3f = enumdirection.b().transform(new Vector3f((Vector3fc)ch));
            BaseBlockPosition baseblockposition = enumdirection.q();
            Vector3f vector3f1 = new Vector3f((float)baseblockposition.u(), (float)baseblockposition.v(), (float)baseblockposition.w());
            vector3f1.cross((Vector3fc)vector3f);
            double d0 = this.e - this.a.dB();
            double d1 = this.f - this.a.dF();
            double d2 = this.g - this.a.dH();
            Vector3f vector3f2 = new Vector3f((float)d0, (float)d1, (float)d2);
            float f2 = vector3f1.dot((Vector3fc)vector3f2);
            float f1 = vector3f.dot((Vector3fc)vector3f2);
            return Math.abs(f2) <= 1.0E-5f && Math.abs(f1) <= 1.0E-5f ? Optional.empty() : Optional.of(Float.valueOf((float)(MathHelper.d((double)(-f2), (double)f1) * 57.2957763671875)));
        }

        @Override
        protected Optional<Float> h() {
            return Optional.of(Float.valueOf(0.0f));
        }
    }

    private class a
    extends PathfinderGoal {
        private int b;

        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = EntityShulker.this.O_();
            return entityliving != null && entityliving.bL() ? EntityShulker.this.dW().al() != EnumDifficulty.a : false;
        }

        @Override
        public void d() {
            this.b = 20;
            EntityShulker.this.b(100);
        }

        @Override
        public void e() {
            EntityShulker.this.b(0);
        }

        @Override
        public boolean V_() {
            return true;
        }

        @Override
        public void a() {
            if (EntityShulker.this.dW().al() != EnumDifficulty.a) {
                --this.b;
                EntityLiving entityliving = EntityShulker.this.O_();
                if (entityliving != null) {
                    EntityShulker.this.H().a(entityliving, 180.0f, 180.0f);
                    double d0 = EntityShulker.this.g((Entity)entityliving);
                    if (d0 < 400.0) {
                        if (this.b <= 0) {
                            this.b = 20 + EntityShulker.this.ae.a(10) * 20 / 2;
                            EntityShulker.this.dW().b(new EntityShulkerBullet(EntityShulker.this.dW(), EntityShulker.this, entityliving, EntityShulker.this.t().o()));
                            EntityShulker.this.a(SoundEffects.xp, 2.0f, (EntityShulker.this.ae.i() - EntityShulker.this.ae.i()) * 0.2f + 1.0f);
                        }
                    } else {
                        EntityShulker.this.h((EntityLiving)null);
                    }
                    super.a();
                }
            }
        }
    }

    private class f
    extends PathfinderGoal {
        private int b;

        f() {
        }

        @Override
        public boolean b() {
            return EntityShulker.this.O_() == null && EntityShulker.this.ae.a(f.b(40)) == 0 && EntityShulker.this.a(EntityShulker.this.dw(), EntityShulker.this.t());
        }

        @Override
        public boolean c() {
            return EntityShulker.this.O_() == null && this.b > 0;
        }

        @Override
        public void d() {
            this.b = this.a(20 * (1 + EntityShulker.this.ae.a(3)));
            EntityShulker.this.b(30);
        }

        @Override
        public void e() {
            if (EntityShulker.this.O_() == null) {
                EntityShulker.this.b(0);
            }
        }

        @Override
        public void a() {
            --this.b;
        }
    }

    private class e
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public e(EntityShulker entityshulker) {
            super((EntityInsentient)entityshulker, EntityHuman.class, true);
        }

        @Override
        public boolean b() {
            return EntityShulker.this.dW().al() == EnumDifficulty.a ? false : super.b();
        }

        @Override
        protected AxisAlignedBB a(double distance) {
            EnumDirection enumdirection = ((EntityShulker)this.e).t();
            return enumdirection.o() == EnumDirection.EnumAxis.a ? this.e.cR().c(4.0, distance, distance) : (enumdirection.o() == EnumDirection.EnumAxis.c ? this.e.cR().c(distance, distance, 4.0) : this.e.cR().c(distance, 4.0, distance));
        }
    }

    private static class c
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        public c(EntityShulker shulker) {
            super(shulker, EntityLiving.class, 10, true, false, (entityliving, worldserver) -> entityliving instanceof IMonster);
        }

        @Override
        public boolean b() {
            return this.e.cr() == null ? false : super.b();
        }

        @Override
        protected AxisAlignedBB a(double distance) {
            EnumDirection enumdirection = ((EntityShulker)this.e).t();
            return enumdirection.o() == EnumDirection.EnumAxis.a ? this.e.cR().c(4.0, distance, distance) : (enumdirection.o() == EnumDirection.EnumAxis.c ? this.e.cR().c(distance, distance, 4.0) : this.e.cR().c(distance, 4.0, distance));
        }
    }

    private static class b
    extends EntityAIBodyControl {
        public b(EntityInsentient entity) {
            super(entity);
        }

        @Override
        public void a() {
        }
    }
}

