/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMonsterEggs;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntitySilverfish
extends EntityMonster {
    @Nullable
    private PathfinderGoalSilverfishWakeOthers a;

    public EntitySilverfish(EntityTypes<? extends EntitySilverfish> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
    }

    @Override
    protected void B() {
        this.a = new PathfinderGoalSilverfishWakeOthers(this);
        this.bT.a(1, new PathfinderGoalFloat(this));
        this.bT.a(1, new ClimbOnTopOfPowderSnowGoal(this, this.dW()));
        this.bT.a(3, this.a);
        this.bT.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bT.a(5, new PathfinderGoalSilverfishHideInBlock(this));
        this.bU.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.bU.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gt().a(GenericAttributes.s, 8.0).a(GenericAttributes.v, 0.25).a(GenericAttributes.c, 1.0);
    }

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.xr;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.xt;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.xs;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.xu, 0.15f, 1.0f);
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        if (this.a(world, source)) {
            return false;
        }
        if ((source.d() != null || source.a(DamageTypeTags.x)) && this.a != null) {
            this.a.h();
        }
        return super.a(world, source, amount);
    }

    @Override
    public void h() {
        this.aX = this.dM();
        super.h();
    }

    @Override
    public void r(float bodyYaw) {
        this.v(bodyYaw);
        super.r(bodyYaw);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return BlockMonsterEggs.o(world.a_(pos.e())) ? 10.0f : super.a(pos, world);
    }

    public static boolean b(EntityTypes<EntitySilverfish> type, GeneratorAccess world, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        if (!EntitySilverfish.c(type, world, spawnReason, pos, random)) {
            return false;
        }
        if (EntitySpawnReason.a(spawnReason)) {
            return true;
        }
        EntityHuman entityhuman = world.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, 5.0, true);
        return (entityhuman == null || entityhuman.affectsSpawning) && entityhuman == null;
    }

    private static class PathfinderGoalSilverfishWakeOthers
    extends PathfinderGoal {
        private final EntitySilverfish a;
        private int b;

        public PathfinderGoalSilverfishWakeOthers(EntitySilverfish silverfish) {
            this.a = silverfish;
        }

        public void h() {
            if (this.b == 0) {
                this.b = this.a(20);
            }
        }

        @Override
        public boolean b() {
            return this.b > 0;
        }

        @Override
        public void a() {
            --this.b;
            if (this.b <= 0) {
                World world = this.a.dW();
                RandomSource randomsource = this.a.dZ();
                BlockPosition blockposition = this.a.dw();
                int i2 = 0;
                while (i2 <= 5 && i2 >= -5) {
                    int j2 = 0;
                    while (j2 <= 10 && j2 >= -10) {
                        int k2 = 0;
                        while (k2 <= 10 && k2 >= -10) {
                            BlockPosition blockposition1 = blockposition.b(j2, i2, k2);
                            IBlockData iblockdata = world.a_(blockposition1);
                            Block block = iblockdata.b();
                            if (block instanceof BlockMonsterEggs) {
                                IBlockData afterState;
                                IBlockData iBlockData = afterState = PathfinderGoalSilverfishWakeOthers.a(world).N().b(GameRules.c) ? iblockdata.y().g() : ((BlockMonsterEggs)block).q(world.a_(blockposition1));
                                if (CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition1, afterState)) {
                                    if (PathfinderGoalSilverfishWakeOthers.a(world).N().b(GameRules.c)) {
                                        world.a(blockposition1, true, this.a);
                                    } else {
                                        world.a(blockposition1, ((BlockMonsterEggs)block).q(world.a_(blockposition1)), 3);
                                    }
                                    if (randomsource.h()) {
                                        return;
                                    }
                                }
                            }
                            k2 = (k2 <= 0 ? 1 : 0) - k2;
                        }
                        j2 = (j2 <= 0 ? 1 : 0) - j2;
                    }
                    i2 = (i2 <= 0 ? 1 : 0) - i2;
                }
            }
        }
    }

    private static class PathfinderGoalSilverfishHideInBlock
    extends PathfinderGoalRandomStroll {
        @Nullable
        private EnumDirection i;
        private boolean j;

        public PathfinderGoalSilverfishHideInBlock(EntitySilverfish silverfish) {
            super(silverfish, 1.0, 10);
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            if (this.b.O_() != null) {
                return false;
            }
            if (!this.b.L().m()) {
                return false;
            }
            RandomSource randomsource = this.b.dZ();
            if (PathfinderGoalSilverfishHideInBlock.a(this.b).N().b(GameRules.c) && randomsource.a(PathfinderGoalSilverfishHideInBlock.b(10)) == 0) {
                this.i = EnumDirection.b(randomsource);
                BlockPosition blockposition = BlockPosition.a(this.b.dB(), this.b.dD() + 0.5, this.b.dH()).a(this.i);
                IBlockData iblockdata = this.b.dW().a_(blockposition);
                if (BlockMonsterEggs.o(iblockdata)) {
                    this.j = true;
                    return true;
                }
            }
            this.j = false;
            return super.b();
        }

        @Override
        public boolean c() {
            return this.j ? false : super.c();
        }

        @Override
        public void d() {
            if (!this.j) {
                super.d();
            } else {
                BlockPosition blockposition;
                World world = this.b.dW();
                IBlockData iblockdata = world.a_(blockposition = BlockPosition.a(this.b.dB(), this.b.dD() + 0.5, this.b.dH()).a(this.i));
                if (BlockMonsterEggs.o(iblockdata)) {
                    if (!CraftEventFactory.callEntityChangeBlockEvent(this.b, blockposition, BlockMonsterEggs.p(iblockdata))) {
                        return;
                    }
                    world.a(blockposition, BlockMonsterEggs.p(iblockdata), 3);
                    this.b.S();
                    this.b.discard(EntityRemoveEvent.Cause.ENTER_BLOCK);
                }
            }
        }
    }
}

