/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBowShoot;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRestrictSun;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.event.entity.EntityShootBowEvent;

public abstract class EntitySkeletonAbstract
extends EntityMonster
implements IRangedEntity {
    private static final int a = 20;
    private static final int b = 40;
    private final PathfinderGoalBowShoot<EntitySkeletonAbstract> c = new PathfinderGoalBowShoot<EntitySkeletonAbstract>(this, 1.0, 20, 15.0f);
    private final PathfinderGoalMeleeAttack d = new PathfinderGoalMeleeAttack(this, 1.2, false){

        @Override
        public void e() {
            super.e();
            EntitySkeletonAbstract.this.w(false);
        }

        @Override
        public void d() {
            super.d();
            EntitySkeletonAbstract.this.w(true);
        }
    };
    private boolean shouldBurnInDay = true;

    protected EntitySkeletonAbstract(EntityTypes<? extends EntitySkeletonAbstract> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
        this.t();
    }

    @Override
    protected void B() {
        this.bT.a(2, new PathfinderGoalRestrictSun(this));
        this.bT.a(3, new PathfinderGoalFleeSun(this, 1.0));
        this.bT.a(3, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 6.0f, 1.0, 1.2));
        this.bT.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bT.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bT.a(6, new PathfinderGoalRandomLookaround(this));
        this.bU.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bU.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bU.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.bU.a(3, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.bZ));
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gt().a(GenericAttributes.v, 0.25);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(this.p(), 0.15f, 1.0f);
    }

    abstract SoundEffect p();

    public boolean shouldBurnInDay() {
        return this.shouldBurnInDay;
    }

    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.shouldBurnInDay = shouldBurnInDay;
    }

    @Override
    public void d_() {
        boolean flag;
        boolean bl = flag = this.shouldBurnInDay && this.gg();
        if (flag) {
            ItemStack itemstack = this.a(EnumItemSlot.f);
            if (!itemstack.f()) {
                if (itemstack.m()) {
                    Item item = itemstack.h();
                    itemstack.b(itemstack.o() + this.ae.a(2));
                    if (itemstack.o() >= itemstack.p()) {
                        this.a(item, EnumItemSlot.f);
                        this.a(EnumItemSlot.f, ItemStack.j);
                    }
                }
                flag = false;
            }
            if (flag) {
                this.d(8.0f);
            }
        }
        super.d_();
    }

    @Override
    public void r() {
        super.r();
        Entity entity = this.dm();
        if (entity instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)entity;
            this.aX = entitycreature.aX;
        }
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        super.a(random, localDifficulty);
        this.a(EnumItemSlot.a, new ItemStack(Items.oR));
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        entityData = super.a(world, difficulty, spawnReason, entityData);
        RandomSource randomsource = world.H_();
        this.a(randomsource, difficulty);
        this.a(world, randomsource, difficulty);
        this.t();
        this.a_(this.dW().paperConfig().entities.behavior.mobsCanAlwaysPickUpLoot.skeletons || randomsource.i() < 0.55f * difficulty.d());
        if (this.a(EnumItemSlot.f).f()) {
            LocalDate localdate = LocalDate.now();
            int i2 = localdate.get(ChronoField.DAY_OF_MONTH);
            int j2 = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j2 == 10 && i2 == 31 && randomsource.i() < 0.25f) {
                this.a(EnumItemSlot.f, new ItemStack(randomsource.i() < 0.1f ? Blocks.es : Blocks.er));
                this.bW[EnumItemSlot.f.b()] = 0.0f;
            }
        }
        return entityData;
    }

    public void t() {
        if (this.dW() != null && !this.dW().C) {
            this.bT.a(this.d);
            this.bT.a(this.c);
            ItemStack itemstack = this.b(ProjectileHelper.a(this, Items.oR));
            if (itemstack.a(Items.oR)) {
                int i2 = this.x();
                if (this.dW().al() != EnumDifficulty.d) {
                    i2 = this.go();
                }
                this.c.c(i2);
                this.bT.a(4, this.c);
            } else {
                this.bT.a(4, this.d);
            }
        }
    }

    protected int x() {
        return 20;
    }

    protected int go() {
        return 40;
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        ItemStack itemstack = this.b(ProjectileHelper.a(this, Items.oR));
        ItemStack itemstack1 = this.d(itemstack);
        EntityArrow entityarrow = this.a(itemstack1, pullProgress, itemstack);
        double d0 = target.dB() - this.dB();
        double d1 = target.e(0.3333333333333333) - entityarrow.dD();
        double d2 = target.dH() - this.dH();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            EntityShootBowEvent event = CraftEventFactory.callEntityShootBowEvent(this, this.eZ(), entityarrow.u(), entityarrow, EnumHand.a, 0.8f, true);
            if (event.isCancelled()) {
                event.getProjectile().remove();
                return;
            }
            if (event.getProjectile() == entityarrow.getBukkitEntity()) {
                IProjectile.a(entityarrow, worldserver, itemstack1, d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - worldserver.al().a() * 4);
            }
        }
        this.a(SoundEffects.xH, 1.0f, 1.0f / (this.dZ().i() * 0.4f + 0.8f));
    }

    protected EntityArrow a(ItemStack arrow, float damageModifier, @Nullable ItemStack shotFrom) {
        return ProjectileHelper.a(this, arrow, damageModifier, shotFrom);
    }

    @Override
    public boolean a(ItemProjectileWeapon weapon) {
        return weapon == Items.oR;
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.t();
        if (nbt.e("Paper.ShouldBurnInDay")) {
            this.shouldBurnInDay = nbt.q("Paper.ShouldBurnInDay");
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Paper.ShouldBurnInDay", this.shouldBurnInDay);
    }

    @Override
    public void setItemSlot(EnumItemSlot slot, ItemStack stack, boolean silent) {
        super.setItemSlot(slot, stack, silent);
        if (!this.dW().C) {
            this.t();
        }
    }

    public boolean gp() {
        return this.cw();
    }
}

