/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.SlimeChangeDirectionEvent;
import com.destroystokyo.paper.event.entity.SlimeSwimEvent;
import com.destroystokyo.paper.event.entity.SlimeTargetLivingEntityEvent;
import com.destroystokyo.paper.event.entity.SlimeWanderEvent;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.ConversionType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.SlimeSplitEvent;

public class EntitySlime
extends EntityInsentient
implements IMonster {
    private static final DataWatcherObject<Integer> ca = DataWatcher.a(EntitySlime.class, DataWatcherRegistry.b);
    public static final int a = 1;
    public static final int b = 127;
    public static final int c = 4;
    public float d;
    public float bY;
    public float bZ;
    private boolean cb;
    private boolean canWander = true;

    public EntitySlime(EntityTypes<? extends EntitySlime> type, World world) {
        super((EntityTypes<? extends EntityInsentient>)type, world);
        this.cN();
        this.bQ = new ControllerMoveSlime(this);
    }

    @Override
    protected void B() {
        this.bT.a(1, new PathfinderGoalSlimeRandomJump(this));
        this.bT.a(2, new PathfinderGoalSlimeNearestPlayer(this));
        this.bT.a(3, new PathfinderGoalSlimeRandomDirection(this));
        this.bT.a(5, new PathfinderGoalSlimeIdle(this));
        this.bU.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, (entityliving, worldserver) -> Math.abs(entityliving.dD() - this.dD()) <= 4.0));
        this.bU.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    public SoundCategory dn() {
        return SoundCategory.f;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ca, 1);
    }

    @VisibleForTesting
    public void a(int size, boolean heal) {
        int j2 = MathHelper.a(size, 1, 127);
        this.al.a(ca, j2);
        this.ay();
        this.m_();
        this.g(GenericAttributes.s).a(j2 * j2);
        this.g(GenericAttributes.v).a(0.2f + 0.1f * (float)j2);
        this.g(GenericAttributes.c).a(j2);
        if (heal) {
            this.x(this.eS());
        }
        this.bO = j2;
    }

    public int go() {
        return this.al.a(ca);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Paper.canWander", this.canWander);
        nbt.a("Size", this.go() - 1);
        nbt.a("wasOnGround", this.cb);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.a(nbt.h("Size") + 1, false);
        super.a(nbt);
        if (nbt.e("Paper.canWander")) {
            this.canWander = nbt.q("Paper.canWander");
        }
        this.cb = nbt.q("wasOnGround");
    }

    public boolean gp() {
        return this.go() <= 1;
    }

    protected ParticleParam p() {
        return Particles.V;
    }

    @Override
    protected boolean X() {
        return this.go() > 0;
    }

    @Override
    public void h() {
        this.bZ = this.bY;
        this.bY += (this.d - this.bY) * 0.5f;
        super.h();
        if (this.aJ() && !this.cb) {
            float f2 = this.a(this.aw()).a() * 2.0f;
            float f1 = f2 / 2.0f;
            int i2 = 0;
            while ((float)i2 < f2 * 16.0f) {
                float f22 = this.ae.i() * ((float)Math.PI * 2);
                float f3 = this.ae.i() * 0.5f + 0.5f;
                float f4 = MathHelper.a(f22) * f1 * f3;
                float f5 = MathHelper.b(f22) * f1 * f3;
                this.dW().a(this.p(), this.dB() + (double)f4, this.dD(), this.dH() + (double)f5, 0.0, 0.0, 0.0);
                ++i2;
            }
            this.a(this.gm(), this.fg(), ((this.ae.i() - this.ae.i()) * 0.2f + 1.0f) / 0.8f);
            this.d = -0.5f;
        } else if (!this.aJ() && this.cb) {
            this.d = 1.0f;
        }
        this.cb = this.aJ();
        this.x();
    }

    protected void x() {
        this.d *= 0.6f;
    }

    protected int t() {
        return this.ae.a(20) + 10;
    }

    @Override
    public void m_() {
        double d0 = this.dB();
        double d1 = this.dD();
        double d2 = this.dH();
        super.m_();
        this.a_(d0, d1, d2);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (ca.equals(data)) {
            this.m_();
            this.v(this.aZ);
            this.aX = this.aZ;
            if (this.bj() && this.ae.a(20) == 0) {
                this.bs();
            }
        }
        super.a(data);
    }

    public EntityTypes<? extends EntitySlime> aq() {
        return super.aq();
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        this.remove(reason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        int i2 = this.go();
        if (!this.dW().C && i2 > 1 && this.eF()) {
            float f2 = this.a(this.aw()).a();
            float f1 = f2 / 2.0f;
            int j2 = i2 / 2;
            int k2 = 2 + this.ae.a(3);
            ScoreboardTeam scoreboardteam = this.cr();
            SlimeSplitEvent event = new SlimeSplitEvent((Slime)this.getBukkitEntity(), k2);
            this.dW().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || event.getCount() <= 0) {
                super.remove(entity_removalreason, cause);
                return;
            }
            k2 = event.getCount();
            ArrayList<EntityLiving> slimes = new ArrayList<EntityLiving>(j2);
            for (int l2 = 0; l2 < k2; ++l2) {
                float f22 = ((float)(l2 % 2) - 0.5f) * f1;
                float f3 = ((float)(l2 / 2) - 0.5f) * f1;
                EntitySlime converted = this.convertTo(this.aq(), new ConversionParams(ConversionType.b, false, false, scoreboardteam), EntitySpawnReason.k, (T entityslime) -> {
                    entityslime.aware = this.aware;
                    entityslime.a(j2, true);
                    entityslime.b(this.dB() + (double)f22, this.dD() + 0.5, this.dH() + (double)f3, this.ae.i() * 360.0f, 0.0f);
                }, null, null);
                if (converted == null) continue;
                slimes.add(converted);
            }
            if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, slimes, EntityTransformEvent.TransformReason.SPLIT).isCancelled()) {
                super.remove(entity_removalreason, cause);
                return;
            }
            for (EntityLiving living : slimes) {
                this.dW().addFreshEntity(living, CreatureSpawnEvent.SpawnReason.SLIME_SPLIT);
            }
        }
        super.remove(entity_removalreason, cause);
    }

    @Override
    public void h(Entity entity) {
        super.h(entity);
        if (entity instanceof EntityIronGolem && this.gk()) {
            this.j((EntityLiving)entity);
        }
    }

    @Override
    public void a_(EntityHuman player) {
        if (this.gk()) {
            this.j(player);
        }
    }

    protected void j(EntityLiving target) {
        World world = this.dW();
        if (world instanceof WorldServer) {
            DamageSource damagesource;
            WorldServer worldserver = (WorldServer)world;
            if (this.bL() && this.i(target) && this.E(target) && target.a(worldserver, damagesource = this.dX().b(this), this.gl())) {
                this.a(SoundEffects.xJ, 1.0f, (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
                EnchantmentManager.a(worldserver, (Entity)target, damagesource);
            }
        }
    }

    @Override
    protected Vec3D a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vec3D(0.0, (double)dimensions.b() - 0.015625 * (double)this.go() * (double)scaleFactor, 0.0);
    }

    protected boolean gk() {
        return !this.gp() && this.dk();
    }

    protected float gl() {
        return (float)this.h(GenericAttributes.c);
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return this.gp() ? SoundEffects.yF : SoundEffects.xL;
    }

    @Override
    public SoundEffect o_() {
        return this.gp() ? SoundEffects.yE : SoundEffects.xK;
    }

    protected SoundEffect gm() {
        return this.gp() ? SoundEffects.yH : SoundEffects.xN;
    }

    public static boolean c(EntityTypes<EntitySlime> type, GeneratorAccess world, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        if (world.al() != EnumDifficulty.a) {
            if (EntitySpawnReason.a(spawnReason)) {
                return EntitySlime.a(type, world, spawnReason, pos, random);
            }
            double maxHeightSwamp = world.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.surfaceBiome.maximum;
            double minHeightSwamp = world.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.surfaceBiome.minimum;
            if (world.t(pos).a(BiomeTags.aq) && (double)pos.v() > minHeightSwamp && (double)pos.v() < maxHeightSwamp && random.i() < 0.5f && random.i() < world.aq() && world.A(pos) <= random.a(8)) {
                return EntitySlime.a(type, world, spawnReason, pos, random);
            }
            if (!(world instanceof GeneratorAccessSeed)) {
                return false;
            }
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(pos);
            boolean flag = world.getMinecraftWorld().paperConfig().entities.spawning.allChunksAreSlimeChunks || SeededRandom.a(chunkcoordintpair.h, chunkcoordintpair.i, ((GeneratorAccessSeed)world).D(), world.getMinecraftWorld().spigotConfig.slimeSeed).a(10) == 0;
            double maxHeightSlimeChunk = world.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.slimeChunk.maximum;
            if (random.a(10) == 0 && flag && (double)pos.v() < maxHeightSlimeChunk) {
                return EntitySlime.a(type, world, spawnReason, pos, random);
            }
        }
        return false;
    }

    @Override
    public float fg() {
        return 0.4f * (float)this.go();
    }

    @Override
    public int Z() {
        return 0;
    }

    protected boolean gq() {
        return this.go() > 0;
    }

    @Override
    public void s() {
        Vec3D vec3d = this.dz();
        this.n(vec3d.d, this.fj(), vec3d.f);
        this.ar = true;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        RandomSource randomsource = world.H_();
        int i2 = randomsource.a(3);
        if (i2 < 2 && randomsource.i() < 0.5f * difficulty.d()) {
            ++i2;
        }
        int j2 = 1 << i2;
        this.a(j2, true);
        return super.a(world, difficulty, spawnReason, entityData);
    }

    float m() {
        float f2 = this.gp() ? 1.4f : 0.8f;
        return ((this.ae.i() - this.ae.i()) * 0.2f + 1.0f) * f2;
    }

    protected SoundEffect gn() {
        return this.gp() ? SoundEffects.yG : SoundEffects.xM;
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return super.e(pose).a(this.go());
    }

    public boolean canWander() {
        return this.canWander;
    }

    public void setWander(boolean canWander) {
        this.canWander = canWander;
    }

    private static class ControllerMoveSlime
    extends ControllerMove {
        private float l;
        private int m;
        private final EntitySlime n;
        private boolean o;

        public ControllerMoveSlime(EntitySlime slime) {
            super(slime);
            this.n = slime;
            this.l = 180.0f * slime.dM() / (float)Math.PI;
        }

        public void a(float targetYaw, boolean jumpOften) {
            this.l = targetYaw;
            this.o = jumpOften;
        }

        public void a(double speed) {
            this.h = speed;
            this.k = ControllerMove.Operation.b;
        }

        @Override
        public void a() {
            this.d.v(this.b(this.d.dM(), this.l, 90.0f));
            this.d.aZ = this.d.dM();
            this.d.aX = this.d.dM();
            if (this.k != ControllerMove.Operation.b) {
                this.d.G(0.0f);
            } else {
                this.k = ControllerMove.Operation.a;
                if (this.d.aJ()) {
                    this.d.C((float)(this.h * this.d.h(GenericAttributes.v)));
                    if (this.m-- <= 0) {
                        this.m = this.n.t();
                        if (this.o) {
                            this.m /= 3;
                        }
                        this.n.J().a();
                        if (this.n.gq()) {
                            this.n.a(this.n.gn(), this.n.fg(), this.n.m());
                        }
                    } else {
                        this.n.bo = 0.0f;
                        this.n.bq = 0.0f;
                        this.d.C(0.0f);
                    }
                } else {
                    this.d.C((float)(this.h * this.d.h(GenericAttributes.v)));
                }
            }
        }
    }

    private static class PathfinderGoalSlimeRandomJump
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeRandomJump(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
            slime.L().a(true);
        }

        @Override
        public boolean b() {
            return (this.a.bj() || this.a.bx()) && this.a.I() instanceof ControllerMoveSlime && this.a.canWander && new SlimeSwimEvent((Slime)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public boolean V_() {
            return true;
        }

        @Override
        public void a() {
            ControllerMove controllermove;
            if (this.a.dZ().i() < 0.8f) {
                this.a.J().a();
            }
            if ((controllermove = this.a.I()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.2);
            }
        }
    }

    private static class PathfinderGoalSlimeNearestPlayer
    extends PathfinderGoal {
        private final EntitySlime a;
        private int b;

        public PathfinderGoalSlimeNearestPlayer(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = this.a.O_();
            if (entityliving == null || !entityliving.bL()) {
                return false;
            }
            if (!this.a.c(entityliving)) {
                return false;
            }
            return this.a.I() instanceof ControllerMoveSlime && this.a.canWander && new SlimeTargetLivingEntityEvent((Slime)this.a.getBukkitEntity(), (LivingEntity)entityliving.getBukkitEntity()).callEvent();
        }

        @Override
        public void d() {
            this.b = PathfinderGoalSlimeNearestPlayer.b(300);
            super.d();
        }

        @Override
        public boolean c() {
            EntityLiving entityliving = this.a.O_();
            if (entityliving == null || !entityliving.bL()) {
                return false;
            }
            if (!this.a.c(entityliving)) {
                return false;
            }
            return --this.b > 0 && this.a.canWander && new SlimeTargetLivingEntityEvent((Slime)this.a.getBukkitEntity(), (LivingEntity)entityliving.getBukkitEntity()).callEvent();
        }

        @Override
        public boolean V_() {
            return true;
        }

        @Override
        public void a() {
            ControllerMove controllermove;
            EntityLiving entityliving = this.a.O_();
            if (entityliving != null) {
                this.a.a((Entity)entityliving, 10.0f, 10.0f);
            }
            if ((controllermove = this.a.I()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.a.dM(), this.a.gk());
            }
        }

        @Override
        public void e() {
            this.b = 0;
            this.a.h((EntityLiving)null);
        }
    }

    private static class PathfinderGoalSlimeRandomDirection
    extends PathfinderGoal {
        private final EntitySlime a;
        private float b;
        private int c;

        public PathfinderGoalSlimeRandomDirection(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return this.a.O_() == null && (this.a.aJ() || this.a.bj() || this.a.bx() || this.a.b(MobEffects.y)) && this.a.I() instanceof ControllerMoveSlime && this.a.canWander;
        }

        @Override
        public void a() {
            ControllerMove controllermove;
            if (--this.c <= 0) {
                this.c = this.a(40 + this.a.dZ().a(60));
                this.b = this.a.dZ().a(360);
                SlimeChangeDirectionEvent event = new SlimeChangeDirectionEvent((Slime)this.a.getBukkitEntity(), this.b);
                if (!this.a.canWander || !event.callEvent()) {
                    return;
                }
                this.b = event.getNewYaw();
            }
            if ((controllermove = this.a.I()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.b, false);
            }
        }
    }

    private static class PathfinderGoalSlimeIdle
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeIdle(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return !this.a.bZ() && this.a.canWander && new SlimeWanderEvent((Slime)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public void a() {
            ControllerMove controllermove = this.a.I();
            if (controllermove instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.0);
            }
        }
    }
}

