/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationSpider;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntitySkeleton;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntitySpider
extends EntityMonster {
    private static final DataWatcherObject<Byte> a = DataWatcher.a(EntitySpider.class, DataWatcherRegistry.a);
    private static final float b = 0.1f;

    public EntitySpider(EntityTypes<? extends EntitySpider> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
    }

    @Override
    protected void B() {
        this.bT.a(1, new PathfinderGoalFloat(this));
        this.bT.a(2, new PathfinderGoalAvoidTarget<Armadillo>(this, Armadillo.class, 6.0f, 1.0, 1.2, entityliving -> !((Armadillo)entityliving).t()));
        this.bT.a(3, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bT.a(4, new PathfinderGoalSpiderMeleeAttack(this));
        this.bT.a(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.bT.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bT.a(6, new PathfinderGoalRandomLookaround(this));
        this.bU.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bU.a(2, new PathfinderGoalSpiderNearestAttackableTarget<EntityHuman>(this, EntityHuman.class));
        this.bU.a(3, new PathfinderGoalSpiderNearestAttackableTarget<EntityIronGolem>(this, EntityIronGolem.class));
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new NavigationSpider(this, world);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, (byte)0);
    }

    @Override
    public void h() {
        super.h();
        if (!this.dW().C) {
            this.x(this.P && (this.dW().paperConfig().entities.behavior.allowSpiderWorldBorderClimbing || !CollisionUtil.isCollidingWithBorder(this.dW().F_(), this.cR().g(1.0E-7)) || !this.dW().F_().a(this, this.cR())));
        }
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gt().a(GenericAttributes.s, 16.0).a(GenericAttributes.v, 0.3f);
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.zk;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.zm;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.zl;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.zn, 0.15f, 1.0f);
    }

    @Override
    public boolean q_() {
        return this.t();
    }

    @Override
    public void a(IBlockData state, Vec3D multiplier) {
        if (!state.a(Blocks.bz)) {
            super.a(state, multiplier);
        }
    }

    @Override
    public boolean b(MobEffect effect) {
        return effect.a(MobEffects.s) && this.dW().paperConfig().entities.mobEffects.spidersImmuneToPoisonEffect ? false : super.b(effect);
    }

    public boolean t() {
        return (this.al.a(a) & 1) != 0;
    }

    public void x(boolean climbing) {
        byte b0 = this.al.a(a);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.al.a(a, b0);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        EntitySkeleton entityskeleton;
        GroupDataEntity object = super.a(world, difficulty, spawnReason, entityData);
        RandomSource randomsource = world.H_();
        if (randomsource.a(100) == 0 && (entityskeleton = EntityTypes.bf.a(this.dW(), EntitySpawnReason.g)) != null) {
            entityskeleton.b(this.dB(), this.dD(), this.dH(), this.dM(), 0.0f);
            entityskeleton.a(world, difficulty, spawnReason, (GroupDataEntity)null);
            entityskeleton.n(this);
        }
        if (object == null) {
            object = new GroupDataSpider();
            if (world.al() == EnumDifficulty.d && randomsource.i() < 0.1f * difficulty.d()) {
                ((GroupDataSpider)object).a(randomsource);
            }
        }
        if (object instanceof GroupDataSpider) {
            GroupDataSpider entityspider_groupdataspider = (GroupDataSpider)object;
            Holder<MobEffectList> holder = entityspider_groupdataspider.a;
            if (holder != null) {
                this.addEffect(new MobEffect(holder, -1), null, EntityPotionEffectEvent.Cause.SPIDER_SPAWN, world instanceof WorldServer);
            }
        }
        return object;
    }

    @Override
    public Vec3D l(Entity vehicle) {
        return vehicle.dr() <= this.dr() ? new Vec3D(0.0, 0.3125 * (double)this.ek(), 0.0) : super.l(vehicle);
    }

    private static class PathfinderGoalSpiderMeleeAttack
    extends PathfinderGoalMeleeAttack {
        public PathfinderGoalSpiderMeleeAttack(EntitySpider spider) {
            super(spider, 1.0, true);
        }

        @Override
        public boolean b() {
            return super.b() && !this.a.ca();
        }

        @Override
        public boolean c() {
            float f2 = this.a.by();
            if (f2 >= 0.5f && this.a.dZ().a(100) == 0) {
                this.a.h((EntityLiving)null);
                return false;
            }
            return super.c();
        }
    }

    private static class PathfinderGoalSpiderNearestAttackableTarget<T extends EntityLiving>
    extends PathfinderGoalNearestAttackableTarget<T> {
        public PathfinderGoalSpiderNearestAttackableTarget(EntitySpider spider, Class<T> targetEntityClass) {
            super((EntityInsentient)spider, targetEntityClass, true);
        }

        @Override
        public boolean b() {
            float f2 = this.e.by();
            return f2 >= 0.5f ? false : super.b();
        }
    }

    public static class GroupDataSpider
    implements GroupDataEntity {
        @Nullable
        public Holder<MobEffectList> a;

        public void a(RandomSource random) {
            int i2 = random.a(5);
            if (i2 <= 1) {
                this.a = MobEffects.a;
            } else if (i2 <= 2) {
                this.a = MobEffects.e;
            } else if (i2 <= 3) {
                this.a = MobEffects.j;
            } else if (i2 <= 4) {
                this.a = MobEffects.n;
            }
        }
    }
}

