/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;

public class EntityStrider
extends EntityAnimal
implements ISteerable,
ISaddleable {
    private static final MinecraftKey bZ = MinecraftKey.b("suffocating");
    private static final AttributeModifier ca = new AttributeModifier(bZ, -0.34f, AttributeModifier.Operation.b);
    private static final float cb = 0.35f;
    private static final float cd = 0.55f;
    private static final DataWatcherObject<Integer> ce = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> cf = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cg = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.k);
    public final SaddleStorage ch;
    @Nullable
    private PathfinderGoalTempt ci;

    public EntityStrider(EntityTypes<? extends EntityStrider> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.ch = new SaddleStorage(this.al, ce, cg);
        this.I = true;
        this.a(PathType.j, -1.0f);
        this.a(PathType.i, 0.0f);
        this.a(PathType.n, 0.0f);
        this.a(PathType.o, 0.0f);
    }

    public static boolean c(EntityTypes<EntityStrider> type, GeneratorAccess world, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = pos.k();
        do {
            blockposition_mutableblockposition.c(EnumDirection.b);
        } while (world.b_(blockposition_mutableblockposition).a(TagsFluid.b));
        return world.a_(blockposition_mutableblockposition).l();
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (ce.equals(data) && this.dW().C) {
            this.ch.a();
        }
        super.a(data);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ce, 0);
        builder.a(cf, false);
        builder.a(cg, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.ch.a(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.ch.b(nbt);
    }

    @Override
    public boolean j() {
        return this.ch.d();
    }

    @Override
    public boolean f() {
        return this.bL() && !this.e_();
    }

    @Override
    public void a(ItemStack stack, @Nullable SoundCategory soundCategory) {
        this.ch.a(true);
        if (soundCategory != null) {
            this.dW().a((EntityHuman)null, this, SoundEffects.yD, soundCategory, 0.5f, 1.0f);
        }
    }

    @Override
    protected void B() {
        this.bT.a(1, new PathfinderGoalPanic(this, 1.65));
        this.bT.a(2, new PathfinderGoalBreed(this, 1.0));
        this.ci = new PathfinderGoalTempt(this, 1.4, itemstack -> itemstack.a(TagsItem.aA), false);
        this.bT.a(3, this.ci);
        this.bT.a(4, new a(this, 1.0));
        this.bT.a(5, new PathfinderGoalFollowParent(this, 1.0));
        this.bT.a(7, new PathfinderGoalRandomStroll(this, 1.0, 60));
        this.bT.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bT.a(8, new PathfinderGoalRandomLookaround(this));
        this.bT.a(9, new PathfinderGoalLookAtPlayer(this, EntityStrider.class, 8.0f));
    }

    public void x(boolean cold) {
        this.al.a(cf, cold);
        AttributeModifiable attributemodifiable = this.g(GenericAttributes.v);
        if (attributemodifiable != null) {
            if (cold) {
                attributemodifiable.a(ca);
            } else {
                attributemodifiable.c(bZ);
            }
        }
    }

    public boolean p() {
        return this.al.a(cf);
    }

    @Override
    public boolean a(Fluid state) {
        return state.a(TagsFluid.b);
    }

    @Override
    protected Vec3D a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        float f1 = Math.min(0.25f, this.aT.b());
        float f2 = this.aT.c();
        float f3 = 0.12f * MathHelper.b(f2 * 1.5f) * 2.0f * f1;
        return super.a(passenger, dimensions, scaleFactor).b(0.0, f3 * scaleFactor, 0.0);
    }

    @Override
    public boolean a(IWorldReader world) {
        return world.f(this);
    }

    @Override
    @Nullable
    public EntityLiving cX() {
        EntityHuman entityhuman;
        Entity entity;
        if (this.j() && (entity = this.da()) instanceof EntityHuman && (entityhuman = (EntityHuman)entity).b(Items.ol)) {
            return entityhuman;
        }
        return super.cX();
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        Vec3D[] avec3d = new Vec3D[]{EntityStrider.a(this.dr(), (double)passenger.dr(), passenger.dM()), EntityStrider.a(this.dr(), (double)passenger.dr(), passenger.dM() - 22.5f), EntityStrider.a(this.dr(), (double)passenger.dr(), passenger.dM() + 22.5f), EntityStrider.a(this.dr(), (double)passenger.dr(), passenger.dM() - 45.0f), EntityStrider.a(this.dr(), (double)passenger.dr(), passenger.dM() + 45.0f)};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.cR().e;
        double d1 = this.cR().b - 0.5;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        Vec3D[] avec3d1 = avec3d;
        int i2 = avec3d.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            Vec3D vec3d = avec3d1[j2];
            blockposition_mutableblockposition.b(this.dB() + vec3d.d, d0, this.dH() + vec3d.f);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockposition_mutableblockposition.j());
                blockposition_mutableblockposition.c(EnumDirection.a);
            }
        }
        for (BlockPosition blockposition : set) {
            double d3;
            if (this.dW().b_(blockposition).a(TagsFluid.b) || !DismountUtil.a(d3 = this.dW().j(blockposition))) continue;
            Vec3D vec3d1 = Vec3D.a(blockposition, d3);
            for (EntityPose entitypose : passenger.fO()) {
                AxisAlignedBB axisalignedbb = passenger.f(entitypose);
                if (!DismountUtil.a(this.dW(), passenger, axisalignedbb.c(vec3d1))) continue;
                passenger.b(entitypose);
                return vec3d1;
            }
        }
        return new Vec3D(this.dB(), this.cR().e, this.dH());
    }

    @Override
    protected void a(EntityHuman controllingPlayer, Vec3D movementInput) {
        this.b(controllingPlayer.dM(), controllingPlayer.dO() * 0.5f);
        this.aX = this.aZ = this.dM();
        this.N = this.aZ;
        this.ch.b();
        super.a(controllingPlayer, movementInput);
    }

    @Override
    protected Vec3D b(EntityHuman controllingPlayer, Vec3D movementInput) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float e(EntityHuman controllingPlayer) {
        return (float)(this.h(GenericAttributes.v) * (double)(this.p() ? 0.35f : 0.55f) * (double)this.ch.c());
    }

    @Override
    protected float aU() {
        return this.X + 0.6f;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(this.bx() ? SoundEffects.yB : SoundEffects.yA, 1.0f, 1.0f);
    }

    @Override
    public boolean a() {
        return this.ch.a(this.dZ());
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
        if (this.bx()) {
            this.k();
        } else {
            super.a(heightDifference, onGround, state, landedPosition);
        }
    }

    @Override
    public void h() {
        if (this.x() && this.ae.a(140) == 0) {
            this.b(SoundEffects.yw);
        } else if (this.gl() && this.ae.a(60) == 0) {
            this.b(SoundEffects.yx);
        }
        if (!this.gb()) {
            boolean suffocating;
            EntityStrider entitystrider;
            IBlockData iblockdata = this.dW().a_(this.dw());
            IBlockData iblockdata1 = this.bt();
            boolean flag = iblockdata.a(TagsBlock.aW) || iblockdata1.a(TagsBlock.aW) || this.b(TagsFluid.b) > 0.0;
            Entity entity = this.dl();
            boolean flag1 = entity instanceof EntityStrider && (entitystrider = (EntityStrider)entity).p();
            boolean flag2 = flag1;
            boolean bl = suffocating = !flag || flag2;
            if (suffocating ^ this.p() && CraftEventFactory.callStriderTemperatureChangeEvent(this, suffocating)) {
                this.x(suffocating);
            }
        }
        super.h();
        this.go();
    }

    private boolean x() {
        return this.ci != null && this.ci.i();
    }

    @Override
    protected boolean D() {
        return true;
    }

    private void go() {
        if (this.bx()) {
            VoxelShapeCollision voxelshapecollision = VoxelShapeCollision.a(this);
            if (voxelshapecollision.a(BlockFluids.d, this.dw(), true) && !this.dW().b_(this.dw().d()).a(TagsFluid.b)) {
                this.d(true);
            } else {
                this.h(this.dz().c(0.5).b(0.0, 0.05, 0.0));
            }
        }
    }

    public static AttributeProvider.Builder t() {
        return EntityAnimal.gt().a(GenericAttributes.v, 0.175f);
    }

    @Override
    protected SoundEffect u() {
        return !this.gl() && !this.x() ? SoundEffects.yv : null;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.yz;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.yy;
    }

    @Override
    protected boolean r(Entity passenger) {
        return !this.ca() && !((Entity)this).a(TagsFluid.b);
    }

    @Override
    public boolean fr() {
        return true;
    }

    @Override
    public boolean bY() {
        return false;
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new b(this, world);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return world.a_(pos).y().a(TagsFluid.b) ? 10.0f : (this.bx() ? Float.NEGATIVE_INFINITY : 0.0f);
    }

    @Nullable
    public EntityStrider b(WorldServer world, EntityAgeable entity) {
        return EntityTypes.bt.a(world, EntitySpawnReason.e);
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.az);
    }

    @Override
    protected void f(WorldServer world) {
        super.f(world);
        if (this.j()) {
            this.a(world, Items.oe);
        }
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean flag = this.j(player.b(hand));
        if (!flag && this.j() && !this.ca() && !player.fY()) {
            if (!this.dW().C) {
                player.n(this);
            }
            return EnumInteractionResult.a;
        }
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (!enuminteractionresult.a()) {
            ItemStack itemstack = player.b(hand);
            return itemstack.a(Items.oe) ? itemstack.a(player, (EntityLiving)this, hand) : EnumInteractionResult.e;
        }
        if (flag && !this.bb()) {
            this.dW().a((EntityHuman)null, this.dB(), this.dD(), this.dH(), SoundEffects.yC, this.dn(), 1.0f, 1.0f + (this.ae.i() - this.ae.i()) * 0.2f);
        }
        return enuminteractionresult;
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.6f * this.cS(), this.dr() * 0.4f);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        if (this.e_()) {
            return super.a(world, difficulty, spawnReason, entityData);
        }
        RandomSource randomsource = world.H_();
        if (randomsource.a(30) == 0) {
            EntityInsentient entityinsentient = EntityTypes.bR.a(world.a(), EntitySpawnReason.g);
            if (entityinsentient != null) {
                entityData = this.a(world, difficulty, entityinsentient, (GroupDataEntity)new EntityZombie.GroupDataZombie(EntityZombie.a(randomsource), false));
                entityinsentient.a(EnumItemSlot.a, new ItemStack(Items.ol));
                this.a(new ItemStack(Items.oe), (SoundCategory)null);
            }
        } else if (randomsource.a(10) == 0) {
            EntityAgeable entityageable = EntityTypes.bt.a(world.a(), EntitySpawnReason.g);
            if (entityageable != null) {
                entityageable.c_(-24000);
                entityData = this.a(world, difficulty, entityageable, (GroupDataEntity)null);
            }
        } else {
            entityData = new EntityAgeable.a(0.5f);
        }
        return super.a(world, difficulty, spawnReason, entityData);
    }

    private GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntityInsentient rider, @Nullable GroupDataEntity entityData) {
        rider.b(this.dB(), this.dD(), this.dH(), this.dM(), 0.0f);
        rider.a(world, difficulty, EntitySpawnReason.g, entityData);
        rider.a((Entity)this, true);
        return new EntityAgeable.a(0.0f);
    }

    private static class a
    extends PathfinderGoalGotoTarget {
        private final EntityStrider g;

        a(EntityStrider strider, double speed) {
            super(strider, speed, 8, 2);
            this.g = strider;
        }

        @Override
        public BlockPosition k() {
            return this.e;
        }

        @Override
        public boolean c() {
            return !this.g.bx() && this.a(this.g.dW(), this.e);
        }

        @Override
        public boolean b() {
            return !this.g.bx() && super.b();
        }

        @Override
        public boolean l() {
            return this.d % 20 == 0;
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            return world.a_(pos).a(Blocks.K) && world.a_(pos.d()).a(PathMode.a);
        }
    }

    private static class b
    extends Navigation {
        b(EntityStrider entity, World world) {
            super(entity, world);
        }

        @Override
        protected Pathfinder a(int range) {
            this.o = new PathfinderNormal();
            this.o.a(true);
            return new Pathfinder(this.o, range);
        }

        @Override
        protected boolean a(PathType pathType) {
            return pathType != PathType.i && pathType != PathType.o && pathType != PathType.n ? super.a(pathType) : true;
        }

        @Override
        public boolean a(BlockPosition pos) {
            return this.b.a_(pos).a(Blocks.K) || super.a(pos);
        }
    }
}

