/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityVex
extends EntityMonster
implements TraceableEntity {
    public static final float a = 45.836624f;
    public static final int b = MathHelper.f(3.9269907f);
    protected static final DataWatcherObject<Byte> c = DataWatcher.a(EntityVex.class, DataWatcherRegistry.a);
    private static final int d = 1;
    @Nullable
    EntityInsentient bZ;
    @Nullable
    private BlockPosition ca;
    public boolean cb;
    public int cc;

    public EntityVex(EntityTypes<? extends EntityVex> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
        this.bQ = new c(this);
        this.bO = 3;
    }

    @Override
    public boolean ba() {
        return this.af % b == 0;
    }

    @Override
    protected boolean aL() {
        return !this.dR();
    }

    @Override
    public void h() {
        this.ad = true;
        super.h();
        this.ad = false;
        this.f(true);
        if (this.cb && --this.cc <= 0) {
            this.cc = 20;
            this.a(this.dX().j(), 1.0f);
        }
    }

    @Override
    protected void B() {
        super.B();
        this.bT.a(0, new PathfinderGoalFloat(this));
        this.bT.a(4, new a());
        this.bT.a(8, new d());
        this.bT.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.bT.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.bU.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bU.a(2, new b(this));
        this.bU.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gt().a(GenericAttributes.s, 14.0).a(GenericAttributes.c, 4.0);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, (byte)0);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.e("BoundX")) {
            this.ca = new BlockPosition(nbt.h("BoundX"), nbt.h("BoundY"), nbt.h("BoundZ"));
        }
        if (nbt.e("LifeTicks")) {
            this.b(nbt.h("LifeTicks"));
        }
    }

    @Override
    public void x(Entity original) {
        super.x(original);
        if (original instanceof EntityVex) {
            EntityVex entityvex = (EntityVex)original;
            this.bZ = entityvex.t();
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.ca != null) {
            nbt.a("BoundX", this.ca.u());
            nbt.a("BoundY", this.ca.v());
            nbt.a("BoundZ", this.ca.w());
        }
        if (this.cb) {
            nbt.a("LifeTicks", this.cc);
        }
    }

    @Nullable
    public EntityInsentient t() {
        return this.bZ;
    }

    @Nullable
    public BlockPosition x() {
        return this.ca;
    }

    public void h(@Nullable BlockPosition bounds) {
        this.ca = bounds;
    }

    private boolean c(int mask) {
        byte b0 = this.al.a(c);
        return (b0 & mask) != 0;
    }

    private void a(int mask, boolean value) {
        int j2 = this.al.a(c).byteValue();
        j2 = value ? (j2 |= mask) : (j2 &= ~mask);
        this.al.a(c, (byte)(j2 & 0xFF));
    }

    public boolean go() {
        return this.c(1);
    }

    public void x(boolean charging) {
        this.a(1, charging);
    }

    public void a(EntityInsentient owner) {
        this.bZ = owner;
    }

    public void b(int lifeTicks) {
        this.cb = true;
        this.cc = lifeTicks;
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.Bn;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.Bp;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.Bq;
    }

    @Override
    public float by() {
        return 1.0f;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        RandomSource randomsource = world.H_();
        this.a(randomsource, difficulty);
        this.a(world, randomsource, difficulty);
        return super.a(world, difficulty, spawnReason, entityData);
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        this.a(EnumItemSlot.a, new ItemStack(Items.px));
        this.a(EnumItemSlot.a, 0.0f);
    }

    private class c
    extends ControllerMove {
        public c(EntityVex entityvex) {
            super(entityvex);
        }

        @Override
        public void a() {
            if (this.k == ControllerMove.Operation.b) {
                Vec3D vec3d = new Vec3D(this.e - EntityVex.this.dB(), this.f - EntityVex.this.dD(), this.g - EntityVex.this.dH());
                double d0 = vec3d.g();
                if (d0 < EntityVex.this.cR().a()) {
                    this.k = ControllerMove.Operation.a;
                    EntityVex.this.h(EntityVex.this.dz().c(0.5));
                } else {
                    EntityVex.this.h(EntityVex.this.dz().e(vec3d.c(this.h * 0.05 / d0)));
                    if (EntityVex.this.O_() == null) {
                        Vec3D vec3d1 = EntityVex.this.dz();
                        EntityVex.this.v(-((float)MathHelper.d(vec3d1.d, vec3d1.f)) * 57.295776f);
                        EntityVex.this.aX = EntityVex.this.dM();
                    } else {
                        double d1 = EntityVex.this.O_().dB() - EntityVex.this.dB();
                        double d2 = EntityVex.this.O_().dH() - EntityVex.this.dH();
                        EntityVex.this.v(-((float)MathHelper.d(d1, d2)) * 57.295776f);
                        EntityVex.this.aX = EntityVex.this.dM();
                    }
                }
            }
        }
    }

    private class a
    extends PathfinderGoal {
        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = EntityVex.this.O_();
            return entityliving != null && entityliving.bL() && !EntityVex.this.I().b() && EntityVex.this.ae.a(net.minecraft.world.entity.monster.EntityVex$a.b(7)) == 0 ? EntityVex.this.g((Entity)entityliving) > 4.0 : false;
        }

        @Override
        public boolean c() {
            return EntityVex.this.I().b() && EntityVex.this.go() && EntityVex.this.O_() != null && EntityVex.this.O_().bL();
        }

        @Override
        public void d() {
            EntityLiving entityliving = EntityVex.this.O_();
            if (entityliving != null) {
                Vec3D vec3d = entityliving.bF();
                EntityVex.this.bQ.a(vec3d.d, vec3d.e, vec3d.f, 1.0);
            }
            EntityVex.this.x(true);
            EntityVex.this.a(SoundEffects.Bo, 1.0f, 1.0f);
        }

        @Override
        public void e() {
            EntityVex.this.x(false);
        }

        @Override
        public boolean V_() {
            return true;
        }

        @Override
        public void a() {
            EntityLiving entityliving = EntityVex.this.O_();
            if (entityliving != null) {
                if (EntityVex.this.cR().c(entityliving.cR())) {
                    EntityVex.this.c(net.minecraft.world.entity.monster.EntityVex$a.a(EntityVex.this.dW()), (Entity)entityliving);
                    EntityVex.this.x(false);
                } else {
                    double d0 = EntityVex.this.g((Entity)entityliving);
                    if (d0 < 9.0) {
                        Vec3D vec3d = entityliving.bF();
                        EntityVex.this.bQ.a(vec3d.d, vec3d.e, vec3d.f, 1.0);
                    }
                }
            }
        }
    }

    private class d
    extends PathfinderGoal {
        public d() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return !EntityVex.this.I().b() && EntityVex.this.ae.a(net.minecraft.world.entity.monster.EntityVex$d.b(7)) == 0;
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public void a() {
            BlockPosition blockposition = EntityVex.this.x();
            if (blockposition == null) {
                blockposition = EntityVex.this.dw();
            }
            for (int i2 = 0; i2 < 3; ++i2) {
                BlockPosition blockposition1 = blockposition.b(EntityVex.this.ae.a(15) - 7, EntityVex.this.ae.a(11) - 5, EntityVex.this.ae.a(15) - 7);
                IBlockData blockState = EntityVex.this.dW().getBlockStateIfLoaded(blockposition1);
                if (blockState == null || !blockState.l()) continue;
                EntityVex.this.bQ.a((double)blockposition1.u() + 0.5, (double)blockposition1.v() + 0.5, (double)blockposition1.w() + 0.5, 0.25);
                if (EntityVex.this.O_() != null) break;
                EntityVex.this.H().a((double)blockposition1.u() + 0.5, (double)blockposition1.v() + 0.5, (double)blockposition1.w() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    private class b
    extends PathfinderGoalTarget {
        private final PathfinderTargetCondition b;

        public b(EntityCreature entitycreature) {
            super(entitycreature, false);
            this.b = PathfinderTargetCondition.b().d().e();
        }

        @Override
        public boolean b() {
            return EntityVex.this.bZ != null && EntityVex.this.bZ.O_() != null && this.a(EntityVex.this.bZ.O_(), this.b);
        }

        @Override
        public void d() {
            EntityVex.this.setTarget(EntityVex.this.bZ.O_(), EntityTargetEvent.TargetReason.OWNER_ATTACKED_TARGET, true);
            super.d();
        }
    }
}

