/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.WitchConsumePotionEvent;
import com.destroystokyo.paper.event.entity.WitchThrowPotionEvent;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTargetWitch;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestHealableRaider;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Witch;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.inventory.ItemStack;

public class EntityWitch
extends EntityRaider
implements IRangedEntity {
    private static final MinecraftKey a = MinecraftKey.b("drinking");
    private static final AttributeModifier b = new AttributeModifier(a, -0.25, AttributeModifier.Operation.a);
    private static final DataWatcherObject<Boolean> bZ = DataWatcher.a(EntityWitch.class, DataWatcherRegistry.k);
    public int ca;
    private PathfinderGoalNearestHealableRaider<EntityRaider> cb;
    private PathfinderGoalNearestAttackableTargetWitch<EntityHuman> cc;

    public EntityWitch(EntityTypes<? extends EntityWitch> type, World world) {
        super((EntityTypes<? extends EntityRaider>)type, world);
    }

    @Override
    protected void B() {
        super.B();
        this.cb = new PathfinderGoalNearestHealableRaider<EntityRaider>(this, EntityRaider.class, true, (entityliving, worldserver) -> this.gE() && entityliving.aq() != EntityTypes.bI);
        this.cc = new PathfinderGoalNearestAttackableTargetWitch<EntityHuman>(this, EntityHuman.class, 10, true, false, (PathfinderTargetCondition.a)null);
        this.bT.a(1, new PathfinderGoalFloat(this));
        this.bT.a(2, new PathfinderGoalArrowAttack(this, 1.0, 60, 10.0f));
        this.bT.a(2, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bT.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bT.a(3, new PathfinderGoalRandomLookaround(this));
        this.bU.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class));
        this.bU.a(2, this.cb);
        this.bU.a(3, this.cc);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bZ, false);
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.CR;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.CV;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.CT;
    }

    public void z(boolean drinking) {
        this.au().a(bZ, drinking);
    }

    public boolean m() {
        return this.au().a(bZ);
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gt().a(GenericAttributes.s, 26.0).a(GenericAttributes.v, 0.25);
    }

    @Override
    public void d_() {
        if (!this.dW().C && this.bL()) {
            this.cb.k();
            if (this.cb.i() <= 0) {
                this.cc.a(true);
            } else {
                this.cc.a(false);
            }
            if (this.m()) {
                if (this.ca-- <= 0) {
                    this.z(false);
                    net.minecraft.world.item.ItemStack itemstack = this.eZ();
                    this.a(EnumItemSlot.a, net.minecraft.world.item.ItemStack.j);
                    PotionContents potioncontents = itemstack.a(DataComponents.Q);
                    if (itemstack.a(Items.sZ)) {
                        WitchConsumePotionEvent event = new WitchConsumePotionEvent((Witch)this.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(itemstack));
                        PotionContents potionContents = potioncontents = event.callEvent() ? CraftItemStack.unwrap(event.getPotion()).a(DataComponents.Q) : null;
                    }
                    if (itemstack.a(Items.sZ) && potioncontents != null) {
                        potioncontents.a((MobEffect effect) -> this.addEffect((MobEffect)effect, EntityPotionEffectEvent.Cause.ATTACK));
                    }
                    ((Entity)this).a(GameEvent.l);
                    this.g(GenericAttributes.v).c(b.b());
                }
            } else {
                Holder<PotionRegistry> holder = null;
                if (this.ae.i() < 0.15f && ((Entity)this).a(TagsFluid.a) && !this.b(MobEffects.m)) {
                    holder = Potions.w;
                } else if (this.ae.i() < 0.15f && (this.bY() || this.eG() != null && this.eG().a(DamageTypeTags.i)) && !this.b(MobEffects.l)) {
                    holder = Potions.l;
                } else if (this.ae.i() < 0.05f && this.eE() < this.eS()) {
                    holder = Potions.y;
                } else if (this.ae.i() < 0.5f && this.O_() != null && !this.b(MobEffects.a) && this.O_().g((Entity)this) > 121.0) {
                    holder = Potions.n;
                }
                if (holder != null) {
                    this.setDrinkingPotion(PotionContents.a(Items.sZ, holder));
                }
            }
            if (this.ae.i() < 7.5E-4f) {
                this.dW().a((Entity)this, (byte)15);
            }
        }
        super.d_();
    }

    public void setDrinkingPotion(net.minecraft.world.item.ItemStack potion) {
        potion = CraftEventFactory.handleWitchReadyPotionEvent(this, potion);
        this.a(EnumItemSlot.a, potion);
        this.ca = this.eZ().a(this);
        this.z(true);
        if (!this.bb()) {
            this.dW().a((EntityHuman)null, this.dB(), this.dD(), this.dH(), SoundEffects.CU, this.dn(), 1.0f, 0.8f + this.ae.i() * 0.4f);
        }
        AttributeModifiable attributemodifiable = this.g(GenericAttributes.v);
        attributemodifiable.c(a);
        attributemodifiable.b(b);
    }

    @Override
    public SoundEffect ak_() {
        return SoundEffects.CS;
    }

    @Override
    public void b(byte status) {
        if (status == 15) {
            for (int i2 = 0; i2 < this.ae.a(35) + 10; ++i2) {
                this.dW().a(Particles.ao, this.dB() + this.ae.k() * (double)0.13f, this.cR().e + 0.5 + this.ae.k() * (double)0.13f, this.dH() + this.ae.k() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else {
            super.b(status);
        }
    }

    @Override
    protected float f(DamageSource source, float amount) {
        amount = super.f(source, amount);
        if (source.d() == this) {
            amount = 0.0f;
        }
        if (source.a(DamageTypeTags.k)) {
            amount *= 0.15f;
        }
        return amount;
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        if (!this.m()) {
            Vec3D vec3d = target.dz();
            double d0 = target.dB() + vec3d.d - this.dB();
            double d1 = target.dF() - (double)1.1f - this.dD();
            double d2 = target.dH() + vec3d.f - this.dH();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            Holder<PotionRegistry> holder = Potions.A;
            if (target instanceof EntityRaider) {
                holder = target.eE() <= 4.0f ? Potions.y : Potions.F;
                this.h((EntityLiving)null);
            } else if (d3 >= 8.0 && !target.b(MobEffects.b)) {
                holder = Potions.q;
            } else if (target.eE() >= 8.0f && !target.b(MobEffects.s)) {
                holder = Potions.C;
            } else if (d3 <= 3.0 && !target.b(MobEffects.r) && this.ae.i() < 0.25f) {
                holder = Potions.L;
            }
            World world = this.dW();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                net.minecraft.world.item.ItemStack itemstack = PotionContents.a(Items.we, holder);
                WitchThrowPotionEvent event = new WitchThrowPotionEvent((Witch)this.getBukkitEntity(), (LivingEntity)target.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(itemstack));
                if (!event.callEvent()) {
                    return;
                }
                itemstack = CraftItemStack.asNMSCopy(event.getPotion());
                IProjectile.a(EntityPotion::new, worldserver, itemstack, this, d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
            }
            if (!this.bb()) {
                this.dW().a((EntityHuman)null, this.dB(), this.dD(), this.dH(), SoundEffects.CW, this.dn(), 1.0f, 0.8f + this.ae.i() * 0.4f);
            }
        }
    }

    @Override
    public void a(WorldServer world, int wave, boolean unused) {
    }

    @Override
    public boolean go() {
        return false;
    }
}

