/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicates;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveThroughVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRemoveBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityZombie
extends EntityMonster {
    private static final MinecraftKey a = MinecraftKey.b("baby");
    private final AttributeModifier babyModifier;
    private static final MinecraftKey c = MinecraftKey.b("reinforcement_caller_charge");
    private static final AttributeModifier cc = new AttributeModifier(MinecraftKey.b("reinforcement_callee_charge"), -0.05f, AttributeModifier.Operation.a);
    private static final MinecraftKey cd = MinecraftKey.b("leader_zombie_bonus");
    private static final MinecraftKey ce = MinecraftKey.b("zombie_random_spawn_bonus");
    private static final DataWatcherObject<Boolean> cf = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> cg = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Boolean> ch = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    public static final float d = 0.05f;
    public static final int bZ = 50;
    public static final int ca = 40;
    public static final int cb = 7;
    private static final EntitySize ci = EntityTypes.bO.n().a(0.5f).b(0.93f);
    private static final float cj = 0.1f;
    public static final Predicate<EnumDifficulty> ck = enumdifficulty -> enumdifficulty == EnumDifficulty.d;
    private final PathfinderGoalBreakDoor cl;
    private boolean cm;
    private int cn;
    public int co;
    private boolean shouldBurnInDay;

    public EntityZombie(EntityTypes<? extends EntityZombie> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
        this.babyModifier = new AttributeModifier(a, this.dW().paperConfig().entities.behavior.babyZombieMovementModifier, AttributeModifier.Operation.b);
        this.shouldBurnInDay = true;
        this.cl = new PathfinderGoalBreakDoor(this, (Predicate<EnumDifficulty>)Predicates.in((Collection)world.paperConfig().entities.behavior.doorBreakingDifficulty.getOrDefault(type, world.paperConfig().entities.behavior.doorBreakingDifficulty.get(EntityTypes.bO))));
    }

    public EntityZombie(World world) {
        this((EntityTypes<? extends EntityZombie>)EntityTypes.bO, world);
    }

    @Override
    protected void B() {
        if (this.dW().paperConfig().entities.behavior.zombiesTargetTurtleEggs) {
            this.bT.a(4, new a((EntityCreature)this, 1.0, 3));
        }
        this.bT.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bT.a(8, new PathfinderGoalRandomLookaround(this));
        this.p();
    }

    protected void p() {
        this.bT.a(2, new PathfinderGoalZombieAttack(this, 1.0, false));
        this.bT.a(6, new PathfinderGoalMoveThroughVillage(this, 1.0, true, 4, this::gv));
        this.bT.a(7, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bU.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(EntityPigZombie.class));
        this.bU.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        if (this.dW().spigotConfig.zombieAggressiveTowardsVillager) {
            this.bU.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        }
        this.bU.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.bU.a(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.bZ));
    }

    public static AttributeProvider.Builder gr() {
        return EntityMonster.gt().a(GenericAttributes.m, 35.0).a(GenericAttributes.v, 0.23f).a(GenericAttributes.c, 3.0).a(GenericAttributes.a, 2.0).a(GenericAttributes.A);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cf, false);
        builder.a(cg, 0);
        builder.a(ch, false);
    }

    public boolean gu() {
        return this.au().a(ch);
    }

    public boolean gv() {
        return this.cm;
    }

    public void y(boolean canBreakDoors) {
        if (PathfinderGoalUtil.a(this)) {
            if (this.cm != canBreakDoors) {
                this.cm = canBreakDoors;
                ((Navigation)this.L()).b(canBreakDoors);
                if (canBreakDoors) {
                    this.bT.a(1, this.cl);
                } else {
                    this.bT.a(this.cl);
                }
            }
        } else if (this.cm) {
            this.bT.a(this.cl);
            this.cm = false;
        }
    }

    @Override
    public boolean e_() {
        return this.au().a(cf);
    }

    @Override
    protected int e(WorldServer world) {
        int previousReward = this.bO;
        if (this.e_()) {
            this.bO = (int)((double)this.bO * 2.5);
        }
        int reward = super.e(world);
        this.bO = previousReward;
        return reward;
    }

    @Override
    public void a(boolean baby) {
        this.au().a(cf, baby);
        if (this.dW() != null && !this.dW().C) {
            AttributeModifiable attributemodifiable = this.g(GenericAttributes.v);
            attributemodifiable.c(this.babyModifier.b());
            if (baby) {
                attributemodifiable.b(this.babyModifier);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (cf.equals(data)) {
            this.m_();
        }
        super.a(data);
    }

    protected boolean gp() {
        return true;
    }

    @Override
    public void h() {
        if (!this.dW().C && this.bL() && !this.gb()) {
            if (this.gu()) {
                --this.co;
                if (this.co < 0) {
                    this.ai_();
                }
            } else if (this.gp()) {
                if (((Entity)this).a(TagsFluid.a)) {
                    ++this.cn;
                    if (this.cn >= 600) {
                        this.r(300);
                    }
                } else {
                    this.cn = -1;
                }
            }
        }
        super.h();
    }

    @Override
    public void d_() {
        if (this.bL()) {
            boolean flag;
            boolean bl = flag = this.aj_() && this.gg();
            if (flag) {
                ItemStack itemstack = this.a(EnumItemSlot.f);
                if (!itemstack.f()) {
                    if (itemstack.m()) {
                        Item item = itemstack.h();
                        itemstack.b(itemstack.o() + this.ae.a(2));
                        if (itemstack.o() >= itemstack.p()) {
                            this.a(item, EnumItemSlot.f);
                            this.a(EnumItemSlot.f, ItemStack.j);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.d(8.0f);
                }
            }
        }
        super.d_();
    }

    public void stopDrowning() {
        this.co = -1;
        this.au().a(ch, false);
    }

    public void r(int ticksUntilWaterConversion) {
        this.co = ticksUntilWaterConversion;
        this.au().a(ch, true);
    }

    protected void ai_() {
        this.b(EntityTypes.L);
        if (!this.bb()) {
            this.dW().a((EntityHuman)null, 1040, this.dw(), 0);
        }
    }

    protected void b(EntityTypes<? extends EntityZombie> entityType) {
        EntityZombie converted = this.convertTo(entityType, ConversionParams.a(this, true, true), (T entityzombie) -> entityzombie.J(entityzombie.dW().d_(entityzombie.dw()).d()), EntityTransformEvent.TransformReason.DROWNED, CreatureSpawnEvent.SpawnReason.DROWNED);
        if (converted == null) {
            ((Zombie)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    @VisibleForTesting
    public boolean a(WorldServer world, EntityVillager villager) {
        return EntityZombie.convertVillagerToZombieVillager(world, villager, this.dw(), this.bb(), EntityTransformEvent.TransformReason.INFECTION, CreatureSpawnEvent.SpawnReason.INFECTION) != null;
    }

    public static EntityZombieVillager convertVillagerToZombieVillager(WorldServer worldserver, EntityVillager entityvillager, BlockPosition blockPosition, boolean silent, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityZombieVillager entityzombievillager = entityvillager.convertTo(EntityTypes.bQ, ConversionParams.a(entityvillager, true, true), (T entityzombievillager1) -> {
            entityzombievillager1.a((WorldAccess)worldserver, worldserver.d_(entityzombievillager1.dw()), EntitySpawnReason.i, new GroupDataZombie(false, true));
            entityzombievillager1.a(entityvillager.gy());
            entityzombievillager1.a(entityvillager.gI().a(DynamicOpsNBT.a));
            entityzombievillager1.a(entityvillager.gq().a());
            entityzombievillager1.s(entityvillager.x());
            if (!silent) {
                worldserver.a((EntityHuman)null, 1026, blockPosition, 0);
            }
        }, transformReason, spawnReason);
        return entityzombievillager;
    }

    public boolean aj_() {
        return this.shouldBurnInDay;
    }

    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.shouldBurnInDay = shouldBurnInDay;
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        if (!super.a(world, source, amount)) {
            return false;
        }
        EntityLiving entityliving = this.O_();
        if (entityliving == null && source.d() instanceof EntityLiving) {
            entityliving = (EntityLiving)source.d();
        }
        if (entityliving != null && world.al() == EnumDifficulty.d && (double)this.ae.i() < this.h(GenericAttributes.A) && world.N().b(GameRules.e)) {
            int i2 = MathHelper.a(this.dB());
            int j2 = MathHelper.a(this.dD());
            int k2 = MathHelper.a(this.dH());
            EntityTypes<? extends EntityZombie> entitytypes = this.aq();
            EntityZombie entityzombie = entitytypes.a(world, EntitySpawnReason.j);
            if (entityzombie == null) {
                return true;
            }
            for (int l2 = 0; l2 < 50; ++l2) {
                int k1;
                int j1;
                int i1 = i2 + MathHelper.a(this.ae, 7, 40) * MathHelper.a(this.ae, -1, 1);
                BlockPosition blockposition = new BlockPosition(i1, j1 = j2 + MathHelper.a(this.ae, 7, 40) * MathHelper.a(this.ae, -1, 1), k1 = k2 + MathHelper.a(this.ae, 7, 40) * MathHelper.a(this.ae, -1, 1));
                if (!EntityPositionTypes.a(entitytypes, world, blockposition) || !EntityPositionTypes.a(entitytypes, world, EntitySpawnReason.j, blockposition, world.A)) continue;
                entityzombie.a_(i1, j1, k1);
                if (world.hasNearbyAlivePlayerThatAffectsSpawning(i1, j1, k1, 7.0) || !world.f(entityzombie) || !world.g(entityzombie) || !entityzombie.x() && world.d(entityzombie.cR())) continue;
                entityzombie.setTarget(entityliving, EntityTargetEvent.TargetReason.REINFORCEMENT_TARGET, true);
                entityzombie.a((WorldAccess)world, world.d_(entityzombie.dw()), EntitySpawnReason.j, (GroupDataEntity)null);
                world.addFreshEntityWithPassengers(entityzombie, CreatureSpawnEvent.SpawnReason.REINFORCEMENTS);
                AttributeModifiable attributemodifiable = this.g(GenericAttributes.A);
                AttributeModifier attributemodifier = attributemodifiable.a(c);
                double d0 = attributemodifier != null ? attributemodifier.c() : 0.0;
                attributemodifiable.c(c);
                attributemodifiable.d(new AttributeModifier(c, d0 - 0.05, AttributeModifier.Operation.a));
                entityzombie.g(GenericAttributes.A).d(cc);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean c(WorldServer world, Entity target) {
        boolean flag = super.c(world, target);
        if (flag) {
            float f2 = this.dW().d_(this.dw()).b();
            if (this.eZ().f() && this.bY() && this.ae.i() < f2 * 0.3f) {
                EntityCombustByEntityEvent event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), (float)(2 * (int)f2));
                this.dW().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    target.igniteForSeconds(event.getDuration(), false);
                }
            }
        }
        return flag;
    }

    @Override
    protected SoundEffect u() {
        return SoundEffects.DS;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.Ec;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.DX;
    }

    protected SoundEffect t() {
        return SoundEffects.Ei;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(this.t(), 0.15f, 1.0f);
    }

    public EntityTypes<? extends EntityZombie> aq() {
        return super.aq();
    }

    protected boolean x() {
        return false;
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        super.a(random, localDifficulty);
        float f2 = random.i();
        float f3 = this.dW().al() == EnumDifficulty.d ? 0.05f : 0.01f;
        if (f2 < f3) {
            int i2 = random.a(3);
            if (i2 == 0) {
                this.a(EnumItemSlot.a, new ItemStack(Items.px));
            } else {
                this.a(EnumItemSlot.a, new ItemStack(Items.py));
            }
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("IsBaby", this.e_());
        nbt.a("CanBreakDoors", this.gv());
        nbt.a("InWaterTime", this.bj() ? this.cn : -1);
        nbt.a("DrownedConversionTime", this.gu() ? this.co : -1);
        nbt.a("Paper.ShouldBurnInDay", this.shouldBurnInDay);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(nbt.q("IsBaby"));
        this.y(nbt.q("CanBreakDoors"));
        this.cn = nbt.h("InWaterTime");
        if (nbt.b("DrownedConversionTime", 99) && nbt.h("DrownedConversionTime") > -1) {
            this.r(nbt.h("DrownedConversionTime"));
        }
        if (nbt.e("Paper.ShouldBurnInDay")) {
            this.shouldBurnInDay = nbt.q("Paper.ShouldBurnInDay");
        }
    }

    @Override
    public boolean a(WorldServer world, EntityLiving other) {
        EntityVillager entityvillager;
        double fallbackChance;
        boolean flag = super.a(world, other);
        double d2 = world.al() == EnumDifficulty.d ? 100.0 : (fallbackChance = world.al() == EnumDifficulty.c ? 50.0 : 0.0);
        if (this.ae.j() * 100.0 < world.paperConfig().entities.behavior.zombieVillagerInfectionChance.or(fallbackChance) && other instanceof EntityVillager && this.a(world, entityvillager = (EntityVillager)other)) {
            flag = false;
        }
        return flag;
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? ci : super.e(pose);
    }

    @Override
    public boolean g(ItemStack stack) {
        return stack.a(Items.rp) && this.e_() && this.bZ() ? false : super.g(stack);
    }

    @Override
    public boolean c(WorldServer world, ItemStack stack) {
        return stack.a(Items.rU) ? false : super.c(world, stack);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        RandomSource randomsource = world.H_();
        GroupDataEntity object = super.a(world, difficulty, spawnReason, entityData);
        float f2 = difficulty.d();
        if (spawnReason != EntitySpawnReason.i) {
            this.a_(this.dW().paperConfig().entities.behavior.mobsCanAlwaysPickUpLoot.zombies || randomsource.i() < 0.55f * f2);
        }
        if (object == null) {
            object = new GroupDataZombie(EntityZombie.a(randomsource), true);
        }
        if (object instanceof GroupDataZombie) {
            GroupDataZombie entityzombie_groupdatazombie = (GroupDataZombie)object;
            if (entityzombie_groupdatazombie.a) {
                this.a(true);
                if (entityzombie_groupdatazombie.b) {
                    EntityChicken entitychicken1;
                    if ((double)randomsource.i() < 0.05) {
                        List<Entity> list = world.a(EntityChicken.class, this.cR().c(5.0, 3.0, 5.0), IEntitySelector.c);
                        if (!list.isEmpty()) {
                            EntityChicken entitychicken = (EntityChicken)list.get(0);
                            entitychicken.x(true);
                            this.n(entitychicken);
                        }
                    } else if ((double)randomsource.i() < 0.05 && (entitychicken1 = EntityTypes.z.a(this.dW(), EntitySpawnReason.g)) != null) {
                        entitychicken1.b(this.dB(), this.dD(), this.dH(), this.dM(), 0.0f);
                        entitychicken1.a(world, difficulty, EntitySpawnReason.g, (GroupDataEntity)null);
                        entitychicken1.x(true);
                        this.n(entitychicken1);
                        world.addFreshEntity(entitychicken1, CreatureSpawnEvent.SpawnReason.MOUNT);
                    }
                }
            }
            this.y(randomsource.i() < f2 * 0.1f);
            if (spawnReason != EntitySpawnReason.i) {
                this.a(randomsource, difficulty);
                this.a(world, randomsource, difficulty);
            }
        }
        if (this.a(EnumItemSlot.f).f()) {
            LocalDate localdate = LocalDate.now();
            int i2 = localdate.get(ChronoField.DAY_OF_MONTH);
            int j2 = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j2 == 10 && i2 == 31 && randomsource.i() < 0.25f) {
                this.a(EnumItemSlot.f, new ItemStack(randomsource.i() < 0.1f ? Blocks.es : Blocks.er));
                this.bW[EnumItemSlot.f.b()] = 0.0f;
            }
        }
        this.J(f2);
        return object;
    }

    @VisibleForTesting
    public void b(int inWaterTime) {
        this.cn = inWaterTime;
    }

    @VisibleForTesting
    public void c(int ticksUntilWaterConversion) {
        this.co = ticksUntilWaterConversion;
    }

    public static boolean a(RandomSource random) {
        return random.i() < 0.05f;
    }

    protected void J(float chanceMultiplier) {
        this.gw();
        this.g(GenericAttributes.p).c(new AttributeModifier(EntityInsentient.bM, this.ae.j() * (double)0.05f, AttributeModifier.Operation.a));
        double d0 = this.ae.j() * 1.5 * (double)chanceMultiplier;
        if (d0 > 1.0) {
            this.g(GenericAttributes.m).c(new AttributeModifier(ce, d0, AttributeModifier.Operation.c));
        }
        if (this.ae.i() < chanceMultiplier * 0.05f) {
            this.g(GenericAttributes.A).c(new AttributeModifier(cd, this.ae.j() * 0.25 + 0.5, AttributeModifier.Operation.a));
            this.g(GenericAttributes.s).c(new AttributeModifier(cd, this.ae.j() * 3.0 + 1.0, AttributeModifier.Operation.c));
            this.y(true);
        }
    }

    protected void gw() {
        this.g(GenericAttributes.A).a(this.ae.j() * (double)0.1f);
    }

    @Override
    protected void a(WorldServer world, DamageSource source, boolean causedByPlayer) {
        ItemStack itemstack;
        EntityCreeper entitycreeper;
        super.a(world, source, causedByPlayer);
        Entity entity = source.d();
        if (entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).gp() && !(itemstack = this.go()).f()) {
            entitycreeper.gq();
            this.a(world, itemstack);
        }
    }

    protected ItemStack go() {
        return new ItemStack(Items.ve);
    }

    private class a
    extends PathfinderGoalRemoveBlock {
        a(EntityCreature mob, double speed, int range) {
            super(Blocks.mA, mob, speed, range);
        }

        @Override
        public void a(GeneratorAccess world, BlockPosition pos) {
            world.a((EntityHuman)null, pos, SoundEffects.DY, SoundCategory.f, 0.5f, 0.9f + EntityZombie.this.ae.i() * 0.2f);
        }

        @Override
        public void a(World world, BlockPosition pos) {
            world.a((EntityHuman)null, pos, SoundEffects.AH, SoundCategory.e, 0.7f, 0.9f + world.A.i() * 0.2f);
        }

        @Override
        public double i() {
            return 1.14;
        }
    }

    public static class GroupDataZombie
    implements GroupDataEntity {
        public final boolean a;
        public final boolean b;

        public GroupDataZombie(boolean baby, boolean tryChickenJockey) {
            this.a = baby;
            this.b = tryChickenJockey;
        }
    }
}

