/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.slf4j.Logger;

public class EntityZombieVillager
extends EntityZombie
implements VillagerDataHolder {
    private static final Logger a = LogUtils.getLogger();
    public static final DataWatcherObject<Boolean> b = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<VillagerData> c = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.u);
    private static final int cc = 3600;
    private static final int cd = 6000;
    private static final int ce = 14;
    private static final int cf = 4;
    public int cg;
    @Nullable
    public UUID ch;
    @Nullable
    private NBTBase ci;
    @Nullable
    private MerchantRecipeList cj;
    private int ck;
    private int lastTick = MinecraftServer.currentTick;

    public EntityZombieVillager(EntityTypes<? extends EntityZombieVillager> type, World world) {
        super((EntityTypes<? extends EntityZombie>)type, world);
        BuiltInRegistries.x.a(this.ae).ifPresent(holder_c -> this.a(this.gy().a((VillagerProfession)holder_c.a())));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(b, false);
        builder.a(c, new VillagerData(VillagerType.c, VillagerProfession.b, 1));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = VillagerData.c.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.gy());
        Logger logger = a;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("VillagerData", (NBTBase)nbtbase));
        if (this.cj != null) {
            nbt.a("Offers", (NBTBase)MerchantRecipeList.a.encodeStart(this.dY().a(DynamicOpsNBT.a), (Object)this.cj).getOrThrow());
        }
        if (this.ci != null) {
            nbt.a("Gossips", this.ci);
        }
        nbt.a("ConversionTime", this.gx() ? this.cg : -1);
        if (this.ch != null) {
            nbt.a("ConversionPlayer", this.ch);
        }
        nbt.a("Xp", this.ck);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("VillagerData", 10)) {
            DataResult dataresult = VillagerData.c.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("VillagerData")));
            Logger logger = a;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(this::a);
        }
        if (nbt.e("Offers")) {
            DataResult dataresult1 = MerchantRecipeList.a.parse(this.dY().a(DynamicOpsNBT.a), (Object)nbt.c("Offers"));
            Logger logger1 = a;
            Objects.requireNonNull(logger1);
            dataresult1.resultOrPartial(SystemUtils.a("Failed to load offers: ", arg_0 -> ((Logger)logger1).warn(arg_0))).ifPresent(merchantrecipelist -> {
                this.cj = merchantrecipelist;
            });
        }
        if (nbt.b("Gossips", 9)) {
            this.ci = nbt.c("Gossips", 10);
        }
        if (nbt.b("ConversionTime", 99) && nbt.h("ConversionTime") > -1) {
            this.a(nbt.b("ConversionPlayer") ? nbt.a("ConversionPlayer") : null, nbt.h("ConversionTime"));
        }
        if (nbt.b("Xp", 3)) {
            this.ck = nbt.h("Xp");
        }
    }

    @Override
    public void h() {
        if (!this.dW().C && this.bL() && this.gx()) {
            int i2 = this.gA();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            this.cg -= (i2 *= elapsedTicks);
            if (this.cg <= 0) {
                this.g((WorldServer)this.dW());
            }
        }
        super.h();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.qw)) {
            if (this.b(MobEffects.r)) {
                itemstack.a(1, (EntityLiving)player);
                if (!this.dW().C) {
                    this.a(player.cG(), this.ae.a(2401) + 3600);
                }
                return EnumInteractionResult.b;
            }
            return EnumInteractionResult.c;
        }
        return super.b(player, hand);
    }

    @Override
    protected boolean gp() {
        return false;
    }

    @Override
    public boolean h(double distanceSquared) {
        return !this.gx() && this.ck == 0;
    }

    public boolean gx() {
        return this.au().a(b);
    }

    public void a(@Nullable UUID uuid, int delay) {
        this.startConverting(uuid, delay, true);
    }

    public void startConverting(@Nullable UUID uuid, int delay, boolean broadcastEntityEvent) {
        this.ch = uuid;
        this.cg = delay;
        this.au().a(b, true);
        this.removeEffect(MobEffects.r, EntityPotionEffectEvent.Cause.CONVERSION);
        this.addEffect(new MobEffect(MobEffects.e, delay, Math.min(this.dW().al().a() - 1, 0)), EntityPotionEffectEvent.Cause.CONVERSION);
        if (broadcastEntityEvent) {
            this.dW().a((Entity)this, (byte)16);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 16) {
            if (!this.bb()) {
                this.dW().a(this.dB(), this.dF(), this.dH(), SoundEffects.El, this.dn(), 1.0f + this.ae.i(), this.ae.i() * 0.7f + 0.3f, false);
            }
        } else {
            super.b(status);
        }
    }

    private void g(WorldServer world) {
        EntityVillager converted = this.convertTo(EntityTypes.bD, ConversionParams.a(this, false, false), (T entityvillager) -> {
            EntityHuman entityhuman;
            Iterator<EnumItemSlot> iterator = this.a(world, (ItemStack itemstack) -> !EnchantmentManager.a(itemstack, EnchantmentEffectComponents.E)).iterator();
            this.forceDrops = false;
            while (iterator.hasNext()) {
                EnumItemSlot enumitemslot = iterator.next();
                SlotAccess slotaccess = entityvillager.a_(enumitemslot.b() + 300);
                slotaccess.a(this.a(enumitemslot));
            }
            entityvillager.a(this.gy());
            if (this.ci != null) {
                entityvillager.a(this.ci);
            }
            if (this.cj != null) {
                entityvillager.b(this.cj.a());
            }
            entityvillager.t(this.ck);
            entityvillager.a((WorldAccess)world, world.d_(entityvillager.dw()), EntitySpawnReason.i, (GroupDataEntity)null);
            entityvillager.g(world);
            if (this.ch != null && (entityhuman = world.getGlobalPlayerByUUID(this.ch)) instanceof EntityPlayer) {
                CriterionTriggers.s.a((EntityPlayer)entityhuman, this, (EntityVillager)entityvillager);
                world.a(ReputationEvent.a, (Entity)entityhuman, (ReputationHandler)((Object)entityvillager));
            }
            entityvillager.addEffect(new MobEffect(MobEffects.i, 200, 0), EntityPotionEffectEvent.Cause.CONVERSION);
            if (!this.bb()) {
                world.a((EntityHuman)null, 1027, this.dw(), 0);
            }
        }, EntityTransformEvent.TransformReason.CURED, CreatureSpawnEvent.SpawnReason.CURED);
        if (converted == null) {
            ((ZombieVillager)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    @Override
    @VisibleForTesting
    public void r(int conversionTimer) {
        this.cg = conversionTimer;
    }

    private int gA() {
        int i2 = 1;
        if (this.ae.i() < 0.01f) {
            int j2 = 0;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int k2 = (int)this.dB() - 4; k2 < (int)this.dB() + 4 && j2 < 14; ++k2) {
                for (int l2 = (int)this.dD() - 4; l2 < (int)this.dD() + 4 && j2 < 14; ++l2) {
                    for (int i1 = (int)this.dH() - 4; i1 < (int)this.dH() + 4 && j2 < 14; ++i1) {
                        IBlockData iblockdata = this.dW().a_(blockposition_mutableblockposition.d(k2, l2, i1));
                        if (!iblockdata.a(Blocks.fk) && !(iblockdata.b() instanceof BlockBed)) continue;
                        if (this.ae.i() < 0.3f) {
                            ++i2;
                        }
                        ++j2;
                    }
                }
            }
        }
        return i2;
    }

    @Override
    public float fh() {
        return this.e_() ? (this.ae.i() - this.ae.i()) * 0.2f + 2.0f : (this.ae.i() - this.ae.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEffect u() {
        return SoundEffects.Ej;
    }

    @Override
    public SoundEffect e(DamageSource source) {
        return SoundEffects.En;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.Em;
    }

    @Override
    public SoundEffect t() {
        return SoundEffects.Eo;
    }

    @Override
    protected ItemStack go() {
        return ItemStack.j;
    }

    @Override
    public void a(MerchantRecipeList offerData) {
        this.cj = offerData;
    }

    @Override
    public void a(NBTBase gossipData) {
        this.ci = gossipData;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        this.a(this.gy().a(VillagerType.a(world.t(this.dw()))));
        return super.a(world, difficulty, spawnReason, entityData);
    }

    @Override
    public void a(VillagerData villagerData) {
        VillagerData villagerdata1 = this.gy();
        if (villagerdata1.b() != villagerData.b()) {
            this.cj = null;
        }
        this.al.a(c, villagerData);
    }

    @Override
    public VillagerData gy() {
        return this.al.a(c);
    }

    public int gz() {
        return this.ck;
    }

    public void s(int xp) {
        this.ck = xp;
    }
}

