/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.breeze;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorSwim;
import net.minecraft.world.entity.ai.behavior.LongJumpUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.breeze.BreezeUtil;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class LongJump
extends Behavior<Breeze> {
    private static final int c = 4;
    private static final int d = 10;
    private static final int e = 2;
    private static final int f = Math.round(10.0f);
    private static final float g = 24.0f;
    private static final float h = 1.4f;
    private static final float i = 0.058333334f;
    private static final ObjectArrayList<Integer> j = new ObjectArrayList((Collection)Lists.newArrayList((Object[])new Integer[]{40, 55, 60, 75, 80}));

    @VisibleForTesting
    public LongJump() {
        super(Map.of(MemoryModuleType.o, MemoryStatus.a, MemoryModuleType.aU, MemoryStatus.b, MemoryModuleType.aZ, MemoryStatus.c, MemoryModuleType.ba, MemoryStatus.c, MemoryModuleType.aV, MemoryStatus.b, MemoryModuleType.m, MemoryStatus.b, MemoryModuleType.bb, MemoryStatus.c), 200);
    }

    public static boolean a(WorldServer world, Breeze breeze) {
        if (!breeze.aJ() && !breeze.bj()) {
            return false;
        }
        if (BehaviorSwim.a(breeze)) {
            return false;
        }
        if (breeze.ec().a(MemoryModuleType.ba, MemoryStatus.a)) {
            return true;
        }
        EntityLiving livingEntity = breeze.ec().c(MemoryModuleType.o).orElse(null);
        if (livingEntity == null) {
            return false;
        }
        if (LongJump.a(breeze, livingEntity)) {
            breeze.ec().b(MemoryModuleType.o);
            return false;
        }
        if (LongJump.b(breeze, livingEntity)) {
            return false;
        }
        if (!LongJump.c(world, breeze)) {
            return false;
        }
        BlockPosition blockPos = LongJump.a((EntityLiving)breeze, BreezeUtil.a(livingEntity, breeze.dZ()));
        if (blockPos == null) {
            return false;
        }
        IBlockData blockState = world.a_(blockPos.e());
        if (breeze.aq().a(blockState)) {
            return false;
        }
        if (!BreezeUtil.a(breeze, blockPos.b()) && !BreezeUtil.a(breeze, blockPos.b(4).b())) {
            return false;
        }
        breeze.ec().a(MemoryModuleType.ba, blockPos);
        return true;
    }

    @Override
    protected boolean b(WorldServer serverLevel, Breeze breeze) {
        return LongJump.a(serverLevel, breeze);
    }

    @Override
    @Override
    protected boolean a(WorldServer world, Breeze entity, long time) {
        return entity.aw() != EntityPose.a && !entity.ec().a(MemoryModuleType.aU);
    }

    @Override
    @Override
    protected void b(WorldServer serverLevel, Breeze breeze, long l2) {
        if (breeze.ec().a(MemoryModuleType.aZ, MemoryStatus.b)) {
            breeze.ec().a(MemoryModuleType.aZ, Unit.a, f);
        }
        breeze.b(EntityPose.r);
        serverLevel.a(null, breeze, SoundEffects.cE, SoundCategory.f, 1.0f, 1.0f);
        breeze.ec().c(MemoryModuleType.ba).ifPresent(jumpTarget -> breeze.a(ArgumentAnchor.Anchor.b, jumpTarget.b()));
    }

    @Override
    @Override
    protected void c(WorldServer world, Breeze entity, long time) {
        boolean bl = entity.bj();
        if (!bl && entity.ec().a(MemoryModuleType.bb, MemoryStatus.a)) {
            entity.ec().b(MemoryModuleType.bb);
        }
        if (LongJump.a(entity)) {
            Vec3D vec3 = entity.ec().c(MemoryModuleType.ba).flatMap(jumpTarget -> LongJump.a(entity, entity.dZ(), Vec3D.c(jumpTarget))).orElse(null);
            if (vec3 == null) {
                entity.b(EntityPose.a);
                return;
            }
            if (bl) {
                entity.ec().a(MemoryModuleType.bb, Unit.a);
            }
            entity.a(SoundEffects.cK, 1.0f, 1.0f);
            entity.b(EntityPose.g);
            entity.v(entity.aX);
            entity.r(true);
            entity.h(vec3);
        } else if (LongJump.b(entity)) {
            entity.a(SoundEffects.cL, 1.0f, 1.0f);
            entity.b(EntityPose.a);
            entity.r(false);
            boolean bl2 = entity.ec().a(MemoryModuleType.x);
            entity.ec().a(MemoryModuleType.aU, Unit.a, bl2 ? 2L : 10L);
            entity.ec().a(MemoryModuleType.aV, Unit.a, 100L);
        }
    }

    @Override
    @Override
    protected void d(WorldServer serverLevel, Breeze breeze, long l2) {
        if (breeze.aw() == EntityPose.g || breeze.aw() == EntityPose.r) {
            breeze.b(EntityPose.a);
        }
        breeze.ec().b(MemoryModuleType.ba);
        breeze.ec().b(MemoryModuleType.aZ);
        breeze.ec().b(MemoryModuleType.bb);
    }

    private static boolean a(Breeze breeze) {
        return breeze.ec().c(MemoryModuleType.aZ).isEmpty() && breeze.aw() == EntityPose.r;
    }

    private static boolean b(Breeze breeze) {
        boolean bl = breeze.aw() == EntityPose.g;
        boolean bl2 = breeze.aJ();
        boolean bl3 = breeze.bj() && breeze.ec().a(MemoryModuleType.bb, MemoryStatus.b);
        return bl && (bl2 || bl3);
    }

    @Nullable
    private static BlockPosition a(EntityLiving breeze, Vec3D pos) {
        RayTrace clipContext = new RayTrace(pos, pos.a(EnumDirection.a, 10.0), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, breeze);
        MovingObjectPositionBlock hitResult = breeze.dW().a(clipContext);
        if (((MovingObjectPosition)hitResult).d() == MovingObjectPosition.EnumMovingObjectType.b) {
            return BlockPosition.a(hitResult.g()).d();
        }
        RayTrace clipContext2 = new RayTrace(pos, pos.a(EnumDirection.b, 10.0), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, breeze);
        MovingObjectPositionBlock hitResult2 = breeze.dW().a(clipContext2);
        if (((MovingObjectPosition)hitResult2).d() == MovingObjectPosition.EnumMovingObjectType.b) {
            return BlockPosition.a(hitResult2.g()).d();
        }
        return null;
    }

    private static boolean a(Breeze breeze, EntityLiving target) {
        return !target.a((Entity)breeze, breeze.h(GenericAttributes.m));
    }

    private static boolean b(Breeze breeze, EntityLiving target) {
        return target.f((Entity)breeze) - 4.0f <= 0.0f;
    }

    private static boolean c(WorldServer world, Breeze breeze) {
        BlockPosition blockPos = breeze.dw();
        if (world.a_(blockPos).a(Blocks.pB)) {
            return false;
        }
        for (int i2 = 1; i2 <= 4; ++i2) {
            BlockPosition blockPos2 = blockPos.a(EnumDirection.b, i2);
            if (world.a_(blockPos2).l() || world.b_(blockPos2).a(TagsFluid.a)) continue;
            return false;
        }
        return true;
    }

    private static Optional<Vec3D> a(Breeze breeze, RandomSource random, Vec3D jumpTarget) {
        List<Integer> list = SystemUtils.a(j, random);
        for (int i2 : list) {
            float f2 = 0.058333334f * (float)breeze.h(GenericAttributes.m);
            Optional<Vec3D> optional = LongJumpUtil.a(breeze, jumpTarget, f2, i2, false);
            if (!optional.isPresent()) continue;
            if (breeze.b(MobEffects.h)) {
                double d2 = optional.get().d().e * (double)breeze.fk();
                return optional.map(vec3 -> vec3.b(0.0, d2, 0.0));
            }
            return optional;
        }
        return Optional.empty();
    }

    @Override
    protected /* synthetic */ boolean a(WorldServer world, EntityLiving entity) {
        return this.b(world, (Breeze)entity);
    }

    @Override
    protected /* synthetic */ void b(WorldServer world, EntityLiving entity, long time) {
        this.d(world, (Breeze)entity, time);
    }

    @Override
    protected /* synthetic */ void d(WorldServer world, EntityLiving entity, long time) {
        this.b(world, (Breeze)entity, time);
    }
}

