/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.hoglin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.hoglin.HoglinAI;
import net.minecraft.world.entity.monster.hoglin.IOglin;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityHoglin
extends EntityAnimal
implements IMonster,
IOglin {
    private static final DataWatcherObject<Boolean> cd = DataWatcher.a(EntityHoglin.class, DataWatcherRegistry.k);
    private static final int ce = 40;
    private static final float cf = 0.3f;
    private static final int cg = 1;
    private static final float ch = 0.6f;
    private static final int ci = 6;
    private static final float cj = 0.5f;
    public static final int bZ = 300;
    private int ck;
    public int cl;
    public boolean cm;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super EntityHoglin>>> ca = ImmutableList.of(SensorType.c, SensorType.d, SensorType.o, SensorType.n);
    protected static final ImmutableList<? extends MemoryModuleType<?>> cb = ImmutableList.of(MemoryModuleType.r, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.n, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.o, MemoryModuleType.p, MemoryModuleType.aq, (Object[])new MemoryModuleType[]{MemoryModuleType.z, MemoryModuleType.as, MemoryModuleType.at, MemoryModuleType.ap, MemoryModuleType.K, MemoryModuleType.aw, MemoryModuleType.ax, MemoryModuleType.Z});

    public EntityHoglin(EntityTypes<? extends EntityHoglin> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.bO = 5;
    }

    @VisibleForTesting
    public void s(int timeInOverworld) {
        this.cl = timeInOverworld;
    }

    @Override
    public boolean y() {
        return true;
    }

    public static AttributeProvider.Builder p() {
        return EntityMonster.gt().a(GenericAttributes.s, 40.0).a(GenericAttributes.v, 0.3f).a(GenericAttributes.p, 0.6f).a(GenericAttributes.d, 1.0).a(GenericAttributes.c, 6.0);
    }

    @Override
    public boolean c(WorldServer world, Entity target) {
        if (target instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)target;
            this.ck = 10;
            this.dW().a((Entity)this, (byte)4);
            this.b(SoundEffects.mI);
            HoglinAI.a(this, entityliving);
            return IOglin.a(world, this, entityliving);
        }
        return false;
    }

    @Override
    protected void e(EntityLiving target) {
        if (this.t()) {
            IOglin.a(this, target);
        }
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        Entity entity;
        boolean flag = super.a(world, source, amount);
        if (flag && (entity = source.d()) instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            HoglinAI.a(world, this, entityliving);
        }
        return flag;
    }

    protected BehaviorController.b<EntityHoglin> ed() {
        return BehaviorController.a(cb, ca);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return HoglinAI.a(this.ed().a(dynamic));
    }

    public BehaviorController<EntityHoglin> ec() {
        return super.ec();
    }

    @Override
    protected void a(WorldServer world) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("hoglinBrain");
        this.ec().a(world, this);
        gameprofilerfiller.c();
        HoglinAI.a(this);
        if (this.go()) {
            ++this.cl;
            if (this.cl > 300) {
                this.b(SoundEffects.mJ);
                this.gq();
            }
        } else {
            this.cl = 0;
        }
    }

    @Override
    public void d_() {
        if (this.ck > 0) {
            --this.ck;
        }
        super.d_();
    }

    @Override
    protected void i() {
        if (this.e_()) {
            this.bO = 3;
            this.g(GenericAttributes.c).a(0.5);
        } else {
            this.bO = 5;
            this.g(GenericAttributes.c).a(6.0);
        }
    }

    public static boolean c(EntityTypes<EntityHoglin> type, GeneratorAccess world, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return !world.a_(pos.e()).a(Blocks.lf);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        if (world.H_().i() < 0.2f) {
            this.a(true);
        }
        return super.a(world, difficulty, spawnReason, entityData);
    }

    @Override
    public boolean h(double distanceSquared) {
        return !this.aj();
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return HoglinAI.a(this, pos) ? -1.0f : (world.a_(pos.e()).a(Blocks.oR) ? 10.0f : 0.0f);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (enuminteractionresult.a()) {
            this.ai();
        }
        return enuminteractionresult;
    }

    @Override
    public void b(byte status) {
        if (status == 4) {
            this.ck = 10;
            this.b(SoundEffects.mI);
        } else {
            super.b(status);
        }
    }

    @Override
    public int x() {
        return this.ck;
    }

    @Override
    public boolean en() {
        return true;
    }

    @Override
    protected int e(WorldServer world) {
        return this.bO;
    }

    private void gq() {
        EntityZoglin converted = this.convertTo(EntityTypes.bN, ConversionParams.a(this, true, false), (T entityzoglin) -> entityzoglin.a(new MobEffect(MobEffects.i, 200, 0)), EntityTransformEvent.TransformReason.PIGLIN_ZOMBIFIED, CreatureSpawnEvent.SpawnReason.PIGLIN_ZOMBIFIED);
        if (converted == null) {
            this.cl = 0;
        }
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.ar);
    }

    public boolean t() {
        return !this.e_();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cd, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.gr()) {
            nbt.a("IsImmuneToZombification", true);
        }
        nbt.a("TimeInOverworld", this.cl);
        if (this.cm) {
            nbt.a("CannotBeHunted", true);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.x(nbt.q("IsImmuneToZombification"));
        this.cl = nbt.h("TimeInOverworld");
        this.y(nbt.q("CannotBeHunted"));
    }

    public void x(boolean immuneToZombification) {
        this.au().a(cd, immuneToZombification);
    }

    public boolean gr() {
        return this.au().a(cd);
    }

    public boolean go() {
        return !this.dW().G_().b() && !this.gr() && !this.gb();
    }

    private void y(boolean cannotBeHunted) {
        this.cm = cannotBeHunted;
    }

    public boolean gp() {
        return this.t() && !this.cm;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        EntityHoglin entityhoglin = EntityTypes.ak.a(world, EntitySpawnReason.e);
        if (entityhoglin != null) {
            entityhoglin.ai();
        }
        return entityhoglin;
    }

    @Override
    public boolean gv() {
        return !HoglinAI.c(this) && super.gv();
    }

    @Override
    public SoundCategory dn() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect u() {
        return this.dW().C ? null : (SoundEffect)HoglinAI.b(this).orElse(null);
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.mL;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.mK;
    }

    @Override
    protected SoundEffect aV() {
        return SoundEffects.nq;
    }

    @Override
    protected SoundEffect aW() {
        return SoundEffects.np;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.mN, 0.15f, 1.0f);
    }

    @Override
    protected void Y() {
        super.Y();
        PacketDebug.a(this);
    }

    @Override
    @Nullable
    public EntityLiving O_() {
        return this.O();
    }
}

