/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinArmPose;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityPiglin
extends EntityPiglinAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> ca = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cb = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cc = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final MinecraftKey cd = MinecraftKey.b("baby");
    private static final AttributeModifier ce = new AttributeModifier(cd, 0.2f, AttributeModifier.Operation.b);
    private static final int cf = 16;
    private static final float cg = 0.35f;
    private static final int ch = 5;
    private static final float ci = 0.1f;
    private static final int cj = 3;
    private static final float ck = 0.2f;
    private static final EntitySize cl = EntityTypes.aS.n().a(0.5f).b(0.97f);
    private static final double cm = 0.5;
    public final InventorySubcontainer cn = new InventorySubcontainer(8);
    public boolean co;
    protected static final ImmutableList<SensorType<? extends Sensor<? super EntityPiglin>>> d = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.f, SensorType.l);
    protected static final ImmutableList<MemoryModuleType<?>> bZ = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.v, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.ao, MemoryModuleType.an, MemoryModuleType.L, MemoryModuleType.aP, MemoryModuleType.x, MemoryModuleType.y, (Object[])new MemoryModuleType[]{MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.o, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.t, MemoryModuleType.ab, MemoryModuleType.ac, MemoryModuleType.z, MemoryModuleType.ad, MemoryModuleType.ae, MemoryModuleType.ag, MemoryModuleType.af, MemoryModuleType.ai, MemoryModuleType.aj, MemoryModuleType.ah, MemoryModuleType.al, MemoryModuleType.M, MemoryModuleType.ar, MemoryModuleType.s, MemoryModuleType.as, MemoryModuleType.at, MemoryModuleType.ak, MemoryModuleType.am, MemoryModuleType.au, MemoryModuleType.av, MemoryModuleType.aw});
    public Set<Item> allowedBarterItems = new HashSet<Item>();
    public Set<Item> interestItems = new HashSet<Item>();

    public EntityPiglin(EntityTypes<? extends EntityPiglinAbstract> type, World world) {
        super(type, world);
        this.bO = 5;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.e_()) {
            nbt.a("IsBaby", true);
        }
        if (this.co) {
            nbt.a("CannotHunt", true);
        }
        this.b(nbt, this.dY());
        NBTTagList barterList = new NBTTagList();
        this.allowedBarterItems.stream().map(BuiltInRegistries.g::b).map(MinecraftKey::toString).map(NBTTagString::a).forEach(barterList::add);
        nbt.a("Bukkit.BarterList", barterList);
        NBTTagList interestList = new NBTTagList();
        this.interestItems.stream().map(BuiltInRegistries.g::b).map(MinecraftKey::toString).map(NBTTagString::a).forEach(interestList::add);
        nbt.a("Bukkit.InterestList", interestList);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(nbt.q("IsBaby"));
        this.z(nbt.q("CannotHunt"));
        this.a(nbt, this.dY());
        this.allowedBarterItems = nbt.c("Bukkit.BarterList", 8).stream().map(NBTBase::u_).map(MinecraftKey::c).map(BuiltInRegistries.g::a).collect(Collectors.toCollection(HashSet::new));
        this.interestItems = nbt.c("Bukkit.InterestList", 8).stream().map(NBTBase::u_).map(MinecraftKey::c).map(BuiltInRegistries.g::a).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    @VisibleForDebug
    public InventorySubcontainer t() {
        return this.cn;
    }

    @Override
    protected void a(WorldServer world, DamageSource source, boolean causedByPlayer) {
        EntityCreeper entitycreeper;
        super.a(world, source, causedByPlayer);
        Entity entity = source.d();
        if (entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).gp()) {
            ItemStack itemstack = new ItemStack(Items.vh);
            entitycreeper.gq();
            this.a(world, itemstack);
        }
        this.cn.f().forEach(itemstack1 -> this.a(world, (ItemStack)itemstack1));
    }

    protected ItemStack i(ItemStack stack) {
        return this.cn.b(stack);
    }

    protected boolean j(ItemStack stack) {
        return this.cn.c(stack);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ca, false);
        builder.a(cb, false);
        builder.a(cc, false);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (ca.equals(data)) {
            this.m_();
        }
    }

    public static AttributeProvider.Builder gu() {
        return EntityMonster.gt().a(GenericAttributes.s, 16.0).a(GenericAttributes.v, 0.35f).a(GenericAttributes.c, 5.0);
    }

    public static boolean b(EntityTypes<EntityPiglin> type, GeneratorAccess world, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return !world.a_(pos.e()).a(Blocks.lf);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        RandomSource randomsource = world.H_();
        if (spawnReason != EntitySpawnReason.d) {
            if (randomsource.i() < 0.2f) {
                this.a(true);
            } else if (this.go()) {
                this.a(EnumItemSlot.a, this.gw());
            }
        }
        PiglinAI.a(this, world.H_());
        this.a(randomsource, difficulty);
        this.a(world, randomsource, difficulty);
        return super.a(world, difficulty, spawnReason, entityData);
    }

    @Override
    protected boolean X() {
        return false;
    }

    @Override
    public boolean h(double distanceSquared) {
        return !this.aj();
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        if (this.go()) {
            this.a(EnumItemSlot.f, new ItemStack(Items.qk), random);
            this.a(EnumItemSlot.e, new ItemStack(Items.ql), random);
            this.a(EnumItemSlot.d, new ItemStack(Items.qm), random);
            this.a(EnumItemSlot.c, new ItemStack(Items.qn), random);
        }
    }

    private void a(EnumItemSlot slot, ItemStack stack, RandomSource random) {
        if (random.i() < 0.1f) {
            this.a(slot, stack);
        }
    }

    protected BehaviorController.b<EntityPiglin> ed() {
        return BehaviorController.a(bZ, d);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return PiglinAI.a(this, this.ed().a(dynamic));
    }

    public BehaviorController<EntityPiglin> ec() {
        return super.ec();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (enuminteractionresult.a()) {
            return enuminteractionresult;
        }
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return PiglinAI.a(worldserver, this, player, hand);
        }
        boolean flag = PiglinAI.b(this, player.b(hand)) && this.gp() != EntityPiglinArmPose.d;
        return (EnumInteractionResult)((Object)(flag ? EnumInteractionResult.a : EnumInteractionResult.e));
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? cl : super.e(pose);
    }

    @Override
    public void a(boolean baby) {
        this.au().a(ca, baby);
        if (!this.dW().C) {
            AttributeModifiable attributemodifiable = this.g(GenericAttributes.v);
            attributemodifiable.c(ce.b());
            if (baby) {
                attributemodifiable.b(ce);
            }
        }
    }

    @Override
    public boolean e_() {
        return this.au().a(ca);
    }

    private void z(boolean cannotHunt) {
        this.co = cannotHunt;
    }

    @Override
    protected boolean m() {
        return !this.co;
    }

    @Override
    protected void a(WorldServer world) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("piglinBrain");
        this.ec().a(world, this);
        gameprofilerfiller.c();
        PiglinAI.a(this);
        super.a(world);
    }

    @Override
    protected int e(WorldServer world) {
        return this.bO;
    }

    @Override
    protected void g(WorldServer world) {
        PiglinAI.a(world, this);
        this.forceDrops = true;
        this.cn.f().forEach(itemstack -> this.a(world, (ItemStack)itemstack));
        this.forceDrops = false;
        super.g(world);
    }

    private ItemStack gw() {
        return (double)this.ae.i() < 0.5 ? new ItemStack(Items.wL) : new ItemStack(Items.ps);
    }

    public boolean gx() {
        return this.al.a(cb);
    }

    @Override
    public void b(boolean charging) {
        this.al.a(cb, charging);
    }

    @Override
    public void a() {
        this.bf = 0;
    }

    @Override
    public EntityPiglinArmPose gp() {
        return this.gv() ? EntityPiglinArmPose.e : (PiglinAI.a(this.fa()) ? EntityPiglinArmPose.d : (this.gd() && this.gq() ? EntityPiglinArmPose.a : (this.gx() ? EntityPiglinArmPose.c : (this.b(Items.wL) && ItemCrossbow.g(this.ea()) ? EntityPiglinArmPose.b : EntityPiglinArmPose.f))));
    }

    public boolean gv() {
        return this.al.a(cc);
    }

    public void y(boolean dancing) {
        this.al.a(cc, dancing);
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        Entity entity;
        boolean flag = super.a(world, source, amount);
        if (flag && (entity = source.d()) instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            PiglinAI.a(world, this, entityliving);
        }
        return flag;
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        this.b(this, 1.6f);
    }

    @Override
    public boolean a(ItemProjectileWeapon weapon) {
        return weapon == Items.wL;
    }

    protected void k(ItemStack stack) {
        this.b(EnumItemSlot.a, stack);
    }

    protected void l(ItemStack stack) {
        if (stack.a(PiglinAI.c) || this.allowedBarterItems.contains(stack.h())) {
            this.a(EnumItemSlot.b, stack);
            this.g(EnumItemSlot.b);
        } else {
            this.b(EnumItemSlot.b, stack);
        }
    }

    @Override
    public boolean c(WorldServer world, ItemStack stack) {
        return world.N().b(GameRules.c) && this.fN() && PiglinAI.a(this, stack);
    }

    protected boolean m(ItemStack stack) {
        EnumItemSlot enumitemslot = this.f(stack);
        ItemStack itemstack1 = this.a(enumitemslot);
        return this.a(stack, itemstack1, enumitemslot);
    }

    @Override
    protected boolean a(ItemStack newStack, ItemStack oldStack, EnumItemSlot slot) {
        boolean flag1;
        if (EnchantmentManager.a(oldStack, EnchantmentEffectComponents.E)) {
            return false;
        }
        boolean flag = PiglinAI.isLovedItem(newStack, this) || newStack.a(Items.wL);
        boolean bl = flag1 = PiglinAI.isLovedItem(oldStack, this) || oldStack.a(Items.wL);
        return flag && !flag1 ? true : (!flag && flag1 ? false : (this.go() && !newStack.a(Items.wL) && oldStack.a(Items.wL) ? false : super.a(newStack, oldStack, slot)));
    }

    @Override
    protected void a(WorldServer world, EntityItem itemEntity) {
        PiglinAI.a(world, this, itemEntity);
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        if (this.e_() && entity.aq() == EntityTypes.ak) {
            entity = this.b(entity, 3);
        }
        return super.a(entity, force);
    }

    private Entity b(Entity entity, int maxLevel) {
        List<Entity> list = entity.cZ();
        return maxLevel != 1 && !list.isEmpty() ? this.b(list.get(0), maxLevel - 1) : entity;
    }

    @Override
    protected SoundEffect u() {
        return this.dW().C ? null : (SoundEffect)PiglinAI.b(this).orElse(null);
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.uf;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.ud;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.uh, 0.15f, 1.0f);
    }

    @Override
    protected void gr() {
        this.b(SoundEffects.ui);
    }
}

