/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.WardenAngerChangeEvent;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.warden.SonicBoom;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.monster.warden.WardenAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;

public class Warden
extends EntityMonster
implements VibrationSystem {
    private static final Logger cb = LogUtils.getLogger();
    private static final int cc = 40;
    private static final int cd = 200;
    private static final int ce = 500;
    private static final float cf = 0.3f;
    private static final float cg = 1.0f;
    private static final float ch = 1.5f;
    private static final int ci = 30;
    private static final int cj = 24;
    private static final DataWatcherObject<Integer> ck = DataWatcher.a(Warden.class, DataWatcherRegistry.b);
    private static final int cl = 200;
    private static final int cm = 260;
    private static final int cn = 20;
    private static final int co = 120;
    private static final int cp = 20;
    private static final int cq = 35;
    private static final int cr = 10;
    private static final int cs = 20;
    private static final int ct = 100;
    private static final int cu = 20;
    private static final int cv = 30;
    private static final float cw = 4.5f;
    private static final float cx = 0.7f;
    private static final int cy = 30;
    private int cz;
    private int cC;
    private int cD;
    private int cE;
    public AnimationState a = new AnimationState();
    public AnimationState b = new AnimationState();
    public AnimationState c = new AnimationState();
    public AnimationState d = new AnimationState();
    public AnimationState bZ = new AnimationState();
    public AnimationState ca = new AnimationState();
    private final DynamicGameEventListener<VibrationSystem.b> cF = new DynamicGameEventListener<VibrationSystem.b>(new VibrationSystem.b(this));
    private final VibrationSystem.d cG = new a();
    private VibrationSystem.a cH = new VibrationSystem.a();
    AngerManagement cI = new AngerManagement(this::b, Collections.emptyList());

    public Warden(EntityTypes<? extends EntityMonster> type, World world) {
        super(type, world);
        this.bO = 5;
        this.L().a(true);
        this.a(PathType.m, 0.0f);
        this.a(PathType.q, 8.0f);
        this.a(PathType.f, 8.0f);
        this.a(PathType.i, 8.0f);
        this.a(PathType.o, 0.0f);
        this.a(PathType.n, 0.0f);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entityTrackerEntry) {
        return new PacketPlayOutSpawnEntity((Entity)this, entityTrackerEntry, this.c(EntityPose.n) ? 1 : 0);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        if (packet.p() == 1) {
            this.b(EntityPose.n);
        }
    }

    @Override
    public boolean a(IWorldReader world) {
        return super.a(world) && world.a((Entity)this, this.aq().n().a(this.du()));
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return 0.0f;
    }

    @Override
    public boolean a(WorldServer world, DamageSource source) {
        return this.gr() && !source.a(DamageTypeTags.d) ? true : super.a(world, source);
    }

    boolean gr() {
        return this.c(EntityPose.o) || this.c(EntityPose.n);
    }

    @Override
    protected boolean o(Entity entity) {
        return false;
    }

    @Override
    public boolean fU() {
        return true;
    }

    @Override
    protected float aU() {
        return this.X + 0.55f;
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gt().a(GenericAttributes.s, 500.0).a(GenericAttributes.v, 0.3f).a(GenericAttributes.p, 1.0).a(GenericAttributes.d, 1.5).a(GenericAttributes.c, 30.0).a(GenericAttributes.m, 24.0);
    }

    @Override
    public boolean bh() {
        return true;
    }

    @Override
    public float fg() {
        return 4.0f;
    }

    @Override
    @Nullable
    protected SoundEffect u() {
        return !this.c(EntityPose.l) && !this.gr() ? this.t().b() : null;
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.Cn;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.Cj;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.Cx, 10.0f, 1.0f);
    }

    @Override
    public boolean c(WorldServer world, Entity target) {
        world.a((Entity)this, (byte)4);
        this.a(SoundEffects.Ci, 10.0f, this.fh());
        SonicBoom.a((EntityLiving)this, 40);
        return super.c(world, target);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ck, 0);
    }

    public int p() {
        return this.al.a(ck);
    }

    private void gu() {
        this.al.a(ck, this.gx());
    }

    @Override
    public void h() {
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            VibrationSystem.c.a((World)worldserver, this.cH, this.cG);
            if (this.aj() || this.W()) {
                WardenAi.a((EntityLiving)this);
            }
        }
        super.h();
        if (this.dW().B_()) {
            if (this.af % this.gv() == 0) {
                this.cD = 10;
                if (!this.bb()) {
                    this.dW().a(this.dB(), this.dD(), this.dH(), SoundEffects.Cm, this.dn(), 5.0f, this.fh(), false);
                }
            }
            this.cC = this.cz;
            if (this.cz > 0) {
                --this.cz;
            }
            this.cE = this.cD;
            if (this.cD > 0) {
                --this.cD;
            }
            switch (this.aw()) {
                case n: {
                    this.a(this.c);
                    break;
                }
                case o: {
                    this.a(this.d);
                }
            }
        }
    }

    @Override
    protected void a(WorldServer world) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("wardenBrain");
        this.ec().a(world, this);
        gameprofilerfiller.c();
        super.a(world);
        if ((this.af + this.ar()) % 120 == 0) {
            Warden.a(world, this.du(), this, 20);
        }
        if (this.af % 20 == 0) {
            this.cI.a(world, this::b);
            this.gu();
        }
        WardenAi.a(this);
    }

    @Override
    public void b(byte status) {
        if (status == 4) {
            this.a.a();
            this.bZ.a(this.af);
        } else if (status == 61) {
            this.cz = 10;
        } else if (status == 62) {
            this.ca.a(this.af);
        } else {
            super.b(status);
        }
    }

    private int gv() {
        float f2 = (float)this.p() / (float)AngerLevel.c.a();
        return 40 - MathHelper.d(MathHelper.a(f2, 0.0f, 1.0f) * 30.0f);
    }

    public float J(float tickDelta) {
        return MathHelper.h(tickDelta, this.cC, this.cz) / 10.0f;
    }

    public float K(float tickDelta) {
        return MathHelper.h(tickDelta, this.cE, this.cD) / 10.0f;
    }

    private void a(AnimationState animationState) {
        if ((float)animationState.a((float)this.af) < 4500.0f) {
            RandomSource randomsource = this.dZ();
            IBlockData iblockdata = this.bu();
            if (iblockdata.o() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    double d0 = this.dB() + (double)MathHelper.b(randomsource, -0.7f, 0.7f);
                    double d1 = this.dD();
                    double d2 = this.dH() + (double)MathHelper.b(randomsource, -0.7f, 0.7f);
                    this.dW().a(new ParticleParamBlock(Particles.b, iblockdata), d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (Entity.aq.equals(data)) {
            switch (this.aw()) {
                case n: {
                    this.c.a(this.af);
                    break;
                }
                case o: {
                    this.d.a(this.af);
                    break;
                }
                case l: {
                    this.a.a(this.af);
                    break;
                }
                case m: {
                    this.b.a(this.af);
                }
            }
        }
        super.a(data);
    }

    @Override
    public boolean a(Explosion explosion) {
        return this.gr();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return WardenAi.a(this, dynamic);
    }

    public BehaviorController<Warden> ec() {
        return super.ec();
    }

    @Override
    protected void Y() {
        super.Y();
        PacketDebug.a(this);
    }

    @Override
    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> callback) {
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            callback.accept(this.cF, worldserver);
        }
    }

    @Contract(value="null->false")
    public boolean b(@Nullable Entity entity) {
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            if (this.dW() == entity.dW() && IEntitySelector.e.test(entity) && !this.s(entity) && entityliving.aq() != EntityTypes.f && entityliving.aq() != EntityTypes.bG && !entityliving.cC() && !entityliving.eF() && this.dW().F_().a(entityliving.cR())) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    public static void a(WorldServer world, Vec3D pos, @Nullable Entity entity, int range) {
        MobEffect mobeffect = new MobEffect(MobEffects.G, 260, 0, false, false);
        MobEffectUtil.addEffectToPlayersAround(world, entity, pos, range, mobeffect, 200, EntityPotionEffectEvent.Cause.WARDEN);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        RegistryOps<NBTBase> registryops = this.dY().a(DynamicOpsNBT.a);
        AngerManagement.a(this::b).encodeStart(registryops, (Object)this.cI).resultOrPartial(s2 -> cb.error("Failed to encode anger state for Warden: '{}'", s2)).ifPresent(nbtbase -> nbt.a("anger", (NBTBase)nbtbase));
        VibrationSystem.a.a.encodeStart(registryops, (Object)this.cH).resultOrPartial(s2 -> cb.error("Failed to encode vibration listener for Warden: '{}'", s2)).ifPresent(nbtbase -> nbt.a("listener", (NBTBase)nbtbase));
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        RegistryOps<NBTBase> registryops = this.dY().a(DynamicOpsNBT.a);
        if (nbt.e("anger")) {
            AngerManagement.a(this::b).parse(registryops, (Object)nbt.c("anger")).resultOrPartial(s2 -> cb.error("Failed to parse anger state for Warden: '{}'", s2)).ifPresent(angermanagement -> {
                this.cI = angermanagement;
            });
            this.gu();
        }
        if (nbt.b("listener", 10)) {
            VibrationSystem.a.a.parse(registryops, (Object)nbt.p("listener")).resultOrPartial(s2 -> cb.error("Failed to parse vibration listener for Warden: '{}'", s2)).ifPresent(vibrationsystem_a -> {
                this.cH = vibrationsystem_a;
            });
        }
    }

    private void gw() {
        if (!this.c(EntityPose.l)) {
            this.a(this.t().c(), 10.0f, this.fh());
        }
    }

    public AngerLevel t() {
        return AngerLevel.a(this.gx());
    }

    private int gx() {
        return this.cI.b(this.O_());
    }

    public void c(Entity entity) {
        this.cI.a(entity);
    }

    public void d(@Nullable Entity entity) {
        this.a(entity, 35, true);
    }

    @VisibleForTesting
    public void a(@Nullable Entity entity, int amount, boolean listening) {
        if (!this.gb() && this.b(entity)) {
            int activeAnger = this.cI.b(entity);
            WardenAngerChangeEvent event = new WardenAngerChangeEvent((org.bukkit.entity.Warden)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), activeAnger, Math.min(150, activeAnger + amount));
            this.dW().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            amount = event.getNewAnger() - activeAnger;
            WardenAi.a((EntityLiving)this);
            boolean flag1 = !(this.O_() instanceof EntityHuman);
            int j2 = this.cI.a(entity, amount);
            if (entity instanceof EntityHuman && flag1 && AngerLevel.a(j2).d()) {
                this.ec().b(MemoryModuleType.o);
            }
            if (listening) {
                this.gw();
            }
        }
    }

    public Optional<EntityLiving> x() {
        return this.t().d() ? this.cI.a() : Optional.empty();
    }

    @Override
    @Nullable
    public EntityLiving O_() {
        return this.O();
    }

    @Override
    public boolean h(double distanceSquared) {
        return false;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        this.ec().a(MemoryModuleType.aE, Unit.a, 1200L);
        if (spawnReason == EntitySpawnReason.k) {
            this.b(EntityPose.n);
            this.ec().a(MemoryModuleType.aC, Unit.a, WardenAi.a);
            this.a(SoundEffects.Cf, 5.0f, 1.0f);
        }
        return super.a(world, difficulty, spawnReason, entityData);
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        boolean flag = super.a(world, source, amount);
        if (!this.gb() && !this.gr()) {
            Entity entity = source.d();
            this.a(entity, AngerLevel.c.a() + 20, false);
            if (this.bF.c(MemoryModuleType.o).isEmpty() && entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                if (source.b() || this.a((Entity)entityliving, 5.0)) {
                    this.j(entityliving);
                }
            }
        }
        return flag;
    }

    public void j(EntityLiving target) {
        this.ec().b(MemoryModuleType.ay);
        this.ec().a(MemoryModuleType.o, target);
        this.ec().b(MemoryModuleType.E);
        SonicBoom.a((EntityLiving)this, 200);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        EntitySize entitysize = super.e(pose);
        return this.gr() ? EntitySize.c(entitysize.a(), 1.0f) : entitysize;
    }

    @Override
    public boolean bI() {
        return !this.gr() && super.bI();
    }

    @Override
    protected void D(Entity entity) {
        if (!this.gb() && !this.ec().a(MemoryModuleType.aH)) {
            this.ec().a(MemoryModuleType.aH, Unit.a, 20L);
            this.d(entity);
            WardenAi.a(this, entity.dw());
        }
        super.D(entity);
    }

    @VisibleForTesting
    public AngerManagement go() {
        return this.cI;
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new Navigation(this, this, world){

            @Override
            protected Pathfinder a(int range) {
                this.o = new PathfinderNormal();
                this.o.a(true);
                return new Pathfinder(this, this.o, range){

                    @Override
                    protected float a(PathPoint a2, PathPoint b2) {
                        return a2.b(b2);
                    }
                };
            }
        };
    }

    @Override
    public VibrationSystem.a gp() {
        return this.cH;
    }

    @Override
    public VibrationSystem.d gq() {
        return this.cG;
    }

    private class a
    implements VibrationSystem.d {
        private static final int b = 16;
        private final PositionSource c;

        a() {
            this.c = new EntityPositionSource(Warden.this, Warden.this.cS());
        }

        @Override
        public int a() {
            return 16;
        }

        @Override
        public PositionSource b() {
            return this.c;
        }

        @Override
        public TagKey<GameEvent> c() {
            return GameEventTags.b;
        }

        @Override
        public boolean d() {
            return true;
        }

        @Override
        public boolean a(WorldServer world, BlockPosition pos, Holder<GameEvent> event, GameEvent.a emitter) {
            if (!(Warden.this.gb() || Warden.this.eF() || Warden.this.ec().a(MemoryModuleType.aI) || Warden.this.gr() || !world.F_().a(pos))) {
                EntityLiving entityliving;
                Entity entity = emitter.a();
                if (entity instanceof EntityLiving && !Warden.this.b((Entity)(entityliving = (EntityLiving)entity))) {
                    boolean flag = false;
                    return flag;
                }
                boolean flag = true;
                return flag;
            }
            return false;
        }

        @Override
        public void a(WorldServer world, BlockPosition pos, Holder<GameEvent> event, @Nullable Entity sourceEntity, @Nullable Entity entity, float distance) {
            if (!Warden.this.eF()) {
                Warden.this.bF.a(MemoryModuleType.aI, Unit.a, 40L);
                world.a((Entity)Warden.this, (byte)61);
                Warden.this.a(SoundEffects.Cy, 5.0f, Warden.this.fh());
                BlockPosition blockposition1 = pos;
                if (entity != null) {
                    if (Warden.this.a(entity, 30.0)) {
                        if (Warden.this.ec().a(MemoryModuleType.aA)) {
                            if (Warden.this.b(entity)) {
                                blockposition1 = entity.dw();
                            }
                            Warden.this.d(entity);
                        } else {
                            Warden.this.a(entity, 10, true);
                        }
                    }
                    Warden.this.ec().a(MemoryModuleType.aA, Unit.a, 100L);
                } else {
                    Warden.this.d(sourceEntity);
                }
                if (!Warden.this.t().d()) {
                    Optional<EntityLiving> optional = Warden.this.cI.a();
                    if (entity != null || optional.isEmpty() || optional.get() == sourceEntity) {
                        WardenAi.a(Warden.this, blockposition1);
                    }
                }
            }
        }
    }
}

