/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.Behaviors;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorGolemLastSeen;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.VillagerReplenishTradeEvent;
import org.bukkit.inventory.MerchantRecipe;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class EntityVillager
extends EntityVillagerAbstract
implements ReputationHandler,
VillagerDataHolder {
    private static final Logger cf = LogUtils.getLogger();
    private static final DataWatcherObject<VillagerData> cg = DataWatcher.a(EntityVillager.class, DataWatcherRegistry.u);
    public static final int cb = 12;
    public static final Map<Item, Integer> cc = ImmutableMap.of((Object)Items.pT, (Object)4, (Object)Items.uW, (Object)1, (Object)Items.uV, (Object)1, (Object)Items.wa, (Object)1);
    private static final int ch = 2;
    private static final int ci = 10;
    private static final int cj = 1200;
    private static final int ck = 24000;
    private static final int cl = 10;
    private static final int cm = 5;
    private static final long cn = 24000L;
    @VisibleForTesting
    public static final float cd = 0.5f;
    private int co;
    private boolean cp;
    @Nullable
    private EntityHuman cq;
    private boolean cr;
    private int cs;
    private final Reputation ct = new Reputation();
    private long cu;
    private long cv;
    private int cw;
    private long cx;
    public int cy;
    private long cz;
    private boolean cC;
    private static final ImmutableList<MemoryModuleType<?>> cD = ImmutableList.of(MemoryModuleType.b, MemoryModuleType.c, MemoryModuleType.d, MemoryModuleType.e, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.i, MemoryModuleType.j, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.L, MemoryModuleType.aP, (Object[])new MemoryModuleType[]{MemoryModuleType.m, MemoryModuleType.n, MemoryModuleType.q, MemoryModuleType.r, MemoryModuleType.t, MemoryModuleType.v, MemoryModuleType.w, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.A, MemoryModuleType.f, MemoryModuleType.C, MemoryModuleType.D, MemoryModuleType.E, MemoryModuleType.H, MemoryModuleType.I, MemoryModuleType.J, MemoryModuleType.F});
    private static final ImmutableList<SensorType<? extends Sensor<? super EntityVillager>>> cE = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.e, SensorType.f, SensorType.g, SensorType.h, SensorType.i, SensorType.j);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<EntityVillager, Holder<VillagePlaceType>>> ce = ImmutableMap.of(MemoryModuleType.b, (entityvillager, holder) -> holder.a(PoiTypes.n), MemoryModuleType.c, (entityvillager, holder) -> entityvillager.gy().b().b().test((Holder<VillagePlaceType>)holder), MemoryModuleType.d, (entityvillager, holder) -> VillagerProfession.a.test((Holder<VillagePlaceType>)holder), MemoryModuleType.e, (entityvillager, holder) -> holder.a(PoiTypes.o));

    public EntityVillager(EntityTypes<? extends EntityVillager> entityType, World world) {
        this(entityType, world, VillagerType.c);
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> entityType, World world, VillagerType type) {
        super((EntityTypes<? extends EntityVillagerAbstract>)entityType, world);
        ((Navigation)this.L()).b(true);
        this.L().a(true);
        this.L().a(48.0f);
        this.a_(true);
        this.a(this.gy().a(type).a(VillagerProfession.b));
    }

    public BehaviorController<EntityVillager> ec() {
        return super.ec();
    }

    protected BehaviorController.b<EntityVillager> ed() {
        return BehaviorController.a(cD, cE);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        BehaviorController<EntityVillager> behaviorcontroller = this.ed().a(dynamic);
        this.a(behaviorcontroller);
        return behaviorcontroller;
    }

    public void g(WorldServer world) {
        BehaviorController<EntityVillager> behaviorcontroller = this.ec();
        behaviorcontroller.b(world, this);
        this.bF = behaviorcontroller.i();
        this.a(this.ec());
    }

    @Override
    private void a(BehaviorController<EntityVillager> brain) {
        VillagerProfession villagerprofession = this.gy().b();
        if (this.e_()) {
            brain.a(Schedule.e);
            brain.a(Activity.d, Behaviors.a(0.5f));
        } else {
            brain.a(Schedule.f);
            brain.a(Activity.c, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.b(villagerprofession, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.c, (Object)((Object)MemoryStatus.a))));
        }
        brain.a(Activity.a, Behaviors.a(villagerprofession, 0.5f));
        brain.a(Activity.f, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.d(villagerprofession, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.e, (Object)((Object)MemoryStatus.a))));
        brain.a(Activity.e, Behaviors.c(villagerprofession, 0.5f));
        brain.a(Activity.b, Behaviors.e(villagerprofession, 0.5f));
        brain.a(Activity.g, Behaviors.f(villagerprofession, 0.5f));
        brain.a(Activity.i, Behaviors.g(villagerprofession, 0.5f));
        brain.a(Activity.h, Behaviors.h(villagerprofession, 0.5f));
        brain.a(Activity.j, Behaviors.i(villagerprofession, 0.5f));
        brain.a((Set<Activity>)ImmutableSet.of((Object)Activity.a));
        brain.b(Activity.b);
        brain.a(Activity.b);
        brain.a(this.dW().ad(), this.dW().ac());
    }

    @Override
    protected void i() {
        super.i();
        if (this.dW() instanceof WorldServer) {
            this.g((WorldServer)this.dW());
        }
    }

    public static AttributeProvider.Builder gx() {
        return EntityInsentient.C().a(GenericAttributes.v, 0.5);
    }

    public boolean gz() {
        return this.cC;
    }

    @Override
    public void inactiveTick() {
        if (this.p() > 0) {
            this.r(this.p() - 1);
        }
        if (this.dk()) {
            if (this.dW().spigotConfig.tickInactiveVillagers) {
                this.a(this.dW().getMinecraftWorld());
            } else {
                this.customServerAiStep(this.dW().getMinecraftWorld(), true);
            }
        }
        this.gW();
        super.inactiveTick();
    }

    @Override
    protected void a(WorldServer world) {
        this.customServerAiStep(world, false);
    }

    protected void customServerAiStep(WorldServer world, boolean inactive) {
        Raid raid;
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("villagerBrain");
        if (!inactive) {
            this.ec().a(world, this);
        }
        gameprofilerfiller.c();
        if (this.cC) {
            this.cC = false;
        }
        if (!this.gp() && this.co > 0) {
            --this.co;
            if (this.co <= 0) {
                if (this.cp) {
                    this.gU();
                    this.cp = false;
                }
                this.addEffect(new MobEffect(MobEffects.j, 200, 0), EntityPotionEffectEvent.Cause.VILLAGER_TRADE);
            }
        }
        if (this.cq != null) {
            world.a(ReputationEvent.e, (Entity)this.cq, this);
            world.a((Entity)this, (byte)14);
            this.cq = null;
        }
        if (!inactive && !this.gb() && this.ae.a(100) == 0 && (raid = world.d(this.dw())) != null && raid.u() && !raid.a()) {
            world.a((Entity)this, (byte)42);
        }
        if (this.gy().b() == VillagerProfession.b && this.gp()) {
            this.gu();
        }
        if (inactive) {
            return;
        }
        super.a(world);
    }

    @Override
    public void h() {
        super.h();
        if (this.p() > 0) {
            this.r(this.p() - 1);
        }
        this.gW();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (!itemstack.a(Items.ux) && this.bL() && !this.gp() && !this.fR()) {
            if (this.e_()) {
                this.gJ();
                return EnumInteractionResult.a;
            }
            if (!this.dW().C) {
                boolean flag = this.gq().isEmpty();
                if (hand == EnumHand.a) {
                    if (flag) {
                        this.gJ();
                    }
                    player.a(StatisticList.S);
                }
                if (flag) {
                    return EnumInteractionResult.c;
                }
                this.g(player);
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    public void gJ() {
        this.r(40);
        if (!this.dW().B_()) {
            this.b(SoundEffects.Bv);
        }
    }

    private void g(EntityHuman customer) {
        this.h(customer);
        this.a(customer);
        this.a(customer, this.p_(), this.gy().c());
    }

    @Override
    public void a(@Nullable EntityHuman customer) {
        boolean flag = this.go() != null && customer == null;
        super.a(customer);
        if (flag) {
            this.gu();
        }
    }

    @Override
    protected void gu() {
        super.gu();
        this.gK();
    }

    private void gK() {
        if (!this.dW().B_()) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gq()) {
                merchantrecipe.n();
            }
        }
    }

    @Override
    public boolean gA() {
        return true;
    }

    public void gB() {
        this.gP();
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gq()) {
            VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            merchantrecipe.j();
        }
        this.gL();
        this.cx = this.dW().ac();
        ++this.cy;
    }

    private void gL() {
        MerchantRecipeList merchantrecipelist = this.gq();
        EntityHuman entityhuman = this.go();
        if (entityhuman != null && !merchantrecipelist.isEmpty()) {
            entityhuman.a(entityhuman.cd.l, merchantrecipelist, this.gy().c(), this.x(), this.gr(), this.gA());
        }
    }

    private boolean gM() {
        net.minecraft.world.item.trading.MerchantRecipe merchantrecipe;
        Iterator iterator = this.gq().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(merchantrecipe = (net.minecraft.world.item.trading.MerchantRecipe)iterator.next()).t());
        return true;
    }

    private boolean gN() {
        return this.cy == 0 || this.cy < 2 && this.dW().ac() > this.cx + 2400L;
    }

    public boolean gC() {
        long i2 = this.cx + 12000L;
        long j2 = this.dW().ac();
        boolean flag = j2 > i2;
        long k2 = this.dW().ad();
        if (this.cz > 0L) {
            long i1 = k2 / 24000L;
            long l2 = this.cz / 24000L;
            flag |= i1 > l2;
        }
        this.cz = k2;
        if (flag) {
            this.cx = j2;
            this.gX();
        }
        return this.gN() && this.gM();
    }

    private void gO() {
        int i2 = 2 - this.cy;
        if (i2 > 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gq()) {
                VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                merchantrecipe.j();
            }
        }
        for (int j2 = 0; j2 < i2; ++j2) {
            this.gP();
        }
        this.gL();
    }

    private void gP() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gq()) {
            merchantrecipe.g();
        }
    }

    private void h(EntityHuman player) {
        int i2 = this.f(player);
        if (i2 != 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gq()) {
                if (merchantrecipe.ignoreDiscounts) continue;
                merchantrecipe.a(-MathHelper.d((float)i2 * merchantrecipe.p()));
            }
        }
        if (player.b(MobEffects.F)) {
            MobEffect mobeffect = player.c(MobEffects.F);
            int j2 = mobeffect.e();
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe1 : this.gq()) {
                if (merchantrecipe1.ignoreDiscounts) continue;
                double d0 = 0.3 + 0.0625 * (double)j2;
                int k2 = (int)Math.floor(d0 * (double)merchantrecipe1.a().L());
                merchantrecipe1.a(-Math.max(k2, 1));
            }
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cg, new VillagerData(VillagerType.c, VillagerProfession.b, 1));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = VillagerData.c.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.gy());
        Logger logger = cf;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("VillagerData", (NBTBase)nbtbase));
        nbt.a("FoodLevel", (byte)this.cs);
        nbt.a("Gossips", this.ct.a(DynamicOpsNBT.a));
        nbt.a("Xp", this.cw);
        nbt.a("LastRestock", this.cx);
        nbt.a("LastGossipDecay", this.cv);
        nbt.a("RestocksToday", this.cy);
        if (this.cC) {
            nbt.a("AssignProfessionWhenSpawned", true);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("VillagerData", 10)) {
            DataResult dataresult = VillagerData.c.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("VillagerData")));
            Logger logger = cf;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(villagerdata -> this.al.a(cg, villagerdata));
        }
        if (nbt.b("FoodLevel", 1)) {
            this.cs = nbt.f("FoodLevel");
        }
        NBTTagList nbttaglist = nbt.c("Gossips", 10);
        this.ct.a(new Dynamic<NBTTagList>(DynamicOpsNBT.a, nbttaglist));
        if (nbt.b("Xp", 3)) {
            this.cw = nbt.h("Xp");
        }
        this.cx = nbt.i("LastRestock");
        this.cv = nbt.i("LastGossipDecay");
        if (this.dW() instanceof WorldServer) {
            this.g((WorldServer)this.dW());
        }
        this.cy = nbt.h("RestocksToday");
        if (nbt.e("AssignProfessionWhenSpawned")) {
            this.cC = nbt.q("AssignProfessionWhenSpawned");
        }
    }

    @Override
    public boolean h(double distanceSquared) {
        return false;
    }

    @Override
    @Nullable
    protected SoundEffect u() {
        return this.fR() ? null : (this.gp() ? SoundEffects.Bw : SoundEffects.Br);
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return SoundEffects.Bu;
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.Bt;
    }

    public void gD() {
        this.b(this.gy().b().f());
    }

    @Override
    public void a(VillagerData villagerData) {
        VillagerData villagerdata1 = this.gy();
        if (villagerdata1.b() != villagerData.b()) {
            this.ca = null;
        }
        this.al.a(cg, villagerData);
    }

    @Override
    public VillagerData gy() {
        return this.al.a(cg);
    }

    @Override
    protected void b(net.minecraft.world.item.trading.MerchantRecipe offer) {
        int i2 = 3 + this.ae.a(4);
        this.cw += offer.q();
        this.cq = this.go();
        if (this.gT()) {
            this.co = 40;
            this.cp = true;
            i2 += 5;
        }
        if (offer.u()) {
            this.dW().b(new EntityExperienceOrb(this.dW(), this.dB(), this.dD() + 0.5, this.dH(), i2, ExperienceOrb.SpawnReason.VILLAGER_TRADE, this.go(), this));
        }
    }

    @Override
    public void a(@Nullable EntityLiving attacker) {
        if (attacker != null && this.dW() instanceof WorldServer) {
            ((WorldServer)this.dW()).a(ReputationEvent.c, (Entity)attacker, this);
            if (this.bL() && attacker instanceof EntityHuman) {
                this.dW().a((Entity)this, (byte)13);
            }
        }
        super.a(attacker);
    }

    @Override
    public void a(DamageSource damageSource) {
        Entity entity;
        if (SpigotConfig.logVillagerDeaths) {
            cf.info("Villager {} died, message: '{}'", (Object)this, (Object)damageSource.a(this).getString());
        }
        if ((entity = damageSource.d()) != null) {
            this.b(entity);
        }
        this.gQ();
        super.a(damageSource);
    }

    public void gQ() {
        this.a(MemoryModuleType.b);
        this.a(MemoryModuleType.c);
        this.a(MemoryModuleType.d);
        this.a(MemoryModuleType.e);
    }

    private void b(Entity killer) {
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Optional<NearestVisibleLivingEntities> optional = this.bF.c(MemoryModuleType.h);
            if (!optional.isEmpty()) {
                NearestVisibleLivingEntities nearestvisiblelivingentities = optional.get();
                Objects.requireNonNull(ReputationHandler.class);
                nearestvisiblelivingentities.b(ReputationHandler.class::isInstance).forEach(entityliving -> worldserver.a(ReputationEvent.d, killer, (ReputationHandler)((Object)entityliving)));
            }
        }
    }

    @Override
    public void a(MemoryModuleType<GlobalPos> pos) {
        if (this.dW() instanceof WorldServer) {
            MinecraftServer minecraftserver = ((WorldServer)this.dW()).p();
            this.bF.c(pos).ifPresent(globalpos -> {
                WorldServer worldserver = minecraftserver.a(globalpos.a());
                if (worldserver != null) {
                    VillagePlace villageplace = worldserver.z();
                    Optional<Holder<VillagePlaceType>> optional = villageplace.c(globalpos.b());
                    BiPredicate<EntityVillager, Holder<VillagePlaceType>> bipredicate = ce.get(pos);
                    if (optional.isPresent() && bipredicate.test(this, optional.get())) {
                        villageplace.b(globalpos.b());
                        PacketDebug.c(worldserver, globalpos.b());
                    }
                }
            });
        }
    }

    @Override
    public boolean Y_() {
        return this.cs + this.gV() >= 12 && !this.fR() && this.Z_() == 0;
    }

    private boolean gR() {
        return this.cs < 12;
    }

    private void gS() {
        if (this.gR() && this.gV() != 0) {
            for (int i2 = 0; i2 < this.t().b(); ++i2) {
                int j2;
                Integer integer;
                ItemStack itemstack = this.t().a(i2);
                if (itemstack.f() || (integer = cc.get(itemstack.h())) == null) continue;
                for (int k2 = j2 = itemstack.L(); k2 > 0; --k2) {
                    this.cs += integer.intValue();
                    this.t().a(i2, 1);
                    if (this.gR()) continue;
                    return;
                }
            }
        }
    }

    public int f(EntityHuman player) {
        return this.ct.a(player.cG(), (ReputationType reputationtype) -> true);
    }

    private void u(int amount) {
        this.cs -= amount;
    }

    public void gE() {
        this.gS();
        this.u(12);
    }

    public void b(MerchantRecipeList offers) {
        this.ca = offers;
    }

    private boolean gT() {
        int i2 = this.gy().c();
        return VillagerData.d(i2) && this.cw >= VillagerData.c(i2);
    }

    public void gU() {
        this.a(this.gy().a(this.gy().c() + 1));
        this.gv();
    }

    @Override
    protected IChatBaseComponent cz() {
        String s2 = this.aq().g();
        return IChatBaseComponent.c(s2 + "." + BuiltInRegistries.x.b(this.gy().b()).a());
    }

    @Override
    public void b(byte status) {
        if (status == 12) {
            this.a(Particles.Q);
        } else if (status == 13) {
            this.a(Particles.a);
        } else if (status == 14) {
            this.a(Particles.O);
        } else if (status == 42) {
            this.a(Particles.an);
        } else {
            super.b(status);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        if (spawnReason == EntitySpawnReason.e) {
            this.a(this.gy().a(VillagerProfession.b));
        }
        if (spawnReason == EntitySpawnReason.n || spawnReason == EntitySpawnReason.m || EntitySpawnReason.a(spawnReason) || spawnReason == EntitySpawnReason.o) {
            this.a(this.gy().a(VillagerType.a(world.t(this.dw()))));
        }
        if (spawnReason == EntitySpawnReason.d) {
            this.cC = true;
        }
        return super.a(world, difficulty, spawnReason, entityData);
    }

    @Nullable
    public EntityVillager b(WorldServer world, EntityAgeable entity) {
        double d0 = this.ae.j();
        VillagerType villagertype = d0 < 0.5 ? VillagerType.a(world.t(this.dw())) : (d0 < 0.75 ? this.gy().a() : ((EntityVillager)entity).gy().a());
        EntityVillager entityvillager = new EntityVillager(EntityTypes.bD, world, villagertype);
        entityvillager.a((WorldAccess)world, world.d_(entityvillager.dw()), EntitySpawnReason.e, (GroupDataEntity)null);
        return entityvillager;
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        if (world.al() != EnumDifficulty.a) {
            EntityWitch entitywitch = this.convertTo(EntityTypes.bI, ConversionParams.a(this, false, false), (T entitywitch1) -> {
                if (CraftEventFactory.callEntityZapEvent(this, lightning, entitywitch1).isCancelled()) {
                    return false;
                }
                if (SpigotConfig.logVillagerDeaths) {
                    cf.info("Villager {} was struck by lightning {}.", (Object)this, (Object)lightning);
                }
                entitywitch1.a((WorldAccess)world, world.d_(entitywitch1.dw()), EntitySpawnReason.i, (GroupDataEntity)null);
                entitywitch1.ai();
                this.gQ();
                return true;
            }, EntityTransformEvent.TransformReason.LIGHTNING, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            if (entitywitch == null) {
                super.a(world, lightning);
            }
        } else {
            super.a(world, lightning);
        }
    }

    @Override
    protected void a(WorldServer world, EntityItem itemEntity) {
        InventoryCarrier.a(world, this, this, itemEntity);
    }

    @Override
    public boolean c(WorldServer world, ItemStack stack) {
        Item item = stack.h();
        return (stack.a(TagsItem.bQ) || this.gy().b().d().contains((Object)item)) && this.t().c(stack);
    }

    public boolean gF() {
        return this.gV() >= 24;
    }

    public boolean gG() {
        return this.gV() < 12;
    }

    private int gV() {
        InventorySubcontainer inventorysubcontainer = this.t();
        return cc.entrySet().stream().mapToInt(entry -> inventorysubcontainer.a_((Item)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    public boolean gH() {
        return this.t().a_((ItemStack itemstack) -> itemstack.a(TagsItem.bP));
    }

    @Override
    protected void gv() {
        this.updateTrades(2);
    }

    public boolean updateTrades(int amount) {
        VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption;
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> int2objectmap1;
        VillagerData villagerdata = this.gy();
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> int2objectmap = this.dW().J().b(FeatureFlags.c) ? ((int2objectmap1 = VillagerTrades.c.get(villagerdata.b())) != null ? int2objectmap1 : VillagerTrades.a.get(villagerdata.b())) : VillagerTrades.a.get(villagerdata.b());
        if (int2objectmap != null && !int2objectmap.isEmpty() && (avillagertrades_imerchantrecipeoption = (VillagerTrades.IMerchantRecipeOption[])int2objectmap.get(villagerdata.c())) != null) {
            MerchantRecipeList merchantrecipelist = this.gq();
            this.a(merchantrecipelist, avillagertrades_imerchantrecipeoption, amount);
            return true;
        }
        return false;
    }

    public void a(WorldServer world, EntityVillager villager, long time) {
        if (!(time >= this.cu && time < this.cu + 1200L || time >= villager.cu && time < villager.cu + 1200L)) {
            this.ct.a(villager.ct, this.ae, 10);
            this.cu = time;
            villager.cu = time;
            this.a(world, time, 5);
        }
    }

    private void gW() {
        long i2 = this.dW().ac();
        if (this.cv == 0L) {
            this.cv = i2;
        } else if (i2 >= this.cv + 24000L) {
            this.ct.b();
            this.cv = i2;
        }
    }

    public void a(WorldServer world, long time, int requiredCount) {
        AxisAlignedBB axisalignedbb;
        List<EntityVillager> list;
        List<EntityVillager> list1;
        if (this.a(time) && (list1 = (list = world.a(EntityVillager.class, axisalignedbb = this.cR().c(10.0, 10.0, 10.0))).stream().filter(entityvillager -> entityvillager.a(time)).limit(5L).toList()).size() >= requiredCount && SpawnUtil.trySpawnMob(EntityTypes.aq, EntitySpawnReason.f, world, this.dw(), 10, 8, 6, SpawnUtil.a.a, CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE, () -> SensorGolemLastSeen.b(this)).isPresent()) {
            list.forEach(SensorGolemLastSeen::b);
        }
    }

    public boolean a(long time) {
        return !this.b(this.dW().ac()) ? false : !this.bF.a(MemoryModuleType.F);
    }

    @Override
    public void a(ReputationEvent interaction, Entity entity) {
        if (interaction == ReputationEvent.a) {
            this.ct.a(entity.cG(), ReputationType.d, 20);
            this.ct.a(entity.cG(), ReputationType.c, 25);
        } else if (interaction == ReputationEvent.e) {
            this.ct.a(entity.cG(), ReputationType.e, 2);
        } else if (interaction == ReputationEvent.c) {
            this.ct.a(entity.cG(), ReputationType.b, 25);
        } else if (interaction == ReputationEvent.d) {
            this.ct.a(entity.cG(), ReputationType.a, 25);
        }
    }

    @Override
    public int x() {
        return this.cw;
    }

    public void t(int experience) {
        this.cw = experience;
    }

    private void gX() {
        this.gO();
        this.cy = 0;
    }

    public Reputation gI() {
        return this.ct;
    }

    @Override
    public void a(NBTBase nbt) {
        this.ct.a(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt));
    }

    @Override
    protected void Y() {
        super.Y();
        PacketDebug.a(this);
    }

    @Override
    public void b(BlockPosition pos) {
        super.b(pos);
        this.bF.a(MemoryModuleType.H, Long.valueOf(this.dW().ac()));
        this.bF.b(MemoryModuleType.m);
        this.bF.b(MemoryModuleType.E);
    }

    @Override
    public void fS() {
        super.fS();
        this.bF.a(MemoryModuleType.I, Long.valueOf(this.dW().ac()));
    }

    private boolean b(long worldTime) {
        Optional<Long> optional = this.bF.c(MemoryModuleType.H);
        return optional.filter(olong -> worldTime - olong < 24000L).isPresent();
    }
}

