/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import io.papermc.paper.event.player.PlayerPurchaseEvent;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftMerchantRecipe;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;
import org.slf4j.Logger;

public abstract class EntityVillagerAbstract
extends EntityAgeable
implements InventoryCarrier,
NPC,
IMerchant {
    private static final DataWatcherObject<Integer> cb = DataWatcher.a(EntityVillagerAbstract.class, DataWatcherRegistry.b);
    private static final Logger cc = LogUtils.getLogger();
    public static final int bZ = 300;
    private static final int cd = 8;
    @Nullable
    private EntityHuman ce;
    @Nullable
    protected MerchantRecipeList ca;
    private final InventorySubcontainer cf = new InventorySubcontainer(8, (CraftAbstractVillager)this.getBukkitEntity());

    @Override
    public CraftMerchant getCraftMerchant() {
        return (CraftAbstractVillager)this.getBukkitEntity();
    }

    public EntityVillagerAbstract(EntityTypes<? extends EntityVillagerAbstract> type, World world) {
        super((EntityTypes<? extends EntityAgeable>)type, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        if (entityData == null) {
            entityData = new EntityAgeable.a(false);
        }
        return super.a(world, difficulty, spawnReason, entityData);
    }

    public int p() {
        return this.al.a(cb);
    }

    public void r(int ticks) {
        this.al.a(cb, ticks);
    }

    @Override
    public int x() {
        return 0;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cb, 0);
    }

    @Override
    public void a(@Nullable EntityHuman customer) {
        this.ce = customer;
    }

    @Override
    @Nullable
    public EntityHuman go() {
        return this.ce;
    }

    public boolean gp() {
        return this.ce != null;
    }

    public void resetOffers() {
        this.ca = new MerchantRecipeList();
        this.gv();
    }

    @Override
    public MerchantRecipeList gq() {
        if (this.dW().C) {
            throw new IllegalStateException("Cannot load Villager offers on the client");
        }
        if (this.ca == null) {
            this.ca = new MerchantRecipeList();
            this.gv();
        }
        return this.ca;
    }

    @Override
    public void a(@Nullable MerchantRecipeList offers) {
    }

    @Override
    public void s(int experience) {
    }

    @Override
    public void processTrade(MerchantRecipe recipe, @Nullable PlayerPurchaseEvent event) {
        if (event == null || event.willIncreaseTradeUses()) {
            recipe.l();
        }
        if (event == null || event.isRewardingExp()) {
            this.b(recipe);
        }
        this.a(recipe);
    }

    @Override
    public void a(MerchantRecipe offer) {
        this.bN = -this.Q();
        if (this.ce instanceof EntityPlayer) {
            CriterionTriggers.t.a((EntityPlayer)this.ce, this, offer.f());
        }
    }

    protected abstract void b(MerchantRecipe var1);

    @Override
    public boolean gr() {
        return true;
    }

    @Override
    public void i(ItemStack stack) {
        if (!this.dW().C && this.bN > -this.Q() + 20) {
            this.bN = -this.Q();
            this.b(this.x(!stack.f()));
        }
    }

    @Override
    public SoundEffect gs() {
        return SoundEffects.Bx;
    }

    protected SoundEffect x(boolean sold) {
        return sold ? SoundEffects.Bx : SoundEffects.Bv;
    }

    public void gt() {
        this.b(SoundEffects.Bs);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        MerchantRecipeList merchantrecipelist;
        super.b(nbt);
        if (!this.dW().C && !(merchantrecipelist = this.gq()).isEmpty()) {
            nbt.a("Offers", (NBTBase)MerchantRecipeList.a.encodeStart(this.dY().a(DynamicOpsNBT.a), (Object)merchantrecipelist).getOrThrow());
        }
        this.b(nbt, this.dY());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.e("Offers")) {
            DataResult dataresult = MerchantRecipeList.a.parse(this.dY().a(DynamicOpsNBT.a), (Object)nbt.c("Offers"));
            Logger logger = cc;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(SystemUtils.a("Failed to load offers: ", arg_0 -> ((Logger)logger).warn(arg_0))).ifPresent(merchantrecipelist -> {
                this.ca = merchantrecipelist;
            });
        }
        this.a(nbt, this.dY());
    }

    @Override
    @Nullable
    public Entity b(TeleportTransition teleportTarget) {
        this.gu();
        return super.b(teleportTarget);
    }

    protected void gu() {
        this.a((EntityHuman)null);
    }

    @Override
    public void a(DamageSource damageSource) {
        super.a(damageSource);
        this.gu();
    }

    protected void a(ParticleParam parameters) {
        for (int i2 = 0; i2 < 5; ++i2) {
            double d0 = this.ae.k() * 0.02;
            double d1 = this.ae.k() * 0.02;
            double d2 = this.ae.k() * 0.02;
            this.dW().a(parameters, this.d(1.0), this.dE() + 1.0, this.g(1.0), d0, d1, d2);
        }
    }

    @Override
    public boolean y() {
        return false;
    }

    @Override
    public InventorySubcontainer t() {
        return this.cf;
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        int j2 = mappedIndex - 300;
        return j2 >= 0 && j2 < this.cf.b() ? SlotAccess.a(this.cf, j2) : super.a_(mappedIndex);
    }

    protected abstract void gv();

    protected void a(MerchantRecipeList recipeList, VillagerTrades.IMerchantRecipeOption[] pool, int count) {
        ArrayList arraylist = Lists.newArrayList((Object[])pool);
        int j2 = 0;
        while (j2 < count && !arraylist.isEmpty()) {
            MerchantRecipe merchantrecipe = ((VillagerTrades.IMerchantRecipeOption)arraylist.remove(this.ae.a(arraylist.size()))).a(this, this.ae);
            if (merchantrecipe == null) continue;
            VillagerAcquireTradeEvent event = new VillagerAcquireTradeEvent((AbstractVillager)this.getBukkitEntity(), (org.bukkit.inventory.MerchantRecipe)merchantrecipe.asBukkit());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                CraftMerchantRecipe craftMerchantRecipe = CraftMerchantRecipe.fromBukkit(event.getRecipe());
                if (craftMerchantRecipe.getIngredients().isEmpty()) {
                    return;
                }
                recipeList.add(craftMerchantRecipe.toMinecraft());
            }
            ++j2;
        }
    }

    @Override
    public Vec3D u(float delta) {
        float f1 = MathHelper.h(delta, this.aY, this.aX) * ((float)Math.PI / 180);
        Vec3D vec3d = new Vec3D(0.0, this.cR().c() - 1.0, 0.2);
        return this.o(delta).e(vec3d.b(-f1));
    }

    @Override
    public boolean gw() {
        return this.dW().C;
    }
}

