/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.destroystokyo.paper.event.player.PlayerReadyArrowEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import io.papermc.paper.event.player.PlayerShieldDisableEvent;
import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftVector;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class EntityHuman
extends EntityLiving {
    private static final Logger a = LogUtils.getLogger();
    public static final EnumMainHand bH = EnumMainHand.b;
    public static final int bI = 0;
    public static final int bJ = 20;
    public static final int bK = 100;
    public static final int bL = 10;
    public static final int bM = 200;
    public static final int bN = 499;
    public static final int bO = 500;
    public static final float bP = 4.5f;
    public static final float bQ = 3.0f;
    public static final float bR = 1.5f;
    public static final float bS = 0.6f;
    public static final float bT = 0.6f;
    public static final float bU = 1.62f;
    private static final int b = 40;
    public static final Vec3D bV = new Vec3D(0.0, 0.6, 0.0);
    public static final EntitySize bW = EntitySize.b(0.6f, 1.8f).b(1.62f).a(EntityAttachments.a().a(EntityAttachment.b, bV));
    private static final Map<EntityPose, EntitySize> c = ImmutableMap.builder().put((Object)EntityPose.a, (Object)bW).put((Object)EntityPose.c, (Object)EntityLiving.aD).put((Object)EntityPose.b, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.d, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.e, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.f, (Object)EntitySize.b(0.6f, 1.5f).b(1.27f).a(EntityAttachments.a().a(EntityAttachment.b, bV))).put((Object)EntityPose.h, (Object)EntitySize.c(0.2f, 0.2f).b(1.62f)).build();
    private static final DataWatcherObject<Float> d = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> e = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Byte> bX = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Byte> bY = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<NBTTagCompound> bZ = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.t);
    protected static final DataWatcherObject<NBTTagCompound> ca = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.t);
    private long f;
    final PlayerInventory g = new PlayerInventory(this);
    protected InventoryEnderChest cb = new InventoryEnderChest(this);
    public final ContainerPlayer cc;
    public Container cd;
    protected FoodMetaData ce = new FoodMetaData();
    protected int cf;
    public float cg;
    public float ch;
    public int ci;
    public double cj;
    public double ck;
    public double cl;
    public double cm;
    public double cn;
    public double co;
    public int h;
    protected boolean cp;
    private final PlayerAbilities i = new PlayerAbilities();
    public int cq;
    public int cr;
    public float cs;
    public int ct;
    protected final float cu = 0.02f;
    private int j;
    public GameProfile k;
    private boolean cz;
    private net.minecraft.world.item.ItemStack cC;
    private final ItemCooldown cD;
    private Optional<GlobalPos> cE;
    @Nullable
    public EntityFishingHook cv;
    public float cw;
    @Nullable
    public Vec3D cx;
    @Nullable
    public Entity cy;
    private boolean cF;
    private int cG;
    public boolean affectsSpawning = true;
    public TriState flyingFallDamage = TriState.NOT_SET;
    public boolean fauxSleeping;
    public int oldLevel = -1;

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public EntityHuman(World world, BlockPosition pos, float yaw, GameProfile gameProfile) {
        super((EntityTypes<? extends EntityLiving>)EntityTypes.bS, world);
        this.cC = net.minecraft.world.item.ItemStack.j;
        this.cD = this.g();
        this.cE = Optional.empty();
        this.a_(gameProfile.getId());
        this.k = gameProfile;
        this.cc = new ContainerPlayer(this.g, !world.C, this);
        this.cd = this.cc;
        this.b((double)pos.u() + 0.5, pos.v() + 1, (double)pos.w() + 0.5, yaw, 0.0f);
        this.bk = 180.0f;
    }

    public boolean a(World world, BlockPosition pos, EnumGamemode gameMode) {
        if (!gameMode.f()) {
            return false;
        }
        if (gameMode == EnumGamemode.d) {
            return true;
        }
        if (this.gv()) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemstack = this.eZ();
        return itemstack.f() || !itemstack.b(new ShapeDetectorBlock(world, pos, false));
    }

    public static AttributeProvider.Builder fX() {
        return EntityLiving.ee().a(GenericAttributes.c, 1.0).a(GenericAttributes.v, 0.1f).a(GenericAttributes.e).a(GenericAttributes.q).a(GenericAttributes.g, 4.5).a(GenericAttributes.j, 3.0).a(GenericAttributes.f).a(GenericAttributes.C).a(GenericAttributes.z).a(GenericAttributes.t).a(GenericAttributes.D);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(d, Float.valueOf(0.0f));
        builder.a(e, 0);
        builder.a(bX, (byte)0);
        builder.a(bY, (byte)bH.b());
        builder.a(bZ, new NBTTagCompound());
        builder.a(ca, new NBTTagCompound());
    }

    @Override
    public void h() {
        this.ad = this.aa_();
        if (this.aa_()) {
            this.d(false);
        }
        if (this.ci > 0) {
            --this.ci;
        }
        if (this.fR()) {
            ++this.h;
            if (this.h == 100 && !new PlayerDeepSleepEvent((Player)this.getBukkitEntity()).callEvent()) {
                this.h = Integer.MIN_VALUE;
            }
            if (this.h > 100) {
                this.h = 100;
            }
            if (!this.dW().C && this.dW().U()) {
                this.a(false, true);
            }
        } else if (this.h > 0) {
            ++this.h;
            if (this.h >= 110) {
                this.h = 0;
            }
        }
        this.gb();
        super.h();
        if (!this.dW().C && this.cd != null && !this.cd.b(this)) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.cd = this.cc;
        }
        this.t();
        EntityHuman entityHuman = this;
        if (entityHuman instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityHuman;
            this.ce.a(entityplayer);
            this.a(StatisticList.k);
            this.a(StatisticList.l);
            if (this.bL()) {
                this.a(StatisticList.m);
            }
            if (this.cg()) {
                this.a(StatisticList.o);
            }
            if (!this.fR()) {
                this.a(StatisticList.n);
            }
        }
        int i2 = 29999999;
        double d0 = MathHelper.a(this.dB(), -2.9999999E7, 2.9999999E7);
        double d1 = MathHelper.a(this.dH(), -2.9999999E7, 2.9999999E7);
        if (d0 != this.dB() || d1 != this.dH()) {
            this.a_(d0, this.dD(), d1);
        }
        ++this.aS;
        net.minecraft.world.item.ItemStack itemstack = this.eZ();
        if (!net.minecraft.world.item.ItemStack.a(this.cC, itemstack)) {
            if (!net.minecraft.world.item.ItemStack.b(this.cC, itemstack)) {
                this.gD();
            }
            this.cC = itemstack.v();
        }
        if (!((Entity)this).a(TagsFluid.a) && this.c(Items.oK)) {
            this.m();
        }
        this.cD.a();
        this.gc();
        if (this.cG > 0) {
            --this.cG;
        }
    }

    @Override
    protected float fq() {
        return this.fG() ? 15.0f : super.fq();
    }

    public boolean fY() {
        return this.cd();
    }

    protected boolean fZ() {
        return this.cd();
    }

    protected boolean ga() {
        return this.cd();
    }

    protected boolean gb() {
        this.cp = ((Entity)this).a(TagsFluid.a);
        return this.cp;
    }

    @Override
    public void l(boolean drag) {
        if (!this.gj().b) {
            super.l(drag);
        }
    }

    @Override
    public void m(boolean drag) {
        if (!this.gj().b) {
            super.m(drag);
        }
    }

    private void m() {
        this.addEffect(new MobEffect(MobEffects.m, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
    }

    private boolean c(Item item) {
        EnumItemSlot enumitemslot;
        Equippable equippable;
        net.minecraft.world.item.ItemStack itemstack;
        Iterator<EnumItemSlot> iterator = EnumItemSlot.i.iterator();
        do {
            if (!iterator.hasNext()) {
                return false;
            }
            enumitemslot = iterator.next();
            itemstack = this.a(enumitemslot);
            equippable = itemstack.a(DataComponents.D);
        } while (!itemstack.a(item) || equippable == null || equippable.a() != enumitemslot);
        return true;
    }

    protected ItemCooldown g() {
        return new ItemCooldown();
    }

    private void t() {
        this.cj = this.cm;
        this.ck = this.cn;
        this.cl = this.co;
        double d0 = this.dB() - this.cm;
        double d1 = this.dD() - this.cn;
        double d2 = this.dH() - this.co;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.cj = this.cm = this.dB();
        }
        if (d2 > 10.0) {
            this.cl = this.co = this.dH();
        }
        if (d1 > 10.0) {
            this.ck = this.cn = this.dD();
        }
        if (d0 < -10.0) {
            this.cj = this.cm = this.dB();
        }
        if (d2 < -10.0) {
            this.cl = this.co = this.dH();
        }
        if (d1 < -10.0) {
            this.ck = this.cn = this.dD();
        }
        this.cm += d0 * 0.25;
        this.co += d2 * 0.25;
        this.cn += d1 * 0.25;
    }

    protected void gc() {
        if (this.h(EntityPose.d)) {
            EntityPose entitypose = this.fJ() ? EntityPose.b : (this.fR() ? EntityPose.c : (this.ck() ? EntityPose.d : (this.fv() ? EntityPose.e : (this.cd() && !this.i.b ? EntityPose.f : EntityPose.a))));
            EntityPose entitypose1 = !(this.aa_() || this.bZ() || this.h(entitypose)) ? (this.h(EntityPose.f) ? EntityPose.f : EntityPose.d) : entitypose;
            this.b(entitypose1);
        }
    }

    protected boolean h(EntityPose pose) {
        return this.dW().a((Entity)this, this.a(pose).a(this.du()).h(1.0E-7));
    }

    @Override
    protected SoundEffect aV() {
        return SoundEffects.uO;
    }

    @Override
    protected SoundEffect aW() {
        return SoundEffects.uM;
    }

    @Override
    protected SoundEffect aX() {
        return SoundEffects.uN;
    }

    @Override
    public int bX() {
        return 10;
    }

    @Override
    public void a(SoundEffect sound, float volume, float pitch) {
        this.dW().a(this, this.dB(), this.dD(), this.dH(), sound, this.dn(), volume, pitch);
    }

    public void a(SoundEffect sound, SoundCategory category, float volume, float pitch) {
    }

    @Override
    public SoundCategory dn() {
        return SoundCategory.h;
    }

    @Override
    public int do() {
        return 20;
    }

    @Override
    public void b(byte status) {
        if (status == 9) {
            this.w();
        } else if (status == 23) {
            this.cz = false;
        } else if (status == 22) {
            this.cz = true;
        } else {
            super.b(status);
        }
    }

    public void closeContainer(InventoryCloseEvent.Reason reason) {
        this.p();
        this.cd = this.cc;
    }

    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        this.cd = this.cc;
    }

    public void p() {
        this.cd = this.cc;
    }

    protected void q() {
    }

    @Override
    public void r() {
        if (!this.dW().C && this.fZ() && this.bZ()) {
            this.ae();
            if (!this.bZ()) {
                this.g(false);
                return;
            }
        }
        super.r();
        this.cg = this.ch;
        this.ch = 0.0f;
    }

    @Override
    protected void fu() {
        super.fu();
        this.eX();
        this.aZ = this.dM();
    }

    @Override
    public void d_() {
        if (this.cf > 0) {
            --this.cf;
        }
        this.j();
        this.g.j();
        this.cg = this.ch;
        if (this.i.b && !this.bZ()) {
            this.k();
        }
        super.d_();
        this.C((float)this.h(GenericAttributes.v));
        float f2 = this.aJ() && !this.eF() && !this.ck() ? Math.min(0.1f, (float)this.dz().i()) : 0.0f;
        this.ch += (f2 - this.ch) * 0.4f;
        if (this.eE() > 0.0f && !this.aa_()) {
            AxisAlignedBB axisalignedbb = this.bZ() && !this.dl().dR() ? this.cR().b(this.dl().cR()).c(1.0, 0.0, 1.0) : this.cR().c(1.0, 0.5, 1.0);
            List<Entity> list = this.dW().a_(this, axisalignedbb);
            ArrayList list1 = Lists.newArrayList();
            for (Entity entity : list) {
                if (entity.aq() == EntityTypes.W) {
                    list1.add(entity);
                    continue;
                }
                if (entity.dR()) continue;
                this.d(entity);
            }
            if (!list1.isEmpty()) {
                this.d((Entity)SystemUtils.a(list1, this.ae));
            }
        }
        this.c(this.gA());
        this.c(this.gB());
        if ((!this.dW().C && (this.Z > 0.5f || this.bj()) || this.i.b || this.fR() || this.av) && !this.dW().paperConfig().entities.behavior.parrotsAreUnaffectedByPlayerMovement) {
            this.gx();
        }
    }

    protected void j() {
    }

    private void c(@Nullable NBTTagCompound entityNbt) {
        if (!(entityNbt == null || entityNbt.e("Silent") && entityNbt.q("Silent") || this.dW().A.a(200) != 0)) {
            String s2 = entityNbt.l("id");
            EntityTypes.a(s2).filter(entitytypes -> entitytypes == EntityTypes.aP).ifPresent(entitytypes -> {
                if (!EntityParrot.a(this.dW(), this)) {
                    this.dW().a((EntityHuman)null, this.dB(), this.dD(), this.dH(), EntityParrot.a(this.dW(), this.dW().A), this.dn(), 1.0f, EntityParrot.a(this.dW().A));
                }
            });
        }
    }

    private void d(Entity entity) {
        entity.a_(this);
    }

    public int gd() {
        return this.al.a(e);
    }

    public void q(int score) {
        this.al.a(e, score);
    }

    public void r(int score) {
        int j2 = this.gd();
        this.al.a(e, j2 + score);
    }

    public void a(int riptideTicks, float riptideAttackDamage, net.minecraft.world.item.ItemStack stack) {
        this.bC = riptideTicks;
        this.bD = riptideAttackDamage;
        this.bE = stack;
        if (!this.dW().C) {
            this.gx();
            this.c(4, true);
        }
    }

    @Override
    @Nonnull
    public net.minecraft.world.item.ItemStack ea() {
        return this.fv() && this.bE != null ? this.bE : super.ea();
    }

    @Override
    public void a(DamageSource damageSource) {
        World world;
        super.a(damageSource);
        this.ay();
        if (!this.aa_() && (world = this.dW()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.dropAllDeathLoot(worldserver, damageSource);
        }
        if (damageSource != null) {
            this.n(-MathHelper.b((this.eK() + this.dM()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -MathHelper.a((this.eK() + this.dM()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.n(0.0, 0.1, 0.0);
        }
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aH();
        this.c(false);
        this.c(Optional.of(GlobalPos.a(this.dW().ah(), this.dw())));
    }

    @Override
    protected void f(WorldServer world) {
        super.f(world);
        if (!world.N().b(GameRules.d)) {
            this.ge();
            this.g.k();
        }
    }

    protected void ge() {
        for (int i2 = 0; i2 < this.g.b(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = this.g.a(i2);
            if (itemstack.f() || !EnchantmentManager.a(itemstack, EnchantmentEffectComponents.D)) continue;
            this.g.b(i2);
        }
    }

    @Override
    protected SoundEffect e(DamageSource source) {
        return source.k().d().a();
    }

    @Override
    public SoundEffect o_() {
        return SoundEffects.uE;
    }

    public void g(net.minecraft.world.item.ItemStack stack) {
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack stack, boolean retainOwnership) {
        return this.a(stack, false, retainOwnership);
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack stack, boolean throwRandomly, boolean retainOwnership) {
        return this.drop(stack, throwRandomly, retainOwnership, true);
    }

    @Nullable
    public EntityItem drop(net.minecraft.world.item.ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        if (!itemstack.f() && this.dW().C) {
            this.a(EnumHand.a);
        }
        return null;
    }

    public float c(IBlockData block) {
        float f2 = this.g.a(block);
        if (f2 > 1.0f) {
            f2 += (float)this.h(GenericAttributes.t);
        }
        if (MobEffectUtil.a(this)) {
            f2 *= 1.0f + (float)(MobEffectUtil.b(this) + 1) * 0.2f;
        }
        if (this.b(MobEffects.d)) {
            float f22 = switch (this.c(MobEffects.d).e()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            f2 *= f22;
        }
        f2 *= (float)this.h(GenericAttributes.f);
        if (((Entity)this).a(TagsFluid.a)) {
            f2 *= (float)this.g(GenericAttributes.C).g();
        }
        if (!this.aJ()) {
            f2 /= 5.0f;
        }
        return f2;
    }

    public boolean d(IBlockData state) {
        return !state.C() || this.g.f().b(state);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a_(this.k.getId());
        NBTTagList nbttaglist = nbt.c("Inventory", 10);
        this.g.b(nbttaglist);
        this.g.j = nbt.h("SelectedItemSlot");
        this.h = nbt.g("SleepTimer");
        this.cs = nbt.j("XpP");
        this.cq = nbt.h("XpLevel");
        this.cr = nbt.h("XpTotal");
        this.ct = nbt.h("XpSeed");
        if (this.ct == 0) {
            this.ct = this.ae.f();
        }
        this.q(nbt.h("Score"));
        this.ce.a(nbt);
        this.i.b(nbt);
        this.g(GenericAttributes.v).a(this.i.b());
        if (nbt.b("EnderItems", 9)) {
            this.cb.a(nbt.c("EnderItems", 10), this.dY());
        }
        if (nbt.b("ShoulderEntityLeft", 10)) {
            this.i(nbt.p("ShoulderEntityLeft"));
        }
        if (nbt.b("ShoulderEntityRight", 10)) {
            this.j(nbt.p("ShoulderEntityRight"));
        }
        if (nbt.b("LastDeathLocation", 10)) {
            DataResult dataresult = GlobalPos.b.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("LastDeathLocation"));
            Logger logger = a;
            Objects.requireNonNull(logger);
            this.c(dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)));
        }
        if (nbt.b("current_explosion_impact_pos", 9)) {
            DataResult dataresult1 = Vec3D.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("current_explosion_impact_pos"));
            Logger logger1 = a;
            Objects.requireNonNull(logger1);
            dataresult1.resultOrPartial(arg_0 -> ((Logger)logger1).error(arg_0)).ifPresent(vec3d -> {
                this.cx = vec3d;
            });
        }
        this.cF = nbt.q("ignore_fall_damage_from_current_explosion");
        this.cG = nbt.h("current_impulse_context_reset_grace_time");
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        GameProfileSerializer.e(nbt);
        nbt.a("Inventory", this.g.a(new NBTTagList()));
        nbt.a("SelectedItemSlot", this.g.j);
        nbt.a("SleepTimer", (short)this.h);
        nbt.a("XpP", this.cs);
        nbt.a("XpLevel", this.cq);
        nbt.a("XpTotal", this.cr);
        nbt.a("XpSeed", this.ct);
        nbt.a("Score", this.gd());
        this.ce.b(nbt);
        this.i.a(nbt);
        nbt.a("EnderItems", this.cb.a(this.dY()));
        if (!this.gA().g()) {
            nbt.a("ShoulderEntityLeft", this.gA());
        }
        if (!this.gB().g()) {
            nbt.a("ShoulderEntityRight", this.gB());
        }
        this.gI().flatMap(globalpos -> {
            DataResult dataresult = GlobalPos.b.encodeStart((DynamicOps)DynamicOpsNBT.a, globalpos);
            Logger logger = a;
            Objects.requireNonNull(logger);
            return dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
        }).ifPresent(nbtbase -> nbt.a("LastDeathLocation", (NBTBase)nbtbase));
        if (this.cx != null) {
            nbt.a("current_explosion_impact_pos", (NBTBase)Vec3D.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cx).getOrThrow());
        }
        nbt.a("ignore_fall_damage_from_current_explosion", this.cF);
        nbt.a("current_impulse_context_reset_grace_time", this.cG);
    }

    @Override
    public boolean a(WorldServer world, DamageSource source) {
        return super.a(world, source) ? true : (source.a(DamageTypeTags.n) ? !world.N().b(GameRules.H) : (source.a(DamageTypeTags.m) ? !world.N().b(GameRules.I) : (source.a(DamageTypeTags.i) ? !world.N().b(GameRules.J) : (source.a(DamageTypeTags.o) ? !world.N().b(GameRules.K) : false))));
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        boolean damaged;
        if (this.a(world, source)) {
            return false;
        }
        if (this.i.a && !source.a(DamageTypeTags.d)) {
            return false;
        }
        this.bf = 0;
        if (this.eF()) {
            return false;
        }
        if (source.g()) {
            if (world.al() == EnumDifficulty.a) {
                return false;
            }
            if (world.al() == EnumDifficulty.b) {
                amount = Math.min(amount / 2.0f + 1.0f, amount);
            }
            if (world.al() == EnumDifficulty.d) {
                amount = amount * 3.0f / 2.0f;
            }
        }
        if (damaged = super.a(world, source, amount)) {
            this.gx();
        }
        return damaged;
    }

    @Override
    protected void d(EntityLiving attacker) {
        super.d(attacker);
        net.minecraft.world.item.ItemStack itemstack = this.fH();
        if (attacker.fU() && itemstack != null) {
            this.disableShield(itemstack, attacker);
        }
    }

    @Override
    public boolean ex() {
        return !this.gj().a && super.ex();
    }

    public boolean a(EntityHuman player) {
        Team team;
        if (player instanceof EntityPlayer) {
            EntityPlayer thatPlayer = (EntityPlayer)player;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = player.dW().getCraftServer().getOfflinePlayer(player.cI());
            team = player.dW().getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof EntityPlayer) {
            return !team.hasPlayer((OfflinePlayer)((EntityPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.dW().getCraftServer().getOfflinePlayer(this.cI()));
    }

    @Override
    protected void c(DamageSource source, float amount) {
        this.a(source, amount, EnumItemSlot.c, EnumItemSlot.d, EnumItemSlot.e, EnumItemSlot.f);
    }

    @Override
    protected void d(DamageSource source, float amount) {
        this.a(source, amount, EnumItemSlot.f);
    }

    @Override
    protected void z(float amount) {
        if (this.bz.a(Items.wi)) {
            if (!this.dW().C) {
                this.b(StatisticList.c.b(this.bz.h()));
            }
            if (amount >= 3.0f) {
                int i2 = 1 + MathHelper.d(amount);
                EnumHand enumhand = this.fA();
                this.bz.a(i2, (EntityLiving)this, EntityHuman.d(enumhand));
                if (this.bz.f()) {
                    if (enumhand == EnumHand.a) {
                        this.a(EnumItemSlot.a, net.minecraft.world.item.ItemStack.j);
                    } else {
                        this.a(EnumItemSlot.b, net.minecraft.world.item.ItemStack.j);
                    }
                    this.bz = net.minecraft.world.item.ItemStack.j;
                    this.a(SoundEffects.wY, 0.8f, 0.8f + this.dW().A.i() * 0.4f);
                }
            }
        }
    }

    @Override
    protected boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f2, EntityDamageEvent event) {
        return super.actuallyHurt(worldserver, damagesource, f2, event);
    }

    public boolean aa() {
        return false;
    }

    public void a(TileEntitySign sign, boolean front) {
    }

    public void a(CommandBlockListenerAbstract commandBlockExecutor) {
    }

    public void a(TileEntityCommand commandBlock) {
    }

    public void a(TileEntityStructure structureBlock) {
    }

    public void a(TileEntityJigsaw jigsaw) {
    }

    public void a(EntityHorseAbstract horse, IInventory inventory) {
    }

    public OptionalInt a(@Nullable ITileInventory factory) {
        return OptionalInt.empty();
    }

    public void a(int syncId, MerchantRecipeList offers, int levelProgress, int experience, boolean leveled, boolean refreshable) {
    }

    public void a(net.minecraft.world.item.ItemStack book, EnumHand hand) {
    }

    public EnumInteractionResult a(Entity entity, EnumHand hand) {
        if (this.aa_()) {
            if (entity instanceof ITileInventory) {
                this.a((ITileInventory)((Object)entity));
            }
            return EnumInteractionResult.e;
        }
        net.minecraft.world.item.ItemStack itemstack = this.b(hand);
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.v();
        EnumInteractionResult enuminteractionresult = entity.a(this, hand);
        if (enuminteractionresult.a()) {
            if (this.i.d && itemstack == this.b(hand) && itemstack.L() < itemstack1.L()) {
                itemstack.e(itemstack1.L());
            }
            return enuminteractionresult;
        }
        if (!itemstack.f() && entity instanceof EntityLiving) {
            EnumInteractionResult enuminteractionresult1;
            if (this.i.d) {
                itemstack = itemstack1;
            }
            if ((enuminteractionresult1 = itemstack.a(this, (EntityLiving)entity, hand)).a()) {
                this.dW().a(GameEvent.r, entity.du(), GameEvent.a.a(this));
                if (itemstack.f() && !this.i.d) {
                    this.a(hand, net.minecraft.world.item.ItemStack.j);
                }
                return enuminteractionresult1;
            }
        }
        return EnumInteractionResult.e;
    }

    @Override
    public void bQ() {
        this.removeVehicle(false);
    }

    @Override
    public void removeVehicle(boolean suppressCancellation) {
        super.removeVehicle(suppressCancellation);
        this.J = 0;
    }

    @Override
    protected boolean fi() {
        return super.fi() || this.fR() || this.dR() || !this.valid;
    }

    @Override
    public boolean el() {
        return !this.i.b;
    }

    @Override
    protected Vec3D a(Vec3D movement, EnumMoveType type) {
        float f2 = this.dQ();
        if (!this.i.b && movement.e <= 0.0 && (type == EnumMoveType.a || type == EnumMoveType.b) && this.ga() && this.I(f2)) {
            double d0;
            double d1 = movement.f;
            double d2 = 0.05;
            double d3 = Math.signum(d0) * 0.05;
            double d4 = Math.signum(d1) * 0.05;
            for (d0 = movement.d; d0 != 0.0 && this.b(d0, 0.0, f2); d0 -= d3) {
                if (!(Math.abs(d0) <= 0.05)) continue;
                d0 = 0.0;
                break;
            }
            while (d1 != 0.0 && this.b(0.0, d1, f2)) {
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    break;
                }
                d1 -= d4;
            }
            while (d0 != 0.0 && d1 != 0.0 && this.b(d0, d1, f2)) {
                d0 = Math.abs(d0) <= 0.05 ? 0.0 : (d0 -= d3);
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    continue;
                }
                d1 -= d4;
            }
            return new Vec3D(d0, movement.e, d1);
        }
        return movement;
    }

    private boolean I(float f2) {
        return this.aJ() || this.Z < f2 && !this.b(0.0, 0.0, f2 - this.Z);
    }

    private boolean b(double offsetX, double offsetZ, float f2) {
        AxisAlignedBB axisalignedbb = this.cR();
        return this.dW().a((Entity)this, new AxisAlignedBB(axisalignedbb.a + offsetX, axisalignedbb.b - (double)f2 - (double)1.0E-5f, axisalignedbb.c + offsetZ, axisalignedbb.d + offsetX, axisalignedbb.b, axisalignedbb.f + offsetZ));
    }

    public void e(Entity target) {
        boolean willAttack = target.cB() && !target.v(this);
        PrePlayerAttackEntityEvent playerAttackEntityEvent = new PrePlayerAttackEntityEvent((Player)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), willAttack);
        if (playerAttackEntityEvent.callEvent() && willAttack) {
            float f2 = this.fv() ? this.bD : (float)this.h(GenericAttributes.c);
            net.minecraft.world.item.ItemStack itemstack = this.ea();
            DamageSource damagesource = Optional.ofNullable(itemstack.h().a(this)).orElse(this.dX().a(this));
            float f1 = this.a(target, f2, damagesource) - f2;
            float f22 = this.H(0.5f);
            f2 *= 0.2f + f22 * f22 * 0.8f;
            f1 *= f22;
            if (target.aq().a(TagsEntity.H) && target instanceof IProjectile) {
                IProjectile iprojectile = (IProjectile)target;
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(target, damagesource, f1, false)) {
                    return;
                }
                if (iprojectile.a(ProjectileDeflection.c, this, this, true)) {
                    this.dW().a((EntityHuman)null, this.dB(), this.dD(), this.dH(), SoundEffects.ux, this.dn());
                    return;
                }
            }
            if (f2 > 0.0f || f1 > 0.0f) {
                double d1;
                double d0;
                boolean flag1;
                boolean flag;
                boolean bl = flag = f22 > 0.9f;
                if (this.cj() && flag) {
                    EntityHuman.sendSoundEffect(this, this.dB(), this.dD(), this.dH(), SoundEffects.uw, this.dn(), 1.0f, 1.0f);
                    flag1 = true;
                } else {
                    flag1 = false;
                }
                f2 += itemstack.h().a(target, f2, damagesource);
                boolean flag2 = flag && this.Z > 0.0f && !this.aJ() && !this.q_() && !this.bj() && !this.b(MobEffects.o) && !this.bZ() && target instanceof EntityLiving && !this.cj();
                boolean bl2 = flag2 = flag2 && !this.dW().paperConfig().entities.behavior.disablePlayerCrits;
                if (flag2) {
                    damagesource = damagesource.critical(true);
                    f2 *= 1.5f;
                }
                float f3 = f2 + f1;
                boolean flag3 = false;
                if (flag && !flag2 && !flag1 && this.aJ() && (d0 = this.ah().j()) < MathHelper.k(d1 = (double)this.fp() * 2.5) && this.b(EnumHand.a).a(TagsItem.bJ)) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                if (target instanceof EntityLiving) {
                    EntityLiving entityliving = (EntityLiving)target;
                    f4 = entityliving.eE();
                }
                Vec3D vec3d = target.dz();
                boolean flag4 = target.b(damagesource, f3);
                if (flag4) {
                    float f5 = this.a(target, damagesource) + (flag1 ? 1.0f : 0.0f);
                    if (f5 > 0.0f) {
                        if (target instanceof EntityLiving) {
                            EntityLiving entityliving1 = (EntityLiving)target;
                            entityliving1.knockback(f5 * 0.5f, MathHelper.a(this.dM() * ((float)Math.PI / 180)), -MathHelper.b(this.dM() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.Cause.ENTITY_ATTACK);
                        } else {
                            target.push(-MathHelper.a(this.dM() * ((float)Math.PI / 180)) * f5 * 0.5f, 0.1, MathHelper.b(this.dM() * ((float)Math.PI / 180)) * f5 * 0.5f, this);
                        }
                        this.h(this.dz().d(0.6, 1.0, 0.6));
                        if (!this.dW().paperConfig().misc.disableSprintInterruptionOnAttack) {
                            this.h(false);
                        }
                    }
                    if (flag3) {
                        float f6 = 1.0f + (float)this.h(GenericAttributes.D) * f2;
                        List<EntityLiving> list = this.dW().a(EntityLiving.class, target.cR().c(1.0, 0.25, 1.0));
                        for (EntityLiving entityliving2 : list) {
                            if (entityliving2 == this || entityliving2 == target || this.s(entityliving2) || entityliving2 instanceof EntityArmorStand && ((EntityArmorStand)entityliving2).x() || !(this.g((Entity)entityliving2) < 9.0)) continue;
                            float f7 = this.a((Entity)entityliving2, f6, damagesource) * f22;
                            if (!entityliving2.a((WorldServer)this.dW(), this.dX().a(this).sweep().critical(flag2), f7)) continue;
                            entityliving2.knockback(0.4f, MathHelper.a(this.dM() * ((float)Math.PI / 180)), -MathHelper.b(this.dM() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.Cause.SWEEP_ATTACK);
                            World world = this.dW();
                            if (!(world instanceof WorldServer)) continue;
                            WorldServer worldserver = (WorldServer)world;
                            EnchantmentManager.a(worldserver, (Entity)entityliving2, damagesource);
                        }
                        EntityHuman.sendSoundEffect(this, this.dB(), this.dD(), this.dH(), SoundEffects.uz, this.dn(), 1.0f, 1.0f);
                        this.gf();
                    }
                    if (target instanceof EntityPlayer && target.T) {
                        boolean cancelled = false;
                        Player player = (Player)target.getBukkitEntity();
                        Vector velocity = CraftVector.toBukkit(vec3d);
                        PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                        this.dW().getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            cancelled = true;
                        } else if (!velocity.equals((Object)event.getVelocity())) {
                            player.setVelocity(event.getVelocity());
                        }
                        if (!cancelled) {
                            ((EntityPlayer)target).f.b(new PacketPlayOutEntityVelocity(target));
                            target.T = false;
                            target.h(vec3d);
                        }
                    }
                    if (flag2) {
                        EntityHuman.sendSoundEffect(this, this.dB(), this.dD(), this.dH(), SoundEffects.uv, this.dn(), 1.0f, 1.0f);
                        this.b(target);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            EntityHuman.sendSoundEffect(this, this.dB(), this.dD(), this.dH(), SoundEffects.uy, this.dn(), 1.0f, 1.0f);
                        } else {
                            EntityHuman.sendSoundEffect(this, this.dB(), this.dD(), this.dH(), SoundEffects.uA, this.dn(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.c(target);
                    }
                    this.B(target);
                    Entity object = target;
                    if (target instanceof EntityComplexPart) {
                        object = ((EntityComplexPart)target).a;
                    }
                    boolean flag5 = false;
                    World world1 = this.dW();
                    if (world1 instanceof WorldServer) {
                        WorldServer worldserver1 = (WorldServer)world1;
                        if (object instanceof EntityLiving) {
                            EntityLiving entityliving2;
                            entityliving2 = (EntityLiving)object;
                            flag5 = itemstack.a(entityliving2, (EntityLiving)this);
                        }
                        EnchantmentManager.a(worldserver1, target, damagesource);
                    }
                    if (!this.dW().C && !itemstack.f() && object instanceof EntityLiving) {
                        if (flag5) {
                            itemstack.b((EntityLiving)object, (EntityLiving)this);
                        }
                        if (itemstack.f()) {
                            if (itemstack == this.eZ()) {
                                this.a(EnumHand.a, net.minecraft.world.item.ItemStack.j);
                            } else {
                                this.a(EnumHand.b, net.minecraft.world.item.ItemStack.j);
                            }
                        }
                    }
                    if (target instanceof EntityLiving) {
                        float f8 = f4 - ((EntityLiving)target).eE();
                        this.a(StatisticList.G, Math.round(f8 * 10.0f));
                        if (this.dW() instanceof WorldServer && f8 > 2.0f) {
                            int i2 = (int)((double)f8 * 0.5);
                            ((WorldServer)this.dW()).a(Particles.g, target.dB(), target.e(0.5), target.dH(), i2, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.causeFoodExhaustion(this.dW().spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
                } else {
                    EntityHuman.sendSoundEffect(this, this.dB(), this.dD(), this.dH(), SoundEffects.ux, this.dn(), 1.0f, 1.0f);
                    if (this instanceof EntityPlayer) {
                        ((EntityPlayer)this).getBukkitEntity().updateInventory();
                    }
                }
            }
        }
    }

    protected float a(Entity target, float baseDamage, DamageSource damageSource) {
        return baseDamage;
    }

    @Override
    protected void g(EntityLiving target) {
        this.e((Entity)target);
    }

    @DoNotUse
    @Deprecated
    public void h(net.minecraft.world.item.ItemStack shield) {
        this.disableShield(shield, null);
    }

    public void disableShield(net.minecraft.world.item.ItemStack shield, @Nullable EntityLiving attacker) {
        CraftEntity finalAttacker;
        CraftEntity craftEntity = finalAttacker = attacker != null ? attacker.getBukkitEntity() : null;
        if (finalAttacker != null) {
            PlayerShieldDisableEvent shieldDisableEvent = new PlayerShieldDisableEvent((Player)this.getBukkitEntity(), (org.bukkit.entity.Entity)finalAttacker, 100);
            if (!shieldDisableEvent.callEvent()) {
                return;
            }
            this.gE().a(shield, shieldDisableEvent.getCooldown());
        } else {
            this.gE().a(shield, 100);
        }
        this.fF();
        this.dW().a((Entity)this, (byte)30);
    }

    public void b(Entity target) {
    }

    public void c(Entity target) {
    }

    public void gf() {
        double d0 = -MathHelper.a(this.dM() * ((float)Math.PI / 180));
        double d1 = MathHelper.b(this.dM() * ((float)Math.PI / 180));
        if (this.dW() instanceof WorldServer) {
            ((WorldServer)this.dW()).a(Particles.ak, this.dB() + d0, this.e(0.5), this.dH() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    public void gg() {
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        this.remove(reason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        super.remove(entity_removalreason, cause);
        this.cc.a(this);
        if (this.cd != null && this.gk()) {
            this.q();
        }
    }

    public boolean c() {
        return false;
    }

    public GameProfile gh() {
        return this.k;
    }

    public PlayerInventory gi() {
        return this.g;
    }

    public PlayerAbilities gj() {
        return this.i;
    }

    @Override
    public boolean fV() {
        return this.i.d;
    }

    public void a(net.minecraft.world.item.ItemStack cursorStack, net.minecraft.world.item.ItemStack slotStack, ClickAction clickType) {
    }

    public boolean gk() {
        return this.cd != this.cc;
    }

    public boolean gl() {
        return true;
    }

    public Either<EnumBedResult, Unit> a(BlockPosition pos) {
        return this.startSleepInBed(pos, false);
    }

    public Either<EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        this.b(blockposition);
        this.h = 0;
        return Either.right(Unit.a);
    }

    public void a(boolean skipSleepTimer, boolean updateSleepingPlayers) {
        super.fS();
        if (this.dW() instanceof WorldServer && updateSleepingPlayers) {
            ((WorldServer)this.dW()).f();
        }
        this.h = skipSleepTimer ? 0 : 100;
    }

    @Override
    public void fS() {
        this.a(true, true);
    }

    public boolean gm() {
        return this.fR() && this.h >= 100;
    }

    public int gn() {
        return this.h;
    }

    public void a(IChatBaseComponent message, boolean overlay) {
    }

    public void a(MinecraftKey stat) {
        this.b(StatisticList.i.b(stat));
    }

    public void a(MinecraftKey stat, int amount) {
        this.a(StatisticList.i.b(stat), amount);
    }

    public void b(Statistic<?> stat) {
        this.a(stat, 1);
    }

    public void a(Statistic<?> stat, int amount) {
    }

    public void a(Statistic<?> stat) {
    }

    public int a(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    public void a(RecipeHolder<?> recipe, List<net.minecraft.world.item.ItemStack> ingredients) {
    }

    public void b(List<ResourceKey<IRecipe<?>>> recipes) {
    }

    public int b(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    @Override
    public void a_(Vec3D movementInput) {
        if (this.bZ()) {
            super.a_(movementInput);
        } else {
            double d0;
            if (this.ck()) {
                double d1;
                d0 = this.bT().e;
                double d2 = d1 = d0 < -0.2 ? 0.085 : 0.06;
                if (d0 <= 0.0 || this.bn || !this.dW().b_(BlockPosition.a(this.dB(), this.dD() + 1.0 - 0.1, this.dH())).c()) {
                    Vec3D vec3d1 = this.dz();
                    this.h(vec3d1.b(0.0, (d0 - vec3d1.e) * d1, 0.0));
                }
            }
            if (this.gj().b) {
                d0 = this.dz().e;
                super.a_(movementInput);
                this.h(this.dz().a(EnumDirection.EnumAxis.b, d0 * 0.6));
            } else {
                super.a_(movementInput);
            }
        }
    }

    @Override
    protected boolean ft() {
        return !this.i.b && super.ft();
    }

    @Override
    public void bp() {
        if (this.i.b) {
            this.i(false);
        } else {
            super.bp();
        }
    }

    protected boolean h(BlockPosition pos) {
        return !this.dW().a_(pos).j(this.dW(), pos);
    }

    @Override
    public float fp() {
        return (float)this.h(GenericAttributes.v);
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        float f2;
        boolean flag;
        if (this.i.c && !this.flyingFallDamage.toBooleanOrElse(false)) {
            return false;
        }
        if (fallDistance >= 2.0f) {
            this.a(StatisticList.t, (int)Math.round((double)fallDistance * 100.0));
        }
        boolean bl = flag = this.cx != null && this.cF;
        if (flag) {
            boolean flag1;
            f2 = Math.min(fallDistance, (float)(this.cx.e - this.dD()));
            boolean bl2 = flag1 = f2 <= 0.0f;
            if (flag1) {
                this.gN();
            } else {
                this.gM();
            }
        } else {
            f2 = fallDistance;
        }
        if (f2 > 0.0f && super.a(f2, damageMultiplier, damageSource)) {
            this.gN();
            return true;
        }
        return false;
    }

    public boolean go() {
        if (!this.fJ() && this.ft() && !this.bj()) {
            this.gp();
            return true;
        }
        return false;
    }

    public void gp() {
        if (!CraftEventFactory.callToggleGlideEvent(this, true).isCancelled()) {
            this.b(7, true);
        } else {
            this.b(7, true);
            this.b(7, false);
        }
    }

    public void gq() {
        if (!CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            this.b(7, true);
            this.b(7, false);
        }
    }

    @Override
    protected void bs() {
        if (!this.aa_()) {
            super.bs();
        }
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        if (this.bj()) {
            this.aY();
            this.b(state);
        } else {
            BlockPosition blockposition1 = this.e(pos);
            if (!pos.equals(blockposition1)) {
                IBlockData iblockdata1 = this.dW().a_(blockposition1);
                if (iblockdata1.a(TagsBlock.bq)) {
                    this.a(iblockdata1, state);
                } else {
                    super.b(blockposition1, iblockdata1);
                }
            } else {
                super.b(pos, state);
            }
        }
    }

    @Override
    public EntityLiving.a eM() {
        return new EntityLiving.a(SoundEffects.uL, SoundEffects.uB);
    }

    @Override
    public boolean a(WorldServer world, EntityLiving other) {
        this.b(StatisticList.g.b(other.aq()));
        return true;
    }

    @Override
    public void a(IBlockData state, Vec3D multiplier) {
        if (!this.i.b) {
            super.a(state, multiplier);
        }
        this.gM();
    }

    public void d(int experience) {
        this.r(experience);
        this.cs += (float)experience / (float)this.gs();
        this.cr = MathHelper.a(this.cr + experience, 0, Integer.MAX_VALUE);
        while (this.cs < 0.0f) {
            float f2 = this.cs * (float)this.gs();
            if (this.cq > 0) {
                this.c(-1);
                this.cs = 1.0f + f2 / (float)this.gs();
                continue;
            }
            this.c(-1);
            this.cs = 0.0f;
        }
        while (this.cs >= 1.0f) {
            this.cs = (this.cs - 1.0f) * (float)this.gs();
            this.c(1);
            this.cs /= (float)this.gs();
        }
    }

    public int gr() {
        return this.ct;
    }

    public void a(net.minecraft.world.item.ItemStack enchantedItem, int experienceLevels) {
        this.cq -= experienceLevels;
        if (this.cq < 0) {
            this.cq = 0;
            this.cs = 0.0f;
            this.cr = 0;
        }
        this.ct = this.ae.f();
    }

    public void c(int levels) {
        this.cq = IntMath.saturatedAdd((int)this.cq, (int)levels);
        if (this.cq < 0) {
            this.cq = 0;
            this.cs = 0.0f;
            this.cr = 0;
        }
        if (levels > 0 && this.cq % 5 == 0 && (float)this.j < (float)this.af - 100.0f) {
            float f2 = this.cq > 30 ? 1.0f : (float)this.cq / 30.0f;
            this.dW().a((EntityHuman)null, this.dB(), this.dD(), this.dH(), SoundEffects.uK, this.dn(), f2 * 0.75f, 1.0f);
            this.j = this.af;
        }
    }

    public int gs() {
        return this.cq >= 30 ? 112 + (this.cq - 30) * 9 : (this.cq >= 15 ? 37 + (this.cq - 15) * 5 : 7 + this.cq * 2);
    }

    private static void sendSoundEffect(EntityHuman fromEntity, double x2, double y2, double z2, SoundEffect soundEffect, SoundCategory soundCategory, float volume, float pitch) {
        fromEntity.dW().a(fromEntity, x2, y2, z2, soundEffect, soundCategory, volume, pitch);
        if (fromEntity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)fromEntity;
            serverPlayer.f.b(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.b.e(soundEffect), soundCategory, x2, y2, z2, volume, pitch, fromEntity.ae.g()));
        }
    }

    public void G(float exhaustion) {
        this.causeFoodExhaustion(exhaustion, EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    }

    public void causeFoodExhaustion(float f2, EntityExhaustionEvent.ExhaustionReason reason) {
        EntityExhaustionEvent event;
        if (!(this.i.a || this.dW().C || (event = CraftEventFactory.callPlayerExhaustionEvent(this, reason, f2)).isCancelled())) {
            this.ce.a(event.getExhaustion());
        }
    }

    public Optional<WardenSpawnTracker> ac() {
        return Optional.empty();
    }

    public FoodMetaData gt() {
        return this.ce;
    }

    public boolean u(boolean ignoreHunger) {
        return this.i.a || ignoreHunger || this.ce.b();
    }

    public boolean gu() {
        return this.eE() > 0.0f && this.eE() < this.eS();
    }

    public boolean gv() {
        return this.i.e;
    }

    public boolean a(BlockPosition pos, EnumDirection facing, net.minecraft.world.item.ItemStack stack) {
        if (this.i.e) {
            return true;
        }
        BlockPosition blockposition1 = pos.a(facing.g());
        ShapeDetectorBlock shapedetectorblock = new ShapeDetectorBlock(this.dW(), blockposition1, false);
        return stack.a(shapedetectorblock);
    }

    @Override
    protected int e(WorldServer world) {
        return !world.N().b(GameRules.d) && !this.aa_() ? Math.min(this.cq * 7, 100) : 0;
    }

    @Override
    protected boolean ep() {
        return true;
    }

    @Override
    public boolean cM() {
        return true;
    }

    @Override
    protected Entity.MovementEmission bg() {
        return !this.i.b && (!this.aJ() || !this.cg()) ? Entity.MovementEmission.d : Entity.MovementEmission.a;
    }

    public void x() {
    }

    @Override
    public IChatBaseComponent al() {
        return IChatBaseComponent.b(this.k.getName());
    }

    public InventoryEnderChest gw() {
        return this.cb;
    }

    @Override
    public net.minecraft.world.item.ItemStack a(EnumItemSlot slot) {
        return slot == EnumItemSlot.a ? this.g.f() : (slot == EnumItemSlot.b ? (net.minecraft.world.item.ItemStack)this.g.i.getFirst() : (slot.a() == EnumItemSlot.Function.b ? this.g.h.get(slot.b()) : net.minecraft.world.item.ItemStack.j));
    }

    @Override
    protected boolean b(EnumItemSlot slot) {
        return slot.a() == EnumItemSlot.Function.b;
    }

    @Override
    public void a(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        this.c(itemstack);
        if (enumitemslot == EnumItemSlot.a) {
            this.onEquipItem(enumitemslot, this.g.g.set(this.g.j, itemstack), itemstack, silent);
        } else if (enumitemslot == EnumItemSlot.b) {
            this.onEquipItem(enumitemslot, this.g.i.set(0, itemstack), itemstack, silent);
        } else if (enumitemslot.a() == EnumItemSlot.Function.b) {
            this.onEquipItem(enumitemslot, this.g.h.set(enumitemslot.b(), itemstack), itemstack, silent);
        }
    }

    public boolean i(net.minecraft.world.item.ItemStack stack) {
        return this.g.f(stack);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> fc() {
        return Lists.newArrayList((Object[])new net.minecraft.world.item.ItemStack[]{this.eZ(), this.fa()});
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> fb() {
        return this.g.h;
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.g;
    }

    public boolean h(NBTTagCompound entityNbt) {
        if (!this.bZ() && this.aJ() && !this.bj() && !this.av) {
            if (this.gA().g()) {
                this.i(entityNbt);
                this.f = this.dW().ac();
                return true;
            }
            if (this.gB().g()) {
                this.j(entityNbt);
                this.f = this.dW().ac();
                return true;
            }
            return false;
        }
        return false;
    }

    public void gx() {
        if (this.f + 20L < this.dW().ac()) {
            if (this.respawnEntityOnShoulder(this.gA())) {
                this.i(new NBTTagCompound());
            }
            if (this.respawnEntityOnShoulder(this.gB())) {
                this.j(new NBTTagCompound());
            }
        }
    }

    public Entity releaseLeftShoulderEntity() {
        Entity entity = this.respawnEntityOnShoulder0(this.gA());
        if (entity != null) {
            this.i(new NBTTagCompound());
        }
        return entity;
    }

    public Entity releaseRightShoulderEntity() {
        Entity entity = this.respawnEntityOnShoulder0(this.gB());
        if (entity != null) {
            this.j(new NBTTagCompound());
        }
        return entity;
    }

    private boolean respawnEntityOnShoulder(NBTTagCompound nbttagcompound) {
        return this.respawnEntityOnShoulder0(nbttagcompound) != null;
    }

    private Entity respawnEntityOnShoulder0(NBTTagCompound nbttagcompound) {
        if (!this.dW().C && !nbttagcompound.g()) {
            return EntityTypes.a(nbttagcompound, this.dW(), EntitySpawnReason.r).map(entity -> {
                if (entity instanceof EntityTameableAnimal) {
                    ((EntityTameableAnimal)entity).b(this.at);
                }
                entity.a_(this.dB(), this.dD() + (double)0.7f, this.dH());
                return ((WorldServer)this.dW()).addWithUUID((Entity)entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY) ? entity : null;
            }).orElse(null);
        }
        return null;
    }

    @Override
    public abstract boolean aa_();

    @Override
    public boolean bG() {
        return !this.aa_() && super.bG();
    }

    @Override
    public boolean ck() {
        return !this.i.b && !this.aa_() && super.ck();
    }

    public abstract boolean b();

    @Override
    public boolean cJ() {
        return !this.i.b;
    }

    public Scoreboard gy() {
        return this.dW().Q();
    }

    @Override
    public IChatBaseComponent p_() {
        IChatMutableComponent ichatmutablecomponent = ScoreboardTeam.a(this.cr(), this.al());
        return this.a(ichatmutablecomponent);
    }

    private IChatMutableComponent a(IChatMutableComponent component) {
        String s2 = this.gh().getName();
        return component.a(chatmodifier -> chatmodifier.a(new ChatClickable(ChatClickable.EnumClickAction.d, "/tell " + s2 + " ")).a(this.cQ()).a(s2));
    }

    @Override
    public String cI() {
        return this.gh().getName();
    }

    @Override
    protected void F(float absorptionAmount) {
        this.au().a(d, Float.valueOf(absorptionAmount));
    }

    @Override
    public float fw() {
        return this.au().a(d).floatValue();
    }

    public boolean a(PlayerModelPart modelPart) {
        return (this.au().a(bX) & modelPart.a()) == modelPart.a();
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        if (mappedIndex == 499) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack a() {
                    return EntityHuman.this.cd.g();
                }

                @Override
                public boolean a(net.minecraft.world.item.ItemStack stack) {
                    EntityHuman.this.cd.b(stack);
                    return true;
                }
            };
        }
        final int j2 = mappedIndex - 500;
        if (j2 >= 0 && j2 < 4) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack a() {
                    return EntityHuman.this.cc.r().a(j2);
                }

                @Override
                public boolean a(net.minecraft.world.item.ItemStack stack) {
                    EntityHuman.this.cc.r().a(j2, stack);
                    EntityHuman.this.cc.a(EntityHuman.this.g);
                    return true;
                }
            };
        }
        if (mappedIndex >= 0 && mappedIndex < this.g.g.size()) {
            return SlotAccess.a(this.g, mappedIndex);
        }
        int k2 = mappedIndex - 200;
        return k2 >= 0 && k2 < this.cb.b() ? SlotAccess.a(this.cb, k2) : super.a_(mappedIndex);
    }

    public boolean gz() {
        return this.cz;
    }

    public void v(boolean reducedDebugInfo) {
        this.cz = reducedDebugInfo;
    }

    @Override
    public void h(int fireTicks) {
        super.h(this.i.a ? Math.min(fireTicks, 1) : fireTicks);
    }

    @Override
    public EnumMainHand fy() {
        return this.al.a(bY) == 0 ? EnumMainHand.a : EnumMainHand.b;
    }

    public void b(EnumMainHand arm) {
        this.al.a(bY, (byte)(arm != EnumMainHand.a ? 1 : 0));
    }

    public NBTTagCompound gA() {
        return this.al.a(bZ);
    }

    public void i(NBTTagCompound entityNbt) {
        this.al.a(bZ, entityNbt);
    }

    public NBTTagCompound gB() {
        return this.al.a(ca);
    }

    public void j(NBTTagCompound entityNbt) {
        this.al.a(ca, entityNbt);
    }

    public float gC() {
        return (float)(1.0 / this.h(GenericAttributes.e) * 20.0);
    }

    public float H(float baseTime) {
        return MathHelper.a(((float)this.aS + baseTime) / this.gC(), 0.0f, 1.0f);
    }

    public void gD() {
        this.aS = 0;
    }

    public ItemCooldown gE() {
        return this.cD;
    }

    @Override
    protected float aT() {
        return !this.i.b && !this.fJ() ? super.aT() : 1.0f;
    }

    public float gF() {
        return (float)this.h(GenericAttributes.q);
    }

    public boolean gG() {
        return this.i.d && this.G() >= 2;
    }

    protected int G() {
        return 0;
    }

    public boolean s(int level) {
        return this.G() >= level;
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return c.getOrDefault((Object)pose, bW);
    }

    @Override
    public ImmutableList<EntityPose> fO() {
        return ImmutableList.of((Object)((Object)EntityPose.a), (Object)((Object)EntityPose.f), (Object)((Object)EntityPose.d));
    }

    protected boolean tryReadyArrow(net.minecraft.world.item.ItemStack bow, net.minecraft.world.item.ItemStack itemstack) {
        return !(this instanceof EntityPlayer) || new PlayerReadyArrowEvent((Player)((EntityPlayer)this).getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(bow), (ItemStack)CraftItemStack.asCraftMirror(itemstack)).callEvent();
    }

    @Override
    public net.minecraft.world.item.ItemStack d(net.minecraft.world.item.ItemStack stack) {
        if (!(stack.h() instanceof ItemProjectileWeapon)) {
            return net.minecraft.world.item.ItemStack.j;
        }
        Predicate<net.minecraft.world.item.ItemStack> predicate = ((ItemProjectileWeapon)stack.h()).d().and(item -> this.tryReadyArrow(stack, (net.minecraft.world.item.ItemStack)item));
        net.minecraft.world.item.ItemStack itemstack1 = ItemProjectileWeapon.a(this, predicate);
        if (!itemstack1.f()) {
            return itemstack1;
        }
        predicate = ((ItemProjectileWeapon)stack.h()).b().and(item -> this.tryReadyArrow(stack, (net.minecraft.world.item.ItemStack)item));
        for (int i2 = 0; i2 < this.g.b(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack2 = this.g.a(i2);
            if (!predicate.test(itemstack2)) continue;
            return itemstack2;
        }
        return this.i.d ? new net.minecraft.world.item.ItemStack(Items.oS) : net.minecraft.world.item.ItemStack.j;
    }

    @Override
    public Vec3D u(float delta) {
        float f3;
        double d0 = 0.22 * (this.fy() == EnumMainHand.b ? -1.0 : 1.0);
        float f1 = MathHelper.h(delta * 0.5f, this.dO(), this.O) * ((float)Math.PI / 180);
        float f2 = MathHelper.h(delta, this.aY, this.aX) * ((float)Math.PI / 180);
        if (!this.fJ() && !this.fv()) {
            if (this.cl()) {
                return this.o(delta).e(new Vec3D(d0, 0.2, -0.15).a(-f1).b(-f2));
            }
            double d2 = this.cR().c() - 1.0;
            double d1 = this.ci() ? -0.2 : 0.07;
            return this.o(delta).e(new Vec3D(d0, d2, d1).b(-f2));
        }
        Vec3D vec3d = this.g(delta);
        Vec3D vec3d1 = this.dz();
        double d1 = vec3d1.j();
        double d3 = vec3d.j();
        if (d1 > 0.0 && d3 > 0.0) {
            double d4 = (vec3d1.d * vec3d.d + vec3d1.f * vec3d.f) / Math.sqrt(d1 * d3);
            double d5 = vec3d1.d * vec3d.f - vec3d1.f * vec3d.d;
            f3 = (float)(Math.signum(d5) * Math.acos(d4));
        } else {
            f3 = 0.0f;
        }
        return this.o(delta).e(new Vec3D(d0, -0.11, 0.85).c(-f3).a(-f1).b(-f2));
    }

    @Override
    public boolean dV() {
        return true;
    }

    public boolean gH() {
        return this.fz() && this.fB().a(Items.rL);
    }

    @Override
    public boolean dU() {
        return false;
    }

    public Optional<GlobalPos> gI() {
        return this.cE;
    }

    public void c(Optional<GlobalPos> lastDeathPos) {
        this.cE = lastDeathPos;
    }

    @Override
    public float eK() {
        return this.cw;
    }

    @Override
    public void p(float yaw) {
        super.p(yaw);
        this.cw = yaw;
    }

    @Override
    public boolean dP() {
        return true;
    }

    @Override
    protected float fo() {
        return this.i.b && !this.bZ() ? (this.cj() ? this.i.a() * 2.0f : this.i.a()) : (this.cj() ? 0.025999999f : 0.02f);
    }

    public double gJ() {
        return this.h(GenericAttributes.g);
    }

    public double gK() {
        return this.h(GenericAttributes.j);
    }

    public boolean b(Entity entity, double additionalRange) {
        return entity.dR() ? false : this.a(entity.cR(), additionalRange);
    }

    public boolean a(AxisAlignedBB box, double additionalRange) {
        double d1 = this.gK() + additionalRange;
        return box.e(this.bF()) < d1 * d1;
    }

    public boolean a(BlockPosition pos, double additionalRange) {
        double d1 = this.gJ() + additionalRange;
        return new AxisAlignedBB(pos).e(this.bF()) < d1 * d1;
    }

    public void w(boolean ignoreFallDamageFromCurrentExplosion) {
        this.cF = ignoreFallDamageFromCurrentExplosion;
        this.cG = ignoreFallDamageFromCurrentExplosion ? 40 : 0;
    }

    public boolean gL() {
        return this.cF;
    }

    public void gM() {
        if (this.cG == 0) {
            this.gN();
        }
    }

    public void gN() {
        this.cG = 0;
        this.cy = null;
        this.cx = null;
        this.cF = false;
    }

    public boolean gO() {
        return false;
    }

    @Override
    public boolean dj() {
        return true;
    }

    public static enum EnumBedResult {
        a,
        b(IChatBaseComponent.c("block.minecraft.bed.no_sleep")),
        c(IChatBaseComponent.c("block.minecraft.bed.too_far_away")),
        d(IChatBaseComponent.c("block.minecraft.bed.obstructed")),
        e,
        f(IChatBaseComponent.c("block.minecraft.bed.not_safe"));

        @Nullable
        private final IChatBaseComponent g;

        private EnumBedResult() {
            this.g = null;
        }

        private EnumBedResult(IChatBaseComponent ichatbasecomponent) {
            this.g = ichatbasecomponent;
        }

        @Nullable
        public IChatBaseComponent a() {
            return this.g;
        }
    }
}

