/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftItem;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;

public abstract class EntityArrow
extends IProjectile {
    private static final double e = 2.0;
    public static final int a = 7;
    private static final DataWatcherObject<Byte> f = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Byte> g = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Boolean> h = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.k);
    private static final int i = 1;
    private static final int j = 2;
    @Nullable
    private IBlockData k;
    protected int b;
    public PickupStatus c = PickupStatus.a;
    public int d;
    public int l;
    private double m = 2.0;
    public SoundEffect n = this.s();
    @Nullable
    private IntOpenHashSet o;
    @Nullable
    private List<Entity> p;
    public ItemStack q = this.v();
    @Nullable
    public ItemStack r = null;

    @Override
    public void inactiveTick() {
        if (this.l()) {
            ++this.l;
        }
        super.inactiveTick();
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, World world) {
        super((EntityTypes<? extends IProjectile>)type, world);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, double x2, double y2, double z2, World world, ItemStack stack, @Nullable ItemStack weapon) {
        this(type, x2, y2, z2, world, stack, weapon, null);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entitytypes, double d0, double d1, double d2, World world, ItemStack itemstack, @Nullable ItemStack itemstack1, @Nullable EntityLiving ownerEntity) {
        this(entitytypes, world);
        this.c(ownerEntity);
        this.q = itemstack.v();
        this.b(itemstack.a(DataComponents.g));
        Unit unit = itemstack.c(DataComponents.v);
        if (unit != null) {
            this.c = PickupStatus.c;
        }
        this.a_(d0, d1, d2);
        if (itemstack1 != null && world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (itemstack1.f()) {
                throw new IllegalArgumentException("Invalid weapon firing an arrow");
            }
            this.r = itemstack1.v();
            int i2 = EnchantmentManager.a(worldserver, itemstack1, this.q);
            if (i2 > 0) {
                this.a((byte)i2);
            }
        }
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, EntityLiving owner, World world, ItemStack stack, @Nullable ItemStack shotFrom) {
        this(type, owner.dB(), owner.dF() - (double)0.1f, owner.dH(), world, stack, shotFrom, owner);
    }

    public void b(SoundEffect sound) {
        this.n = sound;
    }

    @Override
    public boolean a(double distance) {
        double d1 = this.cR().a() * 10.0;
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return distance < (d1 *= 64.0 * EntityArrow.cK()) * d1;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(f, (byte)0);
        builder.a(g, (byte)0);
        builder.a(h, false);
    }

    @Override
    public void c(double x2, double y2, double z2, float power, float uncertainty) {
        super.c(x2, y2, z2, power, uncertainty);
        this.l = 0;
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps) {
        this.a_(x2, y2, z2);
        this.b(yaw, pitch);
    }

    @Override
    public void l(double x2, double y2, double z2) {
        this.n(x2, y2, z2);
        this.l = 0;
        if (this.l() && MathHelper.f(x2, y2, z2) > 0.0) {
            this.a(false);
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (!this.ak && this.d <= 0 && data.equals(h) && this.l()) {
            this.d = 7;
        }
    }

    @Override
    public void h() {
        VoxelShape voxelshape;
        boolean flag = !this.B();
        Vec3D vec3d = this.dz();
        BlockPosition blockposition = this.dw();
        IBlockData iblockdata = this.dW().a_(blockposition);
        if (!iblockdata.l() && flag && !(voxelshape = iblockdata.g(this.dW(), blockposition)).c()) {
            Vec3D vec3d1 = this.du();
            for (AxisAlignedBB axisalignedbb : voxelshape.e()) {
                if (!axisalignedbb.a(blockposition).d(vec3d1)) continue;
                this.a(true);
                break;
            }
        }
        if (this.d > 0) {
            --this.d;
        }
        if (this.bk() || iblockdata.a(Blocks.rk)) {
            this.aH();
        }
        if (this.l() && flag) {
            if (!this.dW().B_()) {
                if (this.k != iblockdata && this.G()) {
                    this.H();
                } else {
                    this.m();
                }
            }
            ++this.b;
            if (this.bL()) {
                this.aK();
            }
        } else {
            if (this.af > 200) {
                this.m();
            }
            this.b = 0;
            Vec3D vec3d2 = this.du();
            if (this.bj()) {
                this.a(vec3d2);
            }
            if (this.y()) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.dW().a(Particles.f, vec3d2.d + vec3d.d * (double)i2 / 4.0, vec3d2.e + vec3d.e * (double)i2 / 4.0, vec3d2.f + vec3d.f * (double)i2 / 4.0, -vec3d.d, -vec3d.e + 0.2, -vec3d.f);
                }
            }
            float f2 = !flag ? (float)(MathHelper.d(-vec3d.d, -vec3d.f) * 57.2957763671875) : (float)(MathHelper.d(vec3d.d, vec3d.f) * 57.2957763671875);
            float f1 = (float)(MathHelper.d(vec3d.e, vec3d.i()) * 57.2957763671875);
            this.w(EntityArrow.f(this.dO(), f1));
            this.v(EntityArrow.f(this.dM(), f2));
            if (flag) {
                MovingObjectPositionBlock movingobjectpositionblock = this.dW().b(new RayTrace(vec3d2, vec3d2.e(vec3d), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
                this.b(movingobjectpositionblock);
            } else {
                this.b(vec3d2.e(vec3d));
                this.aK();
            }
            this.D();
            if (flag && !this.l()) {
                this.bf();
            }
            super.h();
        }
    }

    private void b(MovingObjectPositionBlock blockHitResult) {
        while (this.bL()) {
            Vec3D vec3d = this.du();
            MovingObjectPositionEntity movingobjectpositionentity = this.c(vec3d, blockHitResult.g());
            Vec3D vec3d1 = ((MovingObjectPosition)Objects.requireNonNullElse(movingobjectpositionentity, blockHitResult)).g();
            this.b(vec3d1);
            this.a(vec3d, vec3d1);
            if (this.as != null && this.as.e()) {
                this.bW();
            }
            if (movingobjectpositionentity == null) {
                if (!this.bL() || blockHitResult.d() == MovingObjectPosition.EnumMovingObjectType.a) break;
                this.preHitTargetOrDeflectSelf(blockHitResult);
                this.ar = true;
                break;
            }
            if (!this.bL() || this.ad) continue;
            ProjectileDeflection projectiledeflection = this.preHitTargetOrDeflectSelf(movingobjectpositionentity);
            this.ar = true;
            if (this.z() > 0 && projectiledeflection == ProjectileDeflection.a) continue;
        }
    }

    private void D() {
        Vec3D vec3d = this.dz();
        float f2 = 0.99f;
        if (this.bj()) {
            f2 = this.A();
        }
        this.h(vec3d.c((double)f2));
    }

    private void a(Vec3D pos) {
        Vec3D vec3d1 = this.dz();
        for (int i2 = 0; i2 < 4; ++i2) {
            float f2 = 0.25f;
            this.dW().a(Particles.d, pos.d - vec3d1.d * 0.25, pos.e - vec3d1.e * 0.25, pos.f - vec3d1.f * 0.25, vec3d1.d, vec3d1.e, vec3d1.f);
        }
    }

    @Override
    public ProjectileDeflection preHitTargetOrDeflectSelf(MovingObjectPosition hitResult) {
        if (hitResult instanceof MovingObjectPositionEntity) {
            MovingObjectPositionEntity entityHitResult = (MovingObjectPositionEntity)hitResult;
            if (this.hitCancelled && this.z() > 0) {
                if (this.o == null) {
                    this.o = new IntOpenHashSet(5);
                }
                this.o.add(entityHitResult.a().ar());
            }
        }
        return super.preHitTargetOrDeflectSelf(hitResult);
    }

    @Override
    protected double bd() {
        return 0.05;
    }

    private boolean G() {
        return this.l() && this.dW().b(new AxisAlignedBB(this.du(), this.du()).g(0.06));
    }

    private void H() {
        this.a(false);
        Vec3D vec3d = this.dz();
        this.h(vec3d.d(this.ae.i() * 0.2f, this.ae.i() * 0.2f, this.ae.i() * 0.2f));
        this.l = 0;
    }

    public boolean l() {
        return this.al.a(h);
    }

    protected void a(boolean inGround) {
        this.al.a(h, inGround);
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        super.a(type, movement);
        if (type != EnumMoveType.a && this.G()) {
            this.H();
        }
    }

    protected void m() {
        ++this.l;
        if (this.l >= (this.c == PickupStatus.c ? this.dW().paperConfig().entities.spawning.creativeArrowDespawnRate.value() : (this.c == PickupStatus.a ? this.dW().paperConfig().entities.spawning.nonPlayerArrowDespawnRate.value() : (this instanceof EntityThrownTrident ? this.dW().spigotConfig.tridentDespawnRate : this.dW().spigotConfig.arrowDespawnRate)))) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    private void I() {
        if (this.p != null) {
            this.p.clear();
        }
        if (this.o != null) {
            this.o.clear();
        }
    }

    @Override
    protected void b(Item item) {
        this.r = null;
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        World world;
        super.a(entityHitResult);
        Entity entity = entityHitResult.a();
        float f2 = (float)this.dz().g();
        double d0 = this.m;
        Entity entity1 = this.p();
        DamageSource damagesource = this.dX().a(this, entity1 != null ? entity1 : this);
        if (this.ea() != null && (world = this.dW()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            d0 = EnchantmentManager.a(worldserver, this.ea(), entity, damagesource, (float)d0);
        }
        int i2 = MathHelper.c(MathHelper.a((double)f2 * d0, 0.0, 2.147483647E9));
        if (this.z() > 0) {
            if (this.o == null) {
                this.o = new IntOpenHashSet(5);
            }
            if (this.p == null) {
                this.p = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.o.size() >= this.z() + 1) {
                this.discard(EntityRemoveEvent.Cause.HIT);
                return;
            }
            this.o.add(entity.ar());
        }
        if (this.y()) {
            long j2 = this.ae.a(i2 / 2 + 2);
            i2 = (int)Math.min(j2 + (long)i2, Integer.MAX_VALUE);
        }
        if (entity1 instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity1;
            entityliving.B(entity);
        }
        if (this.y()) {
            damagesource = damagesource.critical();
        }
        boolean flag = entity.aq() == EntityTypes.O;
        int k2 = entity.aG();
        if (this.bY() && !flag) {
            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), 5.0f);
            Bukkit.getPluginManager().callEvent((Event)combustEvent);
            if (!combustEvent.isCancelled()) {
                entity.igniteForSeconds(combustEvent.getDuration(), false);
            }
        }
        if (entity.b(damagesource, (float)i2)) {
            if (flag) {
                return;
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving1 = (EntityLiving)entity;
                if (!this.dW().C && this.z() <= 0) {
                    entityliving1.o(entityliving1.eU() + 1);
                }
                this.a(entityliving1, damagesource);
                World world1 = this.dW();
                if (world1 instanceof WorldServer) {
                    WorldServer worldserver1 = (WorldServer)world1;
                    EnchantmentManager.a(worldserver1, (Entity)entityliving1, damagesource, this.ea());
                }
                this.a(entityliving1);
                if (entityliving1 != entity1 && entityliving1 instanceof EntityHuman && entity1 instanceof EntityPlayer && !this.bb()) {
                    ((EntityPlayer)entity1).f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, 0.0f));
                }
                if (!entity.bL() && this.p != null) {
                    this.p.add(entityliving1);
                }
                if (!this.dW().C && entity1 instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity1;
                    if (this.p != null) {
                        CriterionTriggers.H.a(entityplayer, this.p, this.r);
                    } else if (!entity.bL()) {
                        CriterionTriggers.H.a(entityplayer, List.of(entity), this.r);
                    }
                }
            }
            this.a(this.n, 1.0f, 1.2f / (this.ae.i() * 0.2f + 0.9f));
            if (this.z() <= 0) {
                this.discard(EntityRemoveEvent.Cause.HIT);
            }
        } else {
            entity.h(k2);
            this.a(ProjectileDeflection.b, entity, this.p(), false);
            this.h(this.dz().c(0.2));
            World world2 = this.dW();
            if (world2 instanceof WorldServer) {
                WorldServer worldserver2 = (WorldServer)world2;
                if (this.dz().h() < 1.0E-7) {
                    if (this.c == PickupStatus.b) {
                        this.a(worldserver2, this.u(), 0.1f);
                    }
                    this.discard(EntityRemoveEvent.Cause.HIT);
                }
            }
        }
    }

    protected void a(EntityLiving target, DamageSource source) {
        float f2;
        World world;
        if (this.r != null && (world = this.dW()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            f2 = EnchantmentManager.d(worldserver, this.r, target, source, 0.0f);
        } else {
            f2 = 0.0f;
        }
        double d0 = f2;
        if (d0 > 0.0) {
            double d1 = Math.max(0.0, 1.0 - target.h(GenericAttributes.p));
            Vec3D vec3d = this.dz().d(1.0, 0.0, 1.0).d().c(d0 * 0.6 * d1);
            if (vec3d.h() > 0.0) {
                target.push(vec3d.d, 0.1, vec3d.f, this);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        this.k = this.dW().a_(blockHitResult.b());
        super.a(blockHitResult);
        ItemStack itemstack = this.ea();
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (itemstack != null) {
                this.a(worldserver, blockHitResult, itemstack);
            }
        }
        Vec3D vec3d = this.dz();
        Vec3D vec3d1 = new Vec3D(Math.signum(vec3d.d), Math.signum(vec3d.e), Math.signum(vec3d.f));
        Vec3D vec3d2 = vec3d1.c((double)0.05f);
        this.b(this.du().d(vec3d2));
        this.h(Vec3D.c);
        this.a(this.t(), 1.0f, 1.2f / (this.ae.i() * 0.2f + 0.9f));
        this.a(true);
        this.d = 7;
        this.b(false);
        this.a((byte)0);
        this.b(SoundEffects.aE);
        this.I();
    }

    protected void a(WorldServer world, MovingObjectPositionBlock blockHitResult, ItemStack weaponStack) {
        EntityLiving entityliving1;
        Vec3D vec3d = blockHitResult.b().a(blockHitResult.g());
        Entity entity = this.p();
        EntityLiving entityliving = entity instanceof EntityLiving ? (entityliving1 = (EntityLiving)entity) : null;
        EnchantmentManager.a(world, weaponStack, entityliving, this, (EnumItemSlot)null, vec3d, world.a_(blockHitResult.b()), item -> {
            this.r = null;
        });
    }

    @Override
    public ItemStack ea() {
        return this.r;
    }

    protected SoundEffect s() {
        return SoundEffects.aE;
    }

    protected final SoundEffect t() {
        return this.n;
    }

    protected void a(EntityLiving target) {
    }

    @Nullable
    protected MovingObjectPositionEntity c(Vec3D currentPosition, Vec3D nextPosition) {
        return ProjectileHelper.a(this.dW(), this, currentPosition, nextPosition, this.cR().b(this.dz()).g(1.0), this::b);
    }

    @Override
    public boolean b(Entity entity) {
        EntityHuman entityhuman;
        Entity entity1;
        if (entity instanceof EntityHuman && (entity1 = this.p()) instanceof EntityHuman && !(entityhuman = (EntityHuman)entity1).a((EntityHuman)entity)) {
            return false;
        }
        return super.b(entity) && (this.o == null || !this.o.contains(entity.ar()));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("life", (short)this.l);
        if (this.k != null) {
            nbt.a("inBlockState", GameProfileSerializer.a(this.k));
        }
        nbt.a("shake", (byte)this.d);
        nbt.a("inGround", this.l());
        nbt.a("pickup", (byte)this.c.ordinal());
        nbt.a("damage", this.m);
        nbt.a("crit", this.y());
        nbt.a("PierceLevel", this.z());
        nbt.a("SoundEvent", BuiltInRegistries.b.b(this.n).toString());
        nbt.a("item", this.q.a(this.dY()));
        if (this.r != null) {
            nbt.a("weapon", this.r.b(this.dY(), new NBTTagCompound()));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.l = nbt.g("life");
        if (nbt.b("inBlockState", 10)) {
            this.k = GameProfileSerializer.a(this.dW().a(Registries.f), nbt.p("inBlockState"));
        }
        this.d = nbt.f("shake") & 0xFF;
        this.a(nbt.q("inGround"));
        if (nbt.b("damage", 99)) {
            this.m = nbt.k("damage");
        }
        this.c = PickupStatus.a(nbt.f("pickup"));
        this.b(nbt.q("crit"));
        this.a(nbt.f("PierceLevel"));
        if (nbt.b("SoundEvent", 8)) {
            this.n = BuiltInRegistries.b.b(MinecraftKey.c(nbt.l("SoundEvent"))).orElse(this.s());
        }
        if (nbt.b("item", 10)) {
            this.a(ItemStack.a((HolderLookup.a)this.dY(), (NBTBase)nbt.p("item")).orElse(this.v()));
        } else {
            this.a(this.v());
        }
        this.r = nbt.b("weapon", 10) ? (ItemStack)ItemStack.a((HolderLookup.a)this.dY(), (NBTBase)nbt.p("weapon")).orElse(null) : null;
    }

    @Override
    public void c(@Nullable Entity entity) {
        this.setOwner(entity, true);
    }

    public void setOwner(@Nullable Entity entity, boolean resetPickup) {
        super.c(entity);
        if (!resetPickup) {
            return;
        }
        Entity entity1 = entity;
        boolean b0 = false;
        PickupStatus entityarrow_pickupstatus = this.c;
        Entity entity2 = entity1;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityHuman.class, OminousItemSpawner.class}, (Object)entity2, n2)) {
            case 0: {
                EntityHuman entityhuman = (EntityHuman)entity2;
                if (this.c != PickupStatus.a) {
                    b0 = true;
                    break;
                }
                entityarrow_pickupstatus = PickupStatus.b;
                break;
            }
            case 1: {
                OminousItemSpawner ominousitemspawner = (OminousItemSpawner)entity2;
                entityarrow_pickupstatus = PickupStatus.a;
                break;
            }
            default: {
                entityarrow_pickupstatus = this.c;
                break;
            }
        }
        this.c = entityarrow_pickupstatus;
    }

    @Override
    public void a_(EntityHuman player) {
        if (!this.dW().C && (this.l() || this.B()) && this.d <= 0) {
            ItemStack itemstack = this.u();
            if (this.c == PickupStatus.b && !itemstack.f() && player.gi().canHold(itemstack) > 0) {
                EntityItem item = new EntityItem(this.dW(), this.dB(), this.dD(), this.dH(), itemstack);
                PlayerPickupArrowEvent event = new PlayerPickupArrowEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Item)new CraftItem(this.dW().getCraftServer(), item), (AbstractArrow)this.getBukkitEntity());
                this.dW().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                itemstack = item.l();
            }
            if (this.c == PickupStatus.b && player.gi().f(itemstack) || this.c == PickupStatus.c && player.gj().d) {
                player.a((Entity)this, 1);
                this.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    protected boolean a(EntityHuman player) {
        return switch (this.c.ordinal()) {
            case 0 -> false;
            case 1 -> player.gi().f(this.u());
            case 2 -> player.fV();
            default -> throw new MatchException(null, null);
        };
    }

    public ItemStack u() {
        return this.q.v();
    }

    protected abstract ItemStack v();

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.a;
    }

    public ItemStack w() {
        return this.q;
    }

    public void h(double damage) {
        this.m = damage;
    }

    public double x() {
        return this.m;
    }

    @Override
    public boolean cB() {
        return this.aq().a(TagsEntity.H);
    }

    public void b(boolean critical) {
        this.a(1, critical);
    }

    public void a(byte level) {
        this.al.a(g, level);
    }

    private void a(int index, boolean flag) {
        byte b0 = this.al.a(f);
        if (flag) {
            this.al.a(f, (byte)(b0 | index));
        } else {
            this.al.a(f, (byte)(b0 & ~index));
        }
    }

    public void a(ItemStack stack) {
        this.q = !stack.f() ? stack : this.v();
    }

    public boolean y() {
        byte b0 = this.al.a(f);
        return (b0 & 1) != 0;
    }

    public byte z() {
        return this.al.a(g);
    }

    public void a(float damageModifier) {
        this.h((double)(damageModifier * 2.0f) + this.ae.a((double)this.dW().al().a() * 0.11, 0.57425));
    }

    protected float A() {
        return 0.6f;
    }

    public void r(boolean noClip) {
        this.ad = noClip;
        this.a(2, noClip);
    }

    public boolean B() {
        return !this.dW().C ? this.ad : (this.al.a(f) & 2) != 0;
    }

    @Override
    public boolean bH() {
        return super.bH() && !this.l();
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        return mappedIndex == 0 ? SlotAccess.a(this::w, this::a) : super.a_(mappedIndex);
    }

    @Override
    protected boolean C() {
        return true;
    }

    public static enum PickupStatus {
        a,
        b,
        c;


        public static PickupStatus a(int ordinal) {
            if (ordinal < 0 || ordinal > PickupStatus.values().length) {
                ordinal = 0;
            }
            return PickupStatus.values()[ordinal];
        }
    }
}

