/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityEnderSignal
extends Entity
implements ItemSupplier {
    private static final float a = 12.25f;
    private static final DataWatcherObject<ItemStack> b = DataWatcher.a(EntityEnderSignal.class, DataWatcherRegistry.h);
    public double c;
    public double d;
    public double e;
    public int f;
    public boolean g;

    public EntityEnderSignal(EntityTypes<? extends EntityEnderSignal> type, World world) {
        super(type, world);
    }

    public EntityEnderSignal(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityEnderSignal>)EntityTypes.X, world);
        this.a_(x2, y2, z2);
    }

    public void a(ItemStack stack) {
        if (stack.f()) {
            this.au().a(b, this.m());
        } else {
            this.au().a(b, stack.c(1));
        }
    }

    @Override
    public ItemStack l() {
        return this.au().a(b);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(b, this.m());
    }

    @Override
    public boolean a(double distance) {
        if (this.af < 2 && distance < 12.25) {
            return false;
        }
        double d1 = this.cR().a() * 4.0;
        if (Double.isNaN(d1)) {
            d1 = 4.0;
        }
        return distance < (d1 *= 64.0) * d1;
    }

    public void a(BlockPosition pos) {
        this.signalTo(pos, true);
    }

    public void signalTo(BlockPosition pos, boolean update) {
        double d3;
        double d0 = pos.u();
        int i2 = pos.v();
        double d1 = pos.w();
        double d2 = d0 - this.dB();
        double d4 = Math.sqrt(d2 * d2 + (d3 = d1 - this.dH()) * d3);
        if (d4 > 12.0) {
            this.c = this.dB() + d2 / d4 * 12.0;
            this.e = this.dH() + d3 / d4 * 12.0;
            this.d = this.dD() + 8.0;
        } else {
            this.c = d0;
            this.d = i2;
            this.e = d1;
        }
        if (update) {
            this.f = 0;
            this.g = this.ae.a(5) > 0;
        }
    }

    @Override
    public void l(double x2, double y2, double z2) {
        this.n(x2, y2, z2);
        if (this.O == 0.0f && this.N == 0.0f) {
            double d3 = Math.sqrt(x2 * x2 + z2 * z2);
            this.v((float)(MathHelper.d(x2, z2) * 57.2957763671875));
            this.w((float)(MathHelper.d(y2, d3) * 57.2957763671875));
            this.N = this.dM();
            this.O = this.dO();
        }
    }

    @Override
    public void h() {
        super.h();
        Vec3D vec3d = this.dz();
        double d0 = this.dB() + vec3d.d;
        double d1 = this.dD() + vec3d.e;
        double d2 = this.dH() + vec3d.f;
        double d3 = vec3d.i();
        this.w(IProjectile.f(this.O, (float)(MathHelper.d(vec3d.e, d3) * 57.2957763671875)));
        this.v(IProjectile.f(this.N, (float)(MathHelper.d(vec3d.d, vec3d.f) * 57.2957763671875)));
        if (!this.dW().C) {
            double d4 = this.c - d0;
            double d5 = this.e - d2;
            float f2 = (float)Math.sqrt(d4 * d4 + d5 * d5);
            float f1 = (float)MathHelper.d(d5, d4);
            double d6 = MathHelper.d(0.0025, d3, (double)f2);
            double d7 = vec3d.e;
            if (f2 < 1.0f) {
                d6 *= 0.8;
                d7 *= 0.8;
            }
            int i2 = this.dD() < this.d ? 1 : -1;
            vec3d = new Vec3D(Math.cos(f1) * d6, d7 + ((double)i2 - d7) * (double)0.015f, Math.sin(f1) * d6);
            this.h(vec3d);
        }
        float f2 = 0.25f;
        if (this.bj()) {
            for (int j2 = 0; j2 < 4; ++j2) {
                this.dW().a(Particles.d, d0 - vec3d.d * 0.25, d1 - vec3d.e * 0.25, d2 - vec3d.f * 0.25, vec3d.d, vec3d.e, vec3d.f);
            }
        } else {
            this.dW().a(Particles.ad, d0 - vec3d.d * 0.25 + this.ae.j() * 0.6 - 0.3, d1 - vec3d.e * 0.25 - 0.5, d2 - vec3d.f * 0.25 + this.ae.j() * 0.6 - 0.3, vec3d.d, vec3d.e, vec3d.f);
        }
        if (!this.dW().C) {
            this.a_(d0, d1, d2);
            ++this.f;
            if (this.f > 80 && !this.dW().C) {
                this.a(SoundEffects.iB, 1.0f, 1.0f);
                this.discard(this.g ? EntityRemoveEvent.Cause.DROP : EntityRemoveEvent.Cause.DESPAWN);
                if (this.g) {
                    this.dW().b(new EntityItem(this.dW(), this.dB(), this.dD(), this.dH(), this.l()));
                } else {
                    this.dW().c(2003, this.dw(), 0);
                }
            }
        } else {
            this.o(d0, d1, d2);
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        nbt.a("Item", this.l().a(this.dY()));
    }

    @Override
    public void a(NBTTagCompound nbt) {
        if (nbt.b("Item", 10)) {
            ItemStack itemstack = ItemStack.a((HolderLookup.a)this.dY(), (NBTBase)nbt.p("Item")).orElse(this.m());
            if (!itemstack.f()) {
                this.a(itemstack);
            }
        } else {
            this.a(this.m());
        }
    }

    private ItemStack m() {
        return new ItemStack(Items.tg);
    }

    @Override
    public float by() {
        return 1.0f;
    }

    @Override
    public boolean cB() {
        return false;
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        return false;
    }
}

