/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;

public abstract class EntityFireball
extends IProjectile {
    public static final double a = 0.1;
    public static final double b = 0.5;
    public double c = 0.1;
    public float bukkitYield = 1.0f;
    public boolean isIncendiary = true;

    protected EntityFireball(EntityTypes<? extends EntityFireball> type, World world) {
        super((EntityTypes<? extends IProjectile>)type, world);
    }

    protected EntityFireball(EntityTypes<? extends EntityFireball> type, double x2, double y2, double z2, World world) {
        this(type, world);
        this.a_(x2, y2, z2);
    }

    public EntityFireball(EntityTypes<? extends EntityFireball> type, double x2, double y2, double z2, Vec3D velocity, World world) {
        this(type, world);
        this.b(x2, y2, z2, this.dM(), this.dO());
        this.ay();
        this.a(velocity, this.c);
    }

    public EntityFireball(EntityTypes<? extends EntityFireball> type, EntityLiving owner, Vec3D velocity, World world) {
        this(type, owner.dB(), owner.dD(), owner.dH(), velocity, world);
        this.c(owner);
        this.b(owner.dM(), owner.dO());
    }

    @Override
    protected void a(DataWatcher.a builder) {
    }

    @Override
    public boolean a(double distance) {
        double d1 = this.cR().a() * 4.0;
        if (Double.isNaN(d1)) {
            d1 = 4.0;
        }
        return distance < (d1 *= 64.0) * d1;
    }

    protected RayTrace.BlockCollisionOption al_() {
        return RayTrace.BlockCollisionOption.a;
    }

    @Override
    public void h() {
        Entity entity = this.p();
        this.v();
        if (!this.dW().C && (entity != null && entity.dR() || !this.dW().B(this.dw()))) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            MovingObjectPosition movingobjectposition = ProjectileHelper.a((Entity)this, this::b, this.al_());
            Vec3D vec3d = movingobjectposition.d() != MovingObjectPosition.EnumMovingObjectType.a ? movingobjectposition.g() : this.du().e(this.dz());
            ProjectileHelper.a((Entity)this, 0.2f);
            this.b(vec3d);
            this.aK();
            super.h();
            if (this.m()) {
                this.d(1.0f);
            }
            if (movingobjectposition.d() != MovingObjectPosition.EnumMovingObjectType.a && this.bL()) {
                this.preHitTargetOrDeflectSelf(movingobjectposition);
            }
            this.w();
        }
    }

    private void v() {
        float f2;
        Vec3D vec3d = this.dz();
        Vec3D vec3d1 = this.du();
        if (this.bj()) {
            for (int i2 = 0; i2 < 4; ++i2) {
                float f1 = 0.25f;
                this.dW().a(Particles.d, vec3d1.d - vec3d.d * 0.25, vec3d1.e - vec3d.e * 0.25, vec3d1.f - vec3d.f * 0.25, vec3d.d, vec3d.e, vec3d.f);
            }
            f2 = this.u();
        } else {
            f2 = this.t();
        }
        this.h(vec3d.e(vec3d.d().c(this.c)).c((double)f2));
    }

    private void w() {
        ParticleParam particleparam = this.s();
        Vec3D vec3d = this.du();
        if (particleparam != null) {
            this.dW().a(particleparam, vec3d.d, vec3d.e + 0.5, vec3d.f, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        return false;
    }

    @Override
    public boolean b(Entity entity) {
        return super.b(entity) && !entity.ad;
    }

    protected boolean m() {
        return true;
    }

    @Nullable
    protected ParticleParam s() {
        return Particles.af;
    }

    protected float t() {
        return 0.95f;
    }

    protected float u() {
        return 0.8f;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("acceleration_power", this.c);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("acceleration_power", 6)) {
            this.c = nbt.k("acceleration_power");
        }
    }

    @Override
    public float by() {
        return 1.0f;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entityTrackerEntry) {
        Entity entity = this.p();
        int i2 = entity == null ? 0 : entity.ar();
        Vec3D vec3d = entityTrackerEntry.b();
        return new PacketPlayOutSpawnEntity(this.ar(), this.cG(), vec3d.a(), vec3d.b(), vec3d.c(), entityTrackerEntry.d(), entityTrackerEntry.e(), this.aq(), i2, entityTrackerEntry.c(), 0.0);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        Vec3D vec3d = new Vec3D(packet.j(), packet.k(), packet.l());
        this.h(vec3d);
    }

    public void a(Vec3D velocity, double accelerationPower) {
        this.h(velocity.d().c(accelerationPower));
        this.ar = true;
    }

    @Override
    protected void b(@Nullable Entity deflector, boolean fromAttack) {
        super.b(deflector, fromAttack);
        this.c = fromAttack ? 0.1 : (this.c *= 0.5);
    }
}

