/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.List;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityFireworks
extends IProjectile
implements ItemSupplier {
    public static final DataWatcherObject<ItemStack> a = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.h);
    public static final DataWatcherObject<OptionalInt> b = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.v);
    public static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.k);
    public int d;
    public int e;
    @Nullable
    public EntityLiving f;
    @Nullable
    public UUID spawningEntity;

    public EntityFireworks(EntityTypes<? extends EntityFireworks> type, World world) {
        super((EntityTypes<? extends IProjectile>)type, world);
    }

    public EntityFireworks(World world, double x2, double y2, double z2, ItemStack stack) {
        super((EntityTypes<? extends IProjectile>)EntityTypes.aa, world);
        this.d = 0;
        this.a_(x2, y2, z2);
        this.al.a(a, stack.v());
        int i2 = 1;
        Fireworks fireworks = stack.a(DataComponents.af);
        if (fireworks != null) {
            i2 += fireworks.a();
        }
        this.n(this.ae.a(0.0, 0.002297), 0.05, this.ae.a(0.0, 0.002297));
        this.e = 10 * i2 + this.ae.a(6) + this.ae.a(7);
    }

    public EntityFireworks(World world, @Nullable Entity entity, double x2, double y2, double z2, ItemStack stack) {
        this(world, x2, y2, z2, stack);
        this.c(entity);
    }

    public EntityFireworks(World world, ItemStack stack, EntityLiving shooter) {
        this(world, shooter, shooter.dB(), shooter.dD(), shooter.dH(), stack);
        this.al.a(b, OptionalInt.of(shooter.ar()));
        this.f = shooter;
    }

    public EntityFireworks(World world, ItemStack stack, double x2, double y2, double z2, boolean shotAtAngle) {
        this(world, x2, y2, z2, stack);
        this.al.a(c, shotAtAngle);
    }

    public EntityFireworks(World world, ItemStack stack, Entity entity, double x2, double y2, double z2, boolean shotAtAngle) {
        this(world, stack, x2, y2, z2, shotAtAngle);
        this.c(entity);
    }

    @Override
    public void inactiveTick() {
        World world;
        ++this.d;
        if (this.d > this.e && (world = this.dW()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(worldserver);
            }
        }
        super.inactiveTick();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(a, EntityFireworks.v());
        builder.a(b, OptionalInt.empty());
        builder.a(c, false);
    }

    @Override
    public boolean a(double distance) {
        return distance < 4096.0 && !this.t();
    }

    @Override
    public boolean k(double cameraX, double cameraY, double cameraZ) {
        return super.k(cameraX, cameraY, cameraZ) && !this.t();
    }

    @Override
    public void h() {
        World world;
        MovingObjectPosition movingobjectposition;
        super.h();
        if (this.t()) {
            if (this.f == null) {
                this.al.a(b).ifPresent(i2 -> {
                    Entity entity = this.dW().a(i2);
                    if (entity instanceof EntityLiving) {
                        this.f = (EntityLiving)entity;
                    }
                });
            }
            if (this.f != null) {
                Vec3D vec3d;
                if (this.f.fJ()) {
                    Vec3D vec3d1 = this.f.bT();
                    double d0 = 1.5;
                    double d1 = 0.1;
                    Vec3D vec3d2 = this.f.dz();
                    this.f.h(vec3d2.b(vec3d1.d * 0.1 + (vec3d1.d * 1.5 - vec3d2.d) * 0.5, vec3d1.e * 0.1 + (vec3d1.e * 1.5 - vec3d2.e) * 0.5, vec3d1.f * 0.1 + (vec3d1.f * 1.5 - vec3d2.f) * 0.5));
                    vec3d = this.f.a(Items.vk);
                } else {
                    vec3d = Vec3D.c;
                }
                this.a_(this.f.dB() + vec3d.d, this.f.dD() + vec3d.e, this.f.dH() + vec3d.f);
                this.h(this.f.dz());
            }
            movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
        } else {
            if (!this.m()) {
                double d2 = this.P ? 1.0 : 1.15;
                this.h(this.dz().d(d2, 1.0, d2).b(0.0, 0.04, 0.0));
            }
            Vec3D vec3d = this.dz();
            movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
            this.a(EnumMoveType.a, vec3d);
            this.aK();
            this.h(vec3d);
        }
        if (!this.ad && this.bL() && movingobjectposition.d() != MovingObjectPosition.EnumMovingObjectType.a) {
            this.preHitTargetOrDeflectSelf(movingobjectposition);
            this.ar = true;
        }
        this.F();
        if (this.d == 0 && !this.bb()) {
            this.dW().a((EntityHuman)null, this.dB(), this.dD(), this.dH(), SoundEffects.jj, SoundCategory.i, 3.0f, 1.0f);
        }
        ++this.d;
        if (this.dW().C && this.d % 2 < 2) {
            this.dW().a(Particles.D, this.dB(), this.dD(), this.dH(), this.ae.k() * 0.05, -this.dz().e * 0.5, this.ae.k() * 0.05);
        }
        if (this.d > this.e && (world = this.dW()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(worldserver);
            }
        }
    }

    private void b(WorldServer world) {
        world.a((Entity)this, (byte)17);
        this.a(GameEvent.w, this.p());
        this.e(world);
        this.discard(EntityRemoveEvent.Cause.EXPLODE);
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        super.a(entityHitResult);
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(worldserver);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        BlockPosition blockposition = new BlockPosition(blockHitResult.b());
        this.dW().a_(blockposition).a(this.dW(), blockposition, (Entity)this);
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.s() && !CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(worldserver);
            }
        }
        super.a(blockHitResult);
    }

    private boolean s() {
        return !this.u().isEmpty();
    }

    private void e(WorldServer world) {
        float f2 = 0.0f;
        List<FireworkExplosion> list = this.u();
        if (!list.isEmpty()) {
            f2 = 5.0f + (float)(list.size() * 2);
        }
        if (f2 > 0.0f) {
            if (this.f != null) {
                this.f.a(world, this.dX().a(this, this.p()), 5.0f + (float)(list.size() * 2));
            }
            double d0 = 5.0;
            Vec3D vec3d = this.du();
            List<EntityLiving> list1 = this.dW().a(EntityLiving.class, this.cR().g(5.0));
            for (EntityLiving entityliving : list1) {
                if (entityliving == this.f || !(this.g(entityliving) <= 25.0)) continue;
                boolean flag = false;
                for (int i2 = 0; i2 < 2; ++i2) {
                    Vec3D vec3d1 = new Vec3D(entityliving.dB(), entityliving.e(0.5 * (double)i2), entityliving.dH());
                    MovingObjectPositionBlock movingobjectpositionblock = this.dW().a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
                    if (movingobjectpositionblock.d() != MovingObjectPosition.EnumMovingObjectType.a) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                float f1 = f2 * (float)Math.sqrt((5.0 - (double)this.f(entityliving)) / 5.0);
                entityliving.a(world, this.dX().a(this, this.p()), f1);
            }
        }
    }

    private boolean t() {
        return this.al.a(b).isPresent();
    }

    public boolean m() {
        return this.al.a(c);
    }

    @Override
    public void b(byte status) {
        if (status == 17 && this.dW().C) {
            Vec3D vec3d = this.dz();
            this.dW().a(this.dB(), this.dD(), this.dH(), vec3d.d, vec3d.e, vec3d.f, this.u());
        }
        super.b(status);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Life", this.d);
        nbt.a("LifeTime", this.e);
        nbt.a("FireworksItem", this.l().a(this.dY()));
        nbt.a("ShotAtAngle", this.al.a(c));
        if (this.spawningEntity != null) {
            nbt.a("SpawningEntity", this.spawningEntity);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.d = nbt.h("Life");
        this.e = nbt.h("LifeTime");
        if (nbt.b("FireworksItem", 10)) {
            this.al.a(a, ItemStack.a((HolderLookup.a)this.dY(), (NBTBase)nbt.p("FireworksItem")).orElseGet(EntityFireworks::v));
        } else {
            this.al.a(a, EntityFireworks.v());
        }
        if (nbt.e("ShotAtAngle")) {
            this.al.a(c, nbt.q("ShotAtAngle"));
        }
        if (nbt.b("SpawningEntity")) {
            this.spawningEntity = nbt.a("SpawningEntity");
        }
    }

    private List<FireworkExplosion> u() {
        ItemStack itemstack = this.al.a(a);
        Fireworks fireworks = itemstack.a(DataComponents.af);
        return fireworks != null ? fireworks.b() : List.of();
    }

    @Override
    public ItemStack l() {
        return this.al.a(a);
    }

    @Override
    public boolean cB() {
        return false;
    }

    public static ItemStack v() {
        return new ItemStack(Items.vk);
    }

    @Override
    public DoubleDoubleImmutablePair a_(EntityLiving target, DamageSource source) {
        double d0 = target.du().d - this.du().d;
        double d1 = target.du().f - this.du().f;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }
}

