/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.logging.LogUtils;
import io.papermc.paper.annotation.DoNotUse;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.CraftEquipmentSlot;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.slf4j.Logger;

public class EntityFishingHook
extends IProjectile {
    private static final Logger a = LogUtils.getLogger();
    private final RandomSource b = RandomSource.a();
    private boolean c;
    public int d;
    private static final int e = 10;
    public static final DataWatcherObject<Integer> f = DataWatcher.a(EntityFishingHook.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> g = DataWatcher.a(EntityFishingHook.class, DataWatcherRegistry.k);
    private int h;
    private int i;
    public int j;
    public int k;
    public float l;
    private boolean m = true;
    @Nullable
    public Entity n;
    public HookState o = HookState.a;
    private final int p;
    private final int q;
    public int minWaitTime = 100;
    public int maxWaitTime = 600;
    public int minLureTime = 20;
    public int maxLureTime = 80;
    public float minLureAngle = 0.0f;
    public float maxLureAngle = 360.0f;
    public boolean applyLure = true;
    public boolean rainInfluenced = true;
    public boolean skyInfluenced = true;

    private EntityFishingHook(EntityTypes<? extends EntityFishingHook> type, World world, int luckBonus, int waitTimeReductionTicks) {
        super((EntityTypes<? extends IProjectile>)type, world);
        this.p = Math.max(0, luckBonus);
        this.q = Math.max(0, waitTimeReductionTicks);
        this.minWaitTime = world.paperConfig().fishingTimeRange.minimum;
        this.maxWaitTime = world.paperConfig().fishingTimeRange.maximum;
    }

    public EntityFishingHook(EntityTypes<? extends EntityFishingHook> type, World world) {
        this(type, world, 0, 0);
    }

    public EntityFishingHook(EntityHuman thrower, World world, int luckBonus, int waitTimeReductionTicks, ItemStack stack) {
        this(EntityTypes.bT, world, luckBonus, waitTimeReductionTicks);
        this.c(thrower);
        float f2 = thrower.dO();
        float f1 = thrower.dM();
        float f22 = MathHelper.b(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f3 = MathHelper.a(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f4 = -MathHelper.b(-f2 * ((float)Math.PI / 180));
        float f5 = MathHelper.a(-f2 * ((float)Math.PI / 180));
        double d0 = thrower.dB() - (double)f3 * 0.3;
        double d1 = thrower.dF();
        double d2 = thrower.dH() - (double)f22 * 0.3;
        this.b(d0, d1, d2, f1, f2);
        Vec3D vec3d = new Vec3D(-f3, MathHelper.a(-(f5 / f4), -5.0f, 5.0f), -f22);
        double d3 = vec3d.g();
        vec3d = vec3d.d(0.6 / d3 + this.ae.a(0.5, 0.0103365), 0.6 / d3 + this.ae.a(0.5, 0.0103365), 0.6 / d3 + this.ae.a(0.5, 0.0103365));
        this.h(vec3d);
        this.v((float)(MathHelper.d(vec3d.d, vec3d.f) * 57.2957763671875));
        this.w((float)(MathHelper.d(vec3d.e, vec3d.i()) * 57.2957763671875));
        this.N = this.dM();
        this.O = this.dO();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(f, 0);
        builder.a(g, false);
    }

    @Override
    protected boolean C() {
        return true;
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (f.equals(data)) {
            int i2 = this.au().a(f);
            Entity entity = this.n = i2 > 0 ? this.dW().a(i2 - 1) : null;
        }
        if (g.equals(data)) {
            this.c = this.au().a(g);
            if (this.c) {
                this.n(this.dz().d, -0.4f * MathHelper.a(this.b, 0.6f, 1.0f), this.dz().f);
            }
        }
        super.a(data);
    }

    @Override
    public boolean a(double distance) {
        double d1 = 64.0;
        return distance < 4096.0;
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps) {
    }

    @Override
    public void h() {
        this.b.b(this.cG().getLeastSignificantBits() ^ this.dW().ac());
        super.h();
        EntityHuman entityhuman = this.m();
        if (entityhuman == null) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (this.dW().C || !this.a(entityhuman)) {
            boolean flag;
            if (this.aJ()) {
                ++this.h;
                if (this.h >= 1200) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
            } else {
                this.h = 0;
            }
            float f2 = 0.0f;
            BlockPosition blockposition = this.dw();
            Fluid fluid = this.dW().b_(blockposition);
            if (fluid.a(TagsFluid.a)) {
                f2 = fluid.a(this.dW(), blockposition);
            }
            boolean bl = flag = f2 > 0.0f;
            if (this.o == HookState.a) {
                if (this.n != null) {
                    this.h(Vec3D.c);
                    this.o = HookState.b;
                    return;
                }
                if (flag) {
                    this.h(this.dz().d(0.3, 0.2, 0.3));
                    this.o = HookState.c;
                    return;
                }
                this.t();
            } else {
                if (this.o == HookState.b) {
                    if (this.n != null) {
                        if (!this.n.dR() && this.n.dW().ah() == this.dW().ah()) {
                            this.a_(this.n.dB(), this.n.e(0.8), this.n.dH());
                        } else {
                            this.B(null);
                            this.o = HookState.a;
                        }
                    }
                    return;
                }
                if (this.o == HookState.c) {
                    Vec3D vec3d = this.dz();
                    double d0 = this.dD() + vec3d.e - (double)blockposition.v() - (double)f2;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.n(vec3d.d * 0.9, vec3d.e - d0 * (double)this.ae.i() * 0.2, vec3d.f * 0.9);
                    if (this.i <= 0 && this.k <= 0) {
                        this.m = true;
                    } else {
                        boolean bl2 = this.m = this.m && this.d < 10 && this.b(blockposition);
                    }
                    if (flag) {
                        this.d = Math.max(0, this.d - 1);
                        if (this.c) {
                            this.h(this.dz().b(0.0, -0.1 * (double)this.b.i() * (double)this.b.i(), 0.0));
                        }
                        if (!this.dW().C) {
                            this.a(blockposition);
                        }
                    } else {
                        this.d = Math.min(10, this.d + 1);
                    }
                }
            }
            if (!fluid.a(TagsFluid.a)) {
                this.h(this.dz().b(0.0, -0.03, 0.0));
            }
            this.a(EnumMoveType.a, this.dz());
            this.aK();
            this.F();
            if (this.o == HookState.a && (this.aJ() || this.P)) {
                this.h(Vec3D.c);
            }
            double d1 = 0.92;
            this.h(this.dz().c(0.92));
            this.ay();
        }
    }

    private boolean a(EntityHuman player) {
        ItemStack itemstack = player.eZ();
        ItemStack itemstack1 = player.fa();
        boolean flag = itemstack.a(Items.rJ);
        boolean flag1 = itemstack1.a(Items.rJ);
        if (!player.dR() && player.bL() && (flag || flag1) && this.g(player) <= 1024.0) {
            return false;
        }
        this.discard(EntityRemoveEvent.Cause.DESPAWN);
        return true;
    }

    private void t() {
        MovingObjectPosition movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
        this.preHitTargetOrDeflectSelf(movingobjectposition);
    }

    @Override
    public boolean b(Entity entity) {
        return super.b(entity) || entity.bL() && entity instanceof EntityItem;
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        super.a(entityHitResult);
        if (!this.dW().C) {
            this.B(entityHitResult.a());
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        super.a(blockHitResult);
        this.h(this.dz().d().c(blockHitResult.a(this)));
    }

    public void B(@Nullable Entity entity) {
        this.n = entity;
        this.au().a(f, entity == null ? 0 : entity.ar() + 1);
    }

    private void a(BlockPosition pos) {
        WorldServer worldserver = (WorldServer)this.dW();
        int i2 = 1;
        BlockPosition blockposition1 = pos.d();
        if (this.rainInfluenced && this.ae.i() < 0.25f && this.dW().r(blockposition1)) {
            ++i2;
        }
        if (this.skyInfluenced && this.ae.i() < 0.5f && !this.dW().h(blockposition1)) {
            --i2;
        }
        if (this.i > 0) {
            --this.i;
            if (this.i <= 0) {
                this.j = 0;
                this.k = 0;
                this.au().a(g, false);
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.m().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.FAILED_ATTEMPT);
                this.dW().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
            }
        } else if (this.k > 0) {
            this.k -= i2;
            if (this.k > 0) {
                double d2;
                double d1;
                this.l += (float)this.ae.a(0.0, 9.188);
                float f2 = this.l * ((float)Math.PI / 180);
                float f1 = MathHelper.a(f2);
                float f22 = MathHelper.b(f2);
                double d0 = this.dB() + (double)(f1 * (float)this.k * 0.1f);
                IBlockData iblockdata = worldserver.a_(BlockPosition.a(d0, (d1 = (double)((float)MathHelper.a(this.dD()) + 1.0f)) - 1.0, d2 = this.dH() + (double)(f22 * (float)this.k * 0.1f)));
                if (iblockdata.a(Blocks.J)) {
                    if (this.ae.i() < 0.15f) {
                        worldserver.a(Particles.d, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f22, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f22 * 0.04f;
                    worldserver.a(Particles.E, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    worldserver.a(Particles.E, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.m().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.BITE);
                this.dW().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return;
                }
                this.a(SoundEffects.jr, 0.25f, 1.0f + (this.ae.i() - this.ae.i()) * 0.4f);
                double d3 = this.dD() + 0.5;
                worldserver.a(Particles.d, this.dB(), d3, this.dH(), (int)(1.0f + this.dr() * 20.0f), (double)this.dr(), 0.0, (double)this.dr(), 0.2f);
                worldserver.a(Particles.E, this.dB(), d3, this.dH(), (int)(1.0f + this.dr() * 20.0f), (double)this.dr(), 0.0, (double)this.dr(), 0.2f);
                this.i = MathHelper.a(this.ae, 20, 40);
                this.au().a(g, true);
            }
        } else if (this.j > 0) {
            this.j -= i2;
            float f3 = 0.15f;
            if (this.j < 20) {
                f3 += (float)(20 - this.j) * 0.05f;
            } else if (this.j < 40) {
                f3 += (float)(40 - this.j) * 0.02f;
            } else if (this.j < 60) {
                f3 += (float)(60 - this.j) * 0.01f;
            }
            if (this.ae.i() < f3) {
                double d2;
                double d1;
                float f1 = MathHelper.a(this.ae, 0.0f, 360.0f) * ((float)Math.PI / 180);
                float f2 = MathHelper.a(this.ae, 25.0f, 60.0f);
                double d0 = this.dB() + (double)(MathHelper.a(f1) * f2) * 0.1;
                IBlockData iblockdata = worldserver.a_(BlockPosition.a(d0, (d1 = (double)((float)MathHelper.a(this.dD()) + 1.0f)) - 1.0, d2 = this.dH() + (double)(MathHelper.b(f1) * f2) * 0.1));
                if (iblockdata.a(Blocks.J)) {
                    worldserver.a(Particles.an, d0, d1, d2, 2 + this.ae.a(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.j <= 0) {
                PlayerFishEvent playerFishEvent;
                this.l = MathHelper.a(this.ae, this.minLureAngle, this.maxLureAngle);
                this.k = MathHelper.a(this.ae, this.minLureTime, this.maxLureTime);
                if (this.m() != null && !(playerFishEvent = new PlayerFishEvent((Player)this.m().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.LURED)).callEvent()) {
                    this.k = 0;
                    return;
                }
            }
        } else {
            this.resetTimeUntilLured();
        }
    }

    public void resetTimeUntilLured() {
        this.j = MathHelper.a(this.ae, this.minWaitTime, this.maxWaitTime);
        this.j -= this.applyLure ? (this.q >= this.maxWaitTime ? this.j - 1 : this.q) : 0;
    }

    public boolean b(BlockPosition pos) {
        WaterPosition entityfishinghook_waterposition = WaterPosition.c;
        for (int i2 = -1; i2 <= 2; ++i2) {
            WaterPosition entityfishinghook_waterposition1 = this.a(pos.b(-2, i2, -2), pos.b(2, i2, 2));
            switch (entityfishinghook_waterposition1.ordinal()) {
                case 0: {
                    if (entityfishinghook_waterposition != WaterPosition.c) break;
                    return false;
                }
                case 1: {
                    if (entityfishinghook_waterposition != WaterPosition.a) break;
                    return false;
                }
                case 2: {
                    return false;
                }
            }
            entityfishinghook_waterposition = entityfishinghook_waterposition1;
        }
        return true;
    }

    private WaterPosition a(BlockPosition start, BlockPosition end) {
        return BlockPosition.d(start, end).map(this::c).reduce((entityfishinghook_waterposition, entityfishinghook_waterposition1) -> entityfishinghook_waterposition == entityfishinghook_waterposition1 ? entityfishinghook_waterposition : WaterPosition.c).orElse(WaterPosition.c);
    }

    private WaterPosition c(BlockPosition pos) {
        IBlockData iblockdata = this.dW().a_(pos);
        if (!iblockdata.l() && !iblockdata.a(Blocks.fA)) {
            Fluid fluid = iblockdata.y();
            return fluid.a(TagsFluid.a) && fluid.b() && iblockdata.g(this.dW(), pos).c() ? WaterPosition.b : WaterPosition.c;
        }
        return WaterPosition.a;
    }

    public boolean l() {
        return this.m;
    }

    @Override
    public void b(NBTTagCompound nbt) {
    }

    @Override
    public void a(NBTTagCompound nbt) {
    }

    @Deprecated
    @DoNotUse
    public int a(ItemStack usedItem) {
        return this.retrieve(EnumHand.a, usedItem);
    }

    public int retrieve(EnumHand hand, ItemStack usedItem) {
        EntityHuman entityhuman = this.m();
        if (!this.dW().C && entityhuman != null && !this.a(entityhuman)) {
            PlayerFishEvent playerFishEvent;
            int i2 = 0;
            if (this.n != null) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Entity)this.n.getBukkitEntity(), (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.CAUGHT_ENTITY);
                this.dW().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
                if (this.n != null) {
                    this.d(this.n);
                    CriterionTriggers.E.a((EntityPlayer)entityhuman, usedItem, this, Collections.emptyList());
                    this.dW().a((Entity)this, (byte)31);
                    i2 = this.n instanceof EntityItem ? 3 : 5;
                }
            } else if (this.i > 0) {
                LootParams lootparams = new LootParams.a((WorldServer)this.dW()).a(LootContextParameters.f, this.du()).a(LootContextParameters.i, usedItem).a(LootContextParameters.a, this).a((float)this.p + entityhuman.gF()).a(LootContextParameterSets.f);
                LootTable loottable = this.dW().p().bc().b(LootTables.am);
                ObjectArrayList<ItemStack> list = loottable.a(lootparams);
                CriterionTriggers.E.a((EntityPlayer)entityhuman, usedItem, this, (Collection<ItemStack>)list);
                for (ItemStack itemstack1 : list) {
                    Entity entityitem = null;
                    if (!itemstack1.f()) {
                        entityitem = new EntityItem(this.dW(), this.dB(), this.dD(), this.dH(), itemstack1);
                    }
                    PlayerFishEvent playerFishEvent2 = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Entity)(entityitem != null ? entityitem.getBukkitEntity() : null), (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.CAUGHT_FISH);
                    playerFishEvent2.setExpToDrop(this.ae.a(6) + 1);
                    this.dW().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent2);
                    if (playerFishEvent2.isCancelled()) {
                        return 0;
                    }
                    double d0 = entityhuman.dB() - this.dB();
                    double d1 = entityhuman.dD() - this.dD();
                    double d2 = entityhuman.dH() - this.dH();
                    double d3 = 0.1;
                    if (entityitem != null) {
                        entityitem.n(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                        this.dW().b(entityitem);
                    }
                    if (playerFishEvent2.getExpToDrop() > 0) {
                        entityhuman.dW().b(new EntityExperienceOrb(entityhuman.dW(), entityhuman.dB(), entityhuman.dD() + 0.5, entityhuman.dH() + 0.5, playerFishEvent2.getExpToDrop(), ExperienceOrb.SpawnReason.FISHING, this.m(), this));
                    }
                    if (!itemstack1.a(TagsItem.aV)) continue;
                    entityhuman.a(StatisticList.R, 1);
                }
                i2 = 1;
            }
            if (this.aJ()) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.IN_GROUND);
                this.dW().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
                i2 = 2;
            }
            if (i2 == 0) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.REEL_IN);
                this.dW().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return i2;
        }
        return 0;
    }

    @Override
    public void b(byte status) {
        if (status == 31 && this.dW().C && this.n instanceof EntityHuman && ((EntityHuman)this.n).c()) {
            this.d(this.n);
        }
        super.b(status);
    }

    public void d(Entity entity) {
        Entity entity1 = this.p();
        if (entity1 != null) {
            Vec3D vec3d = new Vec3D(entity1.dB() - this.dB(), entity1.dD() - this.dD(), entity1.dH() - this.dH()).c(0.1);
            entity.h(entity.dz().e(vec3d));
        }
    }

    @Override
    protected Entity.MovementEmission bg() {
        return Entity.MovementEmission.a;
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        this.remove(reason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        this.a((EntityFishingHook)null);
        super.remove(entity_removalreason, cause);
    }

    @Override
    public void av() {
        this.a((EntityFishingHook)null);
    }

    @Override
    public void c(@Nullable Entity entity) {
        super.c(entity);
        this.a(this);
    }

    private void a(@Nullable EntityFishingHook fishingBobber) {
        EntityHuman entityhuman = this.m();
        if (entityhuman != null) {
            entityhuman.cv = fishingBobber;
        }
    }

    @Nullable
    public EntityHuman m() {
        Entity entity = this.p();
        return entity instanceof EntityHuman ? (EntityHuman)entity : null;
    }

    @Nullable
    public Entity s() {
        return this.n;
    }

    @Override
    public boolean o(boolean allowVehicles) {
        return false;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entityTrackerEntry) {
        Entity entity = this.p();
        return new PacketPlayOutSpawnEntity((Entity)this, entityTrackerEntry, entity == null ? this.ar() : entity.ar());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        if (this.m() == null) {
            int i2 = packet.p();
            a.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.dW().a(i2), (Object)i2);
            this.discard(null);
        }
    }

    public static enum HookState {
        a,
        b,
        c;

    }

    private static enum WaterPosition {
        a,
        b,
        c;

    }
}

