/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import io.papermc.paper.event.entity.WaterBottleSplashEvent;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;

public class EntityPotion
extends EntityProjectileThrowable {
    public static final double a = 4.0;
    private static final double c = 16.0;
    public static final Predicate<EntityLiving> b = entityliving -> entityliving.fr() || entityliving.bY();
    private static final Predicate<EntityLiving> APPLY_WATER_GET_ENTITIES_PREDICATE = b.or(Axolotl.class::isInstance);

    public EntityPotion(EntityTypes<? extends EntityPotion> type, World world) {
        super((EntityTypes<? extends EntityProjectileThrowable>)type, world);
    }

    public EntityPotion(World world, EntityLiving owner, ItemStack stack) {
        super(EntityTypes.aW, owner, world, stack);
    }

    public EntityPotion(World world, double x2, double y2, double z2, ItemStack stack) {
        super(EntityTypes.aW, x2, y2, z2, world, stack);
    }

    @Override
    protected Item m() {
        return Items.we;
    }

    @Override
    protected double bd() {
        return 0.05;
    }

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        super.a(blockHitResult);
        if (!this.dW().C) {
            ItemStack itemstack = this.l();
            EnumDirection enumdirection = blockHitResult.c();
            BlockPosition blockposition = blockHitResult.b();
            BlockPosition blockposition1 = blockposition.a(enumdirection);
            PotionContents potioncontents = itemstack.a(DataComponents.Q, PotionContents.a);
            if (potioncontents.a(Potions.a)) {
                this.a(blockposition1);
                this.a(blockposition1.a(enumdirection.g()));
                for (EnumDirection enumdirection1 : EnumDirection.EnumDirectionLimit.a) {
                    this.a(blockposition1.a(enumdirection1));
                }
            }
        }
    }

    @Override
    protected void a(MovingObjectPosition hitResult) {
        super.a(hitResult);
        this.splash(hitResult);
    }

    public void splash(@Nullable MovingObjectPosition hitResult) {
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            ItemStack itemstack = this.l();
            PotionContents potioncontents = itemstack.a(DataComponents.Q, PotionContents.a);
            boolean showParticles = true;
            showParticles = potioncontents.a(Potions.a) ? this.applyWater(worldserver, hitResult) : (this.s() ? this.makeAreaOfEffectCloud(potioncontents, hitResult) : this.applySplash(worldserver, potioncontents.a(), hitResult != null && hitResult.d() == MovingObjectPosition.EnumMovingObjectType.c ? ((MovingObjectPositionEntity)hitResult).a() : null, hitResult));
            if (showParticles) {
                int i2 = potioncontents.e().isPresent() && potioncontents.e().get().a().c() ? 2007 : 2002;
                worldserver.c(i2, this.dw(), potioncontents.b());
            }
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    private boolean applyWater(WorldServer world, @Nullable MovingObjectPosition hitResult) {
        AxisAlignedBB axisalignedbb = this.cR().c(4.0, 2.0, 4.0);
        List<EntityLiving> list = this.dW().a(EntityLiving.class, axisalignedbb, APPLY_WATER_GET_ENTITIES_PREDICATE);
        HashMap<LivingEntity, Double> affected = new HashMap<LivingEntity, Double>();
        HashSet<LivingEntity> rehydrate = new HashSet<LivingEntity>();
        HashSet<LivingEntity> extinguish = new HashSet<LivingEntity>();
        for (EntityLiving entityliving : list) {
            double d0;
            if (entityliving instanceof Axolotl) {
                Axolotl axolotl = (Axolotl)entityliving;
                rehydrate.add((LivingEntity)((org.bukkit.entity.Axolotl)axolotl.getBukkitEntity()));
            }
            if (!((d0 = this.g(entityliving)) < 16.0)) continue;
            if (entityliving.fr()) {
                affected.put(entityliving.getBukkitLivingEntity(), 1.0);
            }
            if (!entityliving.bY() || !entityliving.bL()) continue;
            extinguish.add(entityliving.getBukkitLivingEntity());
        }
        WaterBottleSplashEvent event = CraftEventFactory.callWaterBottleSplashEvent(this, hitResult, affected, rehydrate, extinguish);
        if (!event.isCancelled()) {
            for (LivingEntity affectedEntity : event.getToDamage()) {
                ((CraftLivingEntity)affectedEntity).getHandle().a(world, this.dX().c((Entity)this, this.p()), 1.0f);
            }
            for (LivingEntity toExtinguish : event.getToExtinguish()) {
                ((CraftLivingEntity)toExtinguish).getHandle().aN();
            }
            for (LivingEntity toRehydrate : event.getToRehydrate()) {
                EntityLiving entityLiving = ((CraftLivingEntity)toRehydrate).getHandle();
                if (!(entityLiving instanceof Axolotl)) continue;
                Axolotl axolotl = (Axolotl)entityLiving;
                axolotl.x();
            }
        }
        return !event.isCancelled();
    }

    private boolean applySplash(WorldServer worldserver, Iterable<MobEffect> iterable, @Nullable Entity entity, @Nullable MovingObjectPosition position) {
        PotionSplashEvent event;
        double d1;
        AxisAlignedBB axisalignedbb = this.cR().c(4.0, 2.0, 4.0);
        List<EntityLiving> list = worldserver.a(EntityLiving.class, axisalignedbb);
        HashMap<LivingEntity, Double> affected = new HashMap<LivingEntity, Double>();
        if (!list.isEmpty()) {
            Entity entity1 = this.E();
            for (EntityLiving entityliving : list) {
                double d0;
                if (!entityliving.fL() || !((d0 = this.g(entityliving)) < 16.0)) continue;
                d1 = entityliving == entity ? 1.0 : 1.0 - Math.sqrt(d0) / 4.0;
                affected.put((LivingEntity)entityliving.getBukkitEntity(), d1);
            }
        }
        if (!(event = CraftEventFactory.callPotionSplashEvent(this, position, affected)).isCancelled() && list != null && !list.isEmpty()) {
            Entity entity1 = this.E();
            for (LivingEntity victim : event.getAffectedEntities()) {
                if (!(victim instanceof CraftLivingEntity)) continue;
                EntityLiving entityliving = ((CraftLivingEntity)victim).getHandle();
                d1 = event.getIntensity(victim);
                for (MobEffect mobeffect : iterable) {
                    MobEffectList mobeffectlist;
                    Holder<MobEffectList> holder = mobeffect.c();
                    if (!this.dW().pvpMode && this.p() instanceof EntityPlayer && entityliving instanceof EntityPlayer && entityliving != this.p() && ((mobeffectlist = holder.a()) == MobEffects.b || mobeffectlist == MobEffects.d || mobeffectlist == MobEffects.g || mobeffectlist == MobEffects.o || mobeffectlist == MobEffects.q || mobeffectlist == MobEffects.r || mobeffectlist == MobEffects.s)) continue;
                    if (holder.a().a()) {
                        holder.a().a(worldserver, this, this.p(), entityliving, mobeffect.e(), d1);
                        continue;
                    }
                    int i2 = mobeffect.a(j2 -> (int)(d1 * (double)j2 + 0.5));
                    MobEffect mobeffect1 = new MobEffect(holder, i2, mobeffect.e(), mobeffect.f(), mobeffect.g());
                    if (mobeffect1.a(20)) continue;
                    entityliving.addEffect(mobeffect1, entity1, EntityPotionEffectEvent.Cause.POTION_SPLASH);
                }
            }
        }
        return !event.isCancelled();
    }

    private boolean makeAreaOfEffectCloud(PotionContents potioncontents, @Nullable MovingObjectPosition position) {
        EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.dW(), this.dB(), this.dD(), this.dH());
        Entity entity = this.p();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            entityareaeffectcloud.a(entityliving);
        }
        entityareaeffectcloud.a(3.0f);
        entityareaeffectcloud.b(-0.5f);
        entityareaeffectcloud.c(10);
        entityareaeffectcloud.c(-entityareaeffectcloud.c() / (float)entityareaeffectcloud.g());
        entityareaeffectcloud.a(potioncontents);
        boolean noEffects = potioncontents.c();
        LingeringPotionSplashEvent event = CraftEventFactory.callLingeringPotionSplashEvent(this, position, entityareaeffectcloud);
        if (!(event.isCancelled() || entityareaeffectcloud.dR() || !event.allowsEmptyCreation() && noEffects && !entityareaeffectcloud.k.c())) {
            this.dW().b(entityareaeffectcloud);
        } else {
            entityareaeffectcloud.discard(null);
        }
        return !event.isCancelled();
    }

    public boolean s() {
        return this.l().a(Items.wh);
    }

    private void a(BlockPosition pos) {
        IBlockData iblockdata = this.dW().a_(pos);
        if (iblockdata.a(TagsBlock.aN)) {
            if (CraftEventFactory.callEntityChangeBlockEvent(this, pos, iblockdata.y().g())) {
                this.dW().a(pos, false, this);
            }
        } else if (AbstractCandleBlock.c(iblockdata)) {
            if (CraftEventFactory.callEntityChangeBlockEvent(this, pos, (IBlockData)iblockdata.b(AbstractCandleBlock.b, false))) {
                AbstractCandleBlock.a((EntityHuman)null, iblockdata, (GeneratorAccess)this.dW(), pos);
            }
        } else if (BlockCampfire.h(iblockdata) && CraftEventFactory.callEntityChangeBlockEvent(this, pos, (IBlockData)iblockdata.b(BlockCampfire.c, false))) {
            this.dW().a((EntityHuman)null, 1009, pos, 0);
            BlockCampfire.a(this.p(), (GeneratorAccess)this.dW(), pos, iblockdata);
            this.dW().b(pos, (IBlockData)iblockdata.b(BlockCampfire.c, false));
        }
    }

    @Override
    public DoubleDoubleImmutablePair a_(EntityLiving target, DamageSource source) {
        double d0 = target.du().d - this.du().d;
        double d1 = target.du().f - this.du().f;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }
}

