/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityShulkerBullet
extends IProjectile {
    private static final double a = 0.15;
    @Nullable
    private Entity b;
    @Nullable
    public EnumDirection c;
    public int d;
    public double e;
    public double f;
    public double g;
    @Nullable
    private UUID h;

    public EntityShulkerBullet(EntityTypes<? extends EntityShulkerBullet> type, World world) {
        super((EntityTypes<? extends IProjectile>)type, world);
        this.ad = true;
    }

    public EntityShulkerBullet(World world, EntityLiving owner, Entity target, EnumDirection.EnumAxis axis) {
        this((EntityTypes<? extends EntityShulkerBullet>)EntityTypes.bd, world);
        this.c(owner);
        Vec3D vec3d = owner.cR().f();
        this.b(vec3d.d, vec3d.e, vec3d.f, this.dM(), this.dO());
        this.b = target;
        this.c = EnumDirection.b;
        this.a(axis);
        this.projectileSource = (LivingEntity)owner.getBukkitEntity();
    }

    public Entity getTarget() {
        return this.b;
    }

    public void setTarget(Entity e2) {
        this.b = e2;
        this.c = EnumDirection.b;
        this.a(EnumDirection.EnumAxis.a);
    }

    @Override
    public SoundCategory dn() {
        return SoundCategory.f;
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.b != null) {
            nbt.a("Target", this.b.cG());
        }
        if (this.c != null) {
            nbt.a("Dir", this.c.d());
        }
        nbt.a("Steps", this.d);
        nbt.a("TXD", this.e);
        nbt.a("TYD", this.f);
        nbt.a("TZD", this.g);
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.d = nbt.h("Steps");
        this.e = nbt.k("TXD");
        this.f = nbt.k("TYD");
        this.g = nbt.k("TZD");
        if (nbt.b("Dir", 99)) {
            this.c = EnumDirection.a(nbt.h("Dir"));
        }
        if (nbt.b("Target")) {
            this.h = nbt.a("Target");
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
    }

    @Nullable
    private EnumDirection l() {
        return this.c;
    }

    private void a(@Nullable EnumDirection direction) {
        this.c = direction;
    }

    private void a(@Nullable EnumDirection.EnumAxis axis) {
        BlockPosition blockposition;
        double d0 = 0.5;
        if (this.b == null) {
            blockposition = this.dw().e();
        } else {
            d0 = (double)this.b.ds() * 0.5;
            blockposition = BlockPosition.a(this.b.dB(), this.b.dD() + d0, this.b.dH());
        }
        double d1 = (double)blockposition.u() + 0.5;
        double d2 = (double)blockposition.v() + d0;
        double d3 = (double)blockposition.w() + 0.5;
        EnumDirection enumdirection = null;
        if (!blockposition.a(this.du(), 2.0)) {
            BlockPosition blockposition1 = this.dw();
            ArrayList list = Lists.newArrayList();
            if (axis != EnumDirection.EnumAxis.a) {
                if (blockposition1.u() < blockposition.u() && this.dW().u(blockposition1.i())) {
                    list.add(EnumDirection.f);
                } else if (blockposition1.u() > blockposition.u() && this.dW().u(blockposition1.h())) {
                    list.add(EnumDirection.e);
                }
            }
            if (axis != EnumDirection.EnumAxis.b) {
                if (blockposition1.v() < blockposition.v() && this.dW().u(blockposition1.d())) {
                    list.add(EnumDirection.b);
                } else if (blockposition1.v() > blockposition.v() && this.dW().u(blockposition1.e())) {
                    list.add(EnumDirection.a);
                }
            }
            if (axis != EnumDirection.EnumAxis.c) {
                if (blockposition1.w() < blockposition.w() && this.dW().u(blockposition1.g())) {
                    list.add(EnumDirection.d);
                } else if (blockposition1.w() > blockposition.w() && this.dW().u(blockposition1.f())) {
                    list.add(EnumDirection.c);
                }
            }
            enumdirection = EnumDirection.b(this.ae);
            if (list.isEmpty()) {
                for (int i2 = 5; !this.dW().u(blockposition1.a(enumdirection)) && i2 > 0; --i2) {
                    enumdirection = EnumDirection.b(this.ae);
                }
            } else {
                enumdirection = (EnumDirection)list.get(this.ae.a(list.size()));
            }
            d1 = this.dB() + (double)enumdirection.j();
            d2 = this.dD() + (double)enumdirection.k();
            d3 = this.dH() + (double)enumdirection.l();
        }
        this.a(enumdirection);
        double d4 = d1 - this.dB();
        double d5 = d2 - this.dD();
        double d6 = d3 - this.dH();
        double d7 = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        if (d7 == 0.0) {
            this.e = 0.0;
            this.f = 0.0;
            this.g = 0.0;
        } else {
            this.e = d4 / d7 * 0.15;
            this.f = d5 / d7 * 0.15;
            this.g = d6 / d7 * 0.15;
        }
        this.ar = true;
        this.d = 10 + this.ae.a(5) * 10;
    }

    @Override
    public void dI() {
        if (this.dW().al() == EnumDifficulty.a) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    protected double bd() {
        return 0.04;
    }

    @Override
    public void h() {
        Vec3D vec3d;
        super.h();
        MovingObjectPosition movingobjectposition = null;
        if (!this.dW().C) {
            if (this.b == null && this.h != null) {
                this.b = ((WorldServer)this.dW()).a(this.h);
                if (this.b == null) {
                    this.h = null;
                }
            }
            if (!(this.b == null || !this.b.bL() || this.b instanceof EntityHuman && this.b.aa_())) {
                this.e = MathHelper.a(this.e * 1.025, -1.0, 1.0);
                this.f = MathHelper.a(this.f * 1.025, -1.0, 1.0);
                this.g = MathHelper.a(this.g * 1.025, -1.0, 1.0);
                vec3d = this.dz();
                this.h(vec3d.b((this.e - vec3d.d) * 0.2, (this.f - vec3d.e) * 0.2, (this.g - vec3d.f) * 0.2));
            } else {
                this.bf();
            }
            movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
        }
        vec3d = this.dz();
        this.b(this.du().e(vec3d));
        this.aK();
        if (this.as != null && this.as.e()) {
            this.bW();
        }
        if (movingobjectposition != null && this.bL() && movingobjectposition.d() != MovingObjectPosition.EnumMovingObjectType.a) {
            this.preHitTargetOrDeflectSelf(movingobjectposition);
        }
        ProjectileHelper.a((Entity)this, 0.5f);
        if (this.dW().C) {
            this.dW().a(Particles.t, this.dB() - vec3d.d, this.dD() - vec3d.e + 0.15, this.dH() - vec3d.f, 0.0, 0.0, 0.0);
        } else if (this.b != null && !this.b.dR()) {
            if (this.d > 0) {
                --this.d;
                if (this.d == 0) {
                    this.a(this.c == null ? null : this.c.o());
                }
            }
            if (this.c != null) {
                BlockPosition blockposition = this.dw();
                EnumDirection.EnumAxis enumdirection_enumaxis = this.c.o();
                if (this.dW().a(blockposition.a(this.c), this)) {
                    this.a(enumdirection_enumaxis);
                } else {
                    BlockPosition blockposition1 = this.b.dw();
                    if (enumdirection_enumaxis == EnumDirection.EnumAxis.a && blockposition.u() == blockposition1.u() || enumdirection_enumaxis == EnumDirection.EnumAxis.c && blockposition.w() == blockposition1.w() || enumdirection_enumaxis == EnumDirection.EnumAxis.b && blockposition.v() == blockposition1.v()) {
                        this.a(enumdirection_enumaxis);
                    }
                }
            }
        }
    }

    @Override
    public boolean b(Entity entity) {
        return super.b(entity) && !entity.ad;
    }

    @Override
    public boolean bY() {
        return false;
    }

    @Override
    public boolean a(double distance) {
        return distance < 16384.0;
    }

    @Override
    public float by() {
        return 1.0f;
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        super.a(entityHitResult);
        Entity entity = entityHitResult.a();
        Entity entity1 = this.p();
        EntityLiving entityliving = entity1 instanceof EntityLiving ? (EntityLiving)entity1 : null;
        DamageSource damagesource = this.dX().a((Entity)this, entityliving);
        boolean flag = entity.b(damagesource, 4.0f);
        if (flag) {
            World world = this.dW();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                EnchantmentManager.a(worldserver, entity, damagesource);
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving1 = (EntityLiving)entity;
                entityliving1.addEffect(new MobEffect(MobEffects.y, 200), (Entity)MoreObjects.firstNonNull((Object)entity1, (Object)this), EntityPotionEffectEvent.Cause.ATTACK);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        super.a(blockHitResult);
        ((WorldServer)this.dW()).a(Particles.w, this.dB(), this.dD(), this.dH(), 2, 0.2, 0.2, 0.2, 0.0);
        this.a(SoundEffects.xi, 1.0f, 1.0f);
    }

    private void m() {
        this.destroy(null);
    }

    private void destroy(EntityRemoveEvent.Cause cause) {
        this.discard(cause);
        this.dW().a(GameEvent.o, this.du(), GameEvent.a.a(this));
    }

    @Override
    protected void a(MovingObjectPosition hitResult) {
        super.a(hitResult);
        this.destroy(EntityRemoveEvent.Cause.HIT);
    }

    @Override
    public boolean bH() {
        return true;
    }

    @Override
    public boolean b(DamageSource source) {
        return true;
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, false)) {
            return false;
        }
        this.a(SoundEffects.xj, 1.0f, 1.0f);
        world.a(Particles.f, this.dB(), this.dD(), this.dH(), 15, 0.2, 0.2, 0.2, 0.0);
        this.destroy(EntityRemoveEvent.Cause.DEATH);
        return true;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        double d0 = packet.j();
        double d1 = packet.k();
        double d2 = packet.l();
        this.n(d0, d1, d2);
    }
}

