/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityFireballFireball;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntitySmallFireball
extends EntityFireballFireball {
    public EntitySmallFireball(EntityTypes<? extends EntitySmallFireball> type, World world) {
        super((EntityTypes<? extends EntityFireballFireball>)type, world);
    }

    public EntitySmallFireball(World world, EntityLiving owner, Vec3D velocity) {
        super((EntityTypes<? extends EntityFireballFireball>)EntityTypes.bi, owner, velocity, world);
        if (this.p() != null && this.p() instanceof EntityInsentient) {
            WorldServer worldserver;
            this.isIncendiary = world instanceof WorldServer && (worldserver = (WorldServer)world).N().b(GameRules.c);
        }
    }

    public EntitySmallFireball(World world, double x2, double y2, double z2, Vec3D velocity) {
        super((EntityTypes<? extends EntityFireballFireball>)EntityTypes.bi, x2, y2, z2, velocity, world);
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        super.a(entityHitResult);
        World world = this.dW();
        if (world instanceof WorldServer) {
            DamageSource damagesource;
            WorldServer worldserver = (WorldServer)world;
            Entity entity = entityHitResult.a();
            Entity entity1 = this.p();
            int i2 = entity.aG();
            EntityCombustByEntityEvent event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)((Projectile)this.getBukkitEntity()), (org.bukkit.entity.Entity)entity.getBukkitEntity(), 5.0f);
            entity.dW().getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                entity.igniteForSeconds(event.getDuration(), false);
            }
            if (!entity.a(worldserver, damagesource = this.dX().a(this, entity1), 5.0f)) {
                entity.h(i2);
            } else {
                EnchantmentManager.a(worldserver, entity, damagesource);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        super.a(blockHitResult);
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Entity entity = this.p();
            if (this.isIncendiary) {
                BlockPosition blockposition = blockHitResult.b().a(blockHitResult.c());
                if (this.dW().u(blockposition) && !CraftEventFactory.callBlockIgniteEvent(this.dW(), blockposition, this).isCancelled()) {
                    this.dW().b(blockposition, BlockFireAbstract.a(this.dW(), blockposition));
                }
            }
        }
    }

    @Override
    protected void a(MovingObjectPosition hitResult) {
        super.a(hitResult);
        if (!this.dW().C) {
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }
}

