/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityThrownTrident
extends EntityArrow {
    private static final DataWatcherObject<Byte> f = DataWatcher.a(EntityThrownTrident.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Boolean> g = DataWatcher.a(EntityThrownTrident.class, DataWatcherRegistry.k);
    public boolean h;
    public int e;

    public EntityThrownTrident(EntityTypes<? extends EntityThrownTrident> type, World world) {
        super((EntityTypes<? extends EntityArrow>)type, world);
        this.h(8.0);
    }

    public EntityThrownTrident(World world, EntityLiving owner, ItemStack stack) {
        super(EntityTypes.bz, owner, world, stack, null);
        this.h(8.0);
        this.al.a(f, this.b(stack));
        this.al.a(g, stack.B());
    }

    public EntityThrownTrident(World world, double x2, double y2, double z2, ItemStack stack) {
        super(EntityTypes.bz, x2, y2, z2, world, stack, stack);
        this.h(8.0);
        this.al.a(f, this.b(stack));
        this.al.a(g, stack.B());
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(f, (byte)0);
        builder.a(g, false);
    }

    @Override
    public void h() {
        if (this.b > 4) {
            this.h = true;
        }
        Entity entity = this.p();
        byte b0 = this.al.a(f);
        if (b0 > 0 && (this.h || this.B()) && entity != null) {
            if (!this.G()) {
                World world = this.dW();
                if (world instanceof WorldServer) {
                    WorldServer worldserver = (WorldServer)world;
                    if (this.c == EntityArrow.PickupStatus.b) {
                        this.a(worldserver, this.u(), 0.1f);
                    }
                }
                this.discard(EntityRemoveEvent.Cause.DROP);
            } else {
                if (!(entity instanceof EntityHuman) && this.du().f(entity.bF()) < (double)entity.dr() + 1.0) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
                this.r(true);
                Vec3D vec3d = entity.bF().d(this.du());
                this.o(this.dB(), this.dD() + vec3d.e * 0.015 * (double)b0, this.dH());
                double d0 = 0.05 * (double)b0;
                this.h(this.dz().c(0.95).e(vec3d.d().c(d0)));
                if (this.e == 0) {
                    this.a(SoundEffects.Ab, 10.0f, 1.0f);
                }
                ++this.e;
            }
        }
        super.h();
    }

    private boolean G() {
        Entity entity = this.p();
        return entity != null && entity.bL() ? !(entity instanceof EntityPlayer) || !entity.aa_() : false;
    }

    public boolean D() {
        return this.al.a(g);
    }

    public void setFoil(boolean foil) {
        this.al.a(g, foil);
    }

    public int getLoyalty() {
        return this.al.a(f).byteValue();
    }

    public void setLoyalty(byte loyalty) {
        this.al.a(f, loyalty);
    }

    @Override
    @Nullable
    protected MovingObjectPositionEntity c(Vec3D currentPosition, Vec3D nextPosition) {
        return this.h ? null : super.c(currentPosition, nextPosition);
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        WorldServer worldserver;
        Entity entity = entityHitResult.a();
        float f2 = (float)this.x();
        Entity entity1 = this.p();
        DamageSource damagesource = this.dX().a((Entity)this, entity1 == null ? this : entity1);
        World world = this.dW();
        if (world instanceof WorldServer) {
            worldserver = (WorldServer)world;
            f2 = EnchantmentManager.a(worldserver, this.ea(), entity, damagesource, f2);
        }
        this.h = true;
        if (entity.b(damagesource, f2)) {
            if (entity.aq() == EntityTypes.O) {
                return;
            }
            world = this.dW();
            if (world instanceof WorldServer) {
                worldserver = (WorldServer)world;
                EnchantmentManager.a(worldserver, entity, damagesource, this.ea(), (Item item) -> this.c(worldserver));
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                this.a(entityliving, damagesource);
                this.a(entityliving);
            }
        }
        this.a(ProjectileDeflection.b, entity, this.p(), false);
        this.h(this.dz().d(0.02, 0.2, 0.02));
        this.a(SoundEffects.zZ, 1.0f, 1.0f);
    }

    @Override
    protected void a(WorldServer world, MovingObjectPositionBlock blockHitResult, ItemStack weaponStack) {
        EntityLiving entityliving1;
        Vec3D vec3d = blockHitResult.b().a(blockHitResult.g());
        Entity entity = this.p();
        EntityLiving entityliving = entity instanceof EntityLiving ? (entityliving1 = (EntityLiving)entity) : null;
        EnchantmentManager.a(world, weaponStack, entityliving, this, (EnumItemSlot)null, vec3d, world.a_(blockHitResult.b()), item -> this.c(world));
    }

    @Override
    public ItemStack ea() {
        return this.w();
    }

    @Override
    protected boolean a(EntityHuman player) {
        return super.a(player) || this.B() && this.e(player) && player.gi().f(this.u());
    }

    @Override
    protected ItemStack v() {
        return new ItemStack(Items.wI);
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.Aa;
    }

    @Override
    public void a_(EntityHuman player) {
        if (this.e(player) || this.p() == null) {
            super.a_(player);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.h = nbt.q("DealtDamage");
        this.al.a(f, this.b(this.w()));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("DealtDamage", this.h);
    }

    private byte b(ItemStack stack) {
        World world = this.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return (byte)MathHelper.a(EnchantmentManager.c(worldserver, stack, this), 0, 127);
        }
        return 0;
    }

    @Override
    public void m() {
        byte b0 = this.al.a(f);
        if (this.c != EntityArrow.PickupStatus.b || b0 <= 0) {
            super.m();
        }
    }

    @Override
    protected float A() {
        return 0.99f;
    }

    @Override
    public boolean k(double cameraX, double cameraY, double cameraZ) {
        return true;
    }
}

